/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo;

import br.gov.rs.tce.assdigital.modelo.seguranca.AssinaturaDigitalControle;
import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.beans.types.TipoEntidadesList;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.excecao.OrigemEDestinoIdenticosException;
import br.gov.rs.tce.pad.excecao.SegurancaException;
import br.gov.rs.tce.pad.excecao.SenhaInvalidaException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.ConstantesArquivos;
import br.gov.rs.tce.pad.modelo.GeraArquivoRemessa;
import br.gov.rs.tce.pad.modelo.consolidacao.RecuperaArquivosConsolidacao;
import br.gov.rs.tce.pad.modelo.relatorio.RelatorioControle;
import br.gov.rs.tce.pad.modelo.seguranca.CriptografiaControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.CodigoBarrasHelper;
import br.gov.rs.tce.pad.util.CodigoBarrasICHelper;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.VersaoUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class RemessaControle {
    private static final Log log = LogFactory.getLog(RemessaControle.class);
    public static final String SENHA_CERTIFICADO = "YABX5-EMUE7-ECDD7";
    private Remessa remessa = null;
    private File diretorioDestino = null;
    private List<ChangeListener> _changeListeners;
    private String _situacao;
    private int _progresso;
    private ServicoPAD servicoPAD;
    private boolean compactaTXT;
    private List<String> relatorios;

    public RemessaControle(Remessa rem, File diretorioDestino) {
        this.remessa = rem;
        this.diretorioDestino = diretorioDestino;
        this.compactaTXT = true;
    }

    public RemessaControle(Remessa rem, File diretorioDestino, ChangeListener listener) {
        this.remessa = rem;
        this.diretorioDestino = diretorioDestino;
        this._changeListeners = new ArrayList<ChangeListener>();
        this._changeListeners.add(listener);
    }

    public RemessaControle(ServicoPAD ser, Remessa rem, File diretorioDestino, ChangeListener listener) {
        this.remessa = rem;
        this.servicoPAD = ser;
        this.diretorioDestino = diretorioDestino;
        this._changeListeners = new ArrayList<ChangeListener>();
        this._changeListeners.add(listener);
    }

    public void geraZipAssinado() {
        this.setSituacao("Gerando arquivo compactado com remessa e arquivos de informa\u00e7\u00e3o");
        File arquivoSaida = new File(this.getPath() + "remessa.dat");
        File arquivoSaidaZip = new File(this.getPath() + "remessa.zip");
        if (this.compactaTXT) {
            ArrayList<File> f = new ArrayList<File>();
            f.add(new File(this.getPath() + "remessa.crp"));
            f.add(new File(this.getPath() + "dados.crp"));
            f.add(new File(this.getPath() + "remessa_info.xml"));
            f.add(new File(this.getPath() + "relat.crp"));
            CompactacaoHelper zip = new CompactacaoHelper();
            zip.compacta(f.toArray(new File[f.size()]), arquivoSaida);
            zip.compacta(f.toArray(new File[f.size()]), arquivoSaidaZip);
        } else {
            ArrayList<File> f = new ArrayList<File>();
            f.add(new File(this.getPath() + "remessa.crp"));
            f.add(new File(this.getPath() + "remessa_info.xml"));
            if (this.relatorios != null) {
                for (String pdf : this.relatorios) {
                    f.add(new File(this.getPath() + pdf));
                }
            }
            CompactacaoHelper zip = new CompactacaoHelper();
            zip.compacta(f.toArray(new File[f.size()]), arquivoSaida);
            zip.compacta(f.toArray(new File[f.size()]), arquivoSaidaZip);
        }
        this.setSituacao("Arquivo de remessa gerado");
    }

    public void geraXml(Object rem, FileWriter writer) {
        try {
            Marshaller mar = new Marshaller((Writer)writer);
            mar.setEncoding("ISO-8859-1");
            mar.marshal(rem);
        }
        catch (IOException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", e);
        }
        catch (MarshalException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", (Exception)((Object)e));
        }
    }

    public void geraXml(Object rem, FileWriter writer, String encoding) {
        try {
            Marshaller mar = new Marshaller((Writer)writer);
            mar.setEncoding(encoding);
            mar.marshal(rem);
        }
        catch (IOException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", e);
        }
        catch (MarshalException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw new ConfiguracaoException("Erro ao gerar arquivo com informa\u00e7\u00f5es sobre a remessa e assinatura", (Exception)((Object)e));
        }
    }

    private void criptografaZipRemessa() {
        try {
            File remessaDat = new File(this.getPath() + "remessa.zip");
            File dadosDat = new File(this.getPath() + "dados.dat");
            CriptografiaControle.criptografa(remessaDat, new File(this.getPath() + "remessa.crp"), "P@D.WEB?D&SKTOP;");
            if (dadosDat.exists()) {
                CriptografiaControle.criptografa(dadosDat, new File(this.getPath() + "dados.crp"), "P@D.WEB?D&SKTOP;");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void compactaArquivosXmlPDF(boolean pdf) {
        File[] f = this.buscaArquivosXmlPDF(pdf);
        CompactacaoHelper zip = new CompactacaoHelper();
        zip.compacta(f, new File(this.getPath() + "remessa.zip"));
    }

    public void compactaArquivosTxt(int tipoOperacao) {
        File[] arquivoNomes = this.buscaArquivos(tipoOperacao);
        File destino = new File(this.getPath() + "dados.dat");
        CompactacaoHelper zip = new CompactacaoHelper();
        zip.compacta(arquivoNomes, destino);
    }

    public void compactaArquivosTxt(int tipoOperacao, String dir) {
        File[] arquivoNomes = this.buscaArquivos(tipoOperacao);
        File destino = new File(dir + File.separator + "dados.dat");
        CompactacaoHelper zip = new CompactacaoHelper();
        zip.compacta(arquivoNomes, destino);
    }

    private File[] buscaArquivos(int tipoOperacao) {
        Arquivos arquivos = null;
        List<Arquivo> arquivosSel = null;
        ArrayList<File> arquivoNomes = new ArrayList<File>();
        List<String> arqIgnList = this.servicoPAD.getArquivosIgnoraveis();
        if (6 == tipoOperacao) {
            arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML(this.servicoPAD.resolveArquivoConfigFluxo(tipoOperacao));
            arquivosSel = arquivos.getArquivos();
            List<Arquivo> arquivosVerificados = arquivos.getArquivosPorLeiEntidade(TipoEntidadesList.getLeiPorTipoSetor(this.remessa.getTipoSetor()), this.remessa.getTipoSetor(), this.remessa.getPeriodoInformacoes(), this.remessa.getMes(), this.remessa.getTipoOperacao());
            arquivosVerificados = this.servicoPAD.removeArqComplementaresNaoSelecinados(arquivosVerificados);
            ArrayList<File> nomes = new ArrayList<File>();
            for (int i = 0; i < arquivosSel.size(); ++i) {
                Arquivo arq = arquivosSel.get(i);
                File f = new File(this.remessa.getDiretorioOrigem() + File.separator + arq.getNome());
                if (f.exists()) {
                    nomes.add(f);
                    log.debug((Object)("... Arquivo " + arq.getNome() + " adicionado"));
                    continue;
                }
                if (!arquivosVerificados.contains(arq)) continue;
                if (!arqIgnList.contains(arq.getNome())) {
                    this.setSituacao("Arquivo " + f.getAbsolutePath() + " n\u00e3o encontrado");
                    throw new ConfiguracaoException("Arquivo " + f.getAbsolutePath() + " n\u00e3o encontrado", null);
                }
                this.setSituacao("Arquivo " + arq.getNome() + " n\u00e3o encontrado");
                log.info((Object)("Arquivo " + arq.getNome() + " ignorado..."));
            }
            arquivoNomes = nomes;
        } else {
            arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal");
            arquivosSel = arquivos.getArquivosPorLeiEntidade(TipoEntidadesList.getLeiPorTipoSetor(this.remessa.getTipoSetor()), this.remessa.getTipoSetor(), this.remessa.getPeriodoInformacoes(), this.remessa.getMes(), this.remessa.getTipoOperacao());
            for (int i = 0; i < arquivosSel.size(); ++i) {
                Arquivo arq = arquivosSel.get(i);
                File f = new File(this.remessa.getDiretorioOrigem() + File.separator + arq.getNome());
                if (!f.exists()) {
                    if (!arqIgnList.contains(arq.getNome())) {
                        this.setSituacao("Arquivo " + f.getAbsolutePath() + " n\u00e3o encontrado");
                        throw new ConfiguracaoException("Arquivo " + f.getAbsolutePath() + " n\u00e3o encontrado", null);
                    }
                    this.setSituacao("Arquivo " + arq.getNome() + " n\u00e3o encontrado");
                    log.info((Object)("Arquivo " + arq.getNome() + " ignorado..."));
                    continue;
                }
                arquivoNomes.add(f);
                log.debug((Object)("... Arquivo " + arq.getNome() + " adicionado"));
            }
        }
        File diretorio = new File(this.remessa.getDiretorioOrigem());
        File[] arquivosOutros = diretorio.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.contains("REQ_OUTROS")) {
                    File f = new File(dir, name);
                    return f.isFile();
                }
                return false;
            }
        });
        ArrayList<File> listArquivos = new ArrayList<File>();
        listArquivos.addAll(arquivoNomes);
        Collections.addAll(listArquivos, arquivosOutros);
        return listArquivos.toArray(new File[listArquivos.size()]);
    }

    private File[] buscaArquivosXmlPDF(boolean pdf) {
        boolean temIndiretas = this.servicoPAD.existeIndiretasConsolidacao();
        boolean naoConsolidou = this.servicoPAD.existemIndiretasNaoConsolidadas();
        File rve = new File(this.getPath() + File.separator + "rve.xml");
        File rdi = new File(this.getPath() + File.separator + "rdi.xml");
        File modelo9 = new File(this.getPath() + File.separator + "modelo9.xml");
        File modelo14 = new File(this.getPath() + File.separator + "modelo14.xml");
        File remessaxml = new File(this.getPath() + File.separator + "remessa.xml");
        ArrayList<File> fileL = new ArrayList<File>();
        this.relatorios = new ArrayList<String>();
        if (this.remessa.getGrupoEntrega() == 1 || this.remessa.getGrupoEntrega() == 11) {
            if (temIndiretas && !naoConsolidou || !temIndiretas) {
                if (!modelo9.exists()) {
                    throw new ConfiguracaoException("Arquivo de Modelo9 n\u00e3o encontrado", null);
                }
                fileL.add(modelo9);
                if (pdf && modelo9.exists()) {
                    this.relatorios.add("modelo9.pdf");
                }
            }
            if (temIndiretas && naoConsolidou || !temIndiretas) {
                if (!rve.exists()) {
                    throw new ConfiguracaoException("Arquivo do RVE n\u00e3o encontrado", null);
                }
                fileL.add(rve);
                if (pdf && rve.exists()) {
                    this.relatorios.add("rve.pdf");
                }
                this.adicionaBalancetesSeNecessario(fileL, pdf);
            }
            if (!remessaxml.exists()) {
                throw new ConfiguracaoException("Arquivo com dados da Remessa n\u00e3o encontrado", null);
            }
            fileL.add(remessaxml);
            return this.converteArrayFile(fileL);
        }
        if (this.remessa.getGrupoEntrega() == 2 || this.remessa.getGrupoEntrega() == 13) {
            if (temIndiretas && !naoConsolidou || !temIndiretas) {
                if (!modelo14.exists()) {
                    throw new ConfiguracaoException("Arquivo de Modelo14 n\u00e3o encontrado", null);
                }
                fileL.add(modelo14);
                if (pdf && modelo14.exists()) {
                    this.relatorios.add("modelo14.pdf");
                }
            }
            if (temIndiretas && naoConsolidou || !temIndiretas) {
                if (!rve.exists()) {
                    throw new ConfiguracaoException("Arquivo do RVE n\u00e3o encontrado", null);
                }
                fileL.add(rve);
                if (pdf && rve.exists()) {
                    this.relatorios.add("rve.pdf");
                }
                this.adicionaBalancetesSeNecessario(fileL, pdf);
            }
            if (!remessaxml.exists()) {
                throw new ConfiguracaoException("Arquivo com dados da Remessa n\u00e3o encontrado", null);
            }
            fileL.add(remessaxml);
            return this.converteArrayFile(fileL);
        }
        if (this.remessa.getGrupoEntrega() == 3 || this.remessa.getGrupoEntrega() == 14) {
            if (temIndiretas && naoConsolidou || !temIndiretas) {
                if (!rve.exists()) {
                    throw new ConfiguracaoException("Arquivo do RVE n\u00e3o encontrado", null);
                }
                fileL.add(rve);
                if (pdf && rve.exists()) {
                    this.relatorios.add("rve.pdf");
                }
                this.adicionaBalancetesSeNecessario(fileL, pdf);
            }
            if (!remessaxml.exists()) {
                throw new ConfiguracaoException("Arquivo com dados da Remessa n\u00e3o encontrado", null);
            }
            fileL.add(remessaxml);
            return this.converteArrayFile(fileL);
        }
        if (this.remessa.getGrupoEntrega() == 5 || this.remessa.getGrupoEntrega() == 12) {
            if (temIndiretas && !naoConsolidou || !temIndiretas) {
                if (!modelo9.exists()) {
                    throw new ConfiguracaoException("Arquivo de Modelo9 n\u00e3o encontrado", null);
                }
                fileL.add(modelo9);
                if (pdf && modelo9.exists()) {
                    this.relatorios.add("modelo9.pdf");
                }
            }
            if (temIndiretas && naoConsolidou || !temIndiretas) {
                if (!rve.exists()) {
                    throw new ConfiguracaoException("Arquivo do RVE n\u00e3o encontrado", null);
                }
                fileL.add(rve);
                if (pdf && rve.exists()) {
                    this.relatorios.add("rve.pdf");
                }
                this.adicionaBalancetesSeNecessario(fileL, pdf);
            }
            if (!remessaxml.exists()) {
                throw new ConfiguracaoException("Arquivo com dados da Remessa n\u00e3o encontrado", null);
            }
            fileL.add(remessaxml);
            return this.converteArrayFile(fileL);
        }
        if (this.remessa.getGrupoEntrega() == 7) {
            if (!rve.exists()) {
                throw new ConfiguracaoException("Arquivo do RVE n\u00e3o encontrado", null);
            }
            fileL.add(rve);
            if (!rdi.exists()) {
                throw new ConfiguracaoException("Arquivo do RDI n\u00e3o encontrado", null);
            }
            fileL.add(rdi);
            if (pdf) {
                if (rve.exists()) {
                    this.relatorios.add("rve.pdf");
                }
                if (rdi.exists()) {
                    this.relatorios.add("rdi.pdf");
                }
            }
            if (!remessaxml.exists()) {
                throw new ConfiguracaoException("Arquivo com dados da Remessa n\u00e3o encontrado", null);
            }
            fileL.add(remessaxml);
            return this.converteArrayFile(fileL);
        }
        throw new ConfiguracaoException("Grupo de Entrega desconhecido: " + this.remessa.getGrupoEntrega(), null);
    }

    void adicionaBalancetesSeNecessario(List<File> fileL, boolean pdf) {
        File dcBalPat = new File(this.getPath() + File.separator + "dc-balpat.xml");
        File dcBalOrc = new File(this.getPath() + File.separator + "dc-balorc.xml");
        File dcDvp = new File(this.getPath() + File.separator + "dc-dvp.xml");
        if (this.remessa.getGrupoEntrega() == 14 || this.remessa.getGrupoEntrega() == 13 || this.remessa.getGrupoEntrega() == 11 || this.remessa.getGrupoEntrega() == 12) {
            if (!dcBalPat.exists()) {
                throw new ConfiguracaoException("Arquivo do DC-BalPat n\u00e3o encontrado", null);
            }
            fileL.add(dcBalPat);
            if (pdf) {
                this.relatorios.add("dc-balpat.pdf");
            }
            if (this.remessa.getGrupoEntrega() != 13) {
                if (!dcBalOrc.exists()) {
                    throw new ConfiguracaoException("Arquivo do DC-BalOrc n\u00e3o encontrado", null);
                }
                fileL.add(dcBalOrc);
                if (pdf) {
                    this.relatorios.add("dc-balorc.pdf");
                }
            }
            if (!dcDvp.exists()) {
                throw new ConfiguracaoException("Arquivo do DC-DVP n\u00e3o encontrado", null);
            }
            fileL.add(dcDvp);
            if (pdf) {
                this.relatorios.add("dc-dvp.pdf");
            }
        }
    }

    public void geraRemessa(ServicoPAD module, char[] senha, File certificado, boolean compactaTXT) {
        this.compactaTXT = compactaTXT;
        this.geraRemessa(module, senha, certificado);
    }

    private void geraRemessaPasso3Web(ServicoPAD module, String txt, String xml, String chain, boolean compactaTXT) {
        this.compactaTXT = compactaTXT;
        this.servicoPAD = module;
        boolean temIndiretas = this.servicoPAD.existeIndiretasConsolidacao();
        boolean naoConsolidou = this.servicoPAD.existemIndiretasNaoConsolidadas();
        RemessaInfo reme = new RemessaInfo();
        reme.setCodigoEntidade(this.remessa.getCdEntidade());
        reme.setCodigoRemessa(this.remessa.getCdRemessa());
        reme.setAnoExercicio(this.remessa.getAnoExercicio());
        reme.setGrupoEntrega(this.remessa.getGrupoEntrega());
        reme.setPeriodoInformacoes(this.remessa.getPeriodoInformacoes());
        reme.setMesInformacoes(this.remessa.getMes());
        reme.setCnpjEntidade(this.remessa.getCnpjEntidade());
        reme.setTipoOrgao(this.remessa.getTipoSetor());
        reme.setTipoEntrega(this.remessa.getTipoEntrega());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/Sao_Paulo"), new Locale("pt", "BR"));
        reme.setDataGeracao(cal.getTime());
        reme.setVersao("25.0.0.7");
        reme.setTipoCertificado(this.remessa.getTipoCertificado());
        reme.setCodBarrasRveOriginal(this.servicoPAD.getCodBarrasRVEOriginal());
        reme.setAssinaturaTxt(txt);
        reme.setAssinaturaXml(xml);
        reme.setCadeiaCertificado(chain);
        reme.calculaDigestRemessa();
        if (this.remessa.getGrupoEntrega() == 1 || this.remessa.getGrupoEntrega() == 5) {
            if (temIndiretas && !naoConsolidou || !temIndiretas) {
                reme.setCodBarrasModelo9(CodigoBarrasHelper.constroiCodigoBarra(reme, 2));
            } else {
                reme.setCodBarrasModelo9(null);
            }
            if (temIndiretas && naoConsolidou || !temIndiretas) {
                reme.setCodBarrasRve(CodigoBarrasHelper.constroiCodigoBarra(reme, 1));
            } else {
                reme.setCodBarrasRve(null);
                reme.setAssinaturaTxt("");
            }
            reme.setCodBarrasModelo14(null);
        } else if (this.remessa.getGrupoEntrega() == 2) {
            reme.setCodBarrasModelo14(CodigoBarrasHelper.constroiCodigoBarra(reme, 3));
            reme.setCodBarrasRve(CodigoBarrasHelper.constroiCodigoBarra(reme, 1));
            reme.setCodBarrasModelo9(null);
        } else if (this.remessa.getGrupoEntrega() == 3) {
            reme.setCodBarrasRve(CodigoBarrasHelper.constroiCodigoBarra(reme, 1));
            reme.setCodBarrasModelo9(null);
            reme.setCodBarrasModelo14(null);
        } else {
            throw new ConfiguracaoException("Grupo de Entrega desconhecido: " + this.remessa.getGrupoEntrega());
        }
        try {
            this.geraXml(reme, new FileWriter(this.getPath() + "remessa_info.xml"));
        }
        catch (IOException e) {
            throw new ConfiguracaoException("Erro ao gerar xml da RemessaInfo");
        }
        this.remessa.setRemessaInfo(reme);
    }

    private void geraRemessa(ServicoPAD module, char[] senha, File certificado) {
        this.servicoPAD = module;
        boolean temIndiretas = this.servicoPAD.existeIndiretasConsolidacao();
        boolean naoConsolidou = this.servicoPAD.existemIndiretasNaoConsolidadas();
        this.setSituacao("Recuperando informa\u00e7\u00f5es da remessa atual");
        RemessaInfo reme = new RemessaInfo();
        reme.setCodigoEntidade(this.remessa.getCdEntidade());
        reme.setCodigoRemessa(this.remessa.getCdRemessa());
        reme.setAnoExercicio(this.remessa.getAnoExercicio());
        reme.setGrupoEntrega(this.remessa.getGrupoEntrega());
        reme.setPeriodoInformacoes(this.remessa.getPeriodoInformacoes());
        reme.setMesInformacoes(this.remessa.getMes());
        reme.setCnpjEntidade(this.remessa.getCnpjEntidade());
        reme.setTipoOrgao(this.remessa.getTipoSetor());
        reme.setTipoEntrega(this.remessa.getTipoEntrega());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("America/Sao_Paulo"), new Locale("pt", "BR"));
        reme.setDataGeracao(cal.getTime());
        reme.setVersao("25.0.0.7");
        reme.setTipoCertificado(this.remessa.getTipoCertificado());
        reme.setCodBarrasRveOriginal(this.servicoPAD.getCodBarrasRVEOriginal());
        if (this.remessa.getTipoOperacao() == 6) {
            reme.setDataFinalRemessa(this.remessa.getDataFinal());
            reme.setCodigoArquivosComplementares(this.geraCodigoArquivosComplementares(this.remessa));
        }
        reme.setTipoResponsaveis("P");
        TipoBancoDados tp = DatabaseHelper.recuperaTipoBancoDados(module);
        GeraArquivoRemessa gera = new GeraArquivoRemessa(module, new File(this.getPath() + "remessa.xml"), this.remessa, tp);
        this.setSituacao("Gerando Arquivo da remessa");
        gera.geraArquivo();
        this.setSituacao("Compactando arquivo de remessa");
        this.compactaArquivosXmlPDF(false);
        if (this.compactaTXT) {
            this.compactaArquivosTxt(this.remessa.getTipoOperacao());
        }
        this.setSituacao("Criptografando dados da remessa");
        this.criptografaZipRemessa();
        try {
            String strSenha = null;
            strSenha = senha != null ? new String(senha) : SENHA_CERTIFICADO;
            AssinaturaDigitalControle.CertificationChainAndSignature cc = null;
            byte[] xmlHashParam = AssinaturaDigitalControle.calculaDigest(new File(this.getPath() + "remessa.crp"));
            cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(xmlHashParam, certificado, strSenha);
            log.info((Object)("cc.getSignature() == " + cc.getSignature()));
            if (this.compactaTXT) {
                byte[] txtHashParam = AssinaturaDigitalControle.calculaDigest(new File(this.getPath() + "dados.crp"));
                cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(txtHashParam, certificado, strSenha);
                log.info((Object)("cc.getSignature() == " + cc.getSignature()));
                this.setSituacao("Assinando digitalmente arquivos do usu\u00e1rio");
                cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(new File(this.getPath() + "dados.crp"), certificado, strSenha);
                reme.setAssinaturaTxt(cc.getSignature());
            } else {
                reme.setAssinaturaTxt("");
            }
            this.setSituacao("Assinando digitalmente arquivos da remessa");
            cc = AssinaturaDigitalControle.assinaDigitalmenteArquivo(new File(this.getPath() + "remessa.crp"), certificado, strSenha);
            reme.setAssinaturaXml(cc.getSignature());
            reme.setCadeiaCertificado(cc.getCertificationChain());
        }
        catch (Exception e) {
            log.warn((Object)("geraRemessa: Erro ao gerar remessa: " + e), (Throwable)e);
            if (e.getMessage().indexOf("failed to decrypt safe contents entry") >= 0) {
                throw new SenhaInvalidaException("Senha informada n\u00e3o confere com senha do arquivo de certificado");
            }
            throw new IllegalStateException("Erro ao gerar remessa: " + e.getMessage(), e);
        }
        reme.calculaDigestRemessa();
        if (this.remessa.getGrupoEntrega() == 1 || this.remessa.getGrupoEntrega() == 5 || this.remessa.getGrupoEntrega() == 11 || this.remessa.getGrupoEntrega() == 12) {
            if (temIndiretas && !naoConsolidou || !temIndiretas) {
                reme.setCodBarrasModelo9(CodigoBarrasHelper.constroiCodigoBarra(reme, 2));
            } else {
                reme.setCodBarrasModelo9(null);
            }
            if (temIndiretas && naoConsolidou || !temIndiretas) {
                reme.setCodBarrasRve(CodigoBarrasHelper.constroiCodigoBarra(reme, 1));
                if (this.remessa.getGrupoEntrega() == 11 || this.remessa.getGrupoEntrega() == 12) {
                    this.setCodBarrasDemonstrativosContabeis(reme);
                } else {
                    this.limpaCodBarrasDemonstrativosContabeis(reme);
                }
            } else {
                reme.setCodBarrasRve(null);
                this.limpaCodBarrasDemonstrativosContabeis(reme);
            }
            reme.setCodBarrasModelo14(null);
        } else if (this.remessa.getGrupoEntrega() == 2 || this.remessa.getGrupoEntrega() == 13) {
            reme.setCodBarrasModelo14(CodigoBarrasHelper.constroiCodigoBarra(reme, 3));
            reme.setCodBarrasRve(CodigoBarrasHelper.constroiCodigoBarra(reme, 1));
            reme.setCodBarrasModelo9(null);
            if (this.remessa.getGrupoEntrega() == 13) {
                this.setCodBarrasDemonstrativosContabeisCM(reme);
            } else {
                this.limpaCodBarrasDemonstrativosContabeis(reme);
            }
        } else if (this.remessa.getTipoOperacao() == 6) {
            if (this.remessa.getGrupoEntrega() == 3) {
                reme.setCodBarrasRve(CodigoBarrasICHelper.constroiCodigoBarra(reme, 1));
            } else if (this.remessa.getGrupoEntrega() == 7) {
                reme.setCodBarrasRve(CodigoBarrasICHelper.constroiCodigoBarra(reme, 1));
                reme.setCodBarrasRdi(CodigoBarrasICHelper.constroiCodigoBarra(reme, 2));
            }
            reme.setCodBarrasModelo9(null);
            reme.setCodBarrasModelo14(null);
            this.limpaCodBarrasDemonstrativosContabeis(reme);
        } else if (this.remessa.getGrupoEntrega() == 3 || this.remessa.getGrupoEntrega() == 14) {
            reme.setCodBarrasRve(CodigoBarrasHelper.constroiCodigoBarra(reme, 1));
            reme.setCodBarrasModelo9(null);
            reme.setCodBarrasModelo14(null);
            if (this.remessa.getGrupoEntrega() == 14) {
                this.setCodBarrasDemonstrativosContabeis(reme);
            } else {
                this.limpaCodBarrasDemonstrativosContabeis(reme);
            }
        } else {
            throw new ConfiguracaoException("Grupo de Entrega desconhecido: " + this.remessa.getGrupoEntrega());
        }
        this.setSituacao("Gerando arquivo com informa\u00e7\u00f5es sobre a remessa atual");
        try {
            this.geraXml(reme, new FileWriter(this.getPath() + "remessa_info.xml"));
        }
        catch (IOException e) {
            throw new ConfiguracaoException("Erro ao gerar xml da RemessaInfo");
        }
        this.remessa.setRemessaInfo(reme);
    }

    private void setCodBarrasDemonstrativosContabeis(RemessaInfo reme) {
        reme.setCodBarrasDcBp(CodigoBarrasHelper.constroiCodigoBarra(reme, 8));
        reme.setCodBarrasDcBo(CodigoBarrasHelper.constroiCodigoBarra(reme, 9));
        reme.setCodBarrasDcDvp(CodigoBarrasHelper.constroiCodigoBarra(reme, 10));
    }

    private void setCodBarrasDemonstrativosContabeisCM(RemessaInfo reme) {
        reme.setCodBarrasDcBp(CodigoBarrasHelper.constroiCodigoBarra(reme, 8));
        reme.setCodBarrasDcBo(null);
        reme.setCodBarrasDcDvp(CodigoBarrasHelper.constroiCodigoBarra(reme, 10));
    }

    private void limpaCodBarrasDemonstrativosContabeis(RemessaInfo reme) {
        reme.setCodBarrasDcBp(null);
        reme.setCodBarrasDcBo(null);
        reme.setCodBarrasDcDvp(null);
    }

    private String geraCodigoArquivosComplementares(Remessa remessa) {
        List<String> tipos = this.servicoPAD.buscaArquivosComplementaresSelecionados();
        StringBuffer retorno = new StringBuffer();
        for (String tipo : tipos) {
            retorno.append(tipo);
        }
        return retorno.toString();
    }

    public RemessaInfo recuperaArquivosRemessa(File fRemessa, ChangeListener listener) {
        RemessaInfo rem = this.recuperaArquivosRemessa(fRemessa, listener, true);
        return rem;
    }

    public RemessaInfo recuperaArquivosRemessa(File fRemessa, ChangeListener listener, boolean isNotWeb) {
        CompactacaoHelper comp = new CompactacaoHelper();
        if (isNotWeb) {
            boolean retorno = true;
            try {
                retorno = comp.copiaArquivoCompactado(new File(fRemessa.getPath()), new File(this.getPath()), listener);
            }
            catch (OrigemEDestinoIdenticosException e) {
                log.info((Object)"Origem e destino identicos, arquivo n\u00e3o copiado", (Throwable)e);
            }
            if (!retorno) {
                return null;
            }
        }
        comp.descompacta(new File(this.getPath() + File.separator + "remessa.dat"), new File(this.getPath()));
        System.gc();
        File remessaInfo = new File(this.getPath() + File.separator + "remessa_info.xml");
        log.info((Object)("remessaInfo.getAbsolutePath() = " + remessaInfo.getAbsolutePath()));
        RemessaInfo rem = (RemessaInfo)ConfiguracaoControle.carregaDadosArquivoXML("remessa-info", remessaInfo, true);
        this.remessa.setRemessaInfo(rem);
        return rem;
    }

    public void consolidacaoPrefeitura(ServicoPAD module) {
        CompactacaoHelper comp = new CompactacaoHelper();
        this.servicoPAD = module;
        try {
            CriptografiaControle.descriptografa(new File(this.getPath() + "remessa.crp"), new File(this.getPath() + "remessa.zip"), "P@D.WEB?D&SKTOP;");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        comp.descompacta(new File(this.getPath() + "remessa.zip"), new File(this.getPath()));
        RecuperaArquivosConsolidacao cons = new RecuperaArquivosConsolidacao(module);
        cons.recuperaArquivoPrefeitura(new File(this.getPath() + "remessa.xml"), this.remessa, 0);
    }

    public void geraRelatorios(BindingContext binding) {
        RelatorioControle relatorios = new RelatorioControle();
        relatorios.geraRelatorios(DatacontrolHelper.getRemessaDataControl(binding), DatacontrolHelper.getServicoPADAppModule(binding), this.diretorioDestino);
    }

    private void fireChangedEvent() {
        ChangeEvent evento = new ChangeEvent(this);
        for (ChangeListener list : this._changeListeners) {
            if (list == null) continue;
            list.stateChanged(evento);
        }
    }

    public int getProgressoEnvio() {
        return this._progresso;
    }

    public String getSituacao() {
        return this._situacao;
    }

    private void setSituacao(String situacao) {
        this._situacao = situacao;
        this.fireChangedEvent();
    }

    private String getPath() {
        return this.diretorioDestino.getAbsolutePath() + File.separator;
    }

    private File[] converteArrayFile(List<File> files) {
        int cont = 0;
        File[] file = new File[files.size()];
        Iterator<File> i = files.iterator();
        while (i.hasNext()) {
            file[cont] = i.next();
            ++cont;
        }
        return file;
    }

    public void removeArquivosPdfRemessa() {
        log.info((Object)"removeArquivosPdfRemessa:");
        for (String pdf : ConstantesArquivos.RELATORIOS_PDF) {
            this.excluiArquivo(pdf);
        }
    }

    public void removeArquivosRemessa() {
        log.info((Object)"removeArquivosRemessa:");
        this.excluiArquivo("consolida_remessa.dat");
        this.excluiArquivo("remessa.crp");
        if (!VersaoUtils.isDebugModeEnabled()) {
            this.excluiArquivo("consolidacao.xml");
            this.excluiArquivo("rve.xml");
            this.excluiArquivo("rdi.xml");
            this.excluiArquivo("modelo9.xml");
            this.excluiArquivo("modelo14.xml");
            this.excluiArquivo("mensagensVerificacao.xml");
            this.excluiArquivo("dc-balpat.xml");
            this.excluiArquivo("dc-balorc.xml");
            this.excluiArquivo("dc-dvp.xml");
            this.excluiArquivo("remessa.xml");
        }
        this.excluiArquivo("remessa.zip");
        this.excluiArquivo("remessa.crp");
        this.excluiArquivo("dados.crp");
        this.excluiArquivo("dados.dat");
        this.excluiArquivo("relat.crp");
        this.excluiArquivo("relat.zip");
    }

    public void removeArquivosRemessaWEB() {
        this.excluiArquivo("consolidacao.xml");
        this.excluiArquivo("consolida_remessa.dat");
        this.excluiArquivo("remessa.crp");
        this.excluiArquivo("remessa.zip");
        this.excluiArquivo("remessa.crp");
        this.excluiArquivo("dados.crp");
        this.excluiArquivo("dados.dat");
    }

    private void excluiArquivo(String file) {
        File f = new File(this.getPath() + File.separator + file);
        try {
            if (f.exists()) {
                f.delete();
                log.info((Object)("excluiArquivo: " + f.getCanonicalFile() + " [deleted]"));
            } else {
                log.info((Object)("excluiArquivo: " + f.getCanonicalFile() + " [notFound]"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void geraArquivoCrpPDFs() {
        File rve = new File(this.getPath() + File.separator + "rve.pdf");
        File rdi = new File(this.getPath() + File.separator + "rdi.pdf");
        File modelo9 = new File(this.getPath() + File.separator + "modelo9.pdf");
        File modelo14 = new File(this.getPath() + File.separator + "modelo14.pdf");
        File dcBalPat = new File(this.getPath() + File.separator + "dc-balpat.pdf");
        File dcBalOrc = new File(this.getPath() + File.separator + "dc-balorc.pdf");
        File dcDvp = new File(this.getPath() + File.separator + "dc-dvp.pdf");
        ArrayList<File> files = new ArrayList<File>();
        if (rve.exists()) {
            files.add(rve);
        }
        if (rdi.exists()) {
            files.add(rdi);
        }
        if (modelo9.exists()) {
            files.add(modelo9);
        }
        if (modelo14.exists()) {
            files.add(modelo14);
        }
        if (dcBalPat.exists()) {
            files.add(dcBalPat);
        }
        if (dcBalOrc.exists()) {
            files.add(dcBalOrc);
        }
        if (dcDvp.exists()) {
            files.add(dcDvp);
        }
        try {
            CompactacaoHelper zip = new CompactacaoHelper();
            File relatZip = new File(this.getPath() + "relat.zip");
            File relatCrp = new File(this.getPath() + "relat.crp");
            zip.compacta(this.converteArrayFile(files), relatZip);
            CriptografiaControle.criptografa(relatZip, relatCrp, "P@D.WEB?D&SKTOP;");
        }
        catch (SegurancaException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

