/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.adf.excecao.ExceptionHelper;
import br.gov.rs.tce.pad.beans.Formato;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.excecao.ImportacaoException;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ValoresCampos {
    private MetadadosArquivoContabil _metadados;
    private Map<String, Object> _valoresCampos;
    private static Log log = LogFactory.getLog(ValoresCampos.class);
    private Formato _formatoArquivo;

    public ValoresCampos(MetadadosArquivoContabil metaDados, int qtdCampos) {
        this._metadados = metaDados;
        this._formatoArquivo = metaDados.getArquivo().getFormato();
        this._valoresCampos = new LinkedHashMap<String, Object>(qtdCampos);
    }

    public void adicionaValorCampo(String nomeCampo, Object valorCampo, int tipoDado) {
        if (valorCampo == null && tipoDado != 5) {
            log.debug((Object)("Campo: " + nomeCampo + " no arquivo: " + this._metadados.getArquivo().getNome() + " foi definido como nulo !"));
            throw new ImportacaoException("10016", new Object[]{this._metadados.getArquivo().getNome(), nomeCampo});
        }
        this._valoresCampos.put(nomeCampo, valorCampo);
    }

    public Object getValorCampo(String nomeCampo) {
        assert (!this.verificaNomeCampo(nomeCampo)) : ExceptionHelper.exceptionIncludingDetails(new VerificacaoException("10006", new Object[]{nomeCampo, this._metadados.getArquivo().getNome()}));
        return this._valoresCampos.get(nomeCampo);
    }

    public boolean verificaNomeCampo(String nomeCampo) {
        return this._formatoArquivo.verificaNomeCampo(nomeCampo);
    }

    public Object removeValorCampo(String nomeCampo) {
        assert (!this.verificaNomeCampo(nomeCampo)) : ExceptionHelper.exceptionIncludingDetails(new VerificacaoException("10006", new Object[]{nomeCampo, this._metadados.getArquivo().getNome()}));
        return this._valoresCampos.remove(nomeCampo);
    }

    public Object[] getValoresCamposArray() {
        return this._valoresCampos.values().toArray();
    }

    public String getNomeCampo(int i) {
        return this._formatoArquivo.getNomeCampo(i);
    }
}

