/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SituacaoVerificacao {
    private List<MensagemInstancia> _listaMensagens;
    private int _identificadorMensagem;
    private Log log = LogFactory.getLog(SituacaoVerificacao.class);
    public static boolean testMode = false;
    private Remessa _remessa;
    private boolean bVerAntVazio = false;
    protected Map<IdentificadorArquivo, MetadadosArquivoContabil> _metadadosArquivos;
    protected Map<String, Integer> _tiposDeAvisos;

    public SituacaoVerificacao() {
        this._listaMensagens = new LinkedList<MensagemInstancia>();
        this._metadadosArquivos = new HashMap<IdentificadorArquivo, MetadadosArquivoContabil>();
        this._tiposDeAvisos = new HashMap<String, Integer>();
    }

    public void adicionaMensagem(MensagemInstancia mensagem) {
        MetadadosArquivoContabil metadados = this._metadadosArquivos.get(mensagem.getIdArquivo());
        String msgTipo = mensagem.getTipo();
        boolean imprimeMensagemAviso = true;
        boolean aviso = true;
        Integer msgAvisosQtd = null;
        int maxAvisos = MetadadosArquivoContabil.MAXIMO_MENSAGEM_AVISO;
        if (Mensagem.ehMensagemAviso(msgTipo)) {
            String codMensagem = mensagem.getCodigoMensagem();
            String idContadorAviso = codMensagem + ":" + mensagem.getIdArquivo();
            msgAvisosQtd = this._tiposDeAvisos.get(idContadorAviso);
            if (msgAvisosQtd == null) {
                msgAvisosQtd = 0;
            }
            this._tiposDeAvisos.put(idContadorAviso, msgAvisosQtd + 1);
            if (msgTipo.equalsIgnoreCase("J")) {
                maxAvisos = MetadadosArquivoContabil.MAXIMO_MENSAGEM_JUSTIFICATIVA;
            }
            if (msgAvisosQtd + 1 == maxAvisos) {
                imprimeMensagemAviso = false;
            } else {
                if (msgAvisosQtd + 1 > maxAvisos) {
                    imprimeMensagemAviso = false;
                }
                aviso = false;
            }
        }
        if (imprimeMensagemAviso) {
            mensagem.setIndicador(++this._identificadorMensagem);
            this._listaMensagens.add(mensagem);
        } else if (aviso) {
            mensagem.setIndicador(++this._identificadorMensagem);
            this._listaMensagens.add(mensagem);
            MensagemFactory msgFactory = MensagemFactory.getInstancia();
            Arquivo arq = new Arquivo();
            arq.setIdentificador(mensagem.getIdArquivo().toString());
            arq.setNome(mensagem.getArquivo());
            this.adicionaMensagem(msgFactory.constroiMensagem("ARQ_04", arq, new Object[]{mensagem.getCodigoMensagem(), maxAvisos}));
        }
        if (msgTipo.equals("E")) {
            metadados.setSituacao(2);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Situacao Verifica\u00e7\u00e3o: " + mensagem));
        }
        metadados.incrementaContadorMensagem(mensagem.getTipo());
    }

    public MetadadosArquivoContabil getArquivoPorIdentificador(IdentificadorArquivo idArquivo) {
        MetadadosArquivoContabil arq = this._metadadosArquivos.get(idArquivo);
        if (arq == null) {
            throw new IllegalArgumentException("N\u00e3o foi localizado nenhum arquivo com o id: " + idArquivo);
        }
        return arq;
    }

    public boolean containsArquivoPorIdentificador(IdentificadorArquivo idArquivo) {
        return this._metadadosArquivos.containsKey(idArquivo);
    }

    public void inicializaMetadadosArquivos(List<Arquivo> listArquivos, List<File> listArquivosFisicos) {
        if (listArquivos == null || listArquivos.size() == 0) {
            throw new IllegalArgumentException("A lista de arquivos n\u00e3o pode ser nula ou vazia.");
        }
        this._metadadosArquivos.clear();
        for (int index = 0; index < listArquivos.size(); ++index) {
            Arquivo arquivo = listArquivos.get(index);
            MetadadosArquivoContabil metaDados = new MetadadosArquivoContabil(arquivo);
            for (int indexArquivosFisicos = 0; indexArquivosFisicos < listArquivosFisicos.size(); ++indexArquivosFisicos) {
                File arquivoFisico = listArquivosFisicos.get(indexArquivosFisicos);
                if (!arquivoFisico.getName().equals(arquivo.getNome())) continue;
                metaDados.setArquivoFisico(arquivoFisico);
            }
            this._metadadosArquivos.put(arquivo.getIdentificador(), metaDados);
        }
    }

    public void inicializaMetadadosArquivos(List<Arquivo> listArquivos, String diretorioOrigem) {
        if (listArquivos == null || listArquivos.size() == 0) {
            throw new IllegalArgumentException("A lista de arquivos n\u00e3o pode ser nula ou vazia.");
        }
        if (diretorioOrigem == null || diretorioOrigem.length() < 1) {
            throw new IllegalArgumentException("Diret\u00f3rio de origem \u00e9 inv\u00e1lido.");
        }
        this._metadadosArquivos.clear();
        if (diretorioOrigem.charAt(diretorioOrigem.length() - 1) != File.separatorChar) {
            diretorioOrigem = diretorioOrigem.concat(File.separator);
        }
        for (int index = 0; index < listArquivos.size(); ++index) {
            Arquivo arquivo = listArquivos.get(index);
            MetadadosArquivoContabil metaDados = new MetadadosArquivoContabil(arquivo);
            File arq = new File(diretorioOrigem + arquivo.getNome());
            if (testMode && !arq.exists()) {
                this.log.info((Object)("Arquivo n\u00e3o encontrado: " + arq.getAbsolutePath()));
                File newFile = SituacaoVerificacao.getFileFromParentDir(arq, arquivo.getNome());
                if (newFile != null) {
                    arq = newFile;
                    this.log.info((Object)("Considerando arquivo de pasta superior: " + arq));
                }
            }
            metaDados.setArquivoFisico(arq);
            this._metadadosArquivos.put(arquivo.getIdentificador(), metaDados);
        }
    }

    static File getFileFromParentDir(File origFile, String arq) {
        File dir = origFile.getParentFile();
        File file = new File(dir, arq);
        while (!file.exists()) {
            if ((dir = dir.getParentFile()) == null) {
                return null;
            }
            file = new File(dir, arq);
        }
        return file;
    }

    public void setRemessa(Remessa remessa) {
        this._remessa = remessa;
    }

    public Remessa getRemessa() {
        return this._remessa;
    }

    public void zeraSituacaoVerificao() {
        this._listaMensagens.clear();
        this._tiposDeAvisos.clear();
        this._identificadorMensagem = 0;
    }

    public List<MensagemInstancia> getMensagens() {
        return this._listaMensagens;
    }

    public boolean isVerificacaoEfetuadaComSucesso() {
        MetadadosArquivoContabil mArquivo;
        boolean ok = true;
        Iterator<MetadadosArquivoContabil> it = this._metadadosArquivos.values().iterator();
        while (it.hasNext() && (ok = (mArquivo = it.next()).getSituacao() == 1)) {
        }
        return ok;
    }

    public Iterator<MetadadosArquivoContabil> getMetadadosArquivoIterator() {
        return this._metadadosArquivos.values().iterator();
    }

    public void setBVerAntVazio(boolean bVerAntVazio) {
        this.bVerAntVazio = bVerAntVazio;
    }

    public boolean isBVerAntVazio() {
        return this.bVerAntVazio;
    }
}

