/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.util.PropertiesUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Arquivos
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog(Arquivos.class);
    private String _versaoArquivos;
    private Map<IdentificadorArquivo, Arquivo> _mapaArquivos = new LinkedHashMap<IdentificadorArquivo, Arquivo>(30);
    private boolean _permiteAvancarComErros = PropertiesUtil.getPropertyPermiteAvancarComErros();

    public void addArquivo(Arquivo vArquivo) throws IndexOutOfBoundsException {
        this._mapaArquivos.put(vArquivo.getIdentificador(), vArquivo);
    }

    public void clearArquivo() {
        this._mapaArquivos.clear();
    }

    public Arquivo getArquivoPorIdentificador(IdentificadorArquivo identificador) {
        return this._mapaArquivos.get(identificador);
    }

    public List<Arquivo> getArquivos() {
        HashSet<Arquivo> arquivos = new HashSet<Arquivo>(this._mapaArquivos.values());
        return Arrays.asList(arquivos.toArray(new Arquivo[0]));
    }

    public List<Arquivo> getArquivosPorLeiEntidade(String lei, String entidade, Integer periodo, Integer mes, Integer operacao) {
        if (lei == null || !lei.equals("6404/76") && !lei.equals("4320/64") && !lei.equals("INDIFERENTE") && !lei.equals("UC048")) {
            throw new IllegalArgumentException("Lei n\u00e3o reconhecida: " + lei);
        }
        ArrayList<Arquivo> lista = new ArrayList<Arquivo>(25);
        for (Arquivo arquivo : this._mapaArquivos.values()) {
            String leiArquivo = arquivo.getLei();
            if (!(leiArquivo != null && (leiArquivo.equals("6404/76") || leiArquivo.equals("4320/64") || leiArquivo.equals("INDIFERENTE") || leiArquivo.equals("UC048") || leiArquivo.equals("GENERICA")))) {
                throw new IllegalArgumentException("Lei n\u00e3o reconhecida, verifique a configura\u00e7\u00e3o do arquivo: " + arquivo.getNome() + ", " + leiArquivo);
            }
            if (leiArquivo.equals("GENERICA") || !leiArquivo.equals("INDIFERENTE") && !leiArquivo.equals(lei) || !arquivo.isEntidadeValida(entidade) || !arquivo.isPeriodoValido(String.valueOf(periodo)) || !arquivo.isMesValido(String.valueOf(mes)) || !arquivo.isOperacaoValida(operacao) || !arquivo.getArquivoContabil().isArquivoSelecionado()) continue;
            lista.add(arquivo);
        }
        return lista;
    }

    @Deprecated
    public List<Arquivo> getArquivosPorLeiEntidade(String lei, String entidade, int periodo, int mes) {
        return this.getArquivosPorLeiEntidadePIO(lei, entidade, periodo, mes);
    }

    public List<Arquivo> getArquivosPorLeiEntidadePIO(String lei, String entidade, int periodo, int mes) {
        if (lei == null || !lei.equals("6404/76") && !lei.equals("4320/64") && !lei.equals("INDIFERENTE") && !lei.equals("UC048")) {
            throw new IllegalArgumentException("Lei n\u00e3o reconhecida: " + lei);
        }
        ArrayList<Arquivo> lista = new ArrayList<Arquivo>(25);
        for (Arquivo arquivo : this._mapaArquivos.values()) {
            String leiArquivo = arquivo.getLei();
            if (leiArquivo == null || !leiArquivo.equals("6404/76") && !leiArquivo.equals("4320/64") && !leiArquivo.equals("INDIFERENTE") && !leiArquivo.equals("UC048")) {
                throw new IllegalArgumentException("Lei n\u00e3o reconhecida, verifique a configura\u00e7\u00e3o do arquivo: " + arquivo.getNome() + ", " + leiArquivo);
            }
            if (!leiArquivo.equals(lei) && !leiArquivo.equals("INDIFERENTE") || !arquivo.isEntidadeValida(entidade) || !arquivo.isPeriodoValido(String.valueOf(periodo)) || !arquivo.isMesValido(String.valueOf(mes))) continue;
            lista.add(arquivo);
        }
        return lista;
    }

    public Arquivo[] getTodosArquivos() {
        int size = this._mapaArquivos.size();
        Arquivo[] mArray = new Arquivo[size];
        int index = 0;
        Iterator<Arquivo> it = this._mapaArquivos.values().iterator();
        while (it.hasNext()) {
            mArray[index] = it.next();
            ++index;
        }
        return mArray;
    }

    public int getArquivoCount() {
        return this._mapaArquivos.size();
    }

    public String getVersaoArquivos() {
        return this._versaoArquivos;
    }

    public boolean removeArquivo(Arquivo vArquivo) {
        boolean removed = this._mapaArquivos.remove(vArquivo) != null;
        return removed;
    }

    public void setVersaoArquivos(String versaoArquivos) {
        this._versaoArquivos = versaoArquivos;
    }

    public boolean validaDependencias(MetadadosArquivoContabil metadadosArquivo, SituacaoVerificacao situacao, MensagemFactory msgFactory, List<Arquivo> arquivosList) {
        boolean dependenciasOK = true;
        Arquivo arquivo = metadadosArquivo.getArquivo();
        IdentificadorArquivo[] dependencias = arquivo.getDependencias();
        if (dependencias != null) {
            for (int index = 0; index < dependencias.length; ++index) {
                if (3 != metadadosArquivo.getSituacao() || !this.arquivoSelecionado(arquivosList, dependencias[index])) continue;
                Object[] argumentos = new String[2];
                argumentos[0] = metadadosArquivo.getArquivo().getNome();
                MetadadosArquivoContabil dependente = situacao.getArquivoPorIdentificador(dependencias[index]);
                argumentos[1] = dependente.getArquivo().getNome();
                if (1 == dependente.getSituacao()) continue;
                MensagemInstancia msg = msgFactory.constroiMensagem("VER_01", arquivo, argumentos);
                situacao.adicionaMensagem(msg);
                this.log.warn((Object)("dependencia do arquivo '" + metadadosArquivo.getArquivo().getIdentificadorNome() + "' n\u00e3o encontrada: '" + dependente.getArquivo().getIdentificadorNome() + "'"));
                if (this._permiteAvancarComErros) continue;
                metadadosArquivo.setSituacao(2);
                dependenciasOK = false;
                break;
            }
        }
        return dependenciasOK;
    }

    private boolean arquivoSelecionado(List<Arquivo> arquivosList, IdentificadorArquivo identificadorArquivo) {
        boolean existe = false;
        for (int index = 0; index < arquivosList.size(); ++index) {
            Arquivo arquivo = arquivosList.get(index);
            if (!arquivo.getIdentificador().equals(identificadorArquivo)) continue;
            existe = true;
            break;
        }
        return existe;
    }

    public String toString() {
        return "Arquivos[" + this._mapaArquivos + "]";
    }
}

