/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ldap.test;

import br.gov.rs.tce.ldap.ConfiguracaoLdap;
import br.gov.rs.tce.ldap.ManipulaLdap;
import br.gov.rs.tce.ldap.ManipulaUsuarioLdap;
import br.gov.rs.tce.ldap.UserAttributes;
import br.gov.rs.tce.ldap.exception.LdapException;
import br.gov.rs.tce.ldap.exception.LdapNameNotFoundException;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Hashtable;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;

public class LdapTest {
    public static void main(String[] args) {
        LdapTest.testeBasico();
    }

    public static void testeEntidadeNaoExistente() {
        try {
            String userDn = "CN=12345";
            String rootLogin = ConfiguracaoLdap.getInstance().getRootUsername();
            String rootPassword = ConfiguracaoLdap.getInstance().getRootPassword();
            ManipulaUsuarioLdap ldap = new ManipulaUsuarioLdap(userDn, rootLogin, rootPassword);
            String string = ldap.getMail(userDn, rootLogin, rootPassword);
        }
        catch (LdapNameNotFoundException e) {
            System.out.println("Nao encontrou usuario. Deve estar funcionando.");
        }
        catch (LdapException e) {
            System.out.println("Algum erro aconteceu. Verifique");
            e.printStackTrace();
        }
    }

    public static void testeUpDownCertificado() {
        System.out.println(">>>> testeUpDownCertificado");
        try {
            String certInput = "tcenet-org.56600.17BF.crt";
            String certOutput = "saida.crt";
            X509Certificate cert = X509Certificate.getInstance(LdapTest.getBytesFromFile(new File(certInput)));
            FileWriter writer = new FileWriter(new File(certOutput));
            writer.write("-----BEGIN CERTIFICATE-----");
            writer.write("\n");
            writer.write(new String(Base64.encode(cert.getEncoded())));
            writer.write("\n");
            writer.write("-----END CERTIFICATE-----");
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void testeRootCertificado() {
        System.out.println(">>>> testeRootCertificado");
        try {
            String user = "CN=50000";
            String userLogin = ConfiguracaoLdap.getInstance().getRootUsername();
            String pass = ConfiguracaoLdap.getInstance().getRootPassword();
            ManipulaUsuarioLdap ldap = new ManipulaUsuarioLdap(user, userLogin, pass);
            X509Certificate cert = ldap.getPublicCertificate(user, userLogin, pass);
            try {
                LdapTest.putBytesToFile(new File("cert_as_root.cer"), cert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    public static void testeDownloadCertificado() {
        System.out.println(">>>> testeDownloadCertificado");
        try {
            String userDN = "cn=56600";
            String userLogin = ConfiguracaoLdap.getInstance().formatUsername("56600");
            String pass = "PAD56600";
            ManipulaUsuarioLdap ldap = new ManipulaUsuarioLdap(userDN, userLogin, pass);
            X509Certificate cert = ldap.getPublicCertificate(userDN, userLogin, pass);
            LdapTest.putBytesToFile(new File("certificado.cer"), cert.getEncoded());
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean testeUploadCertificadoPrivado() {
        try {
            String userDn = "cn=56600";
            String login = ConfiguracaoLdap.getInstance().getRootUsername();
            String pass = ConfiguracaoLdap.getInstance().getRootPassword();
            String encoding = "ISO-8859-1";
            System.out.println("Usando encoding " + encoding);
            File pfxOrigem = new File("tcenet-bdl.56600.17BF.pfx");
            if (!pfxOrigem.exists()) {
                System.err.println("ERRO: n\u00e3o \u00e9 poss\u00edvel executar o teste sem um certificado");
                return false;
            }
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            byte[] certByteArray = LdapTest.getBytesFromFile(pfxOrigem);
            ByteBuffer bbfLeitura = ByteBuffer.wrap(certByteArray);
            CharBuffer cbufLeitura = decoder.decode(bbfLeitura);
            ManipulaUsuarioLdap ldap = new ManipulaUsuarioLdap(userDn, login, pass);
            ldap.setPublicAttribute(userDn, UserAttributes.USER_PKCS12, cbufLeitura.toString(), login, pass);
            String certStr = (String)ldap.getPublicAttribute(userDn, UserAttributes.USER_PKCS12, login, pass);
            CharBuffer cbufEscrita = CharBuffer.wrap(certStr.toCharArray());
            CharsetEncoder encoder = charset.newEncoder();
            ByteBuffer bbfEscrita = encoder.encode(cbufEscrita);
            LdapTest.putBytesToFile(new File("output.pfx"), bbfEscrita.array());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void testeCertificado() {
        System.out.println(">>>> testeCertificado");
        String userDn = "cn=50002";
        System.out.println(userDn);
        try {
            String rootUser = ConfiguracaoLdap.getInstance().getRootUsername();
            String rootPassword = ConfiguracaoLdap.getInstance().getRootPassword();
            ManipulaUsuarioLdap ldap = new ManipulaUsuarioLdap(userDn, rootUser, rootPassword);
            Object cert = ldap.getPublicAttribute(userDn, UserAttributes.USER_CERTIFICATE, rootUser, rootPassword);
            System.out.println(cert.toString());
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    public static void putBytesToFile(File file, byte[] bytes) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        ((OutputStream)os).write(bytes);
        ((OutputStream)os).close();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void testeCreateUser() {
        System.out.println(">>>> testeCreateUser");
        try {
            String userToCreate = "cn=teste3";
            String rootUser = ConfiguracaoLdap.getInstance().getRootUsername();
            String rootPassword = ConfiguracaoLdap.getInstance().getRootPassword();
            ManipulaLdap ldap = new ManipulaLdap(rootUser, rootPassword);
            ldap.destroyUserDN(userToCreate, rootUser, rootPassword);
            ldap.createUserDNLike(userToCreate, "cn=50000", rootUser, rootPassword);
            Object obj = ldap.getPublicAttribute(userToCreate, UserAttributes.CN, rootUser, rootPassword);
            System.out.println("aqui:" + obj.getClass().getName() + " # " + obj);
            obj = ldap.getPublicAttribute(userToCreate, UserAttributes.EMAIL, rootUser, rootPassword);
            System.out.println("aqui:" + obj.getClass().getName() + " # " + obj);
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    public static void testeMail() {
        System.out.println(">>>> testeMail");
        String userDn = "cn=56600";
        System.out.println(userDn);
        try {
            String userLogin = ConfiguracaoLdap.getInstance().formatUsername("56600");
            String userPassword = "PAD56600";
            ManipulaUsuarioLdap ldapUser = new ManipulaUsuarioLdap();
            String mail = ldapUser.getMail(userDn, userLogin, userPassword);
            System.out.println("Esse \u00e9 o mail obtido:" + mail);
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    public static void testeSetMail() {
        System.out.println(">>>> testeSetMail");
        try {
            String user = "cn=56600";
            String userLogin = ConfiguracaoLdap.getInstance().formatUsername("56600");
            String userPassword = "PAD56600";
            ManipulaUsuarioLdap ldapUser = new ManipulaUsuarioLdap();
            String mail = ldapUser.getMail(user, userLogin, userPassword);
            System.out.println("antes de setar: " + mail);
            boolean retorno = ldapUser.setMail(user, "teste@tce.rs.gov.br", userLogin, userPassword);
            if (retorno) {
                System.out.println("setou o mail para " + ldapUser.getMail(user, userLogin, userPassword));
                if (ldapUser.setMail(user, mail, userLogin, userPassword)) {
                    System.out.println("Restaurou o email original");
                } else {
                    System.out.println("N\u00e3o restaurou o email original");
                }
            } else {
                System.out.println("N\u00e3o setou o mail!");
            }
        }
        catch (LdapException e) {
            e.printStackTrace();
        }
    }

    public static void testeBasico() {
        System.out.println(">>>> testeBasico");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://iasait.tce.rs.gov.br:389/CN=Users,DC=tce,DC=rs,DC=gov,DC=br");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "cn=orcladmin");
        env.put("java.naming.security.credentials", "iasai4");
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes atts = ctx.getAttributes("cn=50000");
            System.out.println(atts);
            ctx.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

