/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.web.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.validator.Validator;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import oracle.adf.view.faces.component.UIXEditableValue;

public class JSFUtils {
    private static final String NO_RESOURCE_FOUND = "Missing resource: ";

    public static Object resolveExpression(String expression) {
        FacesContext facesContext = JSFUtils.getFacesContext();
        Application app = facesContext.getApplication();
        ValueBinding vExpressionVB = app.createValueBinding(expression);
        return vExpressionVB.getValue(facesContext);
    }

    public static Object resloveMethodExpression(String expression, Class[] paramTypes, Object[] paramObjects) {
        FacesContext facesContext = JSFUtils.getFacesContext();
        Application app = facesContext.getApplication();
        MethodBinding vExpressionVB = app.createMethodBinding(expression, paramTypes);
        return vExpressionVB.invoke(facesContext, paramObjects);
    }

    public static Boolean resolveExpressionAsBoolean(String expression) {
        return (Boolean)JSFUtils.resolveExpression(expression);
    }

    public static String resolveExpressionAsString(String expression) {
        return (String)JSFUtils.resolveExpression(expression);
    }

    public static Object getManagedBeanValue(String beanName) {
        StringBuffer buff = new StringBuffer("#{");
        buff.append(beanName);
        buff.append("}");
        return JSFUtils.resolveExpression(buff.toString());
    }

    public static void removeSessionManagedBean(String beanName) {
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap().remove(beanName);
    }

    public static void setExpressionValue(String expression, Object newValue) {
        FacesContext facesContext = JSFUtils.getFacesContext();
        Application app = facesContext.getApplication();
        ValueBinding vExpressionVB = app.createValueBinding(expression);
        vExpressionVB.getType(facesContext);
        Class bindClass = vExpressionVB.getType(facesContext);
        if (bindClass.isPrimitive() || bindClass.isInstance(newValue)) {
            vExpressionVB.setValue(facesContext, newValue);
        }
    }

    public static void setManagedBeanValue(String beanName, Object newValue) {
        StringBuffer buff = new StringBuffer("#{");
        buff.append(beanName);
        buff.append("}");
        JSFUtils.setExpressionValue(buff.toString(), newValue);
    }

    public static void storeOnSession(String key, Object object) {
        FacesContext ctx = JSFUtils.getFacesContext();
        Map sessionState = ctx.getExternalContext().getSessionMap();
        sessionState.put(key, object);
    }

    public static Object getFromSession(String key) {
        FacesContext ctx = JSFUtils.getFacesContext();
        ExternalContext extCtx = ctx.getExternalContext();
        Map sessionState = extCtx.getSessionMap();
        return sessionState.get(key);
    }

    public static Object getFromRequest(String key) {
        FacesContext ctx = JSFUtils.getFacesContext();
        Map sessionState = ctx.getExternalContext().getRequestMap();
        return sessionState.get(key);
    }

    public static String getStringFromBundle(String key) {
        ResourceBundle bundle = JSFUtils.getBundle();
        return JSFUtils.getStringSafely(bundle, key, null);
    }

    public static FacesMessage getMessageFromBundle(String key, FacesMessage.Severity severity) {
        ResourceBundle bundle = JSFUtils.getBundle();
        String summary = JSFUtils.getStringSafely(bundle, key, null);
        String detail = JSFUtils.getStringSafely(bundle, key + "_detail", summary);
        FacesMessage message = new FacesMessage(summary, detail);
        message.setSeverity(severity);
        return message;
    }

    public static FacesMessage addFacesInformationMessage(String summary) {
        return JSFUtils.addFacesMessage(FacesMessage.SEVERITY_INFO, summary, null, null);
    }

    public static FacesMessage addFacesErrorMessage(String summary) {
        return JSFUtils.addFacesMessage(FacesMessage.SEVERITY_ERROR, summary, null, null);
    }

    public static FacesMessage addFacesErrorMessage(String summary, String msg) {
        return JSFUtils.addFacesMessage(FacesMessage.SEVERITY_ERROR, summary, msg, null);
    }

    public static FacesMessage addFacesMessage(FacesMessage.Severity severity, String summary, String msg, String componentId) {
        FacesContext ctx = JSFUtils.getFacesContext();
        FacesMessage fm = new FacesMessage(severity, summary, msg);
        ctx.addMessage(componentId, fm);
        return fm;
    }

    public static String getRootViewId() {
        return JSFUtils.getFacesContext().getViewRoot().getViewId();
    }

    public static String getRootViewComponentId() {
        return JSFUtils.getFacesContext().getViewRoot().getId();
    }

    public static FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public static FacesContext getFacesContext(ServletRequest req, ServletResponse res, ServletContext servletContext) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            return facesContext;
        }
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        FacesContextFactory contextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        facesContext = contextFactory.getFacesContext((Object)servletContext, (Object)req, (Object)res, lifecycle);
        return facesContext;
    }

    private static ResourceBundle getBundle() {
        FacesContext ctx = JSFUtils.getFacesContext();
        UIViewRoot uiRoot = ctx.getViewRoot();
        Locale locale = uiRoot.getLocale();
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        return ResourceBundle.getBundle(ctx.getApplication().getMessageBundle(), locale, ldr);
    }

    public static Object getRequestAttribute(String name) {
        return JSFUtils.getFacesContext().getExternalContext().getRequestMap().get(name);
    }

    public static void setRequestAttribute(String name, Object value) {
        JSFUtils.getFacesContext().getExternalContext().getRequestMap().put(name, value);
    }

    private static String getStringSafely(ResourceBundle bundle, String key, String defaultValue) {
        String resource = null;
        try {
            resource = bundle.getString(key);
        }
        catch (MissingResourceException mrex) {
            resource = defaultValue != null ? defaultValue : NO_RESOURCE_FOUND + key;
        }
        return resource;
    }

    public static UIComponent findComponentInRoot(String id) {
        UIComponent component = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            UIViewRoot root = facesContext.getViewRoot();
            component = JSFUtils.findComponent((UIComponent)root, id);
        }
        return component;
    }

    public static UIComponent findComponent(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent children = null;
        UIComponent result = null;
        Iterator childrens = base.getFacetsAndChildren();
        while (childrens.hasNext() && result == null) {
            children = (UIComponent)childrens.next();
            if (id.equals(children.getId())) {
                result = children;
                break;
            }
            result = JSFUtils.findComponent(children, id);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static boolean validateComponente(UIXEditableValue component) {
        FacesContext fctx = FacesContext.getCurrentInstance();
        Validator[] validators = component.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            validators[i].validate(fctx, (UIComponent)component, component.getValue());
        }
        return component.isValid();
    }

    public static String getPageURL(String view) {
        FacesContext facesContext = JSFUtils.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        String url = ((HttpServletRequest)externalContext.getRequest()).getRequestURL().toString();
        StringBuffer newUrlBuffer = new StringBuffer();
        newUrlBuffer.append(url.substring(0, url.lastIndexOf("faces/")));
        newUrlBuffer.append("faces");
        String targetPageUrl = view.startsWith("/") ? view : "/" + view;
        newUrlBuffer.append(targetPageUrl);
        return newUrlBuffer.toString();
    }

    public static boolean isPPRRequest(ServletRequest request) {
        String isPpr = request.getParameter("partial");
        return "true".equalsIgnoreCase(isPpr);
    }
}

