/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.web.util;

import br.gov.rs.tce.commons.web.util.exception.DownloadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class DownloadUtils {
    public static final String DEFAULT_CONTENT_TYPE = "application/x-download";
    public static final String PDF_CONTENT_TYPE = "application/pdf";

    public static void sendFileToDownload(File fileToDownload) throws DownloadException, IOException {
        DownloadUtils.sendFileToDownload(fileToDownload, fileToDownload.getName(), DEFAULT_CONTENT_TYPE, Disposition.ATTACHMENT);
    }

    public static void sendFileToDownload(File fileToDownload, String nameToDownload) throws DownloadException, IOException {
        DownloadUtils.sendFileToDownload(fileToDownload, nameToDownload, DEFAULT_CONTENT_TYPE, Disposition.ATTACHMENT);
    }

    public static void sendFileToDownload(File fileToDownload, String nameToDownload, String contentType, Disposition contentDisposition) throws IOException, DownloadException {
        if (fileToDownload.exists()) {
            if (contentType == null) {
                throw new DownloadException("Tipo de conte\u00fado n\u00e3o informado.");
            }
            FileInputStream fis = null;
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            response.reset();
            response.resetBuffer();
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", contentDisposition.getValue() + "; filename=\"" + nameToDownload + "\"");
            response.setContentLength((int)fileToDownload.length());
            ServletOutputStream out = null;
            try {
                int n;
                out = response.getOutputStream();
                fis = new FileInputStream(fileToDownload);
                byte[] buffer = new byte[1024];
                while ((n = fis.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.flush();
            }
            catch (Exception e) {
                throw new DownloadException("Erro ao enviar arquivo para o stream de download.");
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (fis != null) {
                    fis.close();
                }
                FacesContext.getCurrentInstance().responseComplete();
            }
        } else {
            throw new DownloadException("Arquivo enviado pelo servidor n\u00e3o existe.");
        }
    }

    public static enum Disposition {
        ATTACHMENT("attachment"),
        INLINE("inline");

        private String value;

        private Disposition(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

