/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.web.conversores;

import java.math.BigDecimal;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class CpfConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        String cpf = value.replaceAll("\\.", "");
        cpf = cpf.replaceAll("-", "");
        try {
            return new BigDecimal(cpf);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        String cpf = null;
        if (value instanceof String && !value.equals("")) {
            cpf = this.formataCpf(value.toString());
        } else {
            BigDecimal cpfNumber = (BigDecimal)value;
            if (cpfNumber != null && cpfNumber.longValue() != 0L) {
                cpf = this.formataCpf(cpfNumber.toString());
            }
        }
        return cpf;
    }

    private String formataCpf(String cpf) {
        cpf = "00000000000" + cpf;
        int size = cpf.length();
        return cpf.substring(size - 11, size - 8) + "." + cpf.substring(size - 8, size - 5) + "." + cpf.substring(size - 5, size - 2) + "-" + cpf.substring(size - 2, size);
    }
}

