/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.validacao.jsf;

import br.gov.rs.tce.commons.web.util.JSFUtils;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import oracle.adf.view.faces.component.UIXInput;
import org.apache.commons.lang.StringUtils;

public abstract class TceAbstractValidator
implements Validator {
    String mensagemDefault = null;
    FacesContext fcsCtx = null;
    boolean utilizaMensagemDeclarada = true;
    UIComponent component = null;

    public abstract boolean validaValor(Object var1);

    public void validate(FacesContext context, UIComponent component, Object value) {
        this.fcsCtx = context;
        this.component = component;
        this.setMensagemDefault("O campo " + component.getId() + " n\u00e3o foi validado.");
        if (!this.validaValor(value)) {
            this.exibeMensagem(context, component, value);
        }
    }

    private void exibeMensagem(FacesContext context, UIComponent component, Object value) {
        UIXInput uixComponent = (UIXInput)component;
        uixComponent.setValid(false);
        String textoMensagem = (String)uixComponent.getAttributes().get("mensagemValidacao");
        if (textoMensagem == null || !this.utilizaMensagemDeclarada) {
            textoMensagem = this.mensagemDefault;
        }
        String tipoMensagemParam = (String)uixComponent.getAttributes().get("tipoValidacao");
        FacesMessage.Severity tipoMensagem = null;
        if (tipoMensagemParam == null || tipoMensagemParam.startsWith("e") || tipoMensagemParam.startsWith("E")) {
            tipoMensagem = FacesMessage.SEVERITY_ERROR;
        } else if (tipoMensagemParam.startsWith("a") || tipoMensagemParam.startsWith("A")) {
            tipoMensagem = FacesMessage.SEVERITY_WARN;
        } else if (tipoMensagemParam.startsWith("i") || tipoMensagemParam.startsWith("I")) {
            tipoMensagem = FacesMessage.SEVERITY_INFO;
        } else if (tipoMensagemParam.startsWith("f") || tipoMensagemParam.startsWith("F")) {
            tipoMensagem = FacesMessage.SEVERITY_FATAL;
        }
        String sumarioMensagem = (String)uixComponent.getAttributes().get("sumarioValidacao");
        if (StringUtils.isBlank((String)sumarioMensagem)) {
            JSFUtils.addFacesMessage(tipoMensagem, textoMensagem, null, null);
        } else {
            JSFUtils.addFacesMessage(tipoMensagem, sumarioMensagem, textoMensagem, null);
        }
    }

    public Object getAttribute(String name) {
        return this.getComponent().getAttributes().get(name);
    }

    public String getMensagemDefault() {
        return this.mensagemDefault;
    }

    public void setMensagemDefault(String mensagem) {
        this.mensagemDefault = mensagem;
    }

    public FacesContext getFacesContext() {
        return this.fcsCtx;
    }

    public UIComponent getComponent() {
        return this.component;
    }

    public boolean isUtilizaMensagemDeclarada() {
        return this.utilizaMensagemDeclarada;
    }

    public void setUtilizaMensagemDeclarada(boolean naoUtilizaMensagemDeclarada) {
        this.utilizaMensagemDeclarada = naoUtilizaMensagemDeclarada;
    }
}

