/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.command;

import br.gov.rs.tce.command.CommandCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandRunner {
    Log LOG = LogFactory.getLog(CommandRunner.class.getClass());

    public int execute(String command) {
        return this.execute(command, null, true);
    }

    public int execute(String command, boolean wait) {
        return this.execute(command, null, wait);
    }

    public int execute(String command, Writer redirect) {
        return this.execute(command, redirect, true);
    }

    public void executeInThread(final String command, final Writer redirect, final CommandCallback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int ret = CommandRunner.this.execute(command, redirect, true);
                CommandRunner.this.LOG.info((Object)("CommandRunner: retorno == " + ret));
                System.out.println("CommandRunner: retorno == " + ret);
                if (ret != 0) {
                    callback.callback(ret);
                }
            }
        };
        new Thread(runnable).start();
    }

    public int execute(String command, Writer redirect, boolean wait) {
        int exitVal = 0;
        try {
            if (command != null) {
                this.LOG.info((Object)("EXECUTANDO:" + command));
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(this.parseCommand(command));
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR", redirect);
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT", redirect);
                errorGobbler.start();
                outputGobbler.start();
                if (wait) {
                    exitVal = proc.waitFor();
                    errorGobbler.join();
                    outputGobbler.join();
                    this.LOG.info((Object)("Valor de retorno:" + exitVal));
                } else {
                    this.LOG.info((Object)("N\u00e3o esperou waitFor() [retorno:" + exitVal + "]"));
                }
            }
        }
        catch (InterruptedException e) {
            exitVal = -1;
            this.LOG.error((Object)("Erro ao executar comando: " + e.getMessage() + "[retorno:" + exitVal + "]"), (Throwable)e);
        }
        catch (IOException e) {
            exitVal = -2;
            this.LOG.error((Object)("Erro ao executar comando: " + e.getMessage() + "[retorno:" + exitVal + "]"), (Throwable)e);
        }
        return exitVal;
    }

    String[] parseCommand(String command) {
        String regex = "\\S+";
        Matcher matcher = Pattern.compile(regex).matcher(command);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            String current = matcher.group();
            if (current.length() == 0) continue;
            int start = matcher.start();
            boolean removeQuotes = false;
            if (current.charAt(0) == '\"') {
                removeQuotes = true;
                boolean search = true;
                while (search) {
                    int len = current.length();
                    if (len > 0 && current.charAt(len - 1) == '\"') {
                        search = false;
                        continue;
                    }
                    search = matcher.find();
                    current = matcher.group();
                }
            }
            int end = matcher.end();
            if (removeQuotes && end - start > 2) {
                result.add(command.substring(start + 1, end - 1));
                continue;
            }
            result.add(command.substring(start, end));
        }
        String[] array = new String[result.size()];
        result.toArray(array);
        return array;
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        String type;
        Writer writer;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        StreamGobbler(InputStream is, String type, Writer redirect) {
            this.is = is;
            this.type = type;
            this.writer = redirect;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (this.writer != null) {
                        this.writer.write(line);
                    }
                    CommandRunner.this.LOG.info((Object)(this.type + ">" + line));
                }
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

