/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.MutableStruct;
import oracle.ord.im.OrdDocBase;
import oracle.ord.im.OrdMediaUtil;
import oracle.ord.im.OrdSource;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class OrdDoc
extends OrdDocBase {
    OracleConnection conn = null;
    static final OrdDoc _OrdDocFactory = new OrdDoc();

    public void clearLocal() throws SQLException {
        this.getSetSourceObject().setLocal(new BigDecimal(0.0));
    }

    public int closeSource(byte[][] byArray) throws SQLException {
        OrdDocBase[] ordDocBaseArray = new OrdDocBase[]{null};
        Integer n = super._closeSource(byArray, ordDocBaseArray);
        this.copyStruct(ordDocBaseArray[0]);
        return n;
    }

    void copyObject(OrdDoc ordDoc) throws SQLException {
        this._struct = ordDoc._struct;
        if (this._ctx == null) {
            this._ctx = ordDoc._ctx;
        }
        if (this.conn == null) {
            this.conn = ordDoc.conn;
        }
    }

    private void copyStruct(OrdDocBase ordDocBase) throws SQLException {
        this._struct = ordDocBase._struct;
    }

    public CustomDatum create(Datum datum, int n) throws SQLException {
        if (datum == null) {
            return null;
        }
        OrdDoc ordDoc = new OrdDoc();
        ordDoc._struct = new MutableStruct((STRUCT)datum, OrdDocBase._sqlType, OrdDocBase._factory);
        ordDoc._ctx = new OrdDocBase._Ctx((Connection)((STRUCT)datum).getConnection());
        ordDoc.conn = (OracleConnection)ordDoc._ctx.getConnection();
        return ordDoc;
    }

    public void deleteContent() throws SQLException {
        this.copyStruct(super._deleteContent());
    }

    public void export(byte[][] byArray, String string, String string2, String string3) throws SQLException {
        this.copyStruct(super._export(byArray, string, string2, string3));
    }

    public BFILE getBFILE() throws SQLException {
        return super._getBFILE();
    }

    public CLOB getComments() throws SQLException {
        return super.get_Comments();
    }

    public BLOB getContent() throws SQLException {
        return this.getSetSourceObject().getLocaldata();
    }

    public BLOB getContentInLob(byte[][] byArray, String[] stringArray, String[] stringArray2) throws SQLException {
        BLOB bLOB;
        String string = " DECLARE  tempBlob Blob;  BEGIN  DBMS_LOB.CREATETEMPORARY(tempBlob, true, 10);  ? := tempBlob;  END ; ";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.registerOutParameter(1, 2004);
            oracleCallableStatement.execute();
            bLOB = oracleCallableStatement.getBLOB(1);
        }
        finally {
            Object var8_7 = null;
            oracleCallableStatement.close();
        }
        BLOB[] bLOBArray = new BLOB[]{bLOB};
        this.copyStruct(super._getContentInLob(byArray, bLOBArray, stringArray, stringArray2));
        return bLOBArray[0];
    }

    public int getContentLength() throws SQLException {
        if (super.get_ContentLength() != null) {
            return super.get_ContentLength();
        }
        return 0;
    }

    BLOB getContentReadOnly() throws SQLException {
        return this.getSourceObject().getLocaldata();
    }

    public byte[] getDataInByteArray() throws SQLException, IOException, OutOfMemoryError {
        return OrdMediaUtil.getDataInByteArray(this.getContentReadOnly());
    }

    public boolean getDataInFile(String string) throws SQLException, IOException {
        return OrdMediaUtil.getDataInFile(string, this.getContentReadOnly());
    }

    public InputStream getDataInStream() throws SQLException {
        return this.getContentReadOnly().getBinaryStream();
    }

    public static CustomDatumFactory getFactory() {
        return _OrdDocFactory;
    }

    public String getFormat() throws SQLException {
        return super.get_Format();
    }

    public String getMimeType() throws SQLException {
        return super.get_MimeType();
    }

    private OrdSource getSetSourceObject() throws SQLException {
        super.set_Source(super.get_Source());
        return super.get_Source();
    }

    public String getSource() throws SQLException {
        return super._getSource();
    }

    public String getSourceLocation() throws SQLException {
        return this.getSourceObject().getSrclocation();
    }

    public String getSourceName() throws SQLException {
        return this.getSourceObject().getSrcname();
    }

    private OrdSource getSourceObject() throws SQLException {
        return super.get_Source();
    }

    public String getSourceType() throws SQLException {
        return this.getSourceObject().getSrctype();
    }

    public Timestamp getUpdateTime() throws SQLException {
        return this.getSourceObject().getUpdatetime();
    }

    public void importData(byte[][] byArray, boolean bl) throws SQLException {
        String string = "declare  obj ordsys.OrdDoc;  res BOOLEAN;  setProp INTEGER;   begin    obj := ?;  setProp := ? ;  if setProp = 1 then  res := TRUE;  else   res := FALSE;  end  if;   obj.import(?,res);  ? := obj;  end;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setCustomDatum(1, (CustomDatum)this);
            if (bl) {
                oracleCallableStatement.setInt(2, 1);
            } else {
                oracleCallableStatement.setInt(2, 0);
            }
            oracleCallableStatement.setBytes(3, byArray[0]);
            oracleCallableStatement.registerOutParameter(3, -3);
            oracleCallableStatement.registerOutParameter(4, 2002, "ORDSYS.ORDDOC");
            oracleCallableStatement.execute();
            byArray[0] = oracleCallableStatement.getBytes(3);
            this.copyStruct((OrdDoc)oracleCallableStatement.getCustomDatum(4, OrdDoc.getFactory()));
        }
        finally {
            Object var6_5 = null;
            oracleCallableStatement.close();
        }
    }

    public void importFrom(byte[][] byArray, String string, String string2, String string3, boolean bl) throws SQLException {
        String string4 = "declare  obj ordsys.OrdDoc;  res BOOLEAN;  setProp INTEGER;   begin    obj := ?;  setProp := ? ;  if setProp = 1 then  res := TRUE;  else   res := FALSE;  end  if;   obj.importFrom(?,?,?,?,res);  ? := obj;  end;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string4);
            oracleCallableStatement.setCustomDatum(1, (CustomDatum)this);
            if (bl) {
                oracleCallableStatement.setInt(2, 1);
            } else {
                oracleCallableStatement.setInt(2, 0);
            }
            oracleCallableStatement.setBytes(3, byArray[0]);
            oracleCallableStatement.setString(4, string);
            oracleCallableStatement.setString(5, string2);
            oracleCallableStatement.setString(6, string3);
            oracleCallableStatement.registerOutParameter(3, -3);
            oracleCallableStatement.registerOutParameter(7, 2002, "ORDSYS.ORDDOC");
            oracleCallableStatement.execute();
            byArray[0] = oracleCallableStatement.getBytes(3);
            this.copyStruct((OrdDoc)oracleCallableStatement.getCustomDatum(7, OrdDoc.getFactory()));
        }
        finally {
            Object var9_8 = null;
            oracleCallableStatement.close();
        }
    }

    public boolean isLocal() throws SQLException {
        BigDecimal bigDecimal = this.getSourceObject().getLocal();
        if (bigDecimal == null) {
            return true;
        }
        return bigDecimal.intValue() != 0;
    }

    public boolean loadDataFromByteArray(byte[] byArray) throws SQLException, IOException {
        this.deleteContent();
        this.setLocal();
        this.setUpdateTime(null);
        return OrdMediaUtil.loadDataFromByteArray(byArray, this.getContent());
    }

    public boolean loadDataFromFile(String string) throws SQLException, IOException {
        this.deleteContent();
        this.setLocal();
        this.setUpdateTime(null);
        return OrdMediaUtil.loadData(string, this.getContent());
    }

    public boolean loadDataFromInputStream(InputStream inputStream) throws SQLException, IOException {
        this.deleteContent();
        this.setLocal();
        this.setUpdateTime(null);
        return OrdMediaUtil.loadDataFromInputStream(inputStream, this.getContent());
    }

    public int openSource(byte[] byArray, byte[][] byArray2) throws SQLException {
        OrdDocBase[] ordDocBaseArray = new OrdDocBase[]{null};
        Integer n = super._openSource(byArray, byArray2, ordDocBaseArray);
        this.copyStruct(ordDocBaseArray[0]);
        return n;
    }

    public byte[] processSourceCommand(byte[][] byArray, String string, String string2, byte[][] byArray2) throws SQLException {
        OrdDocBase[] ordDocBaseArray = new OrdDocBase[]{null};
        byte[] byArray3 = super._processSourceCommand(byArray, string, string2, byArray2, ordDocBaseArray);
        this.copyStruct(ordDocBaseArray[0]);
        return byArray3;
    }

    public int readFromSource(byte[][] byArray, int n, int n2, byte[][] byArray2) throws SQLException {
        Integer[] integerArray = new Integer[]{new Integer(n2)};
        this.copyStruct(super._readFromSource(byArray, new Integer(n), integerArray, byArray2));
        return integerArray[0];
    }

    public void setComments(CLOB cLOB) throws SQLException {
        super.set_Comments(cLOB);
    }

    void setContent(BLOB bLOB) throws SQLException {
        this.getSetSourceObject().setLocaldata(bLOB);
    }

    public void setContentLength(int n) throws SQLException {
        super.set_ContentLength(new Integer(n));
    }

    public void setFormat(String string) throws SQLException {
        super.set_Format(string);
    }

    public void setLocal() throws SQLException {
        this.getSetSourceObject().setLocal(new BigDecimal(1.0));
    }

    public void setMimeType(String string) throws SQLException {
        super.set_MimeType(string);
    }

    public void setProperties(byte[][] byArray, boolean bl) throws SQLException {
        String string = "declare  obj ordsys.OrdDoc;  res BOOLEAN;  setComments INTEGER;   begin    obj := ?;  setComments := ? ;  if setComments = 1 then  res := TRUE;  else   res := FALSE;  end  if;   obj.setProperties(?,res);  ? := obj;  end;";
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.conn.prepareCall(string);
            oracleCallableStatement.setCustomDatum(1, (CustomDatum)this);
            if (bl) {
                oracleCallableStatement.setInt(2, 1);
            } else {
                oracleCallableStatement.setInt(2, 0);
            }
            oracleCallableStatement.setBytes(3, byArray[0]);
            oracleCallableStatement.registerOutParameter(3, -3);
            oracleCallableStatement.registerOutParameter(4, 2002, "ORDSYS.ORDDOC");
            oracleCallableStatement.execute();
            byArray[0] = oracleCallableStatement.getBytes(3);
            this.copyStruct((OrdDoc)oracleCallableStatement.getCustomDatum(4, OrdDoc.getFactory()));
        }
        finally {
            Object var6_5 = null;
            oracleCallableStatement.close();
        }
    }

    public void setSource(String string, String string2, String string3) throws SQLException {
        OrdSource ordSource = this.getSetSourceObject();
        ordSource.setSrctype(string);
        ordSource.setSrclocation(string2);
        ordSource.setSrcname(string3);
    }

    void setSourceObject(OrdSource ordSource) throws SQLException {
        super.set_Source(ordSource);
    }

    public void setUpdateTime(Timestamp timestamp) throws SQLException {
        this.copyStruct(super._setUpdateTime(timestamp));
    }

    public int trimSource(byte[][] byArray, int n) throws SQLException {
        OrdDocBase[] ordDocBaseArray = new OrdDocBase[]{null};
        Integer n2 = super._trimSource(byArray, new Integer(n), ordDocBaseArray);
        this.copyStruct(ordDocBaseArray[0]);
        return n2;
    }

    public int writeToSource(byte[][] byArray, int n, int n2, byte[] byArray2) throws SQLException {
        Integer[] integerArray = new Integer[]{new Integer(n2)};
        this.copyStruct(super._writeToSource(byArray, new Integer(n), integerArray, byArray2));
        return integerArray[0];
    }
}

