/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.CharacterMap;

public class XMLObjectWriter
extends Writer {
    private PrintWriter m_writer;
    private String m_encoding = "UTF8";
    private int m_mode;
    private String m_xml;
    private static final int s_margin = 30;
    protected Object m_lock = new Object();

    public XMLObjectWriter() {
    }

    public XMLObjectWriter(Writer writer) {
        super((Object)writer);
        this.m_writer = new PrintWriter(writer);
    }

    public XMLObjectWriter(OutputStream outputStream) {
        try {
            this.m_writer = new PrintWriter(new OutputStreamWriter(outputStream, "UTF8"));
        }
        catch (Exception exception) {
            this.m_writer = new PrintWriter(new OutputStreamWriter(outputStream));
        }
    }

    public void setIndentEnabled(boolean bl) {
        this.m_mode = bl ? 2 : 0;
    }

    public void setIndentMode(int n) {
        this.m_mode = n;
    }

    public int getIndentMode() {
        return this.m_mode;
    }

    public void setEncoding(String string) {
        this.m_encoding = string;
    }

    public void writeObjectNode(BaseObjectNode baseObjectNode) throws BIIOException {
        this.writeObjectNode(baseObjectNode, null);
    }

    public void writeObjectNode(BaseObjectNode baseObjectNode, CharacterMap characterMap) throws BIIOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (baseObjectNode != null && baseObjectNode.getDOMElement() == null) {
                    int n = baseObjectNode.getRequiredCapacity(0, this.m_mode) + 30;
                    StringBuffer stringBuffer = new StringBuffer(n);
                    this.writeHeader(stringBuffer, "1.0", null, characterMap);
                    if (this.m_mode > 0) {
                        stringBuffer.append(BaseNode.NEW_LINE);
                    }
                    baseObjectNode.finishAll(stringBuffer, "", this.m_mode);
                    String string = this.convertCharacters(stringBuffer.toString(), characterMap);
                    if (this.m_writer != null) {
                        this.m_writer.print(string);
                    } else {
                        this.m_xml = string;
                    }
                }
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    throw new BIIOException(iOException.getLocalizedMessage(), null);
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    public String toString() {
        if (this.m_writer == null) {
            if (this.m_xml == null) {
                return "";
            }
            return this.m_xml;
        }
        return super.toString();
    }

    public void close() {
        if (this.m_writer != null) {
            this.m_writer.close();
        }
    }

    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(cArray, n, n2);
        }
    }

    private String convertCharacters(String string, CharacterMap characterMap) {
        if (characterMap != null) {
            Vector vector = characterMap.getMappings();
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    Object object;
                    Object e = vector.elementAt(n);
                    if (e instanceof CharacterMap.CharHolder) {
                        object = (CharacterMap.CharHolder)vector.elementAt(n);
                        string = string.replace(((CharacterMap.CharHolder)object).getKey(), ((CharacterMap.CharHolder)object).getValue());
                    } else if (e instanceof CharacterMap.StringHolder) {
                        object = (CharacterMap.StringHolder)vector.elementAt(n);
                        string = this.replace(string, 0, ((CharacterMap.StringHolder)object).getKey(), ((CharacterMap.StringHolder)object).getValue());
                    }
                    ++n;
                }
            }
            return string;
        }
        return string;
    }

    private String replace(String string, int n, String string2, String string3) {
        int n2 = string.indexOf(string2, n);
        if (n2 > -1) {
            String string4 = String.valueOf(string.substring(0, n2)) + string3 + string.substring(n2 + string2.length(), string.length());
            return this.replace(string4, n2, string2, string3);
        }
        return string;
    }

    private void writeHeader(StringBuffer stringBuffer, String string, String string2, CharacterMap characterMap) {
        if (string == null) {
            string = "1.0";
        }
        Object var5_5 = null;
        if (string2 == null) {
            stringBuffer.append("<?xml version=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" ?>");
        } else {
            stringBuffer.append("<?xml version=\"");
            stringBuffer.append(string);
            stringBuffer.append("\" encoding=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" ?>");
        }
    }
}

