/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.PropertyNode;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class BaseObjectNode
extends BaseNode {
    protected boolean m_closed;

    BaseObjectNode(ObjectScope objectScope, Node node) {
        super(objectScope, node);
        this.m_name = ((Element)node).getTagName();
    }

    public BaseObjectNode(String string) {
        super(string);
    }

    void initBuffer() {
        if (this.m_buffer == null) {
            this.m_buffer = new StringBuffer(150);
            this.m_buffer.append("<");
            this.m_buffer.append(this.m_name);
            if (this.m_post == null) {
                this.initPost();
            }
        }
    }

    void initPost() {
        if (this.m_post == null) {
            this.m_post = new StringBuffer("/>");
        }
    }

    public void addProperty(String string, String string2) {
        this.addProperty(string, string2, true);
    }

    public void addProperty(String string, String string2, boolean bl) {
        this.initBuffer();
        if (bl) {
            if (string2 == null) {
                string2 = "";
            }
            this.m_buffer.append(" ");
            this.m_buffer.append(string);
            this.m_buffer.append("=\"");
            this.m_buffer.append(BaseNode.createEscapes(string2));
            this.m_buffer.append("\"");
        } else {
            String string3 = new StringBuffer(20).append("<").append(string).append(">").append(this.createCDATA(string2)).append("</").append(string).append(">").toString();
            this.addChild(string3);
        }
    }

    public void addProperty(String string, boolean bl, boolean bl2) {
        this.addProperty(string, new Boolean(bl).toString(), bl2);
    }

    public void addProperty(String string, boolean bl) {
        this.addProperty(string, bl, true);
    }

    public void addProperty(String string, int n, boolean bl) {
        this.addProperty(string, new Integer(n).toString(), bl);
    }

    public void addProperty(String string, int n) {
        this.addProperty(string, n, true);
    }

    public void addProperty(String string, double d, boolean bl) {
        this.addProperty(string, new Double(d).toString(), bl);
    }

    public void addProperty(String string, double d) {
        this.addProperty(string, d, true);
    }

    public void addProperty(String string, long l, boolean bl) {
        this.addProperty(string, new Long(l).toString(), bl);
    }

    public void addProperty(String string, long l) {
        this.addProperty(string, l, true);
    }

    public void addProperty(String string, char c, boolean bl) {
        this.addProperty(string, new Character(c).toString(), bl);
    }

    public void addProperty(String string, char c) {
        this.addProperty(string, c, true);
    }

    public void addProperty(PropertyNode propertyNode) {
        this.addChild(propertyNode);
    }

    protected void addChild(Object object) {
        this.initVector();
        if (!this.m_closed) {
            this.initPost();
            this.m_post.append(this.m_name).append(">");
            this.m_post.setCharAt(0, '<');
            this.m_post.setCharAt(1, '/');
            this.m_nodes.addElement(object);
            this.m_closed = true;
        } else {
            this.m_nodes.addElement(object);
        }
    }

    public PropertyNode getProperty(String string) {
        Node node = this.getPropertyValue(string);
        if (node == null) {
            return null;
        }
        return new PropertyNode(this.m_scope, node);
    }

    protected Node getPropertyValue(String string, boolean bl) {
        return this.getPropertyValue(string);
    }

    protected Node getPropertyValue(String string) {
        Attr attr = this.getAttributeByName(string);
        if (attr == null) {
            Element element = (Element)((XMLElement)this.m_node).getChildrenByTagName(string).item(0);
            if (element == null) {
                return null;
            }
            return element;
        }
        return attr;
    }

    public Enumeration getPropertyNames() {
        NamedNodeMap namedNodeMap = ((Element)this.m_node).getAttributes();
        Vector<String> vector = new Vector<String>(namedNodeMap.getLength());
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            vector.addElement(node.getNodeName());
            ++n;
        }
        return vector.elements();
    }

    protected Element getFirstElement() {
        NodeList nodeList = ((Element)this.m_node).getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                return (Element)node;
            }
            ++n;
        }
        return null;
    }

    public String getPropertyValueAsString(String string) throws NoSuchPropertyException {
        Node node = this.getPropertyValue(string);
        if (node != null) {
            if (node instanceof Attr) {
                String string2 = ((Attr)node).getValue();
                return string2;
            }
            if (node instanceof Element) {
                Element element = (Element)node;
                Node node2 = element.getFirstChild();
                if (element.getAttributes().getLength() == 0) {
                    if (node2 instanceof Text) {
                        return ((XMLText)node2).getNodeValue();
                    }
                    if (node2 instanceof CDATASection) {
                        return ((XMLCDATA)node2).getNodeValue();
                    }
                }
            }
        }
        throw new NoSuchPropertyException(string);
    }

    public int getPropertyValueAsInteger(String string) throws NoSuchPropertyException {
        String string2 = this.getPropertyValueAsString(string);
        return Integer.valueOf(string2);
    }

    public boolean getPropertyValueAsBoolean(String string) throws NoSuchPropertyException {
        String string2 = this.getPropertyValueAsString(string);
        return Boolean.valueOf(string2);
    }

    public double getPropertyValueAsDouble(String string) throws NoSuchPropertyException {
        String string2 = this.getPropertyValueAsString(string);
        return Double.valueOf(string2);
    }

    public long getPropertyValueAsLong(String string) throws NoSuchPropertyException {
        String string2 = this.getPropertyValueAsString(string);
        return Long.valueOf(string2);
    }

    public char getPropertyValueAsChar(String string) throws NoSuchPropertyException {
        String string2 = this.getPropertyValueAsString(string);
        return string2.charAt(0);
    }

    private Attr getAttributeByName(String string) {
        return ((Element)this.m_node).getAttributeNode(string);
    }

    public int getAttributeCount() {
        NamedNodeMap namedNodeMap = ((XMLElement)this.m_node).getAttributes();
        if (namedNodeMap != null) {
            return namedNodeMap.getLength();
        }
        return 0;
    }
}

