/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.persistence;

import java.io.Serializable;
import java.util.Date;
import java.util.Vector;
import oracle.dss.util.persistence.AttributeValue;

public class ComponentAttribute
implements Serializable {
    private String m_name;
    private Vector m_values = new Vector(2);

    public ComponentAttribute(String string) {
        this.m_name = string;
    }

    public ComponentAttribute(String string, Byte by) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(1, by));
    }

    public ComponentAttribute(String string, Character c) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(2, c));
    }

    public ComponentAttribute(String string, Double d) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(3, d));
    }

    public ComponentAttribute(String string, Float f) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(4, f));
    }

    public ComponentAttribute(String string, Integer n) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(5, n));
    }

    public ComponentAttribute(String string, Short s) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(7, s));
    }

    public ComponentAttribute(String string, Boolean bl) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(8, bl));
    }

    public ComponentAttribute(String string, String string2) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(9, string2));
    }

    public ComponentAttribute(String string, Date date) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(10, date));
    }

    public ComponentAttribute(String string, Long l) {
        this.m_name = string;
        this.m_values.addElement(new AttributeValue(6, l));
    }

    public String getName() {
        return this.m_name.trim();
    }

    public AttributeValue[] getValues() {
        if (this.m_values.size() == 0) {
            return null;
        }
        Object[] objectArray = new AttributeValue[this.m_values.size()];
        this.m_values.copyInto(objectArray);
        return objectArray;
    }

    public boolean add(Object object) {
        int n = -1;
        if (object == null) {
            AttributeValue attributeValue = new AttributeValue(9, null);
            if (this.m_values.contains(attributeValue)) {
                return false;
            }
            this.m_values.addElement(attributeValue);
            return true;
        }
        n = this.getObjectType(object);
        if (n != -1) {
            AttributeValue attributeValue = new AttributeValue(n, object);
            if (this.m_values.contains(attributeValue)) {
                return false;
            }
            this.m_values.addElement(attributeValue);
            return true;
        }
        return false;
    }

    private int getObjectType(Object object) {
        if (object instanceof String) {
            return 9;
        }
        if (object instanceof Boolean) {
            return 8;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Character) {
            return 2;
        }
        if (object instanceof Date) {
            return 10;
        }
        if (object instanceof Double) {
            return 3;
        }
        if (object instanceof Float) {
            return 4;
        }
        if (object instanceof Integer) {
            return 5;
        }
        if (object instanceof Long) {
            return 6;
        }
        if (object instanceof Short) {
            return 7;
        }
        return -1;
    }
}

