/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;

public class Range
implements Serializable {
    public int begin;
    public int end;

    public Range() {
        this.begin = 0;
        this.end = 0;
    }

    public Range(int n, int n2) {
        this.begin = n;
        this.end = n2;
    }

    public Range(Range range) {
        this.begin = range.begin;
        this.end = range.end;
    }

    public Object clone() {
        return new Range(this.begin, this.end);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        return this.begin == range.begin && this.end == range.end;
    }

    public void setBounds(int n, int n2) {
        this.begin = n;
        this.end = n2;
    }

    public boolean contains(Range range) {
        return this.begin < range.begin && this.end > range.end;
    }

    public boolean contains(int n) {
        return n >= this.begin && n <= this.end;
    }

    public int count() {
        return Math.abs(this.end - this.begin) + 1;
    }

    public String toString() {
        return String.valueOf(String.valueOf("(")) + this.begin + "," + this.end + ")";
    }
}

