/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.JChart_2D_BLA;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.JChart_2D_Hilo;
import oracle.dss.graph.pfj.JChart_2D_Hist;
import oracle.dss.graph.pfj.JChart_2D_Pareto;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.JChart_2D_PieBar;
import oracle.dss.graph.pfj.JChart_2D_Polar;
import oracle.dss.graph.pfj.JChart_2D_Radar;
import oracle.dss.graph.pfj.JChart_2D_Scat;
import oracle.dss.graph.pfj.JChart_2D_Spec;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.JChart_3D_Surf;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.SmartText;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.ObjectString;
import oracle.dss.graph.pfj.utilities.TDGTimer;

public class ToolTips {
    static final int DATA_VALUE_ABS = 3;
    static final int DATA_VALUE_FORMATTED = 4;
    static final int DATA_VALUE_OPEN = 5;
    static final int DATA_VALUE_HI = 6;
    static final int DATA_VALUE_LOW = 7;
    static final int DATA_VALUE_CLOSE = 8;
    static final int DATA_VALUE_VOLUME = 9;
    static final int DATA_VALUE_X = 10;
    static final int DATA_VALUE_Y = 11;
    static final int DATA_VALUE_Z = 12;
    static final String RETURN_MACRO = "[R]";
    static final String OBJECT_NAME_MACRO = "[ON]";
    static final String OBJECT_DESCRIPTION_MACRO = "[OD]";
    static final String OBJECT_ID_MACRO = "[OID]";
    static final String OBJECT_INSTANCE_MACRO = "[OIN]";
    static final String SERIES_LABEL_MACRO = "[SL]";
    static final String GROUP_LABEL_MACRO = "[GL]";
    static final String CUMULATIVE_STACKED_VALUE_MACRO = "[CUMSTKV]";
    static final String CUMULATIVE_PERCENTAGE_VALUE_MACRO = "[CUMPCTV]";
    static final String PIE_PERCENTAGE_VALUE_MACRO = "[PIEPCTV]";
    static final String HILO_HIGH_VALUE_MACRO = "[HV]";
    static final String HILO_LOW_VALUE_MACRO = "[LV]";
    static final String HILO_OPEN_VALUE_MACRO = "[OV]";
    static final String HILO_CLOSE_VALUE_MACRO = "[CV]";
    static final String HILO_VOLUME_VALUE_MACRO = "[VV]";
    static final String X_VALUE_MACRO = "[XV]";
    static final String Y_VALUE_MACRO = "[YV]";
    static final String Z_VALUE_MACRO = "[ZV]";
    static final String PARETO_VALUE_MACRO = "[PV]";
    static final int MIN_TOOLTIPWIDTH = 40;
    static final int MIN_TOOLTIPHEIGHT = 12;
    static final int DROPSHADOW_SIZE = 4;
    static final int WIDTH_FUDGE_FACTOR = 6;
    static final int MAXIMUM_TIP_LINES = 100;
    protected String[] m_TipStrings = new String[100];
    protected boolean m_bSeriesRelatedObject;
    protected boolean m_bDataRelatedObject;
    protected boolean m_bDrawCustomToolTip;
    protected boolean m_bReferenceLineRelatedObject;
    protected Rectangle m_RectTipShape = new Rectangle();
    protected Perspective m_Perspective;
    protected DetObj m_detObj;
    protected MouseEvent m_mouseEvt;
    protected TDGMouseState m_mouseState;
    protected Font m_ToolTipFont;
    protected int m_nToolTipX;
    protected int m_nToolTipY;
    protected int m_nNumToolTipLines;
    protected JChart_Base m_Chart;
    protected String m_strCustomToolTipUser = "";
    protected String m_strCustomToolTipDeveloper = "";
    protected String m_strDynamicToolTip;
    TDGTimer timeOutTimer;

    public ToolTips(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_ToolTipFont = new Font("SansSerif", 0, 10);
    }

    public void releaseReferences() {
        if (this.timeOutTimer != null) {
            this.timeOutTimer.stop();
            this.timeOutTimer.finalize();
            this.timeOutTimer = null;
        }
        this.m_Perspective = null;
        this.m_Chart = null;
    }

    public void setUserToolTipDefault() {
        this.m_strCustomToolTipUser = "";
    }

    public void setUserToolTip(String string) {
        this.m_strCustomToolTipUser = string;
    }

    public void setDeveloperToolTipDefault() {
        this.m_strCustomToolTipDeveloper = "";
    }

    public void setDeveloperToolTip(String string) {
        this.m_strCustomToolTipDeveloper = string;
    }

    public void setDynamicToolTip(String string) {
        this.m_strDynamicToolTip = string;
    }

    public void setDetObject(DetObj detObj) {
        this.m_detObj = detObj;
    }

    public void setToolTip(TDGMouseState tDGMouseState, DetObj detObj) {
        this.m_mouseState = tDGMouseState;
        this.m_nToolTipX = tDGMouseState.getMouseX();
        this.m_nToolTipY = tDGMouseState.getMouseY();
        this.m_mouseEvt = tDGMouseState.getMouseEvent();
        this.m_detObj = detObj;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void clearToolTip() {
        int n = 0;
        while (n < 100) {
            this.m_TipStrings[n] = "";
            ++n;
        }
        if (this.timeOutTimer != null) {
            this.timeOutTimer.stop();
            this.timeOutTimer.finalize();
            this.timeOutTimer = null;
        }
    }

    public void drawAlignedString(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        if (n3 != 0) {
            int n6 = fontMetrics.stringWidth(string);
            if (n3 == 1) {
                n4 += (this.m_RectTipShape.width - n6) / 2;
            } else if (n3 == 2) {
                n4 = n4 + this.m_RectTipShape.width - n6;
            }
        }
        if (n3 == 0) {
            ++n4;
        }
        if (n3 == 2) {
            --n4;
        }
        SmartText smartText = this.m_Perspective.getSmartText();
        string = smartText.getDisplayString(this.m_Perspective, string);
        graphics.drawString(string, n4, n5);
    }

    /*
     * Unable to fully structure code
     */
    public int drawDescription(Graphics var1_1, FontMetrics var2_2, String var3_3, int var4_4, int var5_5) {
        block8: {
            var11_6 = 0;
            var12_7 = 0;
            var14_8 = var3_3;
            var17_9 = var2_2.getMaxAscent();
            var8_10 = this.m_RectTipShape.width;
            var9_11 = this.m_bDrawCustomToolTip != false ? var5_5 + this.m_RectTipShape.height : (this.m_Perspective.getToolTipMode() == true ? var5_5 + this.m_RectTipShape.height - var2_2.getHeight() : var5_5 + this.m_RectTipShape.height);
            var6_12 = var4_4;
            var7_13 = var5_5;
            break block8;
            while (++var11_6 < var14_8.length()) lbl-1000:
            // 2 sources

            {
                ** while (var11_6 >= var14_8.length() || var14_8.charAt((int)var11_6) != ' ')
lbl12:
                // 1 sources

            }
lbl13:
            // 2 sources

            var12_7 = var11_6;
            var13_14 = -1;
            var15_15 = null;
            while (var12_7 >= var11_6) {
                var16_16 = (var12_7 = var14_8.indexOf(32, var12_7)) == -1 ? var14_8.substring(var11_6) : var14_8.substring(var11_6, var12_7);
                if (var2_2.stringWidth(var16_16) < var8_10) {
                    var15_15 = var16_16;
                    var13_14 = var12_7;
                    if (var12_7 == -1) {
                        break;
                    }
                } else {
                    var19_17 = 0;
                    var20_18 = 0;
                    var12_7 = var11_6;
                    while (var12_7 < var14_8.length()) {
                        var20_18 = var2_2.charWidth(var14_8.charAt(var12_7));
                        if (var19_17 + var20_18 >= var8_10) break;
                        var19_17 += var20_18;
                        ++var12_7;
                    }
                    this.drawAlignedString(var1_1, var2_2, var14_8.substring(var11_6, var12_7), var6_12, var7_13, 0);
                    var11_6 = var12_7;
                    var15_15 = null;
                    break;
                }
                ++var12_7;
            }
            if (var15_15 != null) {
                this.drawAlignedString(var1_1, var2_2, var15_15, var6_12, var7_13, 0);
                var11_6 = var13_14;
            }
            var7_13 += var2_2.getHeight();
        }
        if (var7_13 + var2_2.getHeight() <= var9_11 && var11_6 != -1) ** GOTO lbl-1000
        return var7_13;
    }

    public void drawToolTip(Graphics graphics, FontMetrics fontMetrics, int n, int n2) {
        block12: {
            block13: {
                block11: {
                    graphics.setColor(Color.black);
                    if (this.m_Perspective.getToolTipTimeOutEnabled()) {
                        this.timeOutTimer = new TDGTimer(5000, true);
                        this.timeOutTimer.start();
                        SymAction symAction = new SymAction();
                        this.timeOutTimer.addActionListener(symAction);
                    } else if (this.timeOutTimer != null) {
                        this.timeOutTimer.stop();
                    }
                    if (!this.m_bDrawCustomToolTip) break block11;
                    int n3 = n2 + fontMetrics.getHeight() - 2;
                    int n4 = 0;
                    while (n4 < this.m_nNumToolTipLines) {
                        if (this.m_TipStrings[n4].length() > 0) {
                            n3 = this.drawDescription(graphics, fontMetrics, this.m_TipStrings[n4], n + 2, n3);
                        }
                        ++n4;
                    }
                    break block12;
                }
                if (this.m_bSeriesRelatedObject && this.m_bDataRelatedObject) break block13;
                this.drawAlignedString(graphics, fontMetrics, this.m_TipStrings[0], n + 2, n2 + fontMetrics.getHeight() - 2, 0);
                if (this.m_TipStrings[1].length() <= 0) break block12;
                this.drawDescription(graphics, fontMetrics, this.m_TipStrings[1], n + 2, n2 + fontMetrics.getHeight() * 2 - 2);
                break block12;
            }
            if (this.m_Perspective.getToolTipMode()) {
                this.drawAlignedString(graphics, fontMetrics, this.m_TipStrings[0], n + 2, n2 + fontMetrics.getHeight() - 2, 0);
                int n5 = this.drawDescription(graphics, fontMetrics, this.m_TipStrings[1], n + 2, n2 + fontMetrics.getHeight() * 2 - 2);
                int n6 = 0;
                int n7 = 0;
                while (n7 < this.m_nNumToolTipLines) {
                    if (this.m_TipStrings[n7 + 2].length() > 0) {
                        this.drawAlignedString(graphics, fontMetrics, this.m_TipStrings[n7 + 2], n + 2, n5 + fontMetrics.getHeight() * n6 - 2, 1);
                        ++n6;
                    }
                    ++n7;
                }
            } else {
                int n8 = 0;
                int n9 = 0;
                while (n9 < this.m_nNumToolTipLines) {
                    if (this.m_TipStrings[n9].length() > 0) {
                        this.drawAlignedString(graphics, fontMetrics, this.m_TipStrings[n9], n + 2, n2 + fontMetrics.getHeight() * (n8 + 1) - 2, 1);
                        ++n8;
                    }
                    ++n9;
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        boolean bl;
        graphics.setFont(this.m_ToolTipFont);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_ToolTipFont);
        if (this.m_detObj != null && (bl = this.prepareToolTip(fontMetrics))) {
            int n;
            Image image = this.m_Perspective.createOffscreenImage(this.m_RectTipShape.width + 6, this.m_RectTipShape.height);
            Graphics graphics2 = image.getGraphics();
            graphics2.setFont(this.m_ToolTipFont);
            this.m_RectTipShape.x = this.m_nToolTipX;
            this.m_RectTipShape.y = this.m_nToolTipY - this.m_RectTipShape.height;
            Rectangle rectangle = this.m_Perspective.getBounds();
            int n2 = this.m_RectTipShape.x + this.m_RectTipShape.width - rectangle.width;
            if (n2 > 0) {
                this.m_RectTipShape.x -= n2;
            }
            if ((n = this.m_RectTipShape.y) < 0) {
                this.m_RectTipShape.y -= n;
            }
            this.m_RectTipShape.width += 6;
            graphics2.setColor(Color.black);
            graphics2.fillRect(0, 0, this.m_RectTipShape.width, this.m_RectTipShape.height);
            this.m_RectTipShape.x -= 4;
            this.m_RectTipShape.y -= 4;
            graphics2.setColor(Color.yellow);
            graphics2.fillRect(0, 0, this.m_RectTipShape.width, this.m_RectTipShape.height);
            graphics2.setColor(Color.black);
            graphics2.drawRect(0, 0, this.m_RectTipShape.width - 1, this.m_RectTipShape.height - 1);
            this.drawToolTip(graphics2, fontMetrics, 0, 0);
            graphics.drawImage(image, this.m_RectTipShape.x, this.m_RectTipShape.y, this.m_Perspective);
            image = null;
        }
    }

    public boolean prepareToolTip(FontMetrics fontMetrics) {
        boolean bl;
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        this.m_bReferenceLineRelatedObject = false;
        this.clearToolTip();
        this.m_bDataRelatedObject = this.isDataRelatedObj();
        if (!this.m_Perspective.getToolTipMode() && !this.m_bDataRelatedObject) {
            bl = false;
        } else {
            bl = true;
            this.m_Chart = this.m_Perspective.getGraphObject();
            JGraphType jGraphType = this.m_Perspective.getJGraphType();
            DataFormat dataFormat = jGraphType.getDataFormat();
            int n = this.m_detObj.getIdentIDRef().stripExceptional().getObjectID();
            String string = ObjectString.objectName(n);
            String string2 = ObjectString.objectDescriptionIntl(this.m_Perspective, n);
            if (this.m_Perspective.getToolTipMode()) {
                this.m_TipStrings[0] = string;
                this.m_TipStrings[1] = string2;
                this.m_RectTipShape.width = fontMetrics.stringWidth(string) > this.m_RectTipShape.width ? fontMetrics.stringWidth(string) + 6 : this.m_RectTipShape.width;
                this.m_RectTipShape.height = fontMetrics.getHeight() + (fontMetrics.stringWidth(string2) / this.m_RectTipShape.width + 1) * fontMetrics.getHeight();
            } else {
                this.m_TipStrings[0] = string2;
                this.m_RectTipShape.width = fontMetrics.stringWidth(string2) > this.m_RectTipShape.width ? fontMetrics.stringWidth(string2) + 6 : this.m_RectTipShape.width;
                this.m_RectTipShape.height = fontMetrics.getHeight() + (fontMetrics.stringWidth(string2) / this.m_RectTipShape.width + 1) * fontMetrics.getHeight();
            }
            this.m_nNumToolTipLines = 0;
            this.m_bSeriesRelatedObject = this.isSeriesRelatedObj();
            bl = this.processCustomToolTips(dataFormat, fontMetrics);
            if (!this.m_bDrawCustomToolTip) {
                if (this.m_bDataRelatedObject && this.m_bReferenceLineRelatedObject) {
                    if (this.m_Perspective.getToolTipMode()) {
                        this.processDeveloperReferenceObjToolTip(dataFormat, fontMetrics);
                    } else {
                        this.processUserReferenceObjToolTip(dataFormat, fontMetrics);
                    }
                }
                if (this.m_bSeriesRelatedObject && this.m_bDataRelatedObject) {
                    if (this.m_Perspective.getToolTipMode()) {
                        this.processDeveloperSeriesObjToolTip(dataFormat, fontMetrics);
                    } else {
                        this.processUserSeriesObjToolTip(dataFormat, fontMetrics);
                    }
                }
            }
            this.m_RectTipShape.width = this.m_RectTipShape.width > 40 ? this.m_RectTipShape.width : 40;
            this.m_RectTipShape.height = this.m_RectTipShape.height > 12 ? this.m_RectTipShape.height : 12;
        }
        return bl;
    }

    private boolean isSeriesRelatedObj() {
        boolean bl = this.m_detObj.getIdentIDRef().stripExceptional().isSeriesRelated();
        int n = this.m_detObj.getObjectID();
        switch (n) {
            case 14: 
            case 270: 
            case 310: {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isDataRelatedObj() {
        boolean bl = this.m_detObj.getSeriesID() >= 0 || this.m_detObj.getGroupID() >= 0;
        int n = this.m_detObj.getObjectID();
        switch (n) {
            case 248: 
            case 249: 
            case 358: {
                this.m_bDataRelatedObject = true;
                this.m_bReferenceLineRelatedObject = true;
            }
        }
        return bl;
    }

    void justifyLabelsAndValues(FontMetrics fontMetrics) {
        int n = 2;
        while (n < this.m_nNumToolTipLines) {
            if (this.m_TipStrings[n].length() > 0) {
                int n2 = this.m_TipStrings[n].indexOf(" ");
                String string = this.m_TipStrings[n].substring(0, n2);
                String string2 = this.m_TipStrings[n].substring(n2, this.m_TipStrings[n].length());
                n2 = 1;
                String string3 = String.valueOf(string) + " " + string2;
                while (fontMetrics.stringWidth(string3) < this.m_RectTipShape.width - 6) {
                    string3 = string;
                    int n3 = 0;
                    while (n3 < n2) {
                        string3 = String.valueOf(string3) + " ";
                        ++n3;
                    }
                    string3 = String.valueOf(string3) + string2;
                    ++n2;
                }
                this.m_TipStrings[n] = string3;
            }
            ++n;
        }
    }

    void processDeveloperReferenceObjToolTip(DataFormat dataFormat, FontMetrics fontMetrics) {
    }

    void processUserReferenceObjToolTip(DataFormat dataFormat, FontMetrics fontMetrics) {
        if (this.m_detObj.getObjectID() == 249) {
            this.FmtUserReferenceLineID(fontMetrics);
        }
        if (this.m_detObj.getObjectID() == 358) {
            this.UserFmtReferenceLineGENERAL(fontMetrics);
        }
    }

    void processUserSeriesObjToolTip(DataFormat dataFormat, FontMetrics fontMetrics) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        this.FmtUserSeriesAndGroupID(fontMetrics);
        if (dataFormat == DataFormat.DF_GENERAL) {
            this.UserFmtGENERAL(fontMetrics);
        } else if (dataFormat == DataFormat.DF_XY) {
            this.UserFmtXY(fontMetrics);
        } else if (dataFormat == DataFormat.DF_XY_LBL) {
            this.UserFmtXY_LBL(fontMetrics);
        } else if (dataFormat == DataFormat.DF_XYZ) {
            this.UserFmtXYZ(fontMetrics);
        } else if (dataFormat != DataFormat.DF_XYZ_LBL) {
            if (dataFormat == DataFormat.DF_GANTT) {
                this.UserFmtGANTT(fontMetrics);
            } else if (dataFormat == DataFormat.DF_HL) {
                this.UserFmtHL(fontMetrics);
            } else if (dataFormat == DataFormat.DF_HLC) {
                this.UserFmtHLC(fontMetrics);
            } else if (dataFormat == DataFormat.DF_OHLC) {
                this.UserFmtOHLC(fontMetrics);
            } else if (dataFormat == DataFormat.DF_HL_VOL) {
                this.UserFmtHL_VOL(fontMetrics);
            } else if (dataFormat == DataFormat.DF_HLC_VOL) {
                this.UserFmtHLC_VOL(fontMetrics);
            } else if (dataFormat == DataFormat.DF_OHLC_VOL) {
                this.UserFmtOHLC_VOL(fontMetrics);
            }
        }
        this.UserSetToolTipHeight(fontMetrics);
        this.justifyLabelsAndValues(fontMetrics);
    }

    void processDeveloperSeriesObjToolTip(DataFormat dataFormat, FontMetrics fontMetrics) {
        if (this.m_Perspective.getJGraphType().isParetoType() && this.ParetoRelated()) {
            this.FmtDevelopersPareto(fontMetrics);
        } else {
            this.FmtDeveloperSeriesAndGroupID(fontMetrics);
        }
        if (dataFormat == DataFormat.DF_GENERAL) {
            this.DeveloperFmtGENERAL(fontMetrics);
        } else if (dataFormat == DataFormat.DF_XY) {
            this.DeveloperFmtXY(fontMetrics);
        } else if (dataFormat == DataFormat.DF_XY_LBL) {
            this.DeveloperFmtXY_LBL(fontMetrics);
        } else if (dataFormat == DataFormat.DF_XYZ) {
            this.DeveloperFmtXYZ(fontMetrics);
        } else if (dataFormat != DataFormat.DF_XYZ_LBL && dataFormat != DataFormat.DF_GANTT) {
            if (dataFormat == DataFormat.DF_HL) {
                this.DeveloperFmtHL(fontMetrics);
            } else if (dataFormat == DataFormat.DF_HLC) {
                this.DeveloperFmtHLC(fontMetrics);
            } else if (dataFormat == DataFormat.DF_OHLC) {
                this.DeveloperFmtOHLC(fontMetrics);
            } else if (dataFormat == DataFormat.DF_HL_VOL) {
                this.DeveloperFmtHL_VOL(fontMetrics);
            } else if (dataFormat == DataFormat.DF_HLC_VOL) {
                this.DeveloperFmtHLC_VOL(fontMetrics);
            } else if (dataFormat == DataFormat.DF_OHLC_VOL) {
                this.DeveloperFmtOHLC_VOL(fontMetrics);
            }
        }
        this.DeveloperSetToolTipHeight(fontMetrics, this.m_TipStrings[1], this.m_RectTipShape.width, this.m_nNumToolTipLines);
    }

    boolean processCustomToolTips(DataFormat dataFormat, FontMetrics fontMetrics) {
        boolean bl = true;
        String string = "";
        if (this.m_Perspective.isToolTipCallBack()) {
            this.m_bDrawCustomToolTip = true;
            if (this.m_strDynamicToolTip != null) {
                string = this.m_strDynamicToolTip;
                this.m_strDynamicToolTip = null;
            } else {
                string = this.m_Perspective.getDynamicToolTip(this.m_mouseState);
            }
        } else if (!this.m_Perspective.getToolTipMode()) {
            if (this.m_strCustomToolTipUser.length() > 0) {
                this.m_bDrawCustomToolTip = true;
                string = this.m_strCustomToolTipUser;
            } else {
                this.m_bDrawCustomToolTip = false;
            }
        } else if (this.m_strCustomToolTipDeveloper.length() > 0) {
            this.m_bDrawCustomToolTip = true;
            string = this.m_strCustomToolTipDeveloper;
        } else {
            this.m_bDrawCustomToolTip = false;
        }
        if (this.m_bDrawCustomToolTip) {
            if (string == null || string.length() < 1) {
                bl = false;
            } else {
                this.m_TipStrings[1] = "";
                this.m_nNumToolTipLines = this.CustomToolTipIntoLines(string);
                this.CustomToolTipMacros(dataFormat);
                this.m_RectTipShape.width = this.CustomSetToolTipWidth(fontMetrics);
                this.m_RectTipShape.height = this.CustomSetToolTipHeight(fontMetrics, this.m_RectTipShape.width);
            }
        }
        return bl;
    }

    int CustomToolTipIntoLines(String string) {
        int n = 0;
        String string2 = string;
        String string3 = string;
        if (string2.indexOf(RETURN_MACRO) != -1) {
            while (n < 100) {
                int n2 = string2.indexOf(RETURN_MACRO);
                if (n2 == -1) {
                    this.m_TipStrings[n] = string2;
                    ++n;
                    break;
                }
                string3 = string2.substring(0, n2);
                string2 = string2.substring(n2 + RETURN_MACRO.length(), string2.length());
                this.m_TipStrings[n] = string3;
                ++n;
            }
        } else {
            this.m_TipStrings[n] = string3;
            ++n;
        }
        return n;
    }

    void CustomToolTipMacros(DataFormat dataFormat) {
        if (this.m_detObj != null) {
            int n = 0;
            while (n < 100) {
                if (this.m_TipStrings[n].length() > 0) {
                    boolean bl;
                    this.CustomLabelMacros(n);
                    int n2 = this.m_detObj.getSeriesID();
                    int n3 = this.m_detObj.getGroupID();
                    boolean bl2 = bl = n2 > -1 && n3 > -1;
                    if (this.m_Chart instanceof JChart_2D_PieBar && n2 > -1) {
                        bl = true;
                    }
                    if (this.m_Chart instanceof JChart_2D_Pareto && n3 > -1) {
                        n2 = this.m_Perspective.getDisplayParetoSeries();
                        bl = true;
                    }
                    if (bl) {
                        this.CustomValueMacros(dataFormat, n, n2, n3);
                    }
                }
                ++n;
            }
        }
    }

    void CustomLabelMacros(int n) {
        this.m_TipStrings[n] = this.CustomReplaceMacro(this.m_TipStrings[n], OBJECT_NAME_MACRO, ObjectString.objectName(this.m_detObj.getIdentIDRef().stripExceptional().getObjectID()));
        this.m_TipStrings[n] = this.CustomReplaceMacro(this.m_TipStrings[n], OBJECT_DESCRIPTION_MACRO, ObjectString.objectDescription(this.m_detObj.getIdentIDRef().stripExceptional().getObjectID()));
        this.m_TipStrings[n] = this.CustomReplaceMacro(this.m_TipStrings[n], OBJECT_ID_MACRO, new Integer(this.m_detObj.getObjectID()).toString());
        this.m_TipStrings[n] = this.CustomReplaceMacro(this.m_TipStrings[n], OBJECT_INSTANCE_MACRO, new Integer(this.m_detObj.getIdentID().getMiscID()).toString());
        if (this.m_detObj.getSeriesID() > -1) {
            this.m_TipStrings[n] = this.CustomReplaceMacro(this.m_TipStrings[n], SERIES_LABEL_MACRO, this.m_Perspective.getSeriesLabel(this.m_detObj.getSeriesID()));
        }
        if (this.m_detObj.getGroupID() > -1) {
            this.m_TipStrings[n] = this.CustomReplaceMacro(this.m_TipStrings[n], GROUP_LABEL_MACRO, this.m_Perspective.getGroupLabel(this.m_detObj.getGroupID()));
        }
    }

    void CustomValueMacros(DataFormat dataFormat, int n, int n2, int n3) {
        double d;
        Point2D point2D;
        double d2;
        double d3;
        double d4;
        if (this.m_Chart instanceof JChart_2D_Scat) {
            try {
                d4 = ((JChart_2D_Scat)this.m_Chart).getXValue(n2, n3);
            }
            catch (AssertionException assertionException) {
                d4 = 0.0;
            }
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d4, this.m_TipStrings[n], X_VALUE_MACRO, "XVALUE");
            try {
                d3 = ((JChart_2D_Scat)this.m_Chart).getYValue(n2, n3);
            }
            catch (AssertionException assertionException) {
                d3 = 0.0;
            }
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d3, this.m_TipStrings[n], Y_VALUE_MACRO, "YVALUE");
            try {
                d2 = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(n2, n3);
            }
            catch (AssertionException assertionException) {
                d2 = 0.0;
            }
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d2, this.m_TipStrings[n], Z_VALUE_MACRO, "ZVALUE");
        }
        if (this.m_Chart instanceof JChart_2D_Polar) {
            try {
                d4 = ((JChart_2D_Polar)this.m_Chart).getXValue(n2, n3);
            }
            catch (AssertionException assertionException) {
                d4 = 0.0;
            }
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d4, this.m_TipStrings[n], X_VALUE_MACRO, "XVALUE");
            try {
                d3 = ((JChart_2D_Polar)this.m_Chart).getYValue(n2, n3);
            }
            catch (AssertionException assertionException) {
                d3 = 0.0;
            }
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d3, this.m_TipStrings[n], Y_VALUE_MACRO, "YVALUE");
            try {
                d2 = ((JChart_2D_Polar)this.m_Chart).getXYZ_ZValue(n2, n3);
            }
            catch (AssertionException assertionException) {
                d2 = 0.0;
            }
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d2, this.m_TipStrings[n], Z_VALUE_MACRO, "ZVALUE");
        }
        if (this.m_Chart instanceof JChart_2D_Pareto && this.m_detObj.getObjectID() != 358) {
            try {
                if (this.ParetoRelated()) {
                    d3 = ((JChart_2D_Standard)this.m_Chart).getParetoValue(n2, n3);
                    this.m_TipStrings[n] = this.CustomReplaceValueMacro(d3, this.m_TipStrings[n], Y_VALUE_MACRO, "YVALUE");
                }
            }
            catch (AssertionException assertionException) {
                // empty catch block
            }
        }
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            double d5;
            if (n3 < 0) {
                d5 = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(n2);
                this.m_TipStrings[n] = this.CustomReplaceValueMacro(d5, this.m_TipStrings[n], Y_VALUE_MACRO, "YVALUE");
            } else {
                d5 = ((JChart_2D_PieBar)this.m_Chart).getGroupValueForBar(n3);
                this.m_TipStrings[n] = this.CustomReplaceValueMacro(d5, this.m_TipStrings[n], Y_VALUE_MACRO, "YVALUE");
            }
        } else if ((this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Circular || this.m_Chart instanceof JChart_2D_Hist || this.m_Chart instanceof JChart_2D_Pie || this.m_Chart instanceof JChart_2D_Radar || this.m_Chart instanceof JChart_2D_Spec || this.m_Chart instanceof JChart_3D || this.m_Chart instanceof JChart_3D_Surf || this.m_Chart instanceof JChart_2D_Pareto) && this.m_detObj.getObjectID() != 358) {
            try {
                point2D = this.m_Chart.getDataValuesXY(n2, n3);
            }
            catch (AssertionException assertionException) {
                point2D = new Point2D.Double();
            }
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(point2D.getX(), this.m_TipStrings[n], X_VALUE_MACRO, "XVALUE");
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(point2D.getY(), this.m_TipStrings[n], Y_VALUE_MACRO, "YVALUE");
        }
        if (this.m_Chart instanceof JChart_2D_BLA && this.m_detObj.getObjectID() != 358) {
            double d6 = ((JChart_2D_Standard)this.m_Chart).getStackedCumulativeValue(n2, n3);
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d6, this.m_TipStrings[n], CUMULATIVE_STACKED_VALUE_MACRO, null);
            d = ((JChart_2D_Standard)this.m_Chart).getPercentCumulativeValue(n2, n3);
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d *= 100.0, this.m_TipStrings[n], CUMULATIVE_PERCENTAGE_VALUE_MACRO, null);
        }
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            if (n3 >= 0) {
                double d7 = ((JChart_2D_Pie)this.m_Chart).getGroupTotal(n3);
                d = ((JChart_2D_Pie)this.m_Chart).getSumTotal();
                double d8 = d7 / d * 100.0;
                this.m_TipStrings[n] = this.CustomReplaceValueMacro(d8, this.m_TipStrings[n], PIE_PERCENTAGE_VALUE_MACRO, null);
            } else {
                double d9 = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(n2);
                d = ((JChart_2D_PieBar)this.m_Chart).getSumTotal();
                double d10 = d9 / d * 100.0;
                this.m_TipStrings[n] = this.CustomReplaceValueMacro(d10, this.m_TipStrings[n], PIE_PERCENTAGE_VALUE_MACRO, null);
            }
        } else if (this.m_Chart instanceof JChart_2D_Pie) {
            try {
                point2D = this.m_Chart.getDataValuesXY(n2, n3);
            }
            catch (AssertionException assertionException) {
                point2D = new Point2D.Double();
            }
            double d11 = ((JChart_2D_Pie)this.m_Chart).getGroupTotal(n3);
            d = point2D.getY() / d11 * 100.0;
            this.m_TipStrings[n] = this.CustomReplaceValueMacro(d, this.m_TipStrings[n], PIE_PERCENTAGE_VALUE_MACRO, null);
        }
        if (this.m_Chart instanceof JChart_2D_Hilo) {
            double d12;
            if (((JChart_2D_Hilo)this.m_Chart).hasHighValue(dataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    d12 = ((JChart_2D_Hilo)this.m_Chart).getHighValue(n2, n3);
                }
                catch (AssertionException assertionException) {
                    d12 = 0.0;
                }
                this.m_TipStrings[n] = this.CustomReplaceValueMacro(d12, this.m_TipStrings[n], HILO_HIGH_VALUE_MACRO, "HIGH");
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasLowValue(dataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    d12 = ((JChart_2D_Hilo)this.m_Chart).getLowValue(n2, n3);
                }
                catch (AssertionException assertionException) {
                    d12 = 0.0;
                }
                this.m_TipStrings[n] = this.CustomReplaceValueMacro(d12, this.m_TipStrings[n], HILO_LOW_VALUE_MACRO, "LOW");
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasOpenValue(dataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    d12 = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(n2, n3);
                    this.m_TipStrings[n] = this.CustomReplaceValueMacro(d12, this.m_TipStrings[n], HILO_OPEN_VALUE_MACRO, "OPEN");
                }
                catch (AssertionException assertionException) {
                    this.m_TipStrings[n] = !this.m_Perspective.getJGraphType().isStockCandleType() ? this.CustomReplaceValueMacro("", this.m_TipStrings[n], HILO_OPEN_VALUE_MACRO, "OPEN") : this.CustomReplaceValueMacro(0.0, this.m_TipStrings[n], HILO_OPEN_VALUE_MACRO, "OPEN");
                }
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasCloseValue(dataFormat) && this.m_detObj.getObjectID() != 310) {
                try {
                    d12 = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(n2, n3);
                    this.m_TipStrings[n] = this.CustomReplaceValueMacro(d12, this.m_TipStrings[n], HILO_CLOSE_VALUE_MACRO, "CLOSE");
                }
                catch (AssertionException assertionException) {
                    this.m_TipStrings[n] = !this.m_Perspective.getJGraphType().isStockCandleType() ? this.CustomReplaceValueMacro("", this.m_TipStrings[n], HILO_CLOSE_VALUE_MACRO, "CLOSE") : this.CustomReplaceValueMacro(0.0, this.m_TipStrings[n], HILO_CLOSE_VALUE_MACRO, "CLOSE");
                }
            }
            if (((JChart_2D_Hilo)this.m_Chart).hasVolumeValue(dataFormat)) {
                try {
                    n2 = 0;
                    d12 = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(n2, n3);
                }
                catch (AssertionException assertionException) {
                    d12 = 0.0;
                }
                this.m_TipStrings[n] = this.CustomReplaceValueMacro(d12, this.m_TipStrings[n], HILO_VOLUME_VALUE_MACRO, "VOLUME");
            }
        }
    }

    String CustomReplaceMacro(String string, String string2, String string3) {
        int n;
        String string4 = "";
        string4 = string;
        while ((n = string4.indexOf(string2)) != -1) {
            String string5 = string4.substring(0, n);
            string5 = String.valueOf(string5) + string3;
            string4 = string5 = String.valueOf(string5) + string4.substring(n += string2.length(), string4.length());
        }
        return string4;
    }

    String CustomReplaceValueMacro(double d, String string, String string2, String string3) {
        int n;
        String string4 = "";
        string4 = string;
        while ((n = string4.indexOf(string2)) != -1) {
            String string5 = this.FmtValue(d, string3);
            String string6 = string4.substring(0, n);
            string6 = String.valueOf(string6) + string5;
            string4 = string6 = String.valueOf(string6) + string4.substring(n += string2.length(), string4.length());
        }
        return string4;
    }

    String CustomReplaceValueMacro(String string, String string2, String string3, String string4) {
        int n;
        String string5 = "";
        string5 = string2;
        while ((n = string5.indexOf(string3)) != -1) {
            String string6 = string;
            String string7 = string5.substring(0, n);
            string7 = String.valueOf(string7) + string6;
            string5 = string7 = String.valueOf(string7) + string5.substring(n += string3.length(), string5.length());
        }
        return string5;
    }

    int CustomSetToolTipWidth(FontMetrics fontMetrics) {
        int n = 0;
        int n2 = 0;
        while (n2 < 100) {
            if (fontMetrics.stringWidth(this.m_TipStrings[n2]) > n) {
                n = fontMetrics.stringWidth(this.m_TipStrings[n2]);
            }
            ++n2;
        }
        return n;
    }

    int CustomSetToolTipHeight(FontMetrics fontMetrics, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 100) {
            if (this.m_TipStrings[n3].length() > 0) {
                if (fontMetrics.stringWidth(this.m_TipStrings[n3]) < n) {
                    n2 += fontMetrics.getHeight();
                } else {
                    double d;
                    double d2 = (double)fontMetrics.stringWidth(this.m_TipStrings[n3]) / (double)n;
                    if (d2 - (d = Math.floor(d2)) > 0.1) {
                        d += 1.0;
                    }
                    n2 = (int)((double)n2 + d * (double)fontMetrics.getHeight());
                }
            }
            ++n3;
        }
        return n2 += 2;
    }

    String FmtValue(double d, String string) {
        String string2 = "";
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(4, this.m_detObj.getSeriesID(), this.m_detObj.getGroupID(), string, -1, -3);
            string2 = this.m_Perspective.getNumberFormatCallBack().toString(d);
        } else {
            string2 = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), d, this.m_Perspective.getDataTextFormatPattern());
        }
        return string2;
    }

    void FmtSingleValue(FontMetrics fontMetrics, int n, String string, double d) {
        if (this.m_Perspective.PFJRes == null) {
            this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
        }
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString(string)) + this.m_Perspective.PFJRes.getString("COLON") + " ";
        String string2 = this.FmtValue(d, string);
        int n2 = n;
        this.m_TipStrings[n2] = String.valueOf(this.m_TipStrings[n2]) + string2;
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
    }

    void FmtDeveloperSeriesAndGroupID(FontMetrics fontMetrics) {
        if (this.m_Perspective.PFJRes == null) {
            this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
        }
        int n = 2;
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString("SERIES")) + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n2 = n;
        this.m_TipStrings[n2] = String.valueOf(this.m_TipStrings[n2]) + this.m_detObj.getSeriesID();
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
        n = 3;
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString("GROUP")) + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n3 = n;
        this.m_TipStrings[n3] = String.valueOf(this.m_TipStrings[n3]) + this.m_detObj.getGroupID();
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
    }

    void FmtUserSeriesAndGroupID(FontMetrics fontMetrics) {
        int n = 0;
        this.m_TipStrings[n] = this.m_Perspective.getSeriesLabel(this.m_detObj.getSeriesID());
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
        n = 1;
        this.m_TipStrings[n] = this.m_Perspective.getGroupLabel(this.m_detObj.getGroupID());
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
    }

    void FmtUserReferenceLineID(FontMetrics fontMetrics) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        int n = 0;
        this.m_TipStrings[n] = this.m_detObj.getReferenceLabel();
        if (this.m_TipStrings[n] != null) {
            this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
        }
    }

    void FmtDevelopersPareto(FontMetrics fontMetrics) {
        if (this.m_Perspective.PFJRes == null) {
            this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
        }
        int n = 2;
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString("SERIES")) + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n2 = n;
        this.m_TipStrings[n2] = String.valueOf(this.m_TipStrings[n2]) + this.m_Perspective.getDisplayParetoSeries();
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
        n = 3;
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString("GROUP")) + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n3 = n;
        this.m_TipStrings[n3] = String.valueOf(this.m_TipStrings[n3]) + this.m_detObj.getGroupID();
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
    }

    void DeveloperSetToolTipHeight(FontMetrics fontMetrics, String string, int n, int n2) {
        int n3 = fontMetrics.getHeight();
        if (fontMetrics.stringWidth(string) < n) {
            n3 += fontMetrics.getHeight();
        } else {
            double d;
            double d2 = (double)fontMetrics.stringWidth(string) / (double)n;
            if (d2 - (d = Math.floor(d2)) > 0.1) {
                d += 1.0;
            }
            n3 = (int)((double)n3 + d * (double)fontMetrics.getHeight());
        }
        n3 += fontMetrics.getHeight() * n2;
        this.m_RectTipShape.height = n3 += 2;
    }

    void DeveloperFmtGENERAL(FontMetrics fontMetrics) {
        int n;
        double d;
        block11: {
            d = 0.0;
            n = 4;
            if (this.m_Chart instanceof JChart_2D_Pareto) {
                try {
                    int n2 = this.m_detObj.getGroupID();
                    int n3 = this.m_Perspective.getDisplayParetoSeries();
                    if (n2 < 0) break block11;
                    if (this.ParetoRelated()) {
                        d = ((JChart_2D_Standard)this.m_Chart).getParetoValue(n3, n2);
                        break block11;
                    }
                    d = this.m_Perspective.getDataAsDouble(n3, this.m_detObj.getGroupID());
                }
                catch (AssertionException assertionException) {
                    d = 0.0;
                }
            } else if (this.m_Chart instanceof JChart_2D_PieBar) {
                if (this.m_detObj.getGroupID() <= 0) {
                    d = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(this.m_detObj.getSeriesID());
                }
            } else {
                try {
                    d = this.m_Perspective.getDataAsDouble(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
                }
                catch (AssertionException assertionException) {
                    d = 0.0;
                }
            }
        }
        if (this.m_Perspective.PFJRes == null) {
            this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
        }
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString("VALUE")) + this.m_Perspective.PFJRes.getString("COLON") + " ";
        int n4 = n;
        this.m_TipStrings[n4] = String.valueOf(this.m_TipStrings[n4]) + Double.toString(d);
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 3;
    }

    void DeveloperFmtXY(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "XVALUE", d);
        n = 5;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "YVALUE", d);
        this.m_nNumToolTipLines = 4;
    }

    void DeveloperFmtXY_LBL(FontMetrics fontMetrics) {
        String string;
        double d;
        int n = 4;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getLabelXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "XVALUE", d);
        n = 5;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getLabelYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "YVALUE", d);
        n = 6;
        try {
            string = ((JChart_2D_Scat)this.m_Chart).getLabelValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            string = "";
        }
        if (this.m_Perspective.PFJRes == null) {
            this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
        }
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString("LABEL")) + this.m_Perspective.PFJRes.getString("COLON") + " " + string;
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtXYZ(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getXYZ_XValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "XVALUE", d);
        n = 5;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getXYZ_YValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "YVALUE", d);
        n = 6;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "ZVALUE", d);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtHL(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 5;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        this.m_nNumToolTipLines = 4;
    }

    void DeveloperFmtHLC(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 5;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 6;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtOHLC(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "OPEN", d);
        n = 5;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 6;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 7;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        this.m_nNumToolTipLines = 6;
    }

    void DeveloperFmtHL_VOL(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 5;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 6;
        try {
            int n2 = 0;
            d = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(n2, this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "VOLUME", d);
        this.m_nNumToolTipLines = 5;
    }

    void DeveloperFmtHLC_VOL(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 5;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 6;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        n = 7;
        try {
            int n2 = 0;
            d = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(n2, this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "VOLUME", d);
        this.m_nNumToolTipLines = 6;
    }

    void DeveloperFmtOHLC_VOL(FontMetrics fontMetrics) {
        double d;
        int n = 4;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "OPEN", d);
        n = 5;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 6;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 7;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        n = 8;
        try {
            int n2 = 0;
            d = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(n2, this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "VOLUME", d);
        this.m_nNumToolTipLines = 7;
    }

    void UserSetToolTipHeight(FontMetrics fontMetrics) {
        this.m_RectTipShape.height = 0;
        int n = 0;
        while (n < this.m_nNumToolTipLines) {
            if (this.m_TipStrings[n].length() > 0) {
                this.m_RectTipShape.height += fontMetrics.getHeight();
            }
            ++n;
        }
    }

    void UserFmtReferenceLineGENERAL(FontMetrics fontMetrics) {
        this.m_RectTipShape.width = 0;
        this.m_RectTipShape.height = 0;
        double d = 0.0;
        int n = 0;
        d = this.m_detObj.getReferenceData();
        this.FmtSingleValue(fontMetrics, n, "VALUE", d);
        this.m_nNumToolTipLines = 1;
    }

    void UserFmtGENERAL(FontMetrics fontMetrics) {
        int n = this.m_detObj.getSeriesID();
        int n2 = this.m_detObj.getGroupID();
        int n3 = 2;
        double d = 0.0;
        if (this.m_Chart instanceof JChart_2D_PieBar) {
            if (n2 <= 0) {
                try {
                    d = ((JChart_2D_Pie)this.m_Chart).getSeriesTotal(n);
                    this.FmtSingleValue(fontMetrics, n3, "VALUE", d);
                }
                catch (AssertionException assertionException) {
                    d = 0.0;
                }
            }
        } else if (this.m_Chart instanceof JChart_2D_Pareto) {
            n = this.m_Perspective.getDisplayParetoSeries();
            try {
                d = this.ParetoRelated() ? ((JChart_2D_Standard)this.m_Chart).getParetoValue(n, n2) : this.m_Perspective.getDataAsDouble(n, n2);
            }
            catch (AssertionException assertionException) {
                d = 0.0;
            }
            this.FmtSingleValue(fontMetrics, n3, "VALUE", d);
        } else {
            try {
                d = this.m_Perspective.getDataAsDouble(n, n2);
                this.FmtSingleValue(fontMetrics, n3, "VALUE", d);
            }
            catch (AssertionException assertionException) {
                d = 0.0;
            }
        }
        this.m_nNumToolTipLines = 3;
    }

    void UserFmtXY(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = this.m_Chart instanceof JChart_2D_Scat ? ((JChart_2D_Scat)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : (this.m_Chart instanceof JChart_2D_Polar ? ((JChart_2D_Polar)this.m_Chart).getXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0);
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "XVALUE", d);
        n = 3;
        try {
            d = this.m_Chart instanceof JChart_2D_Scat ? ((JChart_2D_Scat)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : (this.m_Chart instanceof JChart_2D_Polar ? ((JChart_2D_Polar)this.m_Chart).getYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0);
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "YVALUE", d);
        this.m_nNumToolTipLines = 4;
    }

    void UserFmtXY_LBL(FontMetrics fontMetrics) {
        String string;
        double d;
        int n = 2;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getLabelXValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "XVALUE", d);
        n = 3;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getLabelYValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "YVALUE", d);
        n = 4;
        try {
            string = ((JChart_2D_Scat)this.m_Chart).getLabelValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            string = "";
        }
        if (this.m_Perspective.PFJRes == null) {
            this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
        }
        this.m_TipStrings[n] = String.valueOf(this.m_Perspective.PFJRes.getString("LABEL")) + this.m_Perspective.PFJRes.getString("COLON") + " " + string;
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtXYZ(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getXYZ_XValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "XVALUE", d);
        n = 3;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getXYZ_YValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "YVALUE", d);
        n = 4;
        try {
            d = ((JChart_2D_Scat)this.m_Chart).getXYZ_ZValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "ZVALUE", d);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtHL(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 3;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        this.m_nNumToolTipLines = 4;
    }

    void UserFmtHLC(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 3;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 4;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtOHLC(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "OPEN", d);
        n = 3;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 4;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 5;
        try {
            d = ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        this.m_nNumToolTipLines = 6;
    }

    void UserFmtHL_VOL(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 3;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 4;
        try {
            int n2 = 0;
            d = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(n2, this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "VOLUME", d);
        this.m_nNumToolTipLines = 5;
    }

    void UserFmtHLC_VOL(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 3;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 4;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        n = 5;
        try {
            int n2 = 0;
            d = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(n2, this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "VOLUME", d);
        this.m_nNumToolTipLines = 6;
    }

    void UserFmtOHLC_VOL(FontMetrics fontMetrics) {
        double d;
        int n = 2;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getOpenValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "OPEN", d);
        n = 3;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getHighValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "HIGH", d);
        n = 4;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getLowValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "LOW", d);
        n = 5;
        try {
            d = this.m_detObj.getObjectID() != 310 ? ((JChart_2D_Hilo)this.m_Chart).getCloseValue(this.m_detObj.getSeriesID(), this.m_detObj.getGroupID()) : 0.0;
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "CLOSE", d);
        n = 6;
        try {
            int n2 = 0;
            d = ((JChart_2D_Hilo)this.m_Chart).getVolumeValue(n2, this.m_detObj.getGroupID());
        }
        catch (AssertionException assertionException) {
            d = 0.0;
        }
        this.FmtSingleValue(fontMetrics, n, "VOLUME", d);
        this.m_nNumToolTipLines = 7;
    }

    void UserFmtGANTT(FontMetrics fontMetrics) {
        int n = this.m_detObj.getSeriesID();
        int n2 = 0;
        this.m_TipStrings[n2] = this.m_Perspective.getAlertLabel(this.m_detObj.getSeriesID());
        this.m_RectTipShape.width = fontMetrics.stringWidth(this.m_TipStrings[n2]) > this.m_RectTipShape.width - 6 ? fontMetrics.stringWidth(this.m_TipStrings[n2]) + 6 : this.m_RectTipShape.width;
        this.m_nNumToolTipLines = 1;
    }

    public String[] getUserTooltipStrings(DetObj detObj) {
        String[] stringArray = null;
        if (this.m_Perspective.isToolTipCallBack()) {
            JGraphType jGraphType = this.m_Perspective.getJGraphType();
            DataFormat dataFormat = jGraphType.getDataFormat();
            this.m_Chart = this.m_Perspective.getGraphObject();
            this.m_detObj = detObj;
            MouseEvent mouseEvent = new MouseEvent(this.m_Perspective, 0, 0L, 0, 0, 0, 0, false);
            TDGMouseState tDGMouseState = new TDGMouseState(mouseEvent, detObj);
            String string = this.m_Perspective.getToolTipCallBack().getDynamicToolTip(tDGMouseState, this.m_Perspective.getToolTipMode());
            if (string != null && string.length() > 0) {
                this.clearToolTip();
                this.m_nNumToolTipLines = this.CustomToolTipIntoLines(string);
                this.CustomToolTipMacros(dataFormat);
                stringArray = new String[this.m_nNumToolTipLines];
                int n = 0;
                while (n < this.m_nNumToolTipLines) {
                    stringArray[n] = this.m_TipStrings[n];
                    ++n;
                }
            }
            this.m_detObj = null;
        }
        return stringArray;
    }

    public boolean ParetoRelated() {
        return this.m_detObj.getObjectID() == 473 || this.m_detObj.getObjectID() == 474 || this.m_detObj.getObjectID() == 475 || this.m_detObj.getObjectID() == 476;
    }

    void timeOutTimer_TimerEvent(ActionEvent actionEvent) {
        this.timeOutTimer.stop();
        if (this.m_Perspective.getToolTipDisplay()) {
            this.m_Perspective.toolTipRepaint(false);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ToolTips.this.timeOutTimer) {
                ToolTips.this.timeOutTimer_TimerEvent(actionEvent);
            }
        }
    }
}

