/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class DetPolygon
extends DetObj {
    Polygon m_polygon;
    Polygon m_destPolygon;
    double m_fIntensity;
    Area m_area;
    Arc2D m_arc2D;

    public DetPolygon(Detectiv detectiv, IdentObj identObj, Polygon polygon, BlackBoxIF blackBoxIF, double d) {
        super(detectiv, identObj, blackBoxIF, null, false, true, true);
        this.m_polygon = polygon;
        this.m_fIntensity = d;
    }

    public DetPolygon(Detectiv detectiv, IdentObj identObj, Polygon polygon, BlackBoxIF blackBoxIF, double d, boolean bl) {
        this(detectiv, identObj, polygon, blackBoxIF, null, d, bl);
    }

    public DetPolygon(Detectiv detectiv, IdentObj identObj, Polygon polygon, BlackBoxIF blackBoxIF, double d, boolean bl, Area area) {
        this(detectiv, identObj, polygon, blackBoxIF, null, d, bl);
        this.m_area = area;
    }

    public DetPolygon(Detectiv detectiv, IdentObj identObj, Polygon polygon, BlackBoxIF blackBoxIF, double d, boolean bl, Arc2D arc2D) {
        this(detectiv, identObj, polygon, blackBoxIF, null, d, bl);
        this.m_arc2D = arc2D;
    }

    public DetPolygon(Detectiv detectiv, IdentObj identObj, Polygon polygon, BlackBoxIF blackBoxIF, Rectangle rectangle) {
        this(detectiv, identObj, polygon, blackBoxIF, rectangle, 1.0, true);
    }

    public DetPolygon(Detectiv detectiv, IdentObj identObj, Polygon polygon, BlackBoxIF blackBoxIF, boolean bl) {
        super(detectiv, identObj, blackBoxIF, null, false, true, bl);
        this.m_fIntensity = 1.0;
        this.m_destPolygon = polygon;
    }

    public DetPolygon(Detectiv detectiv, IdentObj identObj, Polygon polygon, BlackBoxIF blackBoxIF, Rectangle rectangle, double d, boolean bl) {
        super(detectiv, identObj, blackBoxIF, rectangle, false, true, bl);
        this.m_polygon = polygon;
        this.m_fIntensity = d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DetPolygon)) {
            return false;
        }
        DetPolygon detPolygon = (DetPolygon)object;
        return this.m_id.equals(detPolygon.m_id);
    }

    public Rectangle getBounds() {
        if (this.m_destPolygon != null) {
            return this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_destPolygon).getBounds();
        }
        return this.m_polygon.getBounds();
    }

    public void hilite(Graphics graphics, VC vC) {
        graphics.setXORMode(Color.yellow);
        if (this.m_destPolygon != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
            graphics2D.drawPolygon(this.m_destPolygon);
        } else {
            int n = this.m_Detectiv.getPerspective().getGraphType();
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.m_arc2D != null || this.m_area != null) {
                this.m_Detectiv.getPerspective();
                if (Perspective.compareVersions(Perspective.m_JavaVersion, "1.4.0") == -1 || this.m_Detectiv.getPerspective().getPrimitiveAntialiasing()) {
                    if (this.m_arc2D != null) {
                        graphics2D.draw(this.m_arc2D);
                    } else {
                        graphics2D.draw(this.m_area);
                    }
                } else {
                    graphics2D.setStroke(new BasicStroke(1.01f));
                    if (this.m_arc2D != null) {
                        graphics2D.draw(this.m_arc2D);
                    } else {
                        graphics2D.draw(this.m_area);
                    }
                    graphics2D.setStroke(new BasicStroke(1.0f));
                }
            } else if (this.m_Detectiv.getPerspective().isPie()) {
                graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
                graphics2D.draw(vC.virtToDestPath(this.m_polygon));
            } else {
                graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
                Polygon polygon = vC.virtToDest(this.m_polygon);
                graphics2D.drawPolygon(polygon);
            }
        }
        graphics.setPaintMode();
    }

    public boolean isPointInObj(int n, int n2, VC vC) {
        if (this.m_destPolygon != null) {
            return this.m_bDetectable && this.m_destPolygon.contains(vC.virtToDestX(n), vC.virtToDestY(n2));
        }
        return this.m_bDetectable && this.m_polygon.contains(n, n2);
    }

    public boolean isPointInObj(Point point, VC vC) {
        return this.isPointInObj(point.x, point.y, vC);
    }

    public void paintIt(Graphics graphics, VC vC) {
        Polygon polygon = null;
        GeneralPath generalPath = null;
        if (this.m_destPolygon != null) {
            polygon = this.m_destPolygon;
        } else if (this.m_area == null && this.m_Detectiv.getPerspective().isPie()) {
            generalPath = vC.virtToDestPath(this.m_polygon);
        } else {
            polygon = vC.virtToDest(this.m_polygon);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.paint(graphics, polygon, this.m_area, this.m_arc2D, generalPath);
        } else {
            Color color = this.m_blackBox.getFillColor();
            if (color == null) {
                this.paint(graphics, polygon, this.m_area, this.m_arc2D, generalPath);
            } else {
                double d = (double)color.getRed() * this.m_fIntensity;
                double d2 = (double)color.getGreen() * this.m_fIntensity;
                double d3 = (double)color.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(d), FP.round(d2), FP.round(d3), color.getAlpha()));
                this.paint(graphics, polygon, this.m_area, this.m_arc2D, generalPath);
                this.m_blackBox.setFillColor(color);
            }
        }
    }

    public void paint(Graphics graphics, Polygon polygon, Area area, Arc2D arc2D, GeneralPath generalPath) {
        if (arc2D != null) {
            this.m_blackBox.paint(graphics, arc2D);
        } else if (area != null) {
            this.m_blackBox.paint(graphics, area);
        } else if (this.m_Detectiv.getPerspective().isPie() && generalPath != null) {
            this.m_blackBox.paint(graphics, generalPath);
        } else {
            this.m_blackBox.paint(graphics, polygon);
        }
    }

    public void setBounds(Rectangle rectangle) {
    }

    public Polygon getShape(VC vC) {
        if (this.m_destPolygon != null) {
            return vC.destToVirt(this.m_destPolygon);
        }
        return this.m_polygon;
    }
}

