/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.PieFrameObj;
import oracle.dss.graph.pfj.PieSliceObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.event.TDGErrorManager;

public class JChart_2D_Pie
extends JChart_2D {
    public static final boolean DEBUG_2D_PIE = false;
    public static final int DRILL_LABEL_MARGIN = 10;
    double m_fRingPct;
    double m_fPieTilt;
    double m_fThickness;
    double m_maxStrLength;
    int m_nPiesPerRow;
    int m_bPieLabelDisplay;
    int m_nFeelerTextFormat;
    String m_strFeelerTextFormatPattern;
    int m_nPieFeelerTextDisplay;
    boolean m_bGTHasRing;
    boolean m_bGTProportional;
    boolean m_bGTMultiple;
    boolean m_bShowPieTotal;
    boolean m_bReverseGroups;
    int m_nKissingFeelers;
    int m_nThickOffset;
    int m_nRadius;
    int m_nSaveRadius;
    int m_temp;
    double m_fPieTotal;
    double m_fHighestGroupTotal;
    Rectangle m_rPieFrame;
    PieSliceObj[] m_slices;
    int m_nSliceCount;
    int m_nLabelHeight;
    int m_nPieLabelHeight;
    int m_nXCenter;
    int m_nYCenter;
    int m_sliceLabelLeftEdge;
    int m_sliceLabelRightEdge;
    int[] m_stringWidths;
    String[] m_fullSliceLabels;
    int m_maxLabelWidthDest;
    Vector m_vectStrLabels;
    Vector m_leftSliceLabels;
    Vector m_rightSliceLabels;
    FontMetrics m_sliceLabelFM;
    Dimension m_labelDimVC;
    int m_nLineWidthFeeler;
    int m_pivotLineVirt;
    int m_pivotLineDest;
    int m_feelerTextGapVirt;
    int m_feelerTextGapDest;
    Rectangle m_rOPI_PieFrame;
    int m_nPieBarSlice;
    Point m_ptTopSlice;
    Point m_ptBottomSlice;
    TextStyleObj m_textStyleFeelers;
    boolean[][] m_bSeriesPartOfOther;
    boolean[][] m_bSeriesDrawn;
    boolean m_bOtherPercentage;
    boolean m_bLabelsAtTopOrBottom;
    boolean m_sliceLabelTruncated;
    boolean m_DetachPresent;
    Area m_area;
    Arc2D m_arc2D;
    double m_xRadius;
    double m_yRadius;
    Rectangle m_drillLabelRect;
    IdentObj m_drillLabel;
    IdentObj m_drillLabelBox;
    TextStyleObj m_pieLabelTextStyleObj;
    VC m_VC;
    int m_leftMostPointOfPie;
    int m_rightMostPointOfPie;
    int m_sliceLabelFontHeight;
    int m_virtMarginHeight;
    int m_virtMarginWidth;
    int m_sliceLabelGap;
    public static final double SLIGHTLY_SHADED = 0.8;
    public static final double MORE_SHADED = 0.6;
    public static final double MOST_SHADED = 0.4;
    public static final double UNKNOWN_ANGLE = -7.0;
    public static final int TYPE_TOP = 1000;
    public static final int TYPE_LEFT = 2000;
    public static final int TYPE_RIGHT = 3000;
    public static final int TYPE_CRUST = 4000;
    public static final int TYPE_RING = 5000;
    public static final int RADIAL_FEELER = 100;
    public static final int PIVOT_FEELER = 200;
    public static final int PPR_AUTOMATIC = 0;
    public static final int MAX_PIELABELHEIGHT = 2500;
    public static final int LABEL_COMPENSATION = 2;
    public static final int AVG_PIELABEL_SIZE = 4;
    public static final int MARGIN = 5;
    public static final int MAX_PIVOT_LINE = 5;
    public static final int MIN_PIVOT_LINE = 2;
    public static final int MAX_FEELER_TEXT_GAP = 3;
    public static final int MIN_FEELER_TEXT_GAP = 1;
    public static final int MIN_CHARS_FOR_TRUNCATION = 0;
    public static final int COLLISION_NONE = 0;
    public static final int COLLISION_BOTH = 1;
    public static final int COLLISION_TOP = 2;
    public static final int COLLISION_BOTTOM = 3;
    public static final double FONT_GAP = 0.33;
    public static final double MIN_RADIUS = 0.25;

    public void calc() {
        super.calc();
        this.calcHighestGroupTotal();
        boolean bl = this.m_Perspective.getOtherSeries();
        if (bl) {
            this.createSeriesPartOfOther(this.m_nTotalSeries, this.m_nTotalGroups);
            this.createSeriesDrawn(this.m_nTotalSeries, this.m_nTotalGroups);
        }
        this.m_bOtherPercentage = false;
        this.m_VC = this.m_Perspective.getVC();
        this.m_vectStrLabels = null;
        this.m_sliceLabelTruncated = false;
        this.m_fullSliceLabels = null;
        this.m_nPieLabelHeight = 0;
        this.m_DetachPresent = false;
        this.m_sliceLabelFM = null;
        this.m_virtMarginHeight = this.m_VC.destToVirtHeight(5);
        this.m_virtMarginWidth = this.m_VC.destToVirtWidth(5);
        if (this.m_Perspective.getDisplay(296)) {
            this.m_nPieLabelHeight = this.calcPieLabelHeight();
        }
        this.createFeelerTextStyle();
        this.m_sliceLabelGap = (int)((double)this.m_VC.destToVirtHeight(TextStyleObj.getFontHeight(this.getSliceLabelFontMetrics())) * 0.33);
        if (this.m_bGTMultiple) {
            this.calcMultiplePies();
        } else {
            this.calcSinglePie();
        }
        this.calcDrillLabel();
        if (this.m_sliceLabelTruncated) {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, new IdentObj(295));
        } else {
            this.m_Perspective.setSliceLabelsTruncated(this.m_sliceLabelTruncated, null);
        }
        this.fireInapropriateDataEvent();
    }

    public void calcDataScrollers() {
    }

    public void calcHighestGroupTotal() {
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_fHighestGroupTotal = 0.0;
        if (this.m_bGTProportional) {
            while (groupsEnumerator.hasMoreElements()) {
                int n = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
                double d = this.getGroupTotal(n);
                if (!(d > this.m_fHighestGroupTotal)) continue;
                this.m_fHighestGroupTotal = d;
            }
        }
    }

    public void calcMultiplePies() {
        int n;
        int n2;
        int n3;
        double d = 0.0;
        int n4 = this.m_nPiesPerRow;
        if (n4 == 0) {
            int n5;
            int n6;
            n4 = (int)Math.sqrt(this.m_nGroups);
            int n7 = this.m_VC.virtToDestHeight(this.m_rOPI_PieFrame.height);
            n3 = this.m_VC.virtToDestWidth(this.m_rOPI_PieFrame.width);
            if (n3 < (int)((double)n7 * 0.2) && n4 > 1) {
                --n4;
            }
            if (n3 < (int)((double)n7 * 0.4) && n4 > 1) {
                --n4;
            }
            if (n3 > (int)((double)n7 * 1.3) && (n6 = (this.m_nGroups - 1) / n4 + 1) == (n5 = (this.m_nGroups - 1) / ++n4 + 1)) {
                --n4;
            }
            if (n3 > (int)((double)n7 * 2.3) && (n6 = (this.m_nGroups - 1) / n4 + 1) == (n5 = (this.m_nGroups - 1) / ++n4 + 1)) {
                --n4;
            }
            if (n4 < 1) {
                n4 = 1;
            }
        }
        if (n4 > this.m_nGroups) {
            TDGErrorManager tDGErrorManager = this.m_Perspective.getErrorManager();
            tDGErrorManager.notifyErrorListener(this, 3973, "WARNING: Attempted using PiesPerRow greater than number of groups.", null);
            n2 = 1;
            n4 = this.m_nGroups;
            n = 0;
        } else {
            n2 = (this.m_nGroups - 1) / n4 + 1;
            n = this.m_nGroups % n4;
        }
        Rectangle rectangle = new Rectangle(this.m_rOPI_PieFrame.x, this.m_rOPI_PieFrame.y, this.m_rOPI_PieFrame.width / n4, this.m_rOPI_PieFrame.height / n2);
        this.m_nRadius = this.calcSinglePieRadius(rectangle);
        if (this.m_nPieFeelerTextDisplay == 0 || this.m_nPieFeelerTextDisplay == 3) {
            int n8;
            int n9 = this.m_VC.virtToDestHeight(rectangle.height - this.m_nPieLabelHeight);
            n3 = this.m_VC.virtToDestWidth(rectangle.width);
            Rectangle rectangle2 = this.m_VC.getDestCoords();
            double d2 = Math.abs((double)rectangle2.width) / (double)rectangle2.height;
            double d3 = 1.0;
            if (d2 > 1.0) {
                d3 = 1.0 / d2;
                d2 = 1.0;
            }
            if ((n8 = (int)this.m_VC.virtToDestWidth((double)this.m_nRadius * d3)) * 2 > (int)((double)n3 * 0.9)) {
                n8 = (int)((double)n3 * 0.9 / (double)2);
            }
            if (n8 * 2 > (int)((double)n9 * 0.9)) {
                n8 = (int)((double)n9 * 0.9 / (double)2);
            }
            this.m_nRadius = this.calcVirtRadius(n8, rectangle2);
        }
        this.m_nSaveRadius = this.m_nRadius;
        int n10 = this.m_rOPI_PieFrame.x;
        int n11 = this.m_rOPI_PieFrame.y + this.m_rOPI_PieFrame.height - rectangle.height;
        this.calcPivotLineAndGap(rectangle.width, rectangle.height);
        int n12 = 0;
        int n13 = 0;
        while (n13 < n2) {
            int n14 = this.m_nGroups < n12 + n4 ? this.m_rOPI_PieFrame.width / 2 - n * rectangle.width / 2 : 0;
            int n15 = 0;
            while (n15 < n4) {
                if (n12 < this.m_nGroups) {
                    rectangle.x = n10 + n15 * rectangle.width + n14;
                    rectangle.y = n11 - n13 * rectangle.height;
                    this.m_rPieFrame = rectangle;
                    double d4 = this.drawPie(rectangle, n12++);
                    d += d4;
                }
                ++n15;
            }
            ++n13;
        }
    }

    public void calcSinglePie() {
        this.m_rPieFrame = this.m_rOPI_PieFrame;
        this.m_nLabelHeight = Math.min(2000, this.m_rOPI_PieFrame.height / 4);
        this.m_nRadius = this.calcSinglePieRadius(this.m_rPieFrame);
        if (this.m_nRadius <= 0) {
            return;
        }
        this.m_nSaveRadius = this.m_nRadius;
        double d = this.drawPie(this.m_rOPI_PieFrame, 0);
    }

    protected int calcSinglePieRadius(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 0;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        this.m_maxLabelWidthDest = 0;
        this.m_bLabelsAtTopOrBottom = false;
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        GroupsEnumerator groupsEnumerator2 = this.getResetGroupsEnumerator(false);
        int n10 = 0;
        int n11 = groupsEnumerator.getAbsoluteGroup(n10);
        if (this.m_gt.isPieBarType() && this.isPieBarSliceOK()) {
            n8 -= n8 - n8 * 9 / 10;
        }
        if ((n9 -= this.m_nPieLabelHeight) < 200 || n8 < 200) {
            return -1;
        }
        this.calcPivotLineAndGap(n8, n9);
        Rectangle rectangle2 = this.m_VC.getDestCoords();
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        int n12 = 0;
        while (seriesEnumerator.hasMoreElements()) {
            double d;
            n6 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalSeries);
            double d2 = this.m_gt.isPieBarType() ? this.getSeriesTotal(n6) : this.getDataValue((int)n6, (int)n11).m_fValue;
            if (!(d2 > 0.0) || !this.m_bSmallDataSet || (n5 = (int)((d = (double)this.m_Perspective.getPieSliceDetach(n6, n11) / 100.0) * 1500.0)) <= n12) continue;
            n12 = n5;
        }
        n6 = 0;
        int n13 = 0;
        if (n12 > 0) {
            double d = 1.0;
            double d3 = Math.abs((double)rectangle2.width) / (double)rectangle2.height;
            if (d3 > 1.0) {
                d = 1.0 / d3;
                d3 = 1.0;
            }
            d3 -= d3 * this.m_fPieTilt;
            double d4 = -1.5707963267948966;
            double d5 = d4 + 4.71238898038469;
            n6 = 0 + (int)(Math.cos(d5) * d * (double)n12);
            d5 = d4 + 0.0;
            n13 = 0 - (int)(Math.sin(d5) * d3 * (double)n12);
        }
        if (this.m_gt.isPieBarType()) {
            this.m_fHighestGroupTotal = this.m_fPieTotal = this.getSumTotal();
        } else {
            this.m_fPieTotal = this.getGroupTotal(n11);
        }
        if (this.m_fPieTotal <= 0.0) {
            return -1;
        }
        FontMetrics fontMetrics = this.getSliceLabelFontMetrics();
        int n14 = TextStyleObj.getFontHeight(fontMetrics);
        this.getSliceLabels(n11, fontMetrics);
        int n15 = this.m_VC.virtToDestWidth(n8 - Math.abs(n6) * 2);
        n5 = this.m_VC.virtToDestHeight(n9 - Math.abs(n13) * 2);
        if (this.m_nPieFeelerTextDisplay == 0 || this.m_nPieFeelerTextDisplay == 3) {
            n7 = n15 < n5 ? n15 / 2 - 5 : n5 / 2 - 5;
            return this.calcVirtRadius(n7, rectangle2);
        }
        int n16 = n9 / 2;
        n16 = this.m_bLabelsAtTopOrBottom ? (n16 -= this.m_VC.destToVirtHeight(n14)) : (n16 -= this.m_VC.destToVirtHeight(n14 / 2));
        n16 = this.m_bLabelsAtTopOrBottom ? (int)((double)n16 / 1.125) : (int)((double)n16 / 1.0625);
        int n17 = this.m_VC.virtToDestHeight(n16);
        int n18 = (int)((double)n8 * 0.25);
        int n19 = this.m_VC.virtToDestWidth(n18);
        int n20 = 0;
        if (n17 < n19) {
            int n21 = this.calcVirtRadius(n17, rectangle2);
            return n21;
        }
        int n22 = this.calcVirtRadius(n19, rectangle2);
        n20 = n19;
        int n23 = n8 / 2;
        int n24 = this.m_VC.virtToDestWidth(n23);
        if (n17 < n24) {
            int n25 = this.calcVirtRadius(n17, rectangle2);
            n4 = n17;
        } else {
            int n26 = this.calcVirtRadius(n24, rectangle2);
            n4 = n24;
        }
        int n27 = (n15 - n20 * 2) / 2;
        int n28 = (n15 - n4 * 2) / 2;
        n27 -= this.m_feelerTextGapDest;
        n28 -= this.m_feelerTextGapDest;
        if (this.m_nPieFeelerTextDisplay == 1) {
            n27 -= this.m_pivotLineDest;
            n28 -= this.m_pivotLineDest;
        }
        n27 -= 5;
        if (this.m_maxLabelWidthDest < (n28 -= 5)) {
            return this.calcVirtRadius(n4, rectangle2);
        }
        if (this.m_nPieFeelerTextDisplay == 2) {
            if (this.m_maxLabelWidthDest < n27) {
                int n29 = n20 + (n27 - this.m_maxLabelWidthDest);
                if (n29 > n4) {
                    n29 = n4;
                }
                return this.calcVirtRadius(n29, rectangle2);
            }
            return this.calcVirtRadius(n20, rectangle2);
        }
        double d = (double)n5 / (double)n14;
        int n30 = this.m_leftSliceLabels.size();
        double d6 = (double)(n30 * 2) + (double)(n30 + 1) * 0.33;
        int n31 = this.m_rightSliceLabels.size();
        double d7 = (double)(n31 * 2) + (double)(n31 + 1) * 0.33;
        if (d6 > d || d7 > d) {
            if (this.m_maxLabelWidthDest < n27) {
                int n32 = n20 + (n27 - this.m_maxLabelWidthDest);
                if (n32 > n4) {
                    n32 = n4;
                }
                return this.calcVirtRadius(n32, rectangle2);
            }
            return this.calcVirtRadius(n20, rectangle2);
        }
        int n33 = this.getLongestStringWidth(fontMetrics);
        if (n15 / (n33 = (int)((double)n33 + (double)n33 * 0.2)) > 6) {
            n33 = n15 / 6;
        }
        int n34 = n3 = (n2 = (int)(Math.floor(d - (double)(n30 + 1) * 0.33) / (double)n30)) < (n = (int)(Math.floor(d - (double)(n31 + 1) * 0.33) / (double)n31)) ? n2 : n;
        if (this.m_maxLabelWidthDest / n3 < n33 && n33 < n27) {
            int n35 = n20 + (n27 - n33);
            if (n35 > n4) {
                n35 = n4;
            }
            return this.calcVirtRadius(n35, rectangle2);
        }
        return this.calcVirtRadius(n20, rectangle2);
    }

    private int getLongestStringWidth(FontMetrics fontMetrics) {
        int n;
        String string = "";
        String string2 = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.m_vectStrLabels.size()) {
            String string3 = (String)this.m_vectStrLabels.elementAt(n4);
            if (string3 != null) {
                boolean bl = false;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    int n5 = string4.length();
                    if (n5 > n2) {
                        n2 = n5;
                        string = string4;
                        continue;
                    }
                    if (n5 <= n3) continue;
                    n3 = n5;
                    string2 = string4;
                }
            }
            ++n4;
        }
        n4 = fontMetrics.stringWidth(string);
        return n4 > (n = fontMetrics.stringWidth(string2)) ? n4 : n;
    }

    private int calcVirtRadius(int n, Rectangle rectangle) {
        if (rectangle.width < rectangle.height) {
            return this.m_VC.destToVirtWidth(n);
        }
        return this.m_VC.destToVirtHeight(n);
    }

    private FontMetrics getSliceLabelFontMetrics() {
        if (this.m_sliceLabelFM == null) {
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            Font font = this.m_textStyleFeelers.getFont(this.m_VC);
            this.m_sliceLabelFM = graphics.getFontMetrics(font);
            return this.m_sliceLabelFM;
        }
        return this.m_sliceLabelFM;
    }

    private void calcPivotLineAndGap(int n, int n2) {
        int n3;
        int n4 = this.m_VC.virtToDestWidth(n);
        int n5 = this.m_VC.virtToDestHeight(n2);
        if (n5 < (n3 = n4 / 2)) {
            n3 = n5;
        }
        this.m_pivotLineDest = (int)((double)n3 * 0.04);
        if (this.m_pivotLineDest > 5) {
            this.m_pivotLineDest = 5;
        } else if (this.m_pivotLineDest < 2) {
            this.m_pivotLineDest = 2;
        }
        this.m_pivotLineVirt = this.m_VC.destToVirtWidth(this.m_pivotLineDest);
        this.m_feelerTextGapDest = (int)((double)n3 * 0.02);
        if (this.m_feelerTextGapDest > 3) {
            this.m_feelerTextGapDest = 3;
        } else if (this.m_feelerTextGapDest < 1) {
            this.m_feelerTextGapDest = 1;
        }
        this.m_feelerTextGapVirt = this.m_VC.destToVirtWidth(this.m_feelerTextGapDest);
    }

    private void getSliceLabels(int n, FontMetrics fontMetrics) {
        int[] nArray;
        int n2;
        String string;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        int n3;
        double d8 = 0.0;
        double d9 = -1.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = this.m_Perspective.getOtherSeries();
        boolean bl2 = false;
        this.m_leftSliceLabels = new Vector();
        this.m_rightSliceLabels = new Vector();
        this.m_vectStrLabels = new Vector();
        this.m_stringWidths = new int[25];
        this.m_sliceLabelFontHeight = TextStyleObj.getFontHeight(fontMetrics);
        double d10 = this.m_Perspective.getOtherPercentage() / 100.0;
        double d11 = this.getPieRotation();
        this.m_maxLabelWidthDest = 0;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        while (seriesEnumerator.hasMoreElements()) {
            n3 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
            d7 = this.m_gt.isPieBarType() ? this.getSeriesTotal(n3) : this.getDataValue((int)n3, (int)n).m_fValue;
            if (!(d7 > 0.0)) continue;
            d6 = d7 / this.m_fPieTotal;
            if (bl && d6 < d10) {
                d8 += d6;
                continue;
            }
            d5 = d11 + d6;
            if (d11 == 0.125) {
                d11 += 1.0E-12;
            }
            if (d11 == 0.375) {
                d11 -= 1.0E-12;
            }
            if (d11 == 0.625) {
                d11 -= 1.0E-12;
            }
            if (d11 == 0.875) {
                d11 -= 1.0E-12;
            }
            d4 = d5 - d11;
            d3 = d11 - Math.floor(d11);
            d2 = d5 - Math.floor(d5);
            d = d3 + d4 / 2.0;
            d -= Math.floor(d);
            string = this.getLabel(n3, n, d7, d6);
            this.m_vectStrLabels.addElement(string);
            n2 = fontMetrics.stringWidth(string);
            if (n2 > this.m_maxLabelWidthDest) {
                this.m_maxLabelWidthDest = n2;
            }
            if ((double)string.length() > this.m_maxStrLength) {
                this.m_maxStrLength = string.length();
            }
            if (this.m_stringWidths.length <= n6) {
                nArray = new int[this.m_stringWidths.length * 2];
                System.arraycopy(this.m_stringWidths, 0, nArray, 0, this.m_stringWidths.length);
                this.m_stringWidths = nArray;
            }
            this.m_stringWidths[n6] = n2;
            if (d < 0.08 || d > 0.92 || d > 0.42 && d < 0.58) {
                this.m_bLabelsAtTopOrBottom = true;
            }
            if (d9 < 0.0) {
                d9 = d;
            }
            if (!(bl2 = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(n3) || this.m_Perspective.getPieSliceDelete(n3, n) : false)) {
                if (d > 0.0 && d <= 0.5) {
                    if (d < d9) {
                        this.m_rightSliceLabels.insertElementAt(string, n5++);
                    } else {
                        this.m_rightSliceLabels.addElement(string);
                    }
                } else if (d < d9 && d != 0.0) {
                    this.m_leftSliceLabels.insertElementAt(string, n4++);
                } else {
                    this.m_leftSliceLabels.addElement(string);
                }
            }
            d11 = d5;
            ++n6;
        }
        if (d8 > 0.0) {
            n3 = -1;
            d7 = d8 * this.m_fPieTotal;
            d6 = d8;
            d5 = d11 + d6;
            if (d11 == 0.125) {
                d11 += 1.0E-12;
            }
            if (d11 == 0.375) {
                d11 -= 1.0E-12;
            }
            if (d11 == 0.625) {
                d11 -= 1.0E-12;
            }
            if (d11 == 0.875) {
                d11 -= 1.0E-12;
            }
            d4 = d5 - d11;
            d3 = d11 - Math.floor(d11);
            d2 = d5 - Math.floor(d5);
            d = d3 + d4 / 2.0;
            d -= Math.floor(d);
            string = this.getLabel(n3, n, d7, d6);
            this.m_vectStrLabels.addElement(string);
            n2 = fontMetrics.stringWidth(string);
            if (n2 > this.m_maxLabelWidthDest) {
                this.m_maxLabelWidthDest = n2;
            }
            if ((double)string.length() > this.m_maxStrLength) {
                this.m_maxStrLength = string.length();
            }
            if (this.m_stringWidths.length <= n6) {
                nArray = new int[this.m_stringWidths.length * 2];
                System.arraycopy(this.m_stringWidths, 0, nArray, 0, this.m_stringWidths.length);
                this.m_stringWidths = nArray;
            }
            this.m_stringWidths[n6] = n2;
            if (d < 0.08 || d > 0.92 || d > 0.42 && d < 0.58) {
                this.m_bLabelsAtTopOrBottom = true;
            }
            if (d9 < 0.0) {
                d9 = d;
            }
            if (!(bl2 = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(n3) || this.m_Perspective.getPieSliceDelete(n3, n) : false)) {
                if (d > 0.0 && d <= 0.5) {
                    if (d < d9) {
                        this.m_rightSliceLabels.insertElementAt(string, n5++);
                    } else {
                        this.m_rightSliceLabels.addElement(string);
                    }
                } else if (d < d9) {
                    this.m_leftSliceLabels.insertElementAt(string, n4++);
                } else {
                    this.m_leftSliceLabels.addElement(string);
                }
            }
        }
        this.m_fullSliceLabels = new String[this.m_vectStrLabels.size()];
    }

    public String getLabel(int n, int n2, double d, double d2) {
        String string;
        switch (this.m_bPieLabelDisplay) {
            case 0: {
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, n, n2, -1, -3);
                    string = this.m_Perspective.getNumberFormatCallBack().toString(d);
                    break;
                }
                string = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, d, this.m_strFeelerTextFormatPattern);
                break;
            }
            case 1: {
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, n, n2, -1, -3);
                    string = this.m_Perspective.getNumberFormatCallBack().toString(d2);
                    break;
                }
                string = TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, d2, this.m_strFeelerTextFormatPattern);
                break;
            }
            case 2: {
                if (n == -1) {
                    if (this.m_Perspective.PFJRes == null) {
                        this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
                    }
                    string = this.m_Perspective.PFJRes.getString("OTHER");
                    break;
                }
                string = this.m_Perspective.getSeriesLabel(n);
                break;
            }
            case 3: {
                if (n == -1) {
                    if (this.m_Perspective.PFJRes == null) {
                        this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
                    }
                    string = this.m_Perspective.PFJRes.getString("OTHER");
                } else {
                    string = this.m_Perspective.getSeriesLabel(n);
                }
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(1, n, n2, -1, -3);
                    string = String.valueOf(string) + ", " + this.m_Perspective.getNumberFormatCallBack().toString(d2);
                    break;
                }
                string = String.valueOf(string) + " (" + TDGNumberFormat.toString(this.m_Perspective, this.m_nFeelerTextFormat, d2, this.m_strFeelerTextFormatPattern) + ")";
                break;
            }
            default: {
                string = "!";
            }
        }
        return string;
    }

    private int calcPieLabelHeight() {
        IdentObj identObj;
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        GroupsEnumerator groupsEnumerator2 = this.getResetGroupsEnumerator(false);
        int n = 0;
        int n2 = groupsEnumerator.getAbsoluteGroup(n);
        int n3 = this.m_bReverseGroups ? groupsEnumerator2.getAbsoluteGroup(n) : n2;
        Dimension dimension = new Dimension(0, 0);
        String string = null;
        string = this.m_gt.isPieBarType() ? (this.m_Perspective.getPieBarLabelDisplay() ? this.m_Perspective.getPieBarLabelString() : "") : this.m_Perspective.getGroupLabel(n3);
        if (!(this.m_bGTMultiple || string != null && string.length() > 0)) {
            return 0;
        }
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(296);
            identObj.setMiscID(n3);
        } else {
            identObj = new IdentObj(296, -3, n3);
        }
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        this.m_pieLabelTextStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), this.m_Perspective.getAutofit(identObj), false, this.m_Perspective.getTextWrap(identObj));
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        Font font = this.m_pieLabelTextStyleObj.getFont(this.m_VC);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        dimension.height = this.m_VC.destToVirtHeight(TextStyleObj.getFontHeight(fontMetrics) + 5);
        return dimension.height;
    }

    public void createFrame() {
        this.m_Frame = new PieFrameObj(this.m_Perspective);
    }

    protected void calcFeelerLabels(int n) {
        FontMetrics fontMetrics;
        double d = 1.0;
        if (this.m_bGTMultiple) {
            fontMetrics = this.getSliceLabelFontMetrics();
            this.getSliceLabels(n, fontMetrics);
        }
        fontMetrics = this.getSliceLabelFontMetrics();
        int n2 = TextStyleObj.getFontHeight(fontMetrics);
        this.m_labelDimVC = new Dimension(this.m_VC.destToVirtWidth(this.m_maxLabelWidthDest), this.m_VC.destToVirtHeight(n2));
    }

    protected void createFeelerTextStyle() {
        IdentObj identObj = this.m_Perspective.getPieSliceLabel();
        this.m_textStyleFeelers = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), this.m_Perspective.getFontSizeAbsolute(identObj), this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), 0, 1, this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bGTHasRing = this.m_gt.toString().equals("PIE_RING") || this.m_gt.toString().equals("PIE_RINGMULT") || this.m_gt.toString().equals("PIE_RINGMULTPROP") || this.m_gt.toString().equals("PIE_BAR_RING");
        this.m_bGTProportional = this.m_gt.toString().equals("PIE_MULTPROP") || this.m_gt.toString().equals("PIE_RINGMULTPROP");
        boolean bl = this.m_bGTMultiple = this.m_bGTProportional || this.m_gt.toString().equals("PIE_MULT") || this.m_gt.toString().equals("PIE_RINGMULT");
        if (!this.m_bSmallDataSet && !this.m_bGTMultiple) {
            this.m_bSmallDataSet = this.m_nSeries < 899;
        }
        this.m_nKissingFeelers = 1;
        this.m_fThickness = (double)this.m_Perspective.getPieDepth() / 100.0;
        this.m_bShowPieTotal = this.m_Perspective.getPieRingTotalDisplay();
        this.m_nPiesPerRow = this.m_Perspective.getPiesPerRow();
        this.m_fPieTilt = (double)this.m_Perspective.getPieTilt() / 100.0;
        this.m_nPieFeelerTextDisplay = this.m_Perspective.getPieFeelerTextDisplay();
        this.m_bPieLabelDisplay = this.m_Perspective.getPieLabelDisplay();
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_nFeelerTextFormat = this.m_Perspective.getPieFeelerTextFormat();
        this.m_strFeelerTextFormatPattern = this.m_Perspective.getPieFeelerTextFormatPattern();
        this.m_fRingPct = this.m_bGTHasRing ? (double)this.m_Perspective.getPieRingSize() / 100.0 : 0.0;
        this.m_nLineWidthFeeler = this.m_Perspective.getLineWidth(this.m_Perspective.getPieFeelerLine());
        this.m_rOPI_PieFrame = this.m_Perspective.getRect(new IdentObj(302));
        this.m_nPieBarSlice = this.m_Perspective.getPieBarSeries();
        PfjAssert.pfjAssert(this.m_nPieBarSlice >= 0);
        if (this.m_nPieBarSlice >= this.m_nTotalSeries) {
            SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
            this.m_nPieBarSlice = seriesEnumerator.getFirstSeries();
            this.m_Perspective.setPieBarSeries(this.m_nPieBarSlice);
        }
    }

    protected Polygon createTopPoly(PieSliceObj pieSliceObj) {
        double d;
        Polygon polygon = new Polygon();
        int n = pieSliceObj.m_polyCrust.npoints;
        polygon.addPoint(pieSliceObj.m_ptRingLeft.x, pieSliceObj.m_ptRingLeft.y);
        int n2 = 0;
        while (n2 < n) {
            polygon.addPoint(pieSliceObj.m_polyCrust.xpoints[n2], pieSliceObj.m_polyCrust.ypoints[n2]);
            ++n2;
        }
        if (pieSliceObj.m_nSeriesID == this.m_nPieBarSlice) {
            this.m_ptTopSlice = new Point(pieSliceObj.m_polyCrust.xpoints[0], pieSliceObj.m_polyCrust.ypoints[0]);
            this.m_ptBottomSlice = new Point(pieSliceObj.m_polyCrust.xpoints[n - 1], pieSliceObj.m_polyCrust.ypoints[n - 1]);
        }
        polygon.addPoint(pieSliceObj.m_ptRingRight.x, pieSliceObj.m_ptRingRight.y);
        if (pieSliceObj.m_polyRing != null) {
            n2 = n - 2;
            while (n2 >= 0) {
                polygon.addPoint(pieSliceObj.m_polyRing.xpoints[n2], pieSliceObj.m_polyRing.ypoints[n2]);
                --n2;
            }
            return polygon;
        }
        Point point = this.m_VC.virtToDest(pieSliceObj.m_ptTip);
        Arc2D.Double double_ = new Arc2D.Double();
        double d2 = (double)360 - pieSliceObj.m_fAngleEnd * (double)360 + (double)90;
        if (d2 > (double)360) {
            d2 -= (double)360;
        }
        if (pieSliceObj.m_fAngleEnd == 0.0) {
            d = (double)360 - pieSliceObj.m_fAngleStart * (double)360;
        }
        d = pieSliceObj.m_fPiePct == 1.0 ? (double)360 - pieSliceObj.m_fAngleStart * (double)360 + pieSliceObj.m_fAngleEnd * (double)360 : (pieSliceObj.m_fAngleEnd > pieSliceObj.m_fAngleStart ? pieSliceObj.m_fAngleEnd * (double)360 - pieSliceObj.m_fAngleStart * (double)360 : (double)360 - pieSliceObj.m_fAngleStart * (double)360 + pieSliceObj.m_fAngleEnd * (double)360);
        double d3 = (double)point.x - this.m_xRadius;
        double d4 = (double)point.y - this.m_yRadius;
        double d5 = this.m_xRadius * (double)2;
        double d6 = this.m_yRadius * (double)2;
        ((Arc2D)double_).setArc(d3, d4, d5, d6, d2, d, 2);
        this.m_arc2D = double_;
        return polygon;
    }

    protected Polygon createCrustPoly(PieSliceObj pieSliceObj) {
        GeneralPath generalPath;
        double d;
        Polygon polygon = new Polygon();
        int n = pieSliceObj.m_polyCrust.npoints;
        int n2 = 0;
        while (n2 < n) {
            if (pieSliceObj.m_bSliceSplit) {
                if (pieSliceObj.m_ptCenter.y < pieSliceObj.m_ptTip.y) {
                    polygon.addPoint(pieSliceObj.m_polyCrust.xpoints[n2], pieSliceObj.m_polyCrust.ypoints[n2]);
                } else {
                    polygon.addPoint(pieSliceObj.m_polyCrust.xpoints[n2], pieSliceObj.m_polyCrust.ypoints[n2]);
                }
            } else {
                polygon.addPoint(pieSliceObj.m_polyCrust.xpoints[n2], pieSliceObj.m_polyCrust.ypoints[n2]);
            }
            ++n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            polygon.addPoint(pieSliceObj.m_polyCrust.xpoints[n2], pieSliceObj.m_polyCrust.ypoints[n2] - this.m_nThickOffset);
            --n2;
        }
        polygon.addPoint(pieSliceObj.m_polyCrust.xpoints[0], pieSliceObj.m_polyCrust.ypoints[0]);
        if (pieSliceObj.m_polyRing != null) {
            return polygon;
        }
        Point point = this.m_VC.virtToDest(pieSliceObj.m_ptTip);
        Arc2D.Double double_ = new Arc2D.Double();
        double d2 = (double)360 - pieSliceObj.m_fAngleEnd * (double)360 + (double)90;
        if (d2 > (double)360) {
            d2 -= (double)360;
        }
        if (pieSliceObj.m_fAngleEnd == 0.0) {
            d = (double)360 - pieSliceObj.m_fAngleStart * (double)360;
        }
        d = pieSliceObj.m_fPiePct == 1.0 ? (double)360 - pieSliceObj.m_fAngleStart * (double)360 + pieSliceObj.m_fAngleEnd * (double)360 : (pieSliceObj.m_fAngleEnd > pieSliceObj.m_fAngleStart ? pieSliceObj.m_fAngleEnd * (double)360 - pieSliceObj.m_fAngleStart * (double)360 : (double)360 - pieSliceObj.m_fAngleStart * (double)360 + pieSliceObj.m_fAngleEnd * (double)360);
        double d3 = (double)point.x - this.m_xRadius;
        double d4 = (double)point.y - this.m_yRadius;
        double d5 = this.m_xRadius * (double)2;
        double d6 = this.m_yRadius * (double)2;
        ((Arc2D)double_).setArc(d3, d4, d5, d6, d2, d, 2);
        Arc2D.Double double_2 = new Arc2D.Double();
        ((Arc2D)double_2).setArc(d3, d4 + (double)this.m_VC.virtToDestHeight(this.m_nThickOffset), d5, d6, d2, d, 2);
        GeneralPath generalPath2 = new GeneralPath();
        Point2D point2D = double_.getStartPoint();
        Point2D point2D2 = double_.getEndPoint();
        Point2D point2D3 = double_2.getStartPoint();
        Point2D point2D4 = double_2.getEndPoint();
        generalPath2.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath2.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        generalPath2.lineTo((float)point2D4.getX(), (float)point2D4.getY());
        generalPath2.lineTo((float)point2D3.getX(), (float)point2D3.getY());
        generalPath2.lineTo((float)point2D.getX(), (float)point2D.getY());
        Area area = new Area(double_);
        Area area2 = new Area(double_2);
        area2.add(new Area(generalPath2));
        area.exclusiveOr(area2);
        area.intersect(area2);
        if (pieSliceObj.m_fPiePct == 1.0) {
            this.m_area = area;
            return polygon;
        }
        if (d2 > (double)270 && d2 < (double)360) {
            generalPath = new GeneralPath();
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point.x, (float)point.y + (float)this.m_VC.virtToDestHeight(this.m_nThickOffset));
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo(point.x, point.y);
            area.subtract(new Area(generalPath));
        }
        if (d2 + d < (double)270 && d2 + d > (double)180) {
            generalPath = new GeneralPath();
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point.x, (float)point.y + (float)this.m_VC.virtToDestHeight(this.m_nThickOffset));
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo(point.x, point.y);
            area.subtract(new Area(generalPath));
        }
        if (d2 > 0.0 && d2 < (double)90) {
            generalPath = new GeneralPath();
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point.x, (float)point.y + (float)this.m_VC.virtToDestHeight(this.m_nThickOffset));
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo(point.x, point.y);
            area.subtract(new Area(generalPath));
        }
        if (d2 + d > (double)90 && d2 + d < (double)180) {
            generalPath = new GeneralPath();
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point.x, (float)point.y + (float)this.m_VC.virtToDestHeight(this.m_nThickOffset));
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo(point.x, point.y);
            area.subtract(new Area(generalPath));
        }
        this.m_area = area;
        return polygon;
    }

    protected Polygon createLeftPoly(PieSliceObj pieSliceObj) {
        Polygon polygon = new Polygon();
        polygon.addPoint(pieSliceObj.m_ptCrustLeft.x, pieSliceObj.m_ptCrustLeft.y);
        polygon.addPoint(pieSliceObj.m_ptRingLeft.x, pieSliceObj.m_ptRingLeft.y);
        polygon.addPoint(pieSliceObj.m_ptRingLeft.x, pieSliceObj.m_ptRingLeft.y - this.m_nThickOffset);
        polygon.addPoint(pieSliceObj.m_ptCrustLeft.x, pieSliceObj.m_ptCrustLeft.y - this.m_nThickOffset);
        polygon.addPoint(pieSliceObj.m_ptCrustLeft.x, pieSliceObj.m_ptCrustLeft.y);
        return polygon;
    }

    protected Polygon createRightPoly(PieSliceObj pieSliceObj) {
        Polygon polygon = new Polygon();
        polygon.addPoint(pieSliceObj.m_ptRingRight.x, pieSliceObj.m_ptRingRight.y);
        polygon.addPoint(pieSliceObj.m_ptCrustRight.x, pieSliceObj.m_ptCrustRight.y);
        polygon.addPoint(pieSliceObj.m_ptCrustRight.x, pieSliceObj.m_ptCrustRight.y - this.m_nThickOffset);
        polygon.addPoint(pieSliceObj.m_ptRingRight.x, pieSliceObj.m_ptRingRight.y - this.m_nThickOffset);
        return polygon;
    }

    protected Polygon createRingPoly(PieSliceObj pieSliceObj) {
        Polygon polygon = new Polygon();
        int n = pieSliceObj.m_polyRing.npoints;
        int n2 = 0;
        while (n2 < n) {
            if (pieSliceObj.m_bSliceSplit) {
                if (pieSliceObj.m_ptCenter.y < pieSliceObj.m_ptTip.y) {
                    polygon.addPoint(pieSliceObj.m_polyRing.xpoints[n2], pieSliceObj.m_polyRing.ypoints[n2] - 100);
                } else {
                    polygon.addPoint(pieSliceObj.m_polyRing.xpoints[n2], pieSliceObj.m_polyRing.ypoints[n2] + 100);
                }
            } else {
                polygon.addPoint(pieSliceObj.m_polyRing.xpoints[n2], pieSliceObj.m_polyRing.ypoints[n2]);
            }
            ++n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            polygon.addPoint(pieSliceObj.m_polyRing.xpoints[n2], pieSliceObj.m_polyRing.ypoints[n2] - this.m_nThickOffset);
            --n2;
        }
        polygon.addPoint(pieSliceObj.m_polyRing.xpoints[0], pieSliceObj.m_polyRing.ypoints[0]);
        return polygon;
    }

    protected PieSliceObj createSliceObj(int n, int n2, int n3, double d, double d2, int n4, double d3, double d4, double d5) {
        double d6;
        PieSliceObj pieSliceObj = new PieSliceObj();
        double d7 = 1.0;
        MinMaxObj minMaxObj = new MinMaxObj();
        Rectangle rectangle = this.m_VC.getDestCoords();
        double d8 = Math.abs((double)rectangle.width) / (double)rectangle.height;
        if (d8 > 1.0) {
            d7 = 1.0 / d8;
            d8 = 1.0;
        }
        d8 -= d8 * d4;
        this.m_xRadius = this.m_VC.virtToDestWidth((double)n3 * d7);
        this.m_yRadius = this.m_VC.virtToDestHeight((double)n3 * d8);
        if (d == 0.125) {
            d += 1.0E-12;
        }
        if (d == 0.375) {
            d -= 1.0E-12;
        }
        if (d == 0.625) {
            d -= 1.0E-12;
        }
        if (d == 0.875) {
            d -= 1.0E-12;
        }
        int n5 = n;
        int n6 = n2;
        double d9 = d2 - d;
        double d10 = -1.5707963267948966;
        pieSliceObj.m_bSliceSplit = false;
        pieSliceObj.m_fAngleStart = d - Math.floor(d);
        pieSliceObj.m_fAngleEnd = d2 - Math.floor(d2);
        pieSliceObj.m_fAngleAvg = d + d9 / 2.0;
        pieSliceObj.m_fAngleAvg -= Math.floor(pieSliceObj.m_fAngleAvg);
        this.calcSlicePositionAndOrient(pieSliceObj);
        pieSliceObj.m_nDetatch = n4;
        if (n4 > 0) {
            d6 = d3 == -7.0 ? d10 + (d + d9 / 2.0) * (Math.PI * 2) : d3;
            pieSliceObj.m_fAngleDet = d6;
            n5 = n + (int)(Math.cos(d6) * d7 * (double)n4);
            n6 = n2 - (int)(Math.sin(d6) * d8 * (double)n4);
        }
        pieSliceObj.m_polyCrust = new Polygon();
        pieSliceObj.m_polyRing = d5 > 0.0 ? new Polygon() : null;
        pieSliceObj.m_ptTip = new Point(n5, n6);
        minMaxObj.testRawValue(n6);
        d6 = d10 + pieSliceObj.m_fAngleAvg * (Math.PI * 2);
        this.calcFeelerPoints(pieSliceObj, minMaxObj, n5, n6, n3, d6, d5, d7, d8);
        this.calcLeftAndRightMostPoints(n, n2, n3, d10, n4, d7, d8);
        this.calcArcPoints(pieSliceObj, minMaxObj, n5, n6, d10, d, d2, n3, d5, d7, d8);
        pieSliceObj.m_fHighestY = minMaxObj.getRawMax();
        pieSliceObj.m_fLowestY = minMaxObj.getRawMin();
        return pieSliceObj;
    }

    protected Point[] calcArcPointsForTestPolygon() {
        Point[] pointArray = new Point[100];
        double d = 0.0;
        double d2 = 1.0;
        double d3 = this.m_fPieTilt;
        Rectangle rectangle = this.m_VC.getDestCoords();
        double d4 = Math.abs((double)rectangle.width) / (double)rectangle.height;
        if (d4 > 1.0) {
            d2 = 1.0 / d4;
            d4 = 1.0;
        }
        d4 -= d4 * d3;
        double d5 = -1.5707963267948966;
        int n = 0;
        while (n < 100) {
            double d6 = d5 + d * (Math.PI * 2);
            int n2 = this.m_nXCenter + (int)Math.rint(Math.cos(d6) * d2 * (double)this.m_nRadius);
            int n3 = this.m_nYCenter - (int)(Math.sin(d6) * d4 * (double)this.m_nRadius);
            if (this.m_nThickOffset > 0 && d > 0.25 && d < 0.75) {
                n3 -= this.m_nThickOffset;
            }
            pointArray[n] = new Point(n2, n3);
            d += 0.01;
            ++n;
        }
        return pointArray;
    }

    protected void calcArcPoints(PieSliceObj pieSliceObj, MinMaxObj minMaxObj, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        int n3;
        int n4;
        double d8;
        double d9 = d3 - d2;
        double d10 = this.getNumPixelsInArc(n, n2, d, d2, d3, d4);
        double d11 = 1.0 / this.m_Perspective.getNumPieArcSegmentsPerPixel();
        double d12 = d11 / d10 * d9;
        double d13 = d2;
        while (d13 < d3) {
            d8 = d + d13 * (Math.PI * 2);
            n4 = n + (int)Math.rint(Math.cos(d8) * d6 * d4);
            n3 = n2 - (int)(Math.sin(d8) * d7 * d4);
            pieSliceObj.m_polyCrust.addPoint(n4, n3);
            minMaxObj.testRawValue(n3);
            if (d5 > 0.0) {
                n4 = n + (int)Math.rint(Math.cos(d8) * d6 * (d4 * d5));
                n3 = n2 - (int)(Math.sin(d8) * d7 * (d4 * d5));
                pieSliceObj.m_polyRing.addPoint(n4, n3);
                minMaxObj.testRawValue(n3);
            }
            d13 += d12;
        }
        d8 = d + d3 * (Math.PI * 2);
        n4 = n + (int)(Math.cos(d8) * d6 * d4);
        n3 = n2 - (int)(Math.sin(d8) * d7 * d4);
        pieSliceObj.m_polyCrust.addPoint(n4, n3);
        minMaxObj.testRawValue(n3);
        if (d5 > 0.0) {
            n4 = n + (int)(Math.cos(d8) * d6 * (d4 * d5));
            n3 = n2 - (int)(Math.sin(d8) * d7 * (d4 * d5));
            pieSliceObj.m_polyRing.addPoint(n4, n3);
            minMaxObj.testRawValue(n3);
        }
        int n5 = pieSliceObj.m_polyCrust.npoints - 1;
        pieSliceObj.m_ptCrustLeft = new Point(pieSliceObj.m_polyCrust.xpoints[0], pieSliceObj.m_polyCrust.ypoints[0]);
        pieSliceObj.m_ptCrustRight = new Point(pieSliceObj.m_polyCrust.xpoints[n5], pieSliceObj.m_polyCrust.ypoints[n5]);
        if (d5 > 0.0) {
            pieSliceObj.m_ptRingLeft = new Point(pieSliceObj.m_polyRing.xpoints[0], pieSliceObj.m_polyRing.ypoints[0]);
            pieSliceObj.m_ptRingRight = new Point(pieSliceObj.m_polyRing.xpoints[n5], pieSliceObj.m_polyRing.ypoints[n5]);
        } else {
            pieSliceObj.m_ptRingLeft = new Point(n, n2);
            pieSliceObj.m_ptRingRight = new Point(n, n2);
        }
    }

    public double getNumPixelsInArc(int n, int n2, double d, double d2, double d3, double d4) {
        double d5 = d + d2 * (Math.PI * 2);
        double d6 = d + d3 * (Math.PI * 2);
        double d7 = d6 - d5;
        double d8 = 1.0;
        Rectangle rectangle = this.m_VC.getDestCoords();
        double d9 = Math.abs((double)rectangle.width) / (double)rectangle.height;
        if (d9 > 1.0) {
            d8 = 1.0 / d9;
            d9 = 1.0;
        }
        double d10 = d + d2 * (Math.PI * 2);
        int n3 = n + (int)Math.rint(Math.cos(d10) * d8 * d4);
        int n4 = n2 - (int)(Math.sin(d10) * d9 * d4);
        int n5 = this.m_VC.virtToDestX(n);
        int n6 = this.m_VC.virtToDestX(n2);
        int n7 = this.m_VC.virtToDestX(n3);
        int n8 = this.m_VC.virtToDestX(n4);
        double d11 = Math.pow(n7 - n5, 2.0);
        double d12 = Math.pow(n8 - n6, 2.0);
        double d13 = Math.sqrt(d11 + d12);
        double d14 = d13 * d7;
        return d14;
    }

    protected void calcFeelerPoints(PieSliceObj pieSliceObj, MinMaxObj minMaxObj, int n, int n2, double d, double d2, double d3, double d4, double d5) {
        double d6;
        int n3;
        int n4;
        if (this.m_nKissingFeelers == 1) {
            n4 = n + (int)Math.rint(Math.cos(d2) * d4 * d);
            n3 = n2 - (int)(Math.sin(d2) * d5 * d);
            pieSliceObj.m_ptCenter = new Point(n4, n3);
        } else {
            d6 = d * (d3 + (1.0 - d3) / 1.5);
            n4 = n + (int)(Math.cos(d2) * d4 * d6);
            n3 = n2 - (int)(Math.sin(d2) * d5 * d6);
            pieSliceObj.m_ptCenter = new Point(n4, n3);
            minMaxObj.testRawValue(n3);
        }
        double d7 = 0.25 - Math.abs(0.5 - pieSliceObj.m_fAngleAvg);
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        d7 *= 4.0;
        double d8 = 0.125;
        if (pieSliceObj.m_fAngleAvg > 0.125 && pieSliceObj.m_fAngleAvg < 0.375) {
            d8 *= Math.abs(0.25 - pieSliceObj.m_fAngleAvg) / 0.125;
        } else if (pieSliceObj.m_fAngleAvg > 0.625 && pieSliceObj.m_fAngleAvg < 0.875) {
            d8 *= Math.abs(0.75 - pieSliceObj.m_fAngleAvg) / 0.125;
        }
        d6 = d + d * (d8 + d7 * (0.3 * this.m_fThickness + 0.5 * this.m_fPieTilt));
        n4 = n + (int)(Math.cos(d2) * d4 * d6);
        n3 = n2 - (int)(Math.sin(d2) * d5 * d6);
        pieSliceObj.m_ptFeelerJoint = new Point(n4, n3);
        minMaxObj.testRawValue(n3);
    }

    protected void calcLeftAndRightMostPoints(int n, int n2, double d, double d2, int n3, double d3, double d4) {
        int n4;
        double d5;
        int n5;
        int n6;
        if (n3 > 0) {
            this.m_DetachPresent = true;
        }
        if ((n6 = (n5 = n + (int)(Math.cos(d5 = d2 + 1.5707963267948966) * d3 * (double)n3)) + (int)Math.rint(Math.cos(d5) * d3 * d)) > this.m_rightMostPointOfPie) {
            this.m_rightMostPointOfPie = n6;
        }
        if ((n4 = (n5 = n + (int)(Math.cos(d5 = d2 + 4.71238898038469) * d3 * (double)n3)) + (int)Math.rint(Math.cos(d5) * d3 * d)) < this.m_leftMostPointOfPie) {
            this.m_leftMostPointOfPie = n4;
        }
    }

    protected void calcSlicePositionAndOrient(PieSliceObj pieSliceObj) {
        if (pieSliceObj.m_fAngleStart == 0.0 || pieSliceObj.m_fAngleEnd == 0.0) {
            pieSliceObj.m_nSliceType = 21;
        } else if ((pieSliceObj.m_fAngleStart >= 0.75 || pieSliceObj.m_fAngleStart <= 0.25) && (pieSliceObj.m_fAngleEnd >= 0.75 || pieSliceObj.m_fAngleEnd <= 0.25)) {
            pieSliceObj.m_nSliceType = 10;
        } else if (pieSliceObj.m_fAngleStart >= 0.25 && pieSliceObj.m_fAngleStart <= 0.75 && pieSliceObj.m_fAngleEnd >= 0.25 && pieSliceObj.m_fAngleEnd <= 0.75) {
            pieSliceObj.m_nSliceType = 20;
            if (pieSliceObj.m_fAngleStart == 0.25 || pieSliceObj.m_fAngleEnd == 0.75) {
                pieSliceObj.m_nSliceType = 21;
            }
        } else {
            pieSliceObj.m_nSliceType = pieSliceObj.m_fAngleStart < 0.5 ? 1 : 2;
        }
        if (pieSliceObj.m_fAngleEnd < pieSliceObj.m_fAngleStart && pieSliceObj.m_fAngleStart < 0.75) {
            pieSliceObj.m_nSliceType = 3;
        }
        if (pieSliceObj.m_fAngleEnd > pieSliceObj.m_fAngleStart && pieSliceObj.m_fAngleEnd - pieSliceObj.m_fAngleStart > 0.5) {
            pieSliceObj.m_nSliceType = 3;
        }
        if (pieSliceObj.m_nSliceType != 1 && pieSliceObj.m_nSliceType != 2 && pieSliceObj.m_nSliceType != 3 && pieSliceObj.m_fAngleStart < 0.5 && pieSliceObj.m_fAngleEnd >= 0.5) {
            pieSliceObj.m_nSliceType = 22;
        }
        pieSliceObj.m_nSliceSide = pieSliceObj.m_fAngleAvg > 0.0 && pieSliceObj.m_fAngleAvg <= 0.5 ? 1 : 0;
    }

    protected double drawPie(Rectangle rectangle, int n) {
        this.m_leftMostPointOfPie = 50000;
        this.m_rightMostPointOfPie = -50000;
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        GroupsEnumerator groupsEnumerator2 = this.getResetGroupsEnumerator(false);
        int n2 = groupsEnumerator.getAbsoluteGroup(n);
        this.m_nXCenter = this.m_rPieFrame.x + this.m_rPieFrame.width / 2;
        this.m_nYCenter = this.m_rPieFrame.y + this.m_nPieLabelHeight + (this.m_rPieFrame.height - this.m_nPieLabelHeight) / 2;
        if (this.m_gt.isPieBarType() && this.isPieBarSliceOK()) {
            this.m_nXCenter = this.m_rPieFrame.x + this.m_rPieFrame.width * 9 / 20;
        }
        this.m_sliceLabelLeftEdge = this.m_rPieFrame.x + this.m_virtMarginWidth;
        this.m_sliceLabelRightEdge = this.m_rPieFrame.x + (this.m_nXCenter - this.m_rPieFrame.x) * 2 - this.m_virtMarginWidth;
        this.m_nThickOffset = (int)(this.m_fThickness * (double)(this.m_rPieFrame.height / 10));
        this.m_slices = new PieSliceObj[this.m_nTotalSeries + 5];
        if (this.m_gt.isPieBarType()) {
            this.m_fHighestGroupTotal = this.m_fPieTotal = this.getSumTotal();
        } else {
            this.m_fPieTotal = this.getGroupTotal(n2);
        }
        if (this.m_fPieTotal > 0.0) {
            if (this.m_bGTProportional && this.m_fHighestGroupTotal > 0.0) {
                double d = this.m_fPieTotal / this.m_fHighestGroupTotal;
                this.m_nRadius = (int)((double)this.m_nSaveRadius * d);
            }
            this.createSliceObjects(n2);
            if (this.m_nPieFeelerTextDisplay > 0) {
                this.calcFeelerLabels(n2);
            }
            this.splitSpanningSlices();
            this.sortSlicesBackToFront();
            if (this.m_nThickOffset == 0) {
                this.drawAllSliceTops();
            } else {
                this.drawBackFacingSlices();
                this.drawThresholdSlices();
                this.drawFrontFacingSlices();
                this.drawFrontMostSlice();
                this.drawAllSliceTops();
            }
            this.drawAllSliceLabels();
            int n3 = this.m_bReverseGroups ? groupsEnumerator2.getAbsoluteGroup(n) : n2;
            if (this.m_bShowPieTotal && this.m_bGTHasRing) {
                this.drawRingLabel(n3);
            }
            if (this.m_Perspective.getDisplay(296)) {
                this.drawPieGroupLabel(n3);
            }
        }
        return this.m_fPieTotal;
    }

    protected void createSliceObjects(int n) {
        double d;
        double d2;
        int n2;
        double d3;
        double d4;
        int n3;
        double d5 = 0.0;
        boolean bl = this.m_Perspective.getOtherSeries();
        boolean bl2 = false;
        double d6 = this.m_Perspective.getOtherPercentage() / 100.0;
        double d7 = this.getPieRotation();
        this.m_nSliceCount = 0;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        while (seriesEnumerator.hasMoreElements()) {
            n3 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
            d4 = this.m_gt.isPieBarType() ? this.getSeriesTotal(n3) : this.getDataValue((int)n3, (int)n).m_fValue;
            if (d4 > 0.0) {
                d3 = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(n3, n) / 100.0 : 0.0;
                n2 = (int)(d3 * 1500.0);
                d2 = d4 / this.m_fPieTotal;
                if (bl && d2 < d6) {
                    d5 += d2;
                    this.setSeriesPartOfOther(n3, n, true);
                    continue;
                }
                d = d7 + d2;
                this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, d7, d, n2, -7.0, this.m_fPieTilt, this.m_fRingPct);
                this.m_slices[this.m_nSliceCount].m_nSeriesID = n3;
                this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
                this.m_slices[this.m_nSliceCount].m_nGroupID = n;
                this.m_slices[this.m_nSliceCount].m_fPiePct = d2;
                this.m_slices[this.m_nSliceCount].m_fSliceValue = d4;
                this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(n3) || this.m_Perspective.getPieSliceDelete(n3, n) : false;
                d7 = d;
                ++this.m_nSliceCount;
                if (!bl) continue;
                this.setSeriesDrawn(n3, n, true);
                continue;
            }
            if (d4 == 0.0) {
                if (!bl) continue;
                this.setSeriesDrawn(n3, n, false);
                continue;
            }
            if (!bl) continue;
            this.setSeriesDrawn(n3, n, false);
        }
        if (d5 > 0.0) {
            n3 = -1;
            d4 = d5 * this.m_fPieTotal;
            d3 = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(n3, n) / 100.0 : 0.0;
            n2 = (int)(d3 * 1500.0);
            d2 = d5;
            d = d7 + d2;
            this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, d7, d, n2, -7.0, this.m_fPieTilt, this.m_fRingPct);
            this.m_slices[this.m_nSliceCount].m_nSeriesID = n3;
            this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
            this.m_slices[this.m_nSliceCount].m_nGroupID = n;
            this.m_slices[this.m_nSliceCount].m_fPiePct = d2;
            this.m_slices[this.m_nSliceCount].m_fSliceValue = d4;
            this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(n3) || this.m_Perspective.getPieSliceDelete(n3, n) : false;
            d7 = d;
            ++this.m_nSliceCount;
        }
    }

    protected void splitSpanningSlices() {
        int n = 0;
        while (n < this.m_nSliceCount) {
            double d = this.m_slices[n].m_fAngleStart;
            double d2 = this.m_slices[n].m_fAngleEnd;
            double d3 = d;
            double d4 = 2.25;
            if (d2 < d) {
                d2 += 1.0;
            }
            if (this.m_slices[n].m_nSliceType == 1 || this.m_slices[n].m_nSliceType == 2 || this.m_slices[n].m_nSliceType == 3) {
                while (d3 < d2) {
                    if (d3 < 1.75) {
                        d4 = 1.75;
                    }
                    if (d3 < 1.25) {
                        d4 = 1.25;
                    }
                    if (d3 < 0.75) {
                        d4 = 0.75;
                    }
                    if (d3 < 0.25) {
                        d4 = 0.25;
                    }
                    if (d4 > d2) {
                        d4 = d2;
                    }
                    if (Math.abs(d4 - d3) < 1.0E-5) {
                        d3 = d2;
                        continue;
                    }
                    this.m_slices[this.m_nSliceCount] = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, d3, d4, this.m_slices[n].m_nDetatch, this.m_slices[n].m_fAngleDet, this.m_fPieTilt, this.m_fRingPct);
                    this.m_slices[this.m_nSliceCount].m_nSliceIdx = this.m_nSliceCount;
                    this.m_slices[this.m_nSliceCount].m_nSeriesID = this.m_slices[n].m_nSeriesID;
                    this.m_slices[this.m_nSliceCount].m_nGroupID = this.m_slices[n].m_nGroupID;
                    this.m_slices[this.m_nSliceCount].m_fPiePct = this.m_slices[n].m_fPiePct;
                    this.m_slices[this.m_nSliceCount].m_fSliceValue = this.m_slices[n].m_fSliceValue;
                    this.m_slices[this.m_nSliceCount].m_bSliceDeleted = this.m_slices[n].m_bSliceDeleted;
                    this.m_slices[this.m_nSliceCount].m_bSliceSplit = true;
                    ++this.m_nSliceCount;
                    d3 = d4;
                }
                this.m_slices[n].m_nSliceType = 4;
            }
            ++n;
        }
    }

    protected void sortSlicesBackToFront() {
        int n = 0;
        int n2 = n + this.m_nSliceCount - 1;
        int n3 = n;
        while (n3 < n2) {
            int n4 = n3 + 1;
            while (n4 <= n2) {
                boolean bl;
                if (this.m_slices[n4].m_ptCenter.y > this.m_nYCenter) {
                    bl = this.m_slices[n3].m_fHighestY < this.m_slices[n4].m_fHighestY;
                } else {
                    boolean bl2 = bl = this.m_slices[n3].m_fLowestY < this.m_slices[n4].m_fLowestY;
                }
                if (bl) {
                    PieSliceObj pieSliceObj = this.m_slices[n3];
                    this.m_slices[n3] = this.m_slices[n4];
                    this.m_slices[n4] = pieSliceObj;
                }
                ++n4;
            }
            ++n3;
        }
    }

    protected void drawAllSliceTops() {
        int n = 0;
        while (n < this.m_nSliceCount) {
            if (!this.m_slices[n].m_bSliceDeleted && !this.m_slices[n].m_bSliceSplit) {
                this.drawSliceTop(this.m_slices[n]);
            }
            ++n;
        }
    }

    protected void drawBackFacingSlices() {
        int n = 0;
        while (n < this.m_nSliceCount) {
            if (!(this.m_slices[n].m_bSliceDeleted || this.m_slices[n].m_nDetatch == 0 && this.m_fRingPct <= 0.0 || this.m_slices[n].m_nSliceType != 10)) {
                this.drawSliceCrust(this.m_slices[n]);
                if (this.m_bSmallDataSet) {
                    if (this.m_slices[n].m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(this.m_slices[n]);
                        this.drawSliceRightEdge(this.m_slices[n]);
                    } else {
                        this.drawSliceRightEdge(this.m_slices[n]);
                        this.drawSliceLeftEdge(this.m_slices[n]);
                    }
                }
                this.drawSliceRing(this.m_slices[n]);
            }
            ++n;
        }
    }

    protected void drawThresholdSlices() {
        int n = 0;
        while (n < this.m_nSliceCount) {
            if (!(this.m_slices[n].m_bSliceDeleted || this.m_slices[n].m_nSliceType != 21 && this.m_slices[n].m_fPiePct != 1.0)) {
                this.drawSliceRing(this.m_slices[n]);
                if (this.m_bSmallDataSet) {
                    if (this.m_slices[n].m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(this.m_slices[n]);
                        this.drawSliceRightEdge(this.m_slices[n]);
                    } else {
                        this.drawSliceRightEdge(this.m_slices[n]);
                        this.drawSliceLeftEdge(this.m_slices[n]);
                    }
                }
                this.drawSliceCrust(this.m_slices[n]);
            }
            ++n;
        }
    }

    protected void drawFrontFacingSlices() {
        int n = 0;
        while (n < this.m_nSliceCount) {
            if (!(this.m_slices[n].m_bSliceDeleted || this.m_slices[n].m_nSliceType != 20 && this.m_slices[n].m_fPiePct != 1.0)) {
                this.drawSliceRing(this.m_slices[n]);
                if (this.m_bSmallDataSet) {
                    if (this.m_slices[n].m_nSliceSide == 1) {
                        this.drawSliceLeftEdge(this.m_slices[n]);
                        this.drawSliceRightEdge(this.m_slices[n]);
                    } else {
                        this.drawSliceRightEdge(this.m_slices[n]);
                        this.drawSliceLeftEdge(this.m_slices[n]);
                    }
                }
                this.drawSliceCrust(this.m_slices[n]);
            }
            ++n;
        }
    }

    protected void drawFrontMostSlice() {
        int n = 0;
        while (n < this.m_nSliceCount) {
            if (!this.m_slices[n].m_bSliceDeleted && this.m_slices[n].m_nSliceType == 22) {
                this.drawSliceRing(this.m_slices[n]);
                if (this.m_bSmallDataSet) {
                    this.drawSliceLeftEdge(this.m_slices[n]);
                    this.drawSliceRightEdge(this.m_slices[n]);
                }
                this.drawSliceCrust(this.m_slices[n]);
            }
            ++n;
        }
    }

    protected void drawPieGroupLabel(int n) {
        IdentObj identObj;
        DataRange dataRange = this.m_Perspective.getViewableDataRangeSG();
        int n2 = dataRange.getColStart();
        int n3 = dataRange.getColStop();
        String string = this.m_gt.isPieBarType() ? (this.m_Perspective.getPieBarLabelDisplay() ? this.m_Perspective.getPieBarLabelString() : "") : this.m_Perspective.getGroupLabel(n);
        if (string == null || string.length() <= 0) {
            return;
        }
        int n4 = this.m_rPieFrame.y;
        int n5 = (int)((double)this.m_rPieFrame.width / 1.2);
        Rectangle rectangle = new Rectangle(this.m_nXCenter - n5 / 2, n4, n5, this.m_nPieLabelHeight);
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(296);
            identObj.setMiscID(n);
        } else {
            identObj = new IdentObj(296, -3, n);
        }
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
            int n6 = this.m_Perspective.getFontStyle(identObj) & 4;
            this.m_pieLabelTextStyleObj.setFontStyle(this.m_pieLabelTextStyleObj.getFontStyle() & 0xFFFFFFFB | n6);
        }
        new DetLabel(this.m_Detectiv, identObj, string, rectangle, this.m_pieLabelTextStyleObj, blackBoxObj, false);
    }

    protected void drawRingLabel(int n) {
        String string;
        double d;
        String string2 = this.m_Perspective.getPieRingTotalFormatPattern();
        int n2 = this.m_Perspective.getPieRingTotalFormat();
        double d2 = (double)this.m_nRadius * 1.5;
        int n3 = (int)d2;
        Dimension dimension = new Dimension(n3, n3);
        double d3 = d = TDGNumberFormat.isPercentFormat(n2) ? 1.0 : this.m_fPieTotal;
        if (this.m_Perspective.isNumberFormatCallBack()) {
            this.m_Perspective.getNumberFormatCallBack().setState(2, -3, -3, -1, -3);
            string = this.m_Perspective.getNumberFormatCallBack().toString(d);
        } else {
            string = TDGNumberFormat.toString(this.m_Perspective, n2, d, string2);
        }
        IdentObj identObj = this.m_Perspective.getPieRingLabel();
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), 1, 1, false, false, this.m_Perspective.getTextWrap(identObj));
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        int n4 = bl ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(identObj), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n4, vector, dimension, this.m_VC);
        Rectangle rectangle = new Rectangle(this.m_nXCenter - dimension.width / 2, this.m_nYCenter - dimension.height / 2, dimension.width, dimension.height);
        identObj = new IdentObj(identObj.getObjectID(), -3, n);
        new DetLabel(this.m_Detectiv, identObj, string, rectangle, textStyleObj, blackBoxObj, false);
    }

    protected void packLabelsOnBottom(PieSliceObj[] pieSliceObjArray) {
        if (pieSliceObjArray == null) {
            return;
        }
        int n = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int n2 = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        boolean bl = false;
        int n3 = n2;
        int n4 = pieSliceObjArray.length - 1;
        while (n4 >= 0) {
            if (n3 + this.m_sliceLabelGap > this.m_nYCenter) {
                int n5 = pieSliceObjArray[n4].m_ptFeelerJoint.y - pieSliceObjArray[n4].m_LabelRect.height / 2;
                int n6 = n3 + this.m_sliceLabelGap;
                if (n5 > n6) {
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 <= n4) {
                        n7 += pieSliceObjArray[n8].m_LabelRect.height + this.m_sliceLabelGap;
                        ++n8;
                    }
                    n8 = n - n5;
                    pieSliceObjArray[n4].m_LabelRect.y = n8 >= n7 ? n5 : n - n7;
                } else {
                    pieSliceObjArray[n4].m_LabelRect.y = n6;
                }
            } else {
                pieSliceObjArray[n4].m_LabelRect.y = n3 + this.m_sliceLabelGap;
            }
            n3 = pieSliceObjArray[n4].m_LabelRect.y + pieSliceObjArray[n4].m_LabelRect.height;
            --n4;
        }
    }

    protected void packLabelsOnTop(PieSliceObj[] pieSliceObjArray) {
        if (pieSliceObjArray == null) {
            return;
        }
        int n = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int n2 = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        boolean bl = false;
        int n3 = n;
        int n4 = 0;
        while (n4 < pieSliceObjArray.length) {
            if (n3 - this.m_sliceLabelGap < this.m_nYCenter) {
                int n5 = pieSliceObjArray[n4].m_ptFeelerJoint.y - pieSliceObjArray[n4].m_LabelRect.height / 2;
                int n6 = n3 - this.m_sliceLabelGap - pieSliceObjArray[n4].m_LabelRect.height;
                if (n5 < n6) {
                    int n7 = 0;
                    int n8 = n4 + 1;
                    while (n8 < pieSliceObjArray.length) {
                        n7 += pieSliceObjArray[n8].m_LabelRect.height + this.m_sliceLabelGap;
                        if (n8 == pieSliceObjArray.length - 1) {
                            n7 += this.m_sliceLabelGap;
                        }
                        ++n8;
                    }
                    n8 = n5 - n2;
                    pieSliceObjArray[n4].m_LabelRect.y = n8 >= n7 ? n5 : n2 + n7;
                } else {
                    pieSliceObjArray[n4].m_LabelRect.y = n6;
                }
            } else {
                pieSliceObjArray[n4].m_LabelRect.y = n3 - this.m_sliceLabelGap - pieSliceObjArray[n4].m_LabelRect.height;
            }
            n3 = pieSliceObjArray[n4].m_LabelRect.y;
            ++n4;
        }
    }

    protected void repositionSliceLabels(PieSliceObj[] pieSliceObjArray, int n) {
        int n2 = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int n3 = this.m_nYCenter;
        int n4 = n2 - n3;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < pieSliceObjArray.length) {
            if (pieSliceObjArray[n7].m_nSliceSide == 0 && pieSliceObjArray[n7].m_fAngleAvg <= 0.75 || pieSliceObjArray[n7].m_nSliceSide == 1 && pieSliceObjArray[n7].m_fAngleAvg >= 0.25) {
                n6 += pieSliceObjArray[n7].m_LabelRect.height + this.m_sliceLabelGap;
            } else if (pieSliceObjArray[n7].m_nSliceSide == 0 && pieSliceObjArray[n7].m_fAngleAvg > 0.75 || pieSliceObjArray[n7].m_nSliceSide == 1 && pieSliceObjArray[n7].m_fAngleAvg < 0.25) {
                n5 += pieSliceObjArray[n7].m_LabelRect.height + this.m_sliceLabelGap;
            }
            ++n7;
        }
        n5 += this.m_sliceLabelGap / 2;
        if ((n6 += this.m_sliceLabelGap / 2) > n4) {
            this.packLabelsOnBottom(pieSliceObjArray);
        } else if (n5 > n4) {
            this.packLabelsOnTop(pieSliceObjArray);
        } else if (n == 1) {
            this.repositionSliceLabelsTop(pieSliceObjArray);
            this.repositionSliceLabelsBottom(pieSliceObjArray);
        } else if (n == 2) {
            this.repositionSliceLabelsTop(pieSliceObjArray);
        } else {
            this.repositionSliceLabelsBottom(pieSliceObjArray);
        }
    }

    protected void repositionSliceLabelsTop(PieSliceObj[] pieSliceObjArray) {
        if (pieSliceObjArray == null) {
            return;
        }
        int n = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int n2 = 0;
        int n3 = 0;
        while (n3 < pieSliceObjArray.length) {
            if (pieSliceObjArray[n3].m_nSliceSide == 0 && pieSliceObjArray[n3].m_fAngleAvg <= 0.75 || pieSliceObjArray[n3].m_nSliceSide == 1 && pieSliceObjArray[n3].m_fAngleAvg >= 0.25) break;
            ++n2;
            ++n3;
        }
        n3 = this.m_nYCenter;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            int n5 = 0;
            int n6 = pieSliceObjArray[n4].m_ptFeelerJoint.y - pieSliceObjArray[n4].m_LabelRect.height / 2;
            n5 = n4 == n2 - 1 ? n3 + this.m_sliceLabelGap / 2 : n3 + this.m_sliceLabelGap;
            if (n6 > n5 && n6 - this.m_sliceLabelGap / 2 >= this.m_nYCenter) {
                int n7 = 0;
                int n8 = 0;
                while (n8 <= n4) {
                    n7 += pieSliceObjArray[n8].m_LabelRect.height + this.m_sliceLabelGap;
                    ++n8;
                }
                n8 = n - n6;
                pieSliceObjArray[n4].m_LabelRect.y = n8 >= n7 ? n6 : n - n7;
            } else {
                pieSliceObjArray[n4].m_LabelRect.y = n5;
            }
            n3 = pieSliceObjArray[n4].m_LabelRect.y + pieSliceObjArray[n4].m_LabelRect.height;
            --n4;
        }
    }

    protected void repositionSliceLabelsBottom(PieSliceObj[] pieSliceObjArray) {
        int n;
        if (pieSliceObjArray == null) {
            return;
        }
        int n2 = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        int n3 = 0;
        int n4 = pieSliceObjArray.length - 1;
        while (n4 >= 0) {
            if (pieSliceObjArray[n4].m_nSliceSide == 0 && pieSliceObjArray[n4].m_fAngleAvg > 0.75 || pieSliceObjArray[n4].m_nSliceSide == 1 && pieSliceObjArray[n4].m_fAngleAvg < 0.25) break;
            ++n3;
            --n4;
        }
        n4 = this.m_nYCenter;
        int n5 = n = pieSliceObjArray.length - n3;
        while (n5 < pieSliceObjArray.length) {
            int n6 = 0;
            int n7 = pieSliceObjArray[n5].m_ptFeelerJoint.y - pieSliceObjArray[n5].m_LabelRect.height / 2;
            n6 = n5 == n ? n4 - this.m_sliceLabelGap / 2 - pieSliceObjArray[n5].m_LabelRect.height : n4 - this.m_sliceLabelGap - pieSliceObjArray[n5].m_LabelRect.height;
            if (n7 < n6 && n7 + pieSliceObjArray[n5].m_LabelRect.height + this.m_sliceLabelGap / 2 <= this.m_nYCenter) {
                int n8 = 0;
                int n9 = n5 + 1;
                while (n9 < pieSliceObjArray.length) {
                    n8 += pieSliceObjArray[n9].m_LabelRect.height + this.m_sliceLabelGap;
                    if (n9 == pieSliceObjArray.length - 1) {
                        n8 += this.m_sliceLabelGap;
                    }
                    ++n9;
                }
                n9 = n7 - n2;
                pieSliceObjArray[n5].m_LabelRect.y = n9 >= n8 ? n7 : n2 + n8;
            } else {
                pieSliceObjArray[n5].m_LabelRect.y = n6;
            }
            n4 = pieSliceObjArray[n5].m_LabelRect.y;
            ++n5;
        }
    }

    protected int checkForCollisions(PieSliceObj[] pieSliceObjArray) {
        if (pieSliceObjArray == null) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int n3 = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        if (pieSliceObjArray[0].m_LabelRect.y + pieSliceObjArray[0].m_LabelRect.height > n2) {
            bl = true;
        }
        if (pieSliceObjArray[pieSliceObjArray.length - 1].m_LabelRect.y < n3) {
            bl2 = true;
        }
        if (pieSliceObjArray.length == 1) {
            n = bl && bl2 ? 1 : (bl ? 2 : (bl2 ? 3 : 0));
            return n;
        }
        boolean bl3 = true;
        if (pieSliceObjArray[0].m_nSliceSide == 1) {
            bl3 = false;
        }
        int n4 = 0;
        while (n4 < pieSliceObjArray.length - 1) {
            PieSliceObj pieSliceObj = pieSliceObjArray[n4];
            PieSliceObj pieSliceObj2 = pieSliceObjArray[n4 + 1];
            Rectangle rectangle = pieSliceObj.m_LabelRect;
            Rectangle rectangle2 = pieSliceObj2.m_LabelRect;
            if (rectangle.y < rectangle2.y + rectangle2.height + this.m_sliceLabelGap) {
                if (bl3) {
                    if (pieSliceObj.m_fAngleAvg > 0.75 && pieSliceObj2.m_fAngleAvg > 0.75) {
                        bl = true;
                    } else if (pieSliceObj.m_fAngleAvg <= 0.75 && pieSliceObj2.m_fAngleAvg <= 0.75) {
                        bl2 = true;
                    } else {
                        bl = true;
                        bl2 = true;
                    }
                } else if (pieSliceObj.m_fAngleAvg < 0.25 && pieSliceObj2.m_fAngleAvg < 0.25) {
                    bl = true;
                } else if (pieSliceObj.m_fAngleAvg >= 0.25 && pieSliceObj2.m_fAngleAvg >= 0.25) {
                    bl2 = true;
                } else {
                    bl = true;
                    bl2 = true;
                }
            }
            ++n4;
        }
        n = bl && bl2 ? 1 : (bl ? 2 : (bl2 ? 3 : 0));
        return n;
    }

    protected void calcNormalSliceLabelRects(PieSliceObj[] pieSliceObjArray, int n) {
        if (pieSliceObjArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < pieSliceObjArray.length) {
            PieSliceObj pieSliceObj = pieSliceObjArray[n2];
            int n3 = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - n;
            if (pieSliceObj.m_nSliceSide == 1) {
                n3 = this.m_rightMostPointOfPie + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
            }
            pieSliceObj.m_LabelRect = new Rectangle(n3, pieSliceObj.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, n, this.m_labelDimVC.height);
            ++n2;
        }
        n2 = this.checkForCollisions(pieSliceObjArray);
        if (n2 != 0) {
            this.repositionSliceLabels(pieSliceObjArray, n2);
        }
    }

    protected boolean calcCircularSliceLabelRects(PieSliceObj[] pieSliceObjArray, PieSliceObj[] pieSliceObjArray2) {
        int n;
        PieSliceObj pieSliceObj;
        if (pieSliceObjArray == null || pieSliceObjArray2 == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < pieSliceObjArray.length) {
            pieSliceObj = pieSliceObjArray[n2];
            pieSliceObj.m_LabelRect = new Rectangle(this.m_sliceLabelLeftEdge, pieSliceObj.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, pieSliceObj.m_ptFeelerJoint.x - this.m_sliceLabelLeftEdge - this.m_pivotLineVirt - this.m_feelerTextGapVirt, this.m_labelDimVC.height);
            ++n2;
        }
        n2 = 0;
        while (n2 < pieSliceObjArray2.length) {
            pieSliceObj = pieSliceObjArray2[n2];
            n = pieSliceObj.m_ptFeelerJoint.x + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
            pieSliceObj.m_LabelRect = new Rectangle(n, pieSliceObj.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_sliceLabelRightEdge - n, this.m_labelDimVC.height);
            ++n2;
        }
        if (this.checkForCollisions(pieSliceObjArray) != 0 || this.checkForCollisions(pieSliceObjArray2) != 0) {
            return false;
        }
        n2 = 0;
        int n3 = 0;
        while (n3 < pieSliceObjArray.length) {
            PieSliceObj pieSliceObj2 = pieSliceObjArray[n3];
            int n4 = this.m_VC.destToVirtWidth(this.m_stringWidths[pieSliceObj2.m_nSliceIdx]);
            if (n4 > pieSliceObj2.m_LabelRect.width) {
                n2 = 1;
            }
            ++n3;
        }
        n3 = 0;
        n = 0;
        while (n < pieSliceObjArray2.length) {
            PieSliceObj pieSliceObj3 = pieSliceObjArray2[n];
            int n5 = this.m_VC.destToVirtWidth(this.m_stringWidths[pieSliceObj3.m_nSliceIdx]);
            if (n5 > pieSliceObj3.m_LabelRect.width) {
                n3 = 1;
            }
            ++n;
        }
        if (n2 == 0 && n3 == 0) {
            return true;
        }
        if (n2 != 0 && n3 != 0) {
            n = this.wrapCircularSliceLabels(pieSliceObjArray) ? 1 : 0;
            if (n == 0) {
                return false;
            }
            return this.wrapCircularSliceLabels(pieSliceObjArray2);
        }
        if (n2 != 0) {
            return this.wrapCircularSliceLabels(pieSliceObjArray);
        }
        return this.wrapCircularSliceLabels(pieSliceObjArray2);
    }

    protected boolean wrapCircularSliceLabels(PieSliceObj[] pieSliceObjArray) {
        Point[] pointArray = this.calcArcPointsForTestPolygon();
        int n = this.m_rPieFrame.y + this.m_rPieFrame.height;
        int n2 = this.m_rPieFrame.y + this.m_nPieLabelHeight;
        int n3 = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
        boolean bl = true;
        int n4 = 0;
        while (n4 < pieSliceObjArray.length) {
            PieSliceObj pieSliceObj = pieSliceObjArray[n4];
            int n5 = this.m_VC.destToVirtWidth(this.m_stringWidths[pieSliceObj.m_nSliceIdx]);
            if (n5 > pieSliceObj.m_LabelRect.width) {
                int n6;
                double d = pieSliceObj.m_fAngleAvg;
                int n7 = 0;
                int n8 = 0;
                n7 = n4 == 0 ? n : pieSliceObjArray[n4 - 1].m_LabelRect.y;
                n8 = n4 == pieSliceObjArray.length - 1 ? n2 : pieSliceObjArray[n4 + 1].m_LabelRect.y + pieSliceObjArray[n4 + 1].m_LabelRect.height;
                if (d > 0.67 && d < 0.83) {
                    n6 = 75;
                } else if (d > 0.17 && d < 0.33) {
                    n6 = 25;
                } else if (d > 0.75 || d == 0.0) {
                    if (d == 0.0) {
                        d = 0.99;
                    }
                    n6 = (int)(d * (double)100) - 5;
                    if (pointArray[n6].y > n8) {
                        n8 = pointArray[n6].y;
                    }
                } else if (d > 0.5) {
                    n6 = (int)(d * (double)100) + 5;
                    if (pointArray[n6].y < n7) {
                        n7 = pointArray[n6].y;
                    }
                } else if (d > 0.25) {
                    n6 = (int)(d * (double)100) - 5;
                    if (pointArray[n6].y < n7) {
                        n7 = pointArray[n6].y;
                    }
                } else {
                    n6 = (int)(d * (double)100) + 5;
                    if (pointArray[n6].y > n8) {
                        n8 = pointArray[n6].y;
                    }
                }
                if ((n7 -= this.m_sliceLabelGap) - (n8 += this.m_sliceLabelGap) < pieSliceObj.m_LabelRect.height * 2) {
                    bl = false;
                    break;
                }
                String string = (String)this.m_vectStrLabels.elementAt(pieSliceObj.m_nSliceIdx);
                int n9 = 0;
                int n10 = 0;
                if (pieSliceObj.m_nSliceSide == 0) {
                    n9 = pieSliceObj.m_LabelRect.x;
                    int n11 = pointArray[n6].x;
                    n10 = pointArray[n6].x - this.m_pivotLineVirt - this.m_feelerTextGapVirt - pieSliceObj.m_LabelRect.x;
                } else {
                    n9 = pointArray[n6].x + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
                    n10 = this.m_sliceLabelRightEdge - n9;
                }
                this.m_textStyleFeelers.setTextTruncate(true, -1, 0);
                this.m_textStyleFeelers.setTextTruncated(false);
                Vector vector = new Vector();
                int n12 = this.m_textStyleFeelers.extractLinesWordWrap(string, vector, this.m_VC.virtToDestWidth(n10), this.getSliceLabelFontMetrics());
                this.m_textStyleFeelers.setWordWrap(true);
                if (this.m_textStyleFeelers.isTextTruncated()) {
                    bl = false;
                    break;
                }
                int n13 = n3 * n12;
                if (n13 > n7 - n8) {
                    bl = false;
                    break;
                }
                int n14 = 0;
                n14 = pieSliceObj.m_ptFeelerJoint.y + n13 / 2 <= n7 && pieSliceObj.m_ptFeelerJoint.y - n13 / 2 >= n8 ? pieSliceObj.m_ptFeelerJoint.y - n13 / 2 : (pieSliceObj.m_ptFeelerJoint.y + n13 / 2 <= n7 ? n8 : n7 - n13);
                pieSliceObj.m_LabelRect = new Rectangle(n9, n14, n10, n13);
            }
            ++n4;
        }
        if (!bl) {
            this.m_textStyleFeelers.setWordWrap(false);
            this.m_textStyleFeelers.setTextTruncate(false, -1, 0);
            return false;
        }
        return true;
    }

    protected void calcWrappedSliceLabelRects(PieSliceObj[] pieSliceObjArray) {
        int n;
        int n2;
        if (pieSliceObjArray == null) {
            return;
        }
        int n3 = this.m_sliceLabelLeftEdge;
        int n4 = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - n3;
        FontMetrics fontMetrics = this.getSliceLabelFontMetrics();
        int n5 = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
        int n6 = 0;
        PieSliceObj pieSliceObj = pieSliceObjArray[0];
        if (pieSliceObj.m_nSliceSide == 1) {
            n6 = this.m_rightSliceLabels.size();
            n3 = this.m_sliceLabelRightEdge - n4;
        } else {
            n6 = this.m_leftSliceLabels.size();
        }
        int n7 = this.m_VC.virtToDestHeight(this.m_rPieFrame.height - this.m_nPieLabelHeight);
        double d = (double)n7 / (double)this.m_sliceLabelFontHeight;
        int n8 = (int)(Math.floor(d - (double)(n6 + 1) * 0.5) / (double)n6);
        int n9 = (int)(Math.floor(d - (double)(n6 + 1) * 0.5) % (double)n6);
        int n10 = 0;
        int n11 = 0;
        while (n11 < pieSliceObjArray.length) {
            pieSliceObj = pieSliceObjArray[n11];
            if (pieSliceObj.m_fAngleAvg > 0.75 || pieSliceObj.m_fAngleAvg < 0.25) {
                ++n10;
            }
            ++n11;
        }
        int n12 = n11 = n10 > pieSliceObjArray.length - n10 ? 1 : 0;
        if (n11 != 0) {
            PieSliceObj[] pieSliceObjArray2 = new PieSliceObj[pieSliceObjArray.length];
            n2 = 0;
            n = pieSliceObjArray.length - 1;
            while (n >= 0) {
                pieSliceObjArray2[n2] = pieSliceObjArray[n];
                ++n2;
                --n;
            }
            pieSliceObjArray = pieSliceObjArray2;
        }
        int n13 = 0;
        while (n13 < pieSliceObjArray.length) {
            int n14;
            pieSliceObj = pieSliceObjArray[n13];
            n2 = this.m_VC.destToVirtWidth(this.m_stringWidths[pieSliceObj.m_nSliceIdx]);
            n = 0;
            int n15 = 0;
            if (n2 <= n4) {
                n15 = 1;
                n9 += n8 - n15;
            } else {
                n14 = this.m_stringWidths[pieSliceObj.m_nSliceIdx];
                String string = (String)this.m_vectStrLabels.elementAt(pieSliceObj.m_nSliceIdx);
                if (n9 > 0) {
                    --n9;
                    n = n8 + 1;
                } else {
                    n = n8;
                }
                this.m_textStyleFeelers.setTextTruncate(true, n, 0);
                this.m_textStyleFeelers.setTextTruncated(false);
                this.m_textStyleFeelers.setWordWrap(true);
                Vector vector = new Vector();
                n15 = this.m_textStyleFeelers.extractLinesWordWrap(string, vector, this.m_VC.virtToDestWidth(n4), fontMetrics);
                if (n15 < n) {
                    n9 += n - n15;
                }
                if (this.m_textStyleFeelers.isTextTruncated()) {
                    this.m_sliceLabelTruncated = true;
                    this.m_fullSliceLabels[pieSliceObj.m_nSliceIdx] = string;
                    string = "";
                    int n16 = 0;
                    while (n16 < vector.size()) {
                        string = String.valueOf(string) + (String)vector.elementAt(n16);
                        if (n16 < vector.size() - 1) {
                            string = String.valueOf(string) + ' ';
                        }
                        ++n16;
                    }
                    this.m_vectStrLabels.setElementAt(string, pieSliceObj.m_nSliceIdx);
                }
            }
            n14 = n5 * n15;
            pieSliceObj.m_LabelRect = new Rectangle(n3, pieSliceObj.m_ptFeelerJoint.y - n14 / 2, n4, n14);
            ++n13;
        }
        if (n11 != 0) {
            PieSliceObj[] pieSliceObjArray3 = new PieSliceObj[pieSliceObjArray.length];
            n2 = 0;
            n = pieSliceObjArray.length - 1;
            while (n >= 0) {
                pieSliceObjArray3[n2] = pieSliceObjArray[n];
                ++n2;
                --n;
            }
            pieSliceObjArray = pieSliceObjArray3;
        }
        this.m_textStyleFeelers.setTextTruncate(false, -1, 0);
        int n17 = this.checkForCollisions(pieSliceObjArray);
        if (n17 != 0) {
            this.repositionSliceLabels(pieSliceObjArray, n17);
        }
    }

    protected void calcOutOfPlotAreaSliceLabels(PieSliceObj[] pieSliceObjArray) {
        int n;
        if (pieSliceObjArray == null) {
            return;
        }
        FontMetrics fontMetrics = this.getSliceLabelFontMetrics();
        int n2 = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
        int n3 = pieSliceObjArray.length / 2;
        int n4 = this.m_sliceLabelLeftEdge;
        int n5 = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - n4;
        if (n5 < 100) {
            n5 = 100;
        }
        if (pieSliceObjArray[0].m_nSliceSide == 1) {
            n4 = this.m_rightMostPointOfPie + this.m_pivotLineVirt + this.m_feelerTextGapVirt;
        }
        int n6 = n = this.m_nYCenter - this.m_labelDimVC.height / 2;
        int n7 = n3;
        while (n7 < pieSliceObjArray.length) {
            pieSliceObjArray[n7].m_LabelRect = new Rectangle(n4, n6, n5, this.m_labelDimVC.height);
            n6 -= this.m_labelDimVC.height + this.m_sliceLabelGap;
            this.truncateLabelAsNeeded(pieSliceObjArray[n7], n5, fontMetrics);
            ++n7;
        }
        n6 = n + (this.m_labelDimVC.height + this.m_sliceLabelGap);
        n7 = n3 - 1;
        while (n7 >= 0) {
            pieSliceObjArray[n7].m_LabelRect = new Rectangle(n4, n6, n5, this.m_labelDimVC.height);
            n6 += this.m_labelDimVC.height + this.m_sliceLabelGap;
            this.truncateLabelAsNeeded(pieSliceObjArray[n7], n5, fontMetrics);
            --n7;
        }
    }

    protected void truncateLabelAsNeeded(PieSliceObj pieSliceObj, int n, FontMetrics fontMetrics) {
        if (this.m_stringWidths[pieSliceObj.m_nSliceIdx] > this.m_VC.virtToDestWidth(n)) {
            String string;
            this.m_fullSliceLabels[pieSliceObj.m_nSliceIdx] = string = (String)this.m_vectStrLabels.elementAt(pieSliceObj.m_nSliceIdx);
            string = TextStyleObj.truncateText(string, fontMetrics, 0, this.m_VC.virtToDestWidth(n));
            this.m_vectStrLabels.setElementAt(string, pieSliceObj.m_nSliceIdx);
            this.m_sliceLabelTruncated = true;
        }
    }

    protected void drawFeelers(PieSliceObj pieSliceObj, BlackBoxObj blackBoxObj) {
        IdentObj identObj;
        Rectangle rectangle = null;
        rectangle = pieSliceObj.m_LabelRect;
        Point[] pointArray = new Point[4];
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(294, pieSliceObj.m_nSeriesID);
            identObj.setMiscID(pieSliceObj.m_nGroupID);
        } else {
            identObj = new IdentObj(294, pieSliceObj.m_nSeriesID, pieSliceObj.m_nGroupID);
        }
        pointArray[0] = new Point(pieSliceObj.m_ptCenter.x, pieSliceObj.m_ptCenter.y);
        if (pieSliceObj.m_nSliceSide == 0) {
            pointArray[1] = new Point(pieSliceObj.m_ptFeelerJoint.x, rectangle.y + rectangle.height / 2);
            pointArray[2] = new Point(rectangle.x + rectangle.width + this.m_feelerTextGapVirt, rectangle.y + rectangle.height / 2);
        } else {
            pointArray[1] = new Point(pieSliceObj.m_ptFeelerJoint.x, rectangle.y + rectangle.height / 2);
            pointArray[2] = new Point(rectangle.x - this.m_feelerTextGapVirt, rectangle.y + rectangle.height / 2);
        }
        IdentObj identObj2 = new IdentObj(identObj);
        identObj2.setMiscID(100);
        pieSliceObj.setRadialLine(new DetLine(this.m_Detectiv, identObj2, pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y, blackBoxObj, null, this.m_nLineWidthFeeler));
        identObj2 = new IdentObj(identObj);
        identObj2.setMiscID(200);
        pieSliceObj.setPivotLine(new DetLine(this.m_Detectiv, identObj2, pointArray[1].x, pointArray[1].y, pointArray[2].x, pointArray[2].y, blackBoxObj, null, this.m_nLineWidthFeeler));
    }

    protected void drawAllSliceLabels() {
        if (this.m_nPieFeelerTextDisplay == 1) {
            int n;
            int n2;
            PieSliceObj[] pieSliceObjArray;
            Vector<PieSliceObj> vector = new Vector<PieSliceObj>();
            Vector<PieSliceObj> vector2 = new Vector<PieSliceObj>();
            PieSliceObj pieSliceObj = null;
            int n3 = 0;
            while (n3 < this.m_nSliceCount) {
                if (!this.m_slices[n3].m_bSliceDeleted && !this.m_slices[n3].m_bSliceSplit) {
                    if (this.m_slices[n3].m_fAngleAvg == 0.0) {
                        pieSliceObj = this.m_slices[n3];
                    } else if (this.m_slices[n3].m_nSliceSide == 0) {
                        if (vector.size() > 0) {
                            pieSliceObjArray = (PieSliceObj)vector.elementAt(vector.size() - 1);
                            if (pieSliceObjArray.m_fAngleAvg > this.m_slices[n3].m_fAngleAvg) {
                                vector.add(this.m_slices[n3]);
                            } else {
                                n2 = 0;
                                while (n2 < vector.size()) {
                                    pieSliceObjArray = (PieSliceObj)vector.elementAt(n2);
                                    if (pieSliceObjArray.m_fAngleAvg < this.m_slices[n3].m_fAngleAvg) {
                                        vector.insertElementAt(this.m_slices[n3], n2);
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                        } else {
                            vector.add(this.m_slices[n3]);
                        }
                    } else if (vector2.size() > 0) {
                        pieSliceObjArray = (PieSliceObj)vector2.elementAt(vector2.size() - 1);
                        if (pieSliceObjArray.m_fAngleAvg < this.m_slices[n3].m_fAngleAvg) {
                            vector2.add(this.m_slices[n3]);
                        } else {
                            n2 = 0;
                            while (n2 < vector2.size()) {
                                pieSliceObjArray = (PieSliceObj)vector2.elementAt(n2);
                                if (pieSliceObjArray.m_fAngleAvg > this.m_slices[n3].m_fAngleAvg) {
                                    vector2.insertElementAt(this.m_slices[n3], n2);
                                    break;
                                }
                                ++n2;
                            }
                        }
                    } else {
                        vector2.add(this.m_slices[n3]);
                    }
                }
                ++n3;
            }
            if (pieSliceObj != null) {
                vector.insertElementAt(pieSliceObj, 0);
            }
            PieSliceObj[] pieSliceObjArray2 = null;
            pieSliceObjArray = null;
            if (vector.size() > 0) {
                pieSliceObjArray2 = new PieSliceObj[vector.size()];
                n2 = 0;
                while (n2 < pieSliceObjArray2.length) {
                    pieSliceObjArray2[n2] = (PieSliceObj)vector.elementAt(n2);
                    ++n2;
                }
            }
            if (vector2.size() > 0) {
                pieSliceObjArray = new PieSliceObj[vector2.size()];
                n2 = 0;
                while (n2 < pieSliceObjArray.length) {
                    pieSliceObjArray[n2] = (PieSliceObj)vector2.elementAt(n2);
                    ++n2;
                }
            }
            n2 = 0;
            boolean bl = false;
            int n4 = this.m_VC.destToVirtHeight(this.m_sliceLabelFontHeight);
            int n5 = this.m_leftSliceLabels.size() * n4 + (this.m_leftSliceLabels.size() + 1) * this.m_sliceLabelGap;
            if (n5 > this.m_rPieFrame.height - this.m_nPieLabelHeight) {
                n2 = 1;
                this.calcOutOfPlotAreaSliceLabels(pieSliceObjArray2);
            }
            if ((n = this.m_rightSliceLabels.size() * n4 + (this.m_rightSliceLabels.size() + 1) * this.m_sliceLabelGap) > this.m_rPieFrame.height - this.m_nPieLabelHeight) {
                bl = true;
                this.calcOutOfPlotAreaSliceLabels(pieSliceObjArray);
            }
            int n6 = this.m_leftMostPointOfPie - this.m_pivotLineVirt - this.m_feelerTextGapVirt - this.m_sliceLabelLeftEdge;
            int n7 = this.m_VC.destToVirtWidth(this.m_maxLabelWidthDest);
            if (bl && n2 == 0) {
                if (n6 >= n7) {
                    this.calcNormalSliceLabelRects(pieSliceObjArray2, n7);
                } else {
                    this.calcWrappedSliceLabelRects(pieSliceObjArray2);
                }
            }
            if (!bl && n2 != 0) {
                if (n6 >= n7) {
                    this.calcNormalSliceLabelRects(pieSliceObjArray, n7);
                } else {
                    this.calcWrappedSliceLabelRects(pieSliceObjArray);
                }
            }
            if (!bl && n2 == 0) {
                if (n6 >= n7) {
                    this.calcNormalSliceLabelRects(pieSliceObjArray2, n7);
                    this.calcNormalSliceLabelRects(pieSliceObjArray, n7);
                } else if (this.m_DetachPresent) {
                    this.calcWrappedSliceLabelRects(pieSliceObjArray2);
                    this.calcWrappedSliceLabelRects(pieSliceObjArray);
                } else {
                    boolean bl2 = this.calcCircularSliceLabelRects(pieSliceObjArray2, pieSliceObjArray);
                    if (!bl2) {
                        this.calcWrappedSliceLabelRects(pieSliceObjArray2);
                        this.calcWrappedSliceLabelRects(pieSliceObjArray);
                    }
                }
            }
        }
        int n = 0;
        while (n < this.m_nSliceCount) {
            if (!this.m_slices[n].m_bSliceDeleted && !this.m_slices[n].m_bSliceSplit && this.m_nPieFeelerTextDisplay > 0) {
                this.drawSliceLabel(this.m_slices[n]);
            }
            ++n;
        }
    }

    PieSliceObj nextSliceOnSide(int n) {
        PieSliceObj pieSliceObj = null;
        int n2 = this.m_slices[n].m_nSliceSide;
        int n3 = n + 1;
        while (n3 < this.m_nSliceCount) {
            if (!this.m_slices[n3].m_bSliceDeleted && !this.m_slices[n3].m_bSliceSplit && this.m_slices[n3].m_nSliceSide == n2) {
                pieSliceObj = this.m_slices[n3];
                break;
            }
            ++n3;
        }
        return pieSliceObj;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawSliceLabel(PieSliceObj var1_1) {
        var3_2 = new Point[4];
        var4_3 = null;
        var9_4 = this.m_Perspective.getGraphicsContext();
        if (this.m_gt.isPieBarType()) {
            var7_5 = new IdentObj(295, var1_1.m_nSeriesID);
            var7_5.setMiscID(var1_1.m_nGroupID);
        } else {
            var7_5 = new IdentObj(295, var1_1.m_nSeriesID, var1_1.m_nGroupID);
        }
        var6_6 = new BlackBoxObj(this.m_Perspective, var7_5);
        var6_6.setTransparentFillColor(true);
        var6_6.setTransparentBorderColor(true);
        var8_7 = new IdentObj(294);
        switch (this.m_nPieFeelerTextDisplay) {
            case 0: {
                return;
            }
            case 1: {
                var2_8 = new BlackBoxObj(this.m_Perspective, var8_7);
                var4_3 = var1_1.m_LabelRect;
                if (var1_1.m_nSliceSide == 0) {
                    this.m_textStyleFeelers.setHorizAlign(2);
                } else {
                    this.m_textStyleFeelers.setHorizAlign(0);
                }
                this.drawFeelers(var1_1, var2_8);
                break;
            }
            case 2: {
                if (var1_1.m_nSliceSide == 0) {
                    var4_3 = new Rectangle(this.m_sliceLabelLeftEdge, var1_1.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, var1_1.m_ptFeelerJoint.x - this.m_sliceLabelLeftEdge - this.m_feelerTextGapVirt, this.m_labelDimVC.height);
                    this.m_textStyleFeelers.setHorizAlign(2);
                } else {
                    var4_3 = new Rectangle(var1_1.m_ptFeelerJoint.x + this.m_feelerTextGapVirt, var1_1.m_ptFeelerJoint.y - this.m_labelDimVC.height / 2, this.m_sliceLabelRightEdge - var1_1.m_ptFeelerJoint.x, this.m_labelDimVC.height);
                    this.m_textStyleFeelers.setHorizAlign(0);
                }
                this.truncateLabelAsNeeded(var1_1, var4_3.width, this.getSliceLabelFontMetrics());
                break;
            }
            default: {
                var10_9 = 0.66;
                var12_10 = this.m_Perspective.getPieSliceLabel();
                var13_11 = this.m_Perspective.getFontSizeAbsolute(var12_10) != false ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(var12_10)) : this.m_Perspective.getFontSizeVC(var12_10);
                var14_12 = 0;
                var15_13 = 0;
                var16_14 = 0;
                var17_15 = 0;
                if (this.m_nSliceCount >= 20) ** GOTO lbl94
                var18_16 = var1_1.m_polyCrust.npoints;
                var19_17 = new Polygon();
                var19_17.addPoint(var1_1.m_ptRingLeft.x, var1_1.m_ptRingLeft.y);
                var20_19 = 0;
                while (var20_19 < var18_16) {
                    var19_17.addPoint(var1_1.m_polyCrust.xpoints[var20_19], var1_1.m_polyCrust.ypoints[var20_19]);
                    ++var20_19;
                }
                var19_17.addPoint(var1_1.m_ptRingRight.x, var1_1.m_ptRingRight.y);
                if (var1_1.m_polyRing != null) {
                    var20_19 = var18_16 - 2;
                    while (var20_19 >= 0) {
                        var19_17.addPoint(var1_1.m_polyRing.xpoints[var20_19], var1_1.m_polyRing.ypoints[var20_19]);
                        --var20_19;
                    }
                }
                if (var1_1.m_polyRing != null) {
                    var16_14 = var1_1.m_polyRing.xpoints[var1_1.m_polyRing.npoints / 2];
                    var17_15 = var1_1.m_polyRing.ypoints[var1_1.m_polyRing.npoints / 2];
                } else {
                    var16_14 = var1_1.m_ptRingRight.x;
                    var17_15 = var1_1.m_ptRingRight.y;
                }
                var20_19 = 0;
                while (var20_19 < 2) {
                    var21_20 = (int)((double)Math.abs(var1_1.m_ptCenter.x - var16_14) * var10_9);
                    var22_21 = (int)((double)Math.abs(var1_1.m_ptCenter.y - var17_15) * var10_9);
                    var14_12 = var1_1.m_ptCenter.x > var16_14 ? var16_14 + var21_20 : var16_14 - var21_20;
                    var15_13 = var1_1.m_ptCenter.y > var17_15 ? var17_15 + var22_21 : var17_15 - var22_21;
                    var23_22 = new Dimension(32000, 32000);
                    var24_23 = new Vector<E>();
                    var24_23.add(this.m_vectStrLabels.elementAt(var1_1.m_nSliceIdx));
                    this.m_textStyleFeelers.formatAndAutofit(var9_4, this.m_Perspective, this.m_Perspective.getAutofit(var12_10), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), var13_11, var24_23, var23_22, this.m_VC);
                    var25_24 = var14_12 - var23_22.width / 2;
                    var26_25 = var15_13 - var23_22.height / 2;
                    var27_26 = var25_24 + var23_22.width;
                    var28_27 = var26_25 + var23_22.height;
                    if (!(var19_17.contains(var25_24, var26_25) && var19_17.contains(var27_26, var26_25) && var19_17.contains(var25_24, var28_27) && var19_17.contains(var27_26, var28_27))) {
                        if (var10_9 == 0.66) {
                            var10_9 = 0.5;
                        } else if (var10_9 == 0.5) {
                            var10_9 = 0.66;
                            var21_20 = (int)((double)Math.abs(var1_1.m_ptCenter.x - var16_14) * var10_9);
                            var22_21 = (int)((double)Math.abs(var1_1.m_ptCenter.y - var17_15) * var10_9);
                            var14_12 = var1_1.m_ptCenter.x > var16_14 ? var16_14 + var21_20 : var16_14 - var21_20;
                            var15_13 = var1_1.m_ptCenter.y > var17_15 ? var17_15 + var22_21 : var17_15 - var22_21;
                        }
                        ++var20_19;
                        continue;
                    }
                    ** GOTO lbl104
                }
                ** GOTO lbl104
lbl94:
                // 1 sources

                if (var1_1.m_polyRing != null) {
                    var16_14 = var1_1.m_polyRing.xpoints[var1_1.m_polyRing.npoints / 2];
                    var17_15 = var1_1.m_polyRing.ypoints[var1_1.m_polyRing.npoints / 2];
                } else {
                    var16_14 = var1_1.m_ptRingRight.x;
                    var17_15 = var1_1.m_ptRingRight.y;
                }
                var18_16 = (int)((double)Math.abs(var1_1.m_ptCenter.x - var16_14) * var10_9);
                var19_18 = (int)((double)Math.abs(var1_1.m_ptCenter.y - var17_15) * var10_9);
                var14_12 = var1_1.m_ptCenter.x > var16_14 ? var16_14 + var18_16 : var16_14 - var18_16;
                var15_13 = var1_1.m_ptCenter.y > var17_15 ? var17_15 + var19_18 : var17_15 - var19_18;
lbl104:
                // 3 sources

                var18_16 = var14_12 - this.m_labelDimVC.width / 2;
                var4_3 = new Rectangle(var18_16, var15_13 - this.m_labelDimVC.height / 2, this.m_labelDimVC.width, this.m_labelDimVC.height);
            }
        }
        if (this.m_gt.isPieBarType()) {
            var19_17 = new IdentObj(388, var1_1.m_nSeriesID);
            var19_17.setMiscID(var1_1.m_nGroupID);
        } else {
            var19_17 = new IdentObj(388, var1_1.m_nSeriesID, var1_1.m_nGroupID);
        }
        var1_1.setLabelBackground(new DetRect(this.m_Detectiv, (IdentObj)var19_17, var4_3.x, var4_3.y, var4_3.width, var4_3.height, var6_6, false, false));
        var5_28 = new BlackBoxObj(this.m_Perspective, var7_5);
        var1_1.setLabel(new DetLabel(this.m_Detectiv, var7_5, (String)this.m_vectStrLabels.elementAt(var1_1.m_nSliceIdx), this.m_fullSliceLabels[var1_1.m_nSliceIdx], var4_3, this.m_textStyleFeelers, var5_28, false));
    }

    protected void drawSliceCrust(PieSliceObj pieSliceObj) {
        IdentObj identObj;
        int n = this.getSliceObjectID(299);
        int n2 = pieSliceObj.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(n, n2);
            identObj.setMiscID(pieSliceObj.m_nGroupID);
        } else {
            identObj = new IdentObj(n, n2, pieSliceObj.m_nGroupID);
        }
        SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(n2, pieSliceObj.m_nGroupID), this.m_bWantRiserBorder);
        Polygon polygon = this.createCrustPoly(pieSliceObj);
        identObj.setMiscID(4000 + pieSliceObj.m_nSliceIdx);
        double d = 0.6;
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, identObj, polygon, (BlackBoxIF)simpleBlackBoxObj, d, false, this.m_area);
        }
    }

    protected void drawSliceLeftEdge(PieSliceObj pieSliceObj) {
        IdentObj identObj;
        if (pieSliceObj.m_nDetatch == 0) {
            return;
        }
        double d = 0.8;
        int n = this.getSliceObjectID(299);
        int n2 = pieSliceObj.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(n, n2);
            identObj.setMiscID(pieSliceObj.m_nGroupID);
        } else {
            identObj = new IdentObj(n, n2, pieSliceObj.m_nGroupID);
        }
        BlackBoxIF blackBoxIF = this.assignSeriesColor(n2, pieSliceObj.m_nGroupID);
        Polygon polygon = this.createLeftPoly(pieSliceObj);
        identObj.setMiscID(2000 + pieSliceObj.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d, false);
        }
    }

    protected void drawSliceRightEdge(PieSliceObj pieSliceObj) {
        IdentObj identObj;
        if (pieSliceObj.m_nDetatch == 0) {
            return;
        }
        double d = 0.4;
        int n = this.getSliceObjectID(299);
        int n2 = pieSliceObj.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(n, n2);
            identObj.setMiscID(pieSliceObj.m_nGroupID);
        } else {
            identObj = new IdentObj(n, n2, pieSliceObj.m_nGroupID);
        }
        BlackBoxIF blackBoxIF = this.assignSeriesColor(n2, pieSliceObj.m_nGroupID);
        Polygon polygon = this.createRightPoly(pieSliceObj);
        identObj.setMiscID(3000 + pieSliceObj.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d, false);
        }
    }

    protected void drawSliceRing(PieSliceObj pieSliceObj) {
        IdentObj identObj;
        if (this.m_fRingPct <= 0.0) {
            return;
        }
        double d = 0.6;
        int n = this.getSliceObjectID(299);
        int n2 = pieSliceObj.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(n, n2);
            identObj.setMiscID(pieSliceObj.m_nGroupID);
        } else {
            identObj = new IdentObj(n, n2, pieSliceObj.m_nGroupID);
        }
        BlackBoxIF blackBoxIF = this.assignSeriesColor(n2, pieSliceObj.m_nGroupID);
        Polygon polygon = this.createRingPoly(pieSliceObj);
        identObj.setMiscID(5000 + pieSliceObj.m_nSliceIdx);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d, false);
        }
    }

    protected void drawSliceTop(PieSliceObj pieSliceObj) {
        IdentObj identObj;
        int n = this.getSliceObjectID(298);
        int n2 = pieSliceObj.m_nSeriesID;
        if (this.m_gt.isPieBarType()) {
            identObj = new IdentObj(n, n2);
            identObj.setMiscID(pieSliceObj.m_nGroupID);
        } else {
            identObj = new IdentObj(n, n2, pieSliceObj.m_nGroupID);
        }
        Polygon polygon = this.createTopPoly(pieSliceObj);
        if (this.m_arc2D != null) {
            Rectangle2D rectangle2D = this.m_arc2D.getBounds2D();
            this.m_smallMarker = rectangle2D != null && (rectangle2D.getHeight() <= (double)10 || rectangle2D.getWidth() <= (double)10);
        }
        BlackBoxIF blackBoxIF = this.assignSeriesColor(n2, pieSliceObj.m_nGroupID);
        identObj.setMiscID(1000);
        if (polygon != null) {
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, 1.0, true, this.m_arc2D);
        }
    }

    public double getGroupTotal(int n) {
        double d = 0.0;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        while (seriesEnumerator.hasMoreElements()) {
            int n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            DatumObj datumObj = this.getDataValue(n2, n);
            double d2 = datumObj.m_fValue;
            if (d2 > 0.0) {
                d += d2;
                this.m_positiveVal = true;
                continue;
            }
            if (d2 == 0.0 && datumObj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(d2 < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return d;
    }

    public double getSeriesTotal(int n) {
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double d = 0.0;
        while (groupsEnumerator.hasMoreElements()) {
            int n2 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
            DatumObj datumObj = this.getDataValue(n, n2);
            double d2 = datumObj.m_fValue;
            if (d2 > 0.0) {
                d += d2;
                this.m_positiveVal = true;
                continue;
            }
            if (d2 == 0.0 && datumObj.m_bOK) {
                this.m_zeroVal = true;
                continue;
            }
            if (!(d2 < 0.0)) continue;
            this.m_negativeVal = true;
        }
        return d;
    }

    public double getSumTotal() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double d = 0.0;
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n2 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                double d2 = this.getDataValue((int)n, (int)n2).m_fValue;
                if (!(d2 > 0.0)) continue;
                d += d2;
            }
        }
        return d;
    }

    private void createSeriesPartOfOther(int n, int n2) {
        this.m_bSeriesPartOfOther = new boolean[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.m_bSeriesPartOfOther[n3][n4] = false;
                ++n4;
            }
            ++n3;
        }
    }

    private void createSeriesDrawn(int n, int n2) {
        this.m_bSeriesDrawn = new boolean[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.m_bSeriesDrawn[n3][n4] = false;
                ++n4;
            }
            ++n3;
        }
    }

    private void setSeriesPartOfOther(int n, int n2, boolean bl) {
        if (this.m_bSeriesPartOfOther != null) {
            this.m_bSeriesPartOfOther[n][n2] = bl;
        }
        if (bl) {
            this.m_bOtherPercentage = true;
        }
    }

    private void setSeriesDrawn(int n, int n2, boolean bl) {
        if (this.m_bSeriesDrawn != null) {
            this.m_bSeriesDrawn[n][n2] = bl;
        }
    }

    protected boolean isSeriesPartOfOther(int n) {
        boolean bl = false;
        if (this.m_Perspective.getOtherSeries() && this.m_bSeriesDrawn != null && this.m_bSeriesPartOfOther != null) {
            int n2 = this.m_Perspective.getGraphType();
            switch (n2) {
                default: {
                    return bl;
                }
                case 55: 
                case 56: 
                case 93: 
                case 94: {
                    bl = this.m_bSeriesPartOfOther[n][0];
                    break;
                }
                case 57: 
                case 58: 
                case 59: 
                case 60: {
                    int n3 = this.getNumSeriesAssignedToOther(n);
                    if (n3 != this.m_nTotalGroups) break;
                    bl = true;
                }
            }
            int n4 = this.getNumSeriesDrawn(n);
            bl = n4 <= 0;
        }
        return bl;
    }

    private int getNumSeriesAssignedToOther(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_nTotalGroups) {
            boolean bl = this.m_bSeriesPartOfOther[n][n3];
            if (bl) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private int getNumSeriesDrawn(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.m_nTotalGroups) {
            boolean bl = this.m_bSeriesDrawn[n][n2];
            if (bl) {
                ++n3;
            }
            ++n2;
        }
        return n3;
    }

    protected boolean getOtherPercentageFlag() {
        return this.m_bOtherPercentage;
    }

    public int getBarThickness() {
        return 0;
    }

    protected double getPieRotation() {
        double d = (double)this.m_Perspective.getPieRotate() / 360.0;
        return d;
    }

    protected int getSliceObjectID(int n) {
        return n;
    }

    protected boolean isPieBarSliceOK() {
        return false;
    }

    protected void calcDrillLabel() {
        this.m_drillLabel = new IdentObj(232);
        this.m_drillLabelBox = new IdentObj(230);
        IdentObj identObj = this.getTitle();
        if (identObj == null) {
            return;
        }
        Dimension dimension = new Dimension(0, 0);
        IdentObj identObj2 = this.getTitleBox();
        String string = this.m_Perspective.getTextString(identObj);
        if (this.m_Perspective.getDisplay(identObj) && string.length() != 0) {
            BlackBoxObj blackBoxObj;
            TextStyleObj textStyleObj = this.getTitleTextStyle();
            int n = this.getTitleFontSizeVC();
            int n2 = this.m_VC.virtToDestHeight(n);
            int n3 = !this.m_Perspective.getFontSizeAbsolute(identObj) ? this.m_VC.virtToDestHeight(this.m_Perspective.getFontSizeVC(identObj)) : this.m_Perspective.getFontSize(identObj);
            int n4 = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(identObj));
            String string2 = this.m_Perspective.getFontName(identObj);
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            Font font = new Font(string2, n4, n3);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            Dimension dimension2 = new Dimension(16000, 16000);
            dimension2 = this.m_VC.virtToDest(dimension2);
            Dimension dimension3 = textStyleObj.getTextSizeDC(graphics, string, n2, this.m_VC, dimension2, null);
            dimension.width = this.m_VC.destToVirtWidth(dimension3.width);
            dimension.height = this.m_VC.destToVirtHeight(dimension3.height);
            Rectangle rectangle = this.m_Perspective.getRect(this.m_Perspective.getPieFrame());
            this.m_drillLabelRect = new Rectangle();
            this.m_drillLabelRect.y = rectangle.y - this.m_VC.destToVirtHeight(10) - dimension.height;
            this.m_drillLabelRect.width = rectangle.width;
            this.m_drillLabelRect.height = dimension.height;
            this.m_drillLabelRect.x = rectangle.x;
            int n5 = this.m_VC.virtToDestWidth(this.m_drillLabelRect.width);
            if (!this.m_Perspective.getTextWrap(identObj) && n5 < fontMetrics.stringWidth(string)) {
                string = TextStyleObj.truncateText(string, fontMetrics, 2, n5);
                this.m_Perspective.setAxisTitleTruncated(true, 0, identObj);
            }
            if (this.m_Perspective.getDisplay(identObj2)) {
                blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj2);
                new DetRect(this.m_Perspective.getDetectiv(), identObj2, this.m_drillLabelRect.x, this.m_drillLabelRect.y, this.m_drillLabelRect.width, this.m_drillLabelRect.height, blackBoxObj, null, false, true, true);
            }
            blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
            new DetLabel(this.m_Perspective.getDetectiv(), identObj, string, this.m_drillLabelRect, textStyleObj, blackBoxObj, this.m_Perspective.getMoveAxisTitles());
        }
    }

    protected TextStyleObj getTitleTextStyle() {
        IdentObj identObj = this.getTitle();
        boolean bl = this.m_Perspective.getAutofit(identObj);
        int n = this.getTitleFontSizeVC();
        boolean bl2 = this.m_Perspective.getFontSizeAbsolute(identObj);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl2, this.m_Perspective.getFontSize(identObj), n, 0, this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), bl, false, this.m_Perspective.getTextWrap(identObj));
        textStyleObj.setDisplayDrillIcon(true);
        int n2 = this.m_VC.virtToDestHeight(n);
        if (n2 < 18 && TextStyleObj.SMALL_DRILL_IMAGE == null) {
            TextStyleObj.SMALL_DRILL_IMAGE = TextStyleObj.getImageResource(Class.forName("oracle.dss.graph.pfj.draw.TextStyleObj"), "images/graph_drill_up.gif");
        } else if (n2 >= 18 && TextStyleObj.LARGE_DRILL_IMAGE == null) {
            TextStyleObj.LARGE_DRILL_IMAGE = TextStyleObj.getImageResource(Class.forName("oracle.dss.graph.pfj.draw.TextStyleObj"), "images/large_drill_up.gif");
        }
        return textStyleObj;
    }

    protected int getTitleFontSizeVC() {
        IdentObj identObj = this.getTitle();
        boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
        int n = bl ? this.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
        return n;
    }

    protected IdentObj getTitle() {
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_drillLabel) != null && this.m_Perspective.getDisplay(this.m_drillLabel)) {
            return this.m_drillLabel;
        }
        return null;
    }

    protected IdentObj getTitleBox() {
        if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(this.m_drillLabel) != null && this.m_Perspective.getDisplay(this.m_drillLabel)) {
            return this.m_drillLabelBox;
        }
        return null;
    }
}

