/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Font;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.FontCacheElement;
import oracle.dss.graph.pfj.Perspective;

public class FontCache {
    static final CategoryIF LOG = Perspective.getInstance("UTIL.FontCache");
    static final int NUM_FONTS = 50;
    static final int NOT_FOUND = -1;
    protected FontCacheElement[] m_fontStuffArray = new FontCacheElement[50];
    protected int m_nCount = 0;

    public void addToCache(String string, int n, int n2, Font font) {
        FontCacheElement fontCacheElement = new FontCacheElement(string, n, n2, font, this.m_nCount);
        int n3 = this.m_nCount;
        int n4 = 49;
        int n5 = 0;
        while (n5 < 50) {
            if (this.m_fontStuffArray[n5] == null) {
                this.m_fontStuffArray[n5] = fontCacheElement;
                return;
            }
            if (this.m_fontStuffArray[n5].m_nCount < n3) {
                n3 = this.m_fontStuffArray[n5].m_nCount;
                n4 = n5;
            }
            ++n5;
        }
        this.m_fontStuffArray[n4] = fontCacheElement;
    }

    public int cachePosition(String string, int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        while (n4 < 50) {
            FontCacheElement fontCacheElement = this.m_fontStuffArray[n4];
            if (fontCacheElement == null) break;
            if (fontCacheElement.m_fontSize == n2 && fontCacheElement.m_fontStyle == n && fontCacheElement.m_fontName.equals(string)) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        return n3;
    }

    public Font getFont(String string, int n, int n2) {
        Font font;
        int n3 = this.cachePosition(string, n, n2);
        if (this.m_nCount == Integer.MAX_VALUE) {
            int n4 = 0;
            while (n4 < 50) {
                if (this.m_fontStuffArray[n4] != null && this.m_fontStuffArray[n4].m_nCount > 0) {
                    this.m_fontStuffArray[n4].m_nCount -= Integer.MAX_VALUE;
                }
                ++n4;
            }
            this.m_nCount = 1;
        } else {
            ++this.m_nCount;
        }
        if (n3 == -1) {
            font = new Font(string, n, n2);
            this.addToCache(string, n, n2, font);
        } else {
            font = this.m_fontStuffArray[n3].m_font;
            this.m_fontStuffArray[n3].m_nCount = this.m_nCount;
        }
        return font;
    }

    public void dump() {
        LOG.info("");
        LOG.info("FontCache dump");
        int n = 0;
        while (n < 50) {
            FontCacheElement fontCacheElement = this.m_fontStuffArray[n];
            if (fontCacheElement != null) {
                LOG.info(String.valueOf(String.valueOf("  i = ")) + n + " LRU = " + fontCacheElement.m_nCount + " font = " + fontCacheElement.m_fontName + " size = " + fontCacheElement.m_fontSize + " style = " + fontCacheElement.m_fontStyle);
            }
            ++n;
        }
    }
}

