/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ParetoMarker
extends BaseGraphComponent
implements UIFillColor {
    public static final int ATTR_COLOR = 0;
    public static final int ATTR_MARKERSHAPE = 1;
    protected static final int ATTR_STYLE_MAXID = 2;
    protected int color;
    protected int markerShape;

    public ParetoMarker(Graph graph) {
        super(graph);
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.color = GraphDefaultValues.getParetoLineColor();
        this.markerShape = GraphDefaultValues.getParetoMarkerShape();
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor(Color color)");
            return;
        }
        this.m_pfj.setFillColor(this.m_pfj.getParetoLineRiser(), color);
        this.m_pfj.setFillColor(this.m_pfj.getParetoLineMarker(), color);
        this.setPropertyOverrideFlags(0);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getParetoLineRiser());
    }

    public void setMarkerShape(int n) {
        if (n < 0 || n > 6) {
            this.m_graph.getErrorHandler().log("invalid marker shape", this.getClass().getName(), "setMarkerShape (int shape)");
        } else {
            this.m_pfj.setMarkerShape(this.m_pfj.getParetoLineMarker(), n);
            this.setPropertyOverrideFlags(1);
        }
    }

    public int getMarkerShape() {
        return this.m_pfj.getMarkerShape(this.m_pfj.getParetoLineMarker());
    }

    protected String getComponentName() {
        return "ParetoMarker";
    }

    protected int getStylePropertyCount() {
        return 2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty("fillColor");
        if (propertyNode != null) {
            this.setFillColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty("markerShape")) != null) {
            this.setMarkerShape(this.m_graph.getSeries().convertMarkerShapeToInt(propertyNode.getValueAsString()));
        }
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("fillColor", BaseGraphComponent.toHexString(this.getFillColor().getRGB()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("markerShape", this.m_graph.getSeries().convertMarkerShapeToString(this.getMarkerShape()));
            bl2 = true;
        }
        return bl2;
    }

    protected void resetStyle() {
        this.setFillColor(new Color(this.color));
        this.setMarkerShape(this.markerShape);
        super.resetStyle();
    }
}

