/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIParetoLine;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ParetoLine
extends BaseGraphComponent
implements UIParetoLine {
    public static final int ATTR_COLOR = 0;
    public static final int ATTR_WIDTH = 1;
    public static final int ATTR_STYLE = 2;
    protected static final int ATTR_STYLE_MAXID = 3;
    protected int color;
    protected int markerShape;
    protected int width;
    protected int style;

    public ParetoLine(Graph graph) {
        super(graph);
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.color = GraphDefaultValues.getParetoLineColor();
        this.width = GraphDefaultValues.getParetoLineWidth();
        this.style = GraphDefaultValues.getParetoLineStyle();
    }

    public void setColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setColor(Color color)");
            return;
        }
        this.m_pfj.setFillColor(this.m_pfj.getParetoLineRiser(), color);
        this.m_pfj.setFillColor(this.m_pfj.getParetoLineMarker(), color);
        this.setPropertyOverrideFlags(0);
    }

    public Color getColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getParetoLineRiser());
    }

    public void setWidth(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid width", this.getClass().getName(), "setWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_pfj.getParetoLineRiser(), n);
            this.setPropertyOverrideFlags(1);
        }
    }

    public int getWidth() {
        return this.m_pfj.getLineWidth(this.m_pfj.getParetoLineRiser());
    }

    public void setLineStyle(int n) {
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setStyle (int style)");
        } else {
            this.m_pfj.setLineStyle(this.m_pfj.getParetoLineRiser(), n);
            this.setPropertyOverrideFlags(2);
        }
    }

    public int getLineStyle() {
        return this.m_pfj.getLineStyle(this.m_pfj.getParetoLineRiser());
    }

    public void setMarkerShape(int n) {
        this.m_graph.getParetoMarker().setMarkerShape(n);
    }

    public int getMarkerShape() {
        return this.m_graph.getParetoMarker().getMarkerShape();
    }

    protected String getComponentName() {
        return "ParetoLine";
    }

    protected int getStylePropertyCount() {
        return 3;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty("color");
        if (propertyNode != null) {
            this.setColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty("width")) != null) {
            this.setWidth(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("lineStyle")) != null) {
            this.setLineStyle(this.convertLineStyleToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("markerShape")) != null) {
            this.setMarkerShape(this.m_graph.getSeries().convertMarkerShapeToInt(propertyNode.getValueAsString()));
        }
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("color", BaseGraphComponent.toHexString(this.getColor().getRGB()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("width", this.getWidth());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("lineStyle", this.convertLineStyleToString(this.getLineStyle()));
            bl2 = true;
        }
        return bl2;
    }

    protected void resetStyle() {
        this.setColor(new Color(this.color));
        this.setWidth(this.width);
        this.setMarkerShape(this.markerShape);
        this.setLineStyle(this.style);
        super.resetStyle();
    }
}

