/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseMajorTick;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class O1MajorTick
extends BaseMajorTick {
    protected static final int ATTR_SKIPPEDWITHLABELS = 5;
    protected static final int ATTR_STYLE_MAXID = 6;
    protected boolean skippedWithLabels;

    public O1MajorTick(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO1MajorGrid();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.visible = GraphDefaultValues.isO1MajorTickVisible();
        this.skippedWithLabels = GraphDefaultValues.isO1MajorTickSkippedWithLabels();
        this.lineColor = GraphDefaultValues.getO1MajorTickLineColor();
        this.lineWidth = GraphDefaultValues.getO1MajorTickLineWidth();
        this.tickStyle = GraphDefaultValues.getO1MajorTickStyle();
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getTickStyle() {
        return this.m_pfj.getO1MajorGridStyle();
    }

    public void setTickStyle(int n) {
        if (n < 0 || n > 4) {
            this.m_graph.getErrorHandler().log("invalid style", "oracle.dss.graph.O1MajorTick", "setTickStyle(int style)");
        } else {
            this.m_pfj.setO1MajorGridStyle(n);
            this.setPropertyOverrideFlags(4);
        }
    }

    public void setSkippedWithLabels(boolean bl) {
        this.m_pfj.setIgnoreGridSkip(!bl);
        this.setPropertyOverrideFlags(5);
    }

    public boolean isSkippedWithLabels() {
        return !this.m_pfj.getIgnoreGridSkip();
    }

    public boolean isVisible() {
        return this.m_pfj.getO1MajorGridDisplay();
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setO1MajorGridDisplay(bl);
        this.setPropertyOverrideFlags(2);
    }

    protected String getComponentName() {
        return "O1MajorTick";
    }

    protected int getStylePropertyCount() {
        return 6;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(5)) {
            objectNode.addProperty("skippedWithLabels", this.isSkippedWithLabels());
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("skippedWithLabels");
        if (propertyNode != null) {
            this.setSkippedWithLabels(propertyNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.setSkippedWithLabels(this.skippedWithLabels);
        super.resetStyle();
    }
}

