/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIMarkerText;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class MarkerText
extends BaseText
implements UIMarkerText,
ViewFormatCallback {
    protected static final int ATTR_VISIBLE = 1;
    protected static final int ATTR_MARKERTEXTPLACE = 2;
    protected static final int ATTR_MARKERTEXTANGLEDEFAULT = 3;
    protected static final int ATTR_MARKERTEXTRADIUSDEFAULT = 4;
    protected static final int ATTR_STYLE_MAXID = 5;
    protected boolean visible;
    protected int markerTextPlace;
    protected int markerTextAngleDefault;
    protected int markerTextRadiusDefault;
    protected static final String ViewFormat_Name = "ViewFormat";
    protected static final String X1ViewFormat_Name = "X1ViewFormat";
    protected static final String Y1ViewFormat_Name = "Y1ViewFormat";
    protected static final String Y2ViewFormat_Name = "Y2ViewFormat";
    protected static final String ZViewFormat_Name = "ZViewFormat";
    protected static final String StockVolumeViewFormat_Name = "StockVolumeViewFormat";
    protected ViewFormat m_viewFormatX1;
    protected ViewFormat m_viewFormatY1;
    protected ViewFormat m_viewFormatY2;
    protected ViewFormat m_viewFormatZ;
    protected ViewFormat m_viewFormatStockVolume;
    private static final String m_method_setViewFormat = "setViewFormat(ViewFormat viewFormat)";

    public MarkerText(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getDataText();
        this.init();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.visible = GraphDefaultValues.isMarkerVisible();
        this.markerTextPlace = GraphDefaultValues.getMarkerTextPlace();
        this.fontTypeface = GraphDefaultValues.getMarkerFontTypeface();
        this.fontColor = GraphDefaultValues.getMarkerFontColor();
        this.fontStyle = GraphDefaultValues.getMarkerFontStyle();
        this.fontSize = GraphDefaultValues.getMarkerFontSize();
        this.graphProportionalFontSize = GraphDefaultValues.getMarkerGraphProportionalFontSize();
        this.markerTextAngleDefault = GraphDefaultValues.getMarkerTextAngleDefault();
        this.markerTextRadiusDefault = GraphDefaultValues.getMarkerTextRadiusDefault();
    }

    public void resetToDefault() {
        this.init();
    }

    public boolean selectObject(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            identObj.setSeriesID(n);
            identObj.setGroupID(n2);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    public int getMarkerTextAngleDefault() {
        return this.m_pfj.getDataTextAngleDefault();
    }

    public void setMarkerTextAngleDefault(int n) {
        if (n < 0 || n > 360) {
            this.m_graph.getErrorHandler().log("invalid value for MarkerTextAngleDefault", this.getClass().getName(), "setMarkerTextAngleDefault(int angle)");
        } else {
            this.m_pfj.setDataTextAngleDefault(n);
            this.setPropertyOverrideFlags(3);
        }
    }

    public int getMarkerTextPlace() {
        return this.m_pfj.getDataTextPosition();
    }

    public void setMarkerTextPlace(int n) {
        if (n < 0 || n > 5) {
            this.m_graph.getErrorHandler().log("invalid placement", "oracle.dss.graph.MarkerText", "setMarkerTextPlace(int place)");
        } else {
            this.m_pfj.setDataTextPosition(n);
            this.setPropertyOverrideFlags(2);
        }
    }

    public int getMarkerTextRadiusDefault() {
        return this.m_pfj.getDataTextRadiusDefault();
    }

    public void setMarkerTextRadiusDefault(int n) {
        if (n < 0 || n > 100) {
            this.m_graph.getErrorHandler().log("invalid value for MarkerTextRadiusDefault", this.getClass().getName(), "setMarkerTextRadiusDefault(int dist)");
        } else {
            this.m_pfj.setDataTextRadiusDefault(n);
            this.setPropertyOverrideFlags(4);
        }
    }

    public ViewFormat getViewFormat(int n) {
        switch (n) {
            case 0: {
                return this.m_viewFormatX1;
            }
            case 1: {
                return this.m_viewFormatY1;
            }
            case 2: {
                return this.m_viewFormatY2;
            }
            case 3: {
                return this.m_viewFormatZ;
            }
            case 4: {
                return this.m_viewFormatStockVolume;
            }
        }
        return null;
    }

    public void setViewFormat(ViewFormat viewFormat, int n) {
        if (viewFormat == null) {
            this.m_graph.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), m_method_setViewFormat);
            return;
        }
        switch (n) {
            case 0: {
                this.m_viewFormatX1 = (ViewFormat)viewFormat.clone();
                this.m_viewFormatX1.setViewFormatCallback(this);
                this.m_viewFormatX1.setView(this.m_graph);
                break;
            }
            case 1: {
                this.m_viewFormatY1 = (ViewFormat)viewFormat.clone();
                this.m_viewFormatY1.setViewFormatCallback(this);
                this.m_viewFormatY1.setView(this.m_graph);
                break;
            }
            case 2: {
                this.m_viewFormatY2 = (ViewFormat)viewFormat.clone();
                this.m_viewFormatY2.setViewFormatCallback(this);
                this.m_viewFormatY2.setView(this.m_graph);
                break;
            }
            case 3: {
                this.m_viewFormatZ = (ViewFormat)viewFormat.clone();
                this.m_viewFormatZ.setViewFormatCallback(this);
                this.m_viewFormatZ.setView(this.m_graph);
                break;
            }
            case 4: {
                this.m_viewFormatStockVolume = (ViewFormat)viewFormat.clone();
                this.m_viewFormatStockVolume.setViewFormatCallback(this);
                this.m_viewFormatStockVolume.setView(this.m_graph);
                break;
            }
            default: {
                this.m_graph.getErrorHandler().log("invalid value", "oracle.dss.graph.MarkerText", "setViewFormat(ViewFormat viewFormat, int value)");
            }
        }
        this.m_pfj.needRecalc();
    }

    public void formatChanged(int n, String string, Object object, Object object2) {
        this.m_pfj.needRecalc();
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setDisplay(this.m_identObj, bl);
        this.setPropertyOverrideFlags(1);
    }

    protected String convertMarkerTextPlaceToString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "MTP_CUSTOM";
                break;
            }
            case 1: {
                string = "MTP_OUTSIDE_MAX";
                break;
            }
            case 2: {
                string = "MTP_ON_MAXEDGE";
                break;
            }
            case 3: {
                string = "MTP_INSIDE_MAX";
                break;
            }
            case 4: {
                string = "MTP_CENTER";
                break;
            }
            case 5: {
                string = "MTP_INSIDE_MIN";
            }
        }
        return string;
    }

    protected int convertMarkerTextPlaceToInt(String string) {
        int n = 0;
        if (string.equals("MTP_CUSTOM")) {
            n = 0;
        } else if (string.equals("MTP_OUTSIDE_MAX")) {
            n = 1;
        } else if (string.equals("MTP_ON_MAXEDGE")) {
            n = 2;
        } else if (string.equals("MTP_INSIDE_MAX")) {
            n = 3;
        } else if (string.equals("MTP_CENTER")) {
            n = 4;
        } else if (string.equals("MTP_INSIDE_MIN")) {
            n = 5;
        }
        return n;
    }

    protected ObjectNode getX1ViewFormatXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(X1ViewFormat_Name);
        boolean bl2 = false;
        if ((bl || this.getViewFormat(0) != null) && this.getViewFormat(0).getXML(bl) != null) {
            objectNode.addProperty(this.getViewFormat(0).getXML(bl));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected ObjectNode getY1ViewFormatXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(Y1ViewFormat_Name);
        boolean bl2 = false;
        if ((bl || this.getViewFormat(1) != null) && this.getViewFormat(1).getXML(bl) != null) {
            objectNode.addProperty(this.getViewFormat(1).getXML(bl));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected ObjectNode getZViewFormatXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(ZViewFormat_Name);
        boolean bl2 = false;
        if ((bl || this.getViewFormat(3) != null) && this.getViewFormat(3).getXML(bl) != null) {
            objectNode.addProperty(this.getViewFormat(3).getXML(bl));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected ObjectNode getY2ViewFormatXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(Y2ViewFormat_Name);
        boolean bl2 = false;
        if ((bl || this.getViewFormat(2) != null) && this.getViewFormat(2).getXML(bl) != null) {
            objectNode.addProperty(this.getViewFormat(2).getXML(bl));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected ObjectNode getStockVolumeViewFormatXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(StockVolumeViewFormat_Name);
        boolean bl2 = false;
        if ((bl || this.getViewFormat(4) != null) && this.getViewFormat(4).getXML(bl) != null) {
            objectNode.addProperty(this.getViewFormat(4).getXML(bl));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected String getComponentName() {
        return "MarkerText";
    }

    protected int getStylePropertyCount() {
        return 5;
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        ObjectNode objectNode2;
        ObjectNode objectNode3;
        ObjectNode objectNode4;
        ObjectNode objectNode5;
        boolean bl2 = super.getNonstyleXML(bl, objectNode);
        ObjectNode objectNode6 = this.getX1ViewFormatXML(bl);
        if (objectNode6 != null) {
            objectNode.addProperty(objectNode6);
            bl2 = true;
        }
        if ((objectNode5 = this.getY1ViewFormatXML(bl)) != null) {
            objectNode.addProperty(objectNode5);
            bl2 = true;
        }
        if ((objectNode4 = this.getY2ViewFormatXML(bl)) != null) {
            objectNode.addProperty(objectNode4);
            bl2 = true;
        }
        if ((objectNode3 = this.getZViewFormatXML(bl)) != null) {
            objectNode.addProperty(objectNode3);
            bl2 = true;
        }
        if ((objectNode2 = this.getStockVolumeViewFormatXML(bl)) != null) {
            objectNode.addProperty(objectNode2);
            bl2 = true;
        }
        return bl2;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("visible", this.isVisible());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("markerTextPlace", this.convertMarkerTextPlaceToString(this.getMarkerTextPlace()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty("markerTextAngleDefault", this.getMarkerTextAngleDefault());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("markerTextRadiusDefault", this.getMarkerTextRadiusDefault());
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode, String string, int n) {
        ObjectNode objectNode2;
        ObjectNode objectNode3;
        ObjectNode objectNode4;
        ObjectNode objectNode5;
        super.setNonstyleXML(objectNode);
        ObjectNode objectNode6 = objectNode.getPropertyValueAsObjectNode(X1ViewFormat_Name, true);
        if (objectNode6 != null && objectNode6.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            this.getViewFormat(0).setXML(objectNode6.getPropertyValueAsObjectNode(ViewFormat_Name, true), string, n);
        }
        if ((objectNode5 = objectNode.getPropertyValueAsObjectNode(Y1ViewFormat_Name, true)) != null && objectNode5.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            this.getViewFormat(1).setXML(objectNode5.getPropertyValueAsObjectNode(ViewFormat_Name, true), string, n);
        }
        if ((objectNode4 = objectNode.getPropertyValueAsObjectNode(Y2ViewFormat_Name, true)) != null && objectNode4.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            this.getViewFormat(2).setXML(objectNode4.getPropertyValueAsObjectNode(ViewFormat_Name, true), string, n);
        }
        if ((objectNode3 = objectNode.getPropertyValueAsObjectNode(ZViewFormat_Name, true)) != null && objectNode3.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            this.getViewFormat(3).setXML(objectNode3.getPropertyValueAsObjectNode(ViewFormat_Name, true), string, n);
        }
        if ((objectNode2 = objectNode.getPropertyValueAsObjectNode(StockVolumeViewFormat_Name, true)) != null && objectNode2.getPropertyValueAsObjectNode(ViewFormat_Name, true) != null) {
            this.getViewFormat(4).setXML(objectNode2.getPropertyValueAsObjectNode(ViewFormat_Name, true), string, n);
        }
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("visible");
        if (propertyNode != null) {
            this.setVisible(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("markerTextPlace")) != null) {
            this.setMarkerTextPlace(this.convertMarkerTextPlaceToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("markerTextAngleDefault")) != null) {
            this.setMarkerTextAngleDefault(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("markerTextRadiusDefault")) != null) {
            this.setMarkerTextRadiusDefault(propertyNode.getValueAsInteger());
        }
    }

    private void init() {
        this.m_viewFormatX1 = new ViewFormat();
        this.m_viewFormatY1 = new ViewFormat();
        this.m_viewFormatY2 = new ViewFormat();
        this.m_viewFormatZ = new ViewFormat();
        this.m_viewFormatStockVolume = new ViewFormat();
        this.m_viewFormatX1.setViewFormatCallback(this);
        this.m_viewFormatY1.setViewFormatCallback(this);
        this.m_viewFormatY2.setViewFormatCallback(this);
        this.m_viewFormatZ.setViewFormatCallback(this);
        this.m_viewFormatStockVolume.setViewFormatCallback(this);
        this.m_viewFormatX1.setView(this.m_graph);
        this.m_viewFormatY1.setView(this.m_graph);
        this.m_viewFormatY2.setView(this.m_graph);
        this.m_viewFormatZ.setView(this.m_graph);
        this.m_viewFormatStockVolume.setView(this.m_graph);
    }

    protected void resetStyle() {
        this.setVisible(this.visible);
        this.setMarkerTextPlace(this.markerTextPlace);
        this.setMarkerTextAngleDefault(this.markerTextAngleDefault);
        this.setMarkerTextRadiusDefault(this.markerTextRadiusDefault);
        super.resetStyle();
    }
}

