/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.Rect;
import oracle.dss.graph.SFX;
import oracle.dss.graph.UILegendArea;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class LegendArea
extends BaseGraphComponent
implements UILegendArea,
Rect {
    protected static final int ATTR_FILLCOLOR = 0;
    protected static final int ATTR_FILLTRANSPARENT = 1;
    protected static final int ATTR_BORDERCOLOR = 2;
    protected static final int ATTR_BORDERTRANSPARENT = 3;
    protected static final int ATTR_VISIBLE = 4;
    protected static final int ATTR_ALONGGRAPHEDGE = 5;
    protected static final int ATTR_AUTOMATICPLACEMENT = 6;
    protected static final int ATTR_POSITION = 7;
    protected static final int ATTR_THREEDSURFACEPOSITION = 8;
    protected static final int ATTR_MARKERSPERROWAUTOMATIC = 9;
    protected static final int ATTR_LEGENDMARKERSPERROW = 10;
    protected static final int ATTR_LEGENDTEXTPOSITION = 11;
    protected static final int ATTR_LEGENDORIENTATION = 12;
    protected static final int ATTR_STYLE_MAXID = 13;
    protected SFX m_sfx;
    private int m_position = GraphDefaultValues.getLegendPosition();
    private int m_automaticPosition;
    private boolean m_bAlongGraphEdge = GraphDefaultValues.isLegendAlongGraphEdge();
    private int m_automaticPlacement = GraphDefaultValues.getLegendAutomaticPlacement();
    private int m_alternatePosition = GraphDefaultValues.getLegendThreeDSurfacePosition();
    private Rectangle m_alternatePFJRect = new Rectangle(-12540, -13966, 25072, 2063);
    private boolean m_bThreeDSurfaceGraph;
    private boolean m_bStandardRectDefault = true;
    private boolean m_bThreeDSurfaceRectDefault = true;
    protected boolean visible;
    protected int position;
    protected int d_threeDSurfacePosition;
    protected boolean d_alongGraphEdge;
    protected int d_automaticPlacement;
    protected int borderColor;
    protected int fillColor;
    protected boolean borderTransparent;
    protected boolean fillTransparent;
    protected boolean markersPerRowAutomatic;
    protected int legendMarkersPerRow;
    protected int legendTextPosition;
    protected int legendOrientation;
    private static final String a_threeDSurfacePosition = "threeDSurfacePosition";
    private static final String a_alongGraphEdge = "alongGraphEdge";
    private static final String a_automaticPlacement = "automaticPlacement";
    private static final String NAME_THREEDSURFACERECT = "ThreeDSurfaceRect";
    protected static final int rect_Height = 2063;
    protected static final int rect_Width = 25072;
    protected static final int rect_X = -14180;
    protected static final int rect_Y = -11537;

    public LegendArea(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getLegendArea();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.visible = GraphDefaultValues.isLegendVisible();
        this.position = GraphDefaultValues.getLegendPosition();
        this.d_alongGraphEdge = GraphDefaultValues.isLegendAlongGraphEdge();
        this.d_automaticPlacement = GraphDefaultValues.getLegendAutomaticPlacement();
        this.borderColor = GraphDefaultValues.getLegendBorderColor();
        this.fillColor = GraphDefaultValues.getLegendFillColor();
        this.borderTransparent = GraphDefaultValues.isLegendBorderTransparent();
        this.fillTransparent = GraphDefaultValues.isLegendFillTransparent();
        this.d_threeDSurfacePosition = GraphDefaultValues.getLegendThreeDSurfacePosition();
        this.markersPerRowAutomatic = GraphDefaultValues.isLegendMarkersPerRowAutomatic();
        this.legendMarkersPerRow = GraphDefaultValues.getLegendMarkersPerRow();
        this.legendTextPosition = GraphDefaultValues.getLegendTextPosition();
        this.legendOrientation = GraphDefaultValues.getLegendOrientation();
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_graph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(2);
    }

    public boolean isBorderTransparent() {
        return this.m_pfj.getTransparentBorderColor(this.m_identObj);
    }

    public void setBorderTransparent(boolean bl) {
        this.m_pfj.setTransparentBorderColor(this.m_identObj, bl);
        this.setPropertyOverrideFlags(3);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.setFillTransparent(true);
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(0);
    }

    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    public void setFillTransparent(boolean bl) {
        this.m_pfj.setTransparentFillColor(this.m_identObj, bl);
        this.setPropertyOverrideFlags(1);
    }

    public boolean isMarkersPerRowAutomatic() {
        return this.m_pfj.getLegendAutomatic();
    }

    public void setMarkersPerRowAutomatic(boolean bl) {
        this.m_pfj.setLegendAutomatic(bl);
        this.setPropertyOverrideFlags(9);
    }

    public int getLegendMarkersPerRow() {
        return this.m_pfj.getLegendMarkersPerRow();
    }

    public void setLegendMarkersPerRow(int n) {
        if (n < 0 || n > 9999) {
            this.m_graph.getErrorHandler().log("invalid number of legend markers", this.getClass().getName(), "setLegendMarkersPerRow(int count)");
        } else {
            this.m_pfj.setLegendMarkersPerRow(n);
            this.setPropertyOverrideFlags(10);
        }
    }

    public int getLegendTextPosition() {
        return this.m_pfj.getLegendMarkerPosition();
    }

    public void setLegendTextPosition(int n) {
        if (n > 4 || n < 0) {
            this.m_graph.getErrorHandler().log("Invalid parameter", this.getClass().getName(), "setLegendTextPosition");
            return;
        }
        this.m_pfj.setLegendMarkerPosition(n);
        this.setPropertyOverrideFlags(11);
    }

    public int getLegendOrientation() {
        return this.m_pfj.getLegendOrient();
    }

    public void setLegendOrientation(int n) {
        if (n > 2 || n < 0) {
            this.m_graph.getErrorHandler().log("Invalid parameter", this.getClass().getName(), "setLegendOrientation");
            return;
        }
        this.m_pfj.setLegendOrient(n);
        this.setPropertyOverrideFlags(12);
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setPosition(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_position = n;
                this.setAutomaticPosition(n, true);
                this.setRectDefault(true);
                this.m_automaticPlacement = 0;
                if (this.m_bThreeDSurfaceGraph) {
                    this.setPropertyOverrideFlags(8);
                    break;
                }
                this.setPropertyOverrideFlags(7);
                break;
            }
            default: {
                this.m_graph.getErrorHandler().log("invalid position", this.getClass().getName(), "setPosition(int position)");
                return;
            }
        }
    }

    public void setAlongGraphEdge(boolean bl) {
        this.m_bAlongGraphEdge = bl;
        this.setAutomaticPosition(this.getAutomaticPosition(), true);
        this.setRectDefault(true);
        this.m_alternatePFJRect = this.getDefaultPFJRect(this.m_alternatePosition, this.m_bAlongGraphEdge);
        this._setStandardRectDefault(true);
        this._setThreeDSurfaceRectDefault(true);
        if (!this.m_bAlongGraphEdge) {
            this.m_graph.adjustTitlesForLegendAlongEdge(this.getAutomaticPosition(), bl);
        }
        this.setPropertyOverrideFlags(5);
    }

    public boolean isAlongGraphEdge() {
        return this.m_bAlongGraphEdge;
    }

    public void setAutomaticPlacement(int n) {
        if (n < 0 || n > 1) {
            this.m_graph.getErrorHandler().log("invalid value for AutomaticPlacement", this.getClass().getName(), "public void setAutomaticPlacement(int placement)");
            return;
        }
        this.m_automaticPlacement = n;
        this.m_automaticPosition = this.m_position;
        this.m_pfj.needRecalc();
        this.setPropertyOverrideFlags(6);
    }

    public int getAutomaticPlacement() {
        return this.m_automaticPlacement;
    }

    public Rectangle getRect() {
        Rectangle rectangle = new Rectangle(this.m_pfj.getRect(this.m_identObj));
        rectangle.y += rectangle.height;
        return rectangle;
    }

    public void setRect(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.y -= rectangle2.height;
        this.m_pfj.setRect(this.m_identObj, rectangle2);
        this.setPositionForRect();
        this.m_graph.setFrameSizeAutomatic(false);
        this.setRectDefault(false);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setDisplay(this.m_identObj, bl);
        this.setPropertyOverrideFlags(4);
    }

    private void setRectXML(ObjectNode objectNode, boolean bl) {
        Rectangle rectangle = null;
        rectangle = bl ? this._getThreeDSurfaceRect() : this._getStandardRect();
        PropertyNode propertyNode = objectNode.getProperty("height");
        if (propertyNode != null) {
            rectangle.height = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("width")) != null) {
            rectangle.width = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("x")) != null) {
            rectangle.x = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("y")) != null) {
            rectangle.y = propertyNode.getValueAsInteger();
        }
        if (bl) {
            this._setThreeDSurfaceRect(rectangle);
        } else {
            this._setStandardRect(rectangle);
        }
    }

    private ObjectNode getRectXML(boolean bl, boolean bl2) {
        boolean bl3 = false;
        Rectangle rectangle = null;
        boolean bl4 = true;
        ObjectNode objectNode = new ObjectNode("Rect");
        if (bl2) {
            rectangle = this._getThreeDSurfaceRect();
            bl4 = this._isThreeDSurfaceRectDefault();
        } else {
            rectangle = this._getStandardRect();
            bl4 = this._isStandardRectDefault();
        }
        if (bl || !bl4) {
            objectNode.addProperty("height", rectangle.height);
            objectNode.addProperty("width", rectangle.width);
            objectNode.addProperty("x", rectangle.x);
            objectNode.addProperty("y", rectangle.y);
            bl3 = true;
        }
        if (bl3) {
            return objectNode;
        }
        return null;
    }

    private ObjectNode getThreeDSurfaceRectXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(NAME_THREEDSURFACERECT);
        boolean bl2 = false;
        ObjectNode objectNode2 = this.getRectXML(bl, true);
        if (bl || objectNode2 != null) {
            objectNode.addProperty(objectNode2);
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected String convertLegendAreaPositionToString(int n) {
        String string = "LAP_BOTTOM";
        switch (n) {
            case 0: {
                string = "LAP_TOP";
                break;
            }
            case 1: {
                string = "LAP_BOTTOM";
                break;
            }
            case 2: {
                string = "LAP_RIGHT";
                break;
            }
            case 3: {
                string = "LAP_LEFT";
            }
        }
        return string;
    }

    protected int convertLegendAreaPositionToInt(String string) {
        if (string.equals("LAP_TOP")) {
            return 0;
        }
        if (string.equals("LAP_BOTTOM")) {
            return 1;
        }
        if (string.equals("LAP_RIGHT")) {
            return 2;
        }
        if (string.equals("LAP_LEFT")) {
            return 3;
        }
        return -1;
    }

    private String _convertAutomaticPlacementToString(int n) {
        switch (n) {
            case 0: {
                return "AP_NEVER";
            }
        }
        return "AP_ALWAYS";
    }

    private int _convertAutomaticPlacementToInt(String string) {
        if (string.equals("AP_NEVER")) {
            return 0;
        }
        if (string.equals("AP_ALWAYS")) {
            return 1;
        }
        return -1;
    }

    protected void resetToDefault() {
        this.m_position = this.position;
        this.m_automaticPosition = this.position;
        this.m_bAlongGraphEdge = GraphDefaultValues.isLegendAlongGraphEdge();
        this.m_automaticPlacement = GraphDefaultValues.getLegendAutomaticPlacement();
        this.m_alternatePosition = this.d_threeDSurfacePosition;
        this.m_alternatePFJRect = this.getDefaultPFJRect(this.d_threeDSurfacePosition, this.isAlongGraphEdge());
        this.m_bThreeDSurfaceGraph = false;
        this.m_bStandardRectDefault = true;
        this.m_bThreeDSurfaceRectDefault = true;
        this.createPropertyOverrideFlags();
    }

    protected void graphTypeChanged(int n, int n2) {
        boolean bl = this._isThreeDSurfaceGraph(n);
        boolean bl2 = this._isThreeDSurfaceGraph(n2);
        if (bl && !bl2 || !bl && bl2) {
            int n3 = this.m_alternatePosition;
            this.m_alternatePosition = this.getPosition();
            this.m_position = n3;
            this.m_automaticPosition = n3;
            Rectangle rectangle = new Rectangle(this.m_pfj.getRect(this.m_identObj));
            this.m_pfj.setRect(this.m_identObj, this.m_alternatePFJRect);
            this.m_alternatePFJRect = rectangle;
        }
        this.m_bThreeDSurfaceGraph = bl2;
    }

    protected void setRectDefault(boolean bl) {
        if (this.m_bThreeDSurfaceGraph) {
            this._setThreeDSurfaceRectDefault(bl);
        } else {
            this._setStandardRectDefault(bl);
        }
    }

    Rectangle getDefaultPFJRect(int n, boolean bl) {
        switch (n) {
            case 2: {
                if (bl) {
                    return new Rectangle(10465, -16000, 5535, 32000);
                }
                return new Rectangle(10141, -13239, 5535, 25051);
            }
            case 1: {
                if (bl) {
                    return new Rectangle(-16000, -16000, 32000, 2063);
                }
                return new Rectangle(-12540, -13966, 25072, 2063);
            }
            case 3: {
                if (bl) {
                    return new Rectangle(-16000, -16000, 5535, 32000);
                }
                return new Rectangle(-15405, -13255, 5535, 25051);
            }
            case 0: {
                if (bl) {
                    return new Rectangle(-16000, 13937, 32000, 2063);
                }
                return new Rectangle(-12432, 10394, 25072, 2063);
            }
        }
        this.m_graph.getErrorHandler().log("invalid position", this.getClass().getName(), "_getDefaultRectForPosition(int position)");
        return null;
    }

    void setAutomaticPosition(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_pfj.putToLookNoCalc(this.m_pfj.getLegendArea(), Attr.LegendAreaRect, this.getDefaultPFJRect(n, this.isAlongGraphEdge()), !bl);
                break;
            }
            default: {
                this.m_graph.getErrorHandler().log("invalid position", this.getClass().getName(), "void setAutomaticPosition(int position)");
                return;
            }
        }
        this.m_automaticPosition = n;
        this.m_graph.setFrameSizeAutomatic(true);
        this.m_graph.setFrameSize(this.m_graph.getGraphType());
        if (this.isAlongGraphEdge()) {
            this.m_graph.adjustTitlesForLegendAlongEdge(this.getAutomaticPosition(), this.isAlongGraphEdge());
        }
    }

    int getAutomaticPosition() {
        return this.m_automaticPosition;
    }

    int calcAutomaticPosition() {
        if (this._isThreeDSurfaceGraph(this.m_graph.getGraphType())) {
            return this.d_threeDSurfacePosition;
        }
        return this._calcAutomaticPosition();
    }

    private int _calcAutomaticPosition() {
        int n;
        Rectangle rectangle;
        Dimension dimension = null;
        dimension = this.m_graph.isShowing() && this.m_graph.isFitToContainer() ? this.m_pfj.getSize() : this.m_graph.getImageSize();
        double d = dimension.width;
        double d2 = dimension.height;
        if (this.m_graph.getTitle().isVisible()) {
            rectangle = null;
            rectangle = this.m_pfj.getRect(this.m_pfj.getTitle());
            d2 -= (double)this.m_pfj.getVC().virtToDestHeight(rectangle.height);
        }
        if (this.m_graph.getSubtitle().isVisible()) {
            rectangle = null;
            rectangle = this.m_pfj.getRect(this.m_pfj.getSubtitle());
            d2 -= (double)this.m_pfj.getVC().virtToDestHeight(rectangle.height);
        }
        if (this.m_graph.getFootnote().isVisible()) {
            rectangle = null;
            rectangle = this.m_pfj.getRect(this.m_pfj.getFootnote());
            d2 -= (double)this.m_pfj.getVC().virtToDestHeight(rectangle.height);
        }
        if (this.m_graph.isO1AxisSupported() && this.m_graph.getO1Axis().isVisible()) {
            if (this.m_graph.isHorizontal()) {
                d *= 0.8;
            } else {
                int n2 = this.m_graph.getO1TickLabel().getTextRotation();
                if (n2 == 1 || n2 == 2) {
                    d2 *= 0.8;
                }
            }
        }
        if (this._isDualY(n = this.m_graph.getGraphType()) && this.m_graph.getY1Axis().isVisible() && this.m_graph.getY2Axis().isVisible()) {
            if (this.m_graph.isHorizontal()) {
                d2 *= 0.9;
            } else {
                d *= 0.9;
            }
        }
        if (this._isPie(n) && this.m_graph.getSliceLabel().isVisible()) {
            d *= 0.9;
        }
        if (n == 93 || n == 94) {
            d *= 0.9;
        }
        if (n == 67 || n == 68) {
            if (d > d2 * 1.4) {
                return 2;
            }
            return 1;
        }
        if (n == 65 || n == 66) {
            if (d > d2 * 1.2) {
                return 2;
            }
            return 1;
        }
        if (d2 > d) {
            return 1;
        }
        return 2;
    }

    boolean isSupported(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 84: 
            case 85: 
            case 86: 
            case 102: {
                return false;
            }
        }
        return true;
    }

    void setPositionForRect() {
        Rectangle rectangle = this.m_pfj.getRect(this.m_identObj);
        this.m_automaticPlacement = 0;
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        if (n2 > 0) {
            if (n < 0) {
                if (Math.abs(n2) > Math.abs(n)) {
                    this.m_position = 0;
                    this.m_automaticPosition = 0;
                } else {
                    this.m_position = 3;
                    this.m_automaticPosition = 3;
                }
            } else if (Math.abs(n2) > Math.abs(n)) {
                this.m_position = 0;
                this.m_automaticPosition = 0;
            } else {
                this.m_position = 2;
                this.m_automaticPosition = 2;
            }
        } else if (n < 0) {
            if (Math.abs(n2) < Math.abs(n)) {
                this.m_position = 3;
                this.m_automaticPosition = 3;
            } else {
                this.m_position = 1;
                this.m_automaticPosition = 1;
            }
        } else if (Math.abs(n2) < Math.abs(n)) {
            this.m_position = 2;
            this.m_automaticPosition = 2;
        } else {
            this.m_position = 1;
            this.m_automaticPosition = 1;
        }
        this.m_bAlongGraphEdge = false;
    }

    private boolean _isDualY(int n) {
        switch (n) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 64: 
            case 71: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 91: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    private boolean _isPie(int n) {
        switch (n) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    private boolean _isThreeDSurfaceGraph(int n) {
        return n == 12 || n == 13 || n == 14;
    }

    private Rectangle _getThreeDSurfaceRect() {
        return this._getLegendRect(true);
    }

    private void _setThreeDSurfaceRect(Rectangle rectangle) {
        this._setLegendRect(rectangle, true);
    }

    private int _getThreeDSurfacePosition() {
        return this._getLegendPosition(true);
    }

    private void _setThreeDSurfacePosition(int n) {
        this._setLegendPosition(n, true);
        this.setPropertyOverrideFlags(8);
    }

    private boolean _isThreeDSurfaceRectDefault() {
        return this.m_bThreeDSurfaceRectDefault;
    }

    private void _setThreeDSurfaceRectDefault(boolean bl) {
        this.m_bThreeDSurfaceRectDefault = bl;
    }

    private Rectangle _getStandardRect() {
        return this._getLegendRect(false);
    }

    private void _setStandardRect(Rectangle rectangle) {
        this._setLegendRect(rectangle, false);
    }

    private int _getStandardPosition() {
        return this._getLegendPosition(false);
    }

    private void _setStandardPosition(int n) {
        this._setLegendPosition(n, false);
        this.setPropertyOverrideFlags(7);
    }

    private boolean _isStandardRectDefault() {
        return this.m_bStandardRectDefault;
    }

    private void _setStandardRectDefault(boolean bl) {
        this.m_bStandardRectDefault = bl;
    }

    private Rectangle _getLegendRect(boolean bl) {
        if (bl && this.m_bThreeDSurfaceGraph || !bl && !this.m_bThreeDSurfaceGraph) {
            return this.getRect();
        }
        Rectangle rectangle = new Rectangle(this.m_alternatePFJRect);
        rectangle.y += rectangle.height;
        return rectangle;
    }

    private void _setLegendRect(Rectangle rectangle, boolean bl) {
        if (bl && this.m_bThreeDSurfaceGraph || !bl && !this.m_bThreeDSurfaceGraph) {
            this.setRect(rectangle);
        } else {
            this.m_alternatePFJRect = new Rectangle(rectangle);
            this.m_alternatePFJRect.y -= this.m_alternatePFJRect.height;
        }
    }

    private int _getLegendPosition(boolean bl) {
        if (bl && this.m_bThreeDSurfaceGraph || !bl && !this.m_bThreeDSurfaceGraph) {
            return this.getPosition();
        }
        return this.m_alternatePosition;
    }

    private void _setLegendPosition(int n, boolean bl) {
        if (bl && this.m_bThreeDSurfaceGraph || !bl && !this.m_bThreeDSurfaceGraph) {
            this.setPosition(n);
        } else {
            this.m_alternatePosition = n;
            this.m_alternatePFJRect = this.getDefaultPFJRect(this.m_alternatePosition, this.isAlongGraphEdge());
        }
    }

    protected String getComponentName() {
        return "LegendArea";
    }

    protected int getStylePropertyCount() {
        return 13;
    }

    protected ObjectNode getXML(boolean bl, boolean bl2) {
        ContainerNode containerNode;
        ObjectNode objectNode;
        ObjectNode objectNode2;
        int n;
        ObjectNode objectNode3 = new ObjectNode(this.getComponentName());
        boolean bl3 = false;
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode3.addProperty("visible", this.isVisible());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            objectNode3.addProperty(a_alongGraphEdge, this.isAlongGraphEdge());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(6)) {
            objectNode3.addProperty(a_automaticPlacement, this._convertAutomaticPlacementToString(this.getAutomaticPlacement()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(7)) {
            objectNode3.addProperty("position", this.convertLegendAreaPositionToString(this._getStandardPosition()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(8)) {
            objectNode3.addProperty(a_threeDSurfacePosition, this.convertLegendAreaPositionToString(this._getThreeDSurfacePosition()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode3.addProperty("borderColor", BaseGraphComponent.toHexString(this.getBorderColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode3.addProperty("fillColor", BaseGraphComponent.toHexString(this.getFillColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode3.addProperty("borderTransparent", this.isBorderTransparent());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode3.addProperty("fillTransparent", this.isFillTransparent());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(9)) {
            objectNode3.addProperty("markersPerRowAutomatic", this.isMarkersPerRowAutomatic());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(10)) {
            objectNode3.addProperty("legendMarkersPerRow", this.getLegendMarkersPerRow());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(11)) {
            n = this.getLegendTextPosition();
            if (n == 0) {
                objectNode3.addProperty("legendTextPosition", "LTP_ON_RIGHT");
            } else if (n == 1) {
                objectNode3.addProperty("legendTextPosition", "LTP_ON_LEFT");
            } else if (n == 2) {
                objectNode3.addProperty("legendTextPosition", "LTP_BELOW");
            } else if (n == 3) {
                objectNode3.addProperty("legendTextPosition", "LTP_ABOVE");
            } else if (n == 4) {
                objectNode3.addProperty("legendTextPosition", "LTP_ON_MWRKER");
            }
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(12)) {
            n = this.getLegendOrientation();
            if (n == 2) {
                objectNode3.addProperty("legendOrientation", "LO_AUTOMATIC");
            } else if (n == 1) {
                objectNode3.addProperty("legendOrientation", "LO_HORIZONTAL");
            } else if (n == 0) {
                objectNode3.addProperty("legendOrientation", "LO_VERTICAL");
            }
            bl3 = true;
        }
        if ((objectNode2 = this.getRectXML(bl, false)) != null) {
            objectNode3.addProperty(objectNode2);
            bl3 = true;
        }
        if ((objectNode = this.getThreeDSurfaceRectXML(bl)) != null) {
            objectNode3.addProperty(objectNode);
            bl3 = true;
        }
        if ((containerNode = this.getSFX().getXML(bl, bl2)) != null) {
            objectNode3.addContainer(containerNode);
            bl3 = true;
        }
        return bl3 ? objectNode3 : null;
    }

    protected void setXML(ObjectNode objectNode, boolean bl) {
        Object object;
        BaseObjectNode baseObjectNode;
        PropertyNode propertyNode = objectNode.getProperty("visible");
        if (propertyNode != null) {
            this.setVisible(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("position")) != null) {
            this._setStandardPosition(this.convertLegendAreaPositionToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_threeDSurfacePosition)) != null) {
            this._setThreeDSurfacePosition(this.convertLegendAreaPositionToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_alongGraphEdge)) != null) {
            this.setAlongGraphEdge(propertyNode.getValueAsBoolean());
        }
        if (!this.isAlongGraphEdge()) {
            ObjectNode objectNode2;
            baseObjectNode = objectNode.getPropertyValueAsObjectNode("Rect", true);
            if (baseObjectNode != null) {
                this.setRectXML((ObjectNode)baseObjectNode, false);
            }
            if ((object = objectNode.getPropertyValueAsObjectNode(NAME_THREEDSURFACERECT, true)) != null && (objectNode2 = ((ObjectNode)object).getPropertyValueAsObjectNode("Rect", true)) != null) {
                this.setRectXML(objectNode2, true);
            }
        }
        if ((propertyNode = objectNode.getProperty(a_automaticPlacement)) != null) {
            this.setAutomaticPlacement(this._convertAutomaticPlacementToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("borderColor")) != null) {
            this.setBorderColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty("fillColor")) != null) {
            this.setFillColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((baseObjectNode = objectNode.getContainer("SFX")) != null) {
            this.getSFX().setXML((ContainerNode)baseObjectNode, bl);
        }
        if ((propertyNode = objectNode.getProperty("borderTransparent")) != null) {
            this.setBorderTransparent(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("fillTransparent")) != null) {
            this.setFillTransparent(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("markersPerRowAutomatic")) != null) {
            this.setMarkersPerRowAutomatic(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("legendMarkersPerRow")) != null) {
            this.setLegendMarkersPerRow(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("legendTextPosition")) != null) {
            object = propertyNode.getValueAsString();
            if (((String)object).equals("LTP_ON_RIGHT")) {
                this.setLegendTextPosition(0);
            } else if (((String)object).equals("LTP_ON_LEFT")) {
                this.setLegendTextPosition(1);
            } else if (((String)object).equals("LTP_ABOVE")) {
                this.setLegendTextPosition(3);
            } else if (((String)object).equals("LTP_BELOW")) {
                this.setLegendTextPosition(2);
            } else if (((String)object).equals("LTP_ON_MWRKER")) {
                this.setLegendTextPosition(4);
            }
        }
        if ((propertyNode = objectNode.getProperty("legendOrientation")) != null) {
            object = propertyNode.getValueAsString();
            if (((String)object).equals("LO_AUTOMATIC")) {
                this.setLegendOrientation(2);
            } else if (((String)object).equals("LO_HORIZONTAL")) {
                this.setLegendOrientation(1);
            } else if (((String)object).equals("LO_VERTICAL")) {
                this.setLegendOrientation(0);
            }
        }
    }

    protected void resetStyle() {
        this.setVisible(this.visible);
        this.setBorderColor(new Color(this.borderColor));
        this.setBorderTransparent(this.borderTransparent);
        this.setFillColor(new Color(this.fillColor));
        this.setFillTransparent(this.fillTransparent);
        this.setMarkersPerRowAutomatic(this.markersPerRowAutomatic);
        this.setLegendMarkersPerRow(this.legendMarkersPerRow);
        this.setLegendTextPosition(this.legendTextPosition);
        this.setLegendOrientation(this.legendOrientation);
        if (this.m_bThreeDSurfaceGraph) {
            this.setPosition(this.d_threeDSurfacePosition);
        } else {
            this.setPosition(this.position);
        }
        this.setAutomaticPlacement(this.d_automaticPlacement);
        this.setAlongGraphEdge(this.d_alongGraphEdge);
        super.resetStyle();
    }

    protected void createPropertyOverrideFlags() {
        if (this.m_sfx != null) {
            this.m_sfx.createPropertyOverrideFlags();
        }
        super.createPropertyOverrideFlags();
    }
}

