/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Font;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.BaseGraphXML;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.UIGraphFont;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class GraphFont
extends BaseGraphXML
implements UIGraphFont {
    public static final int ATTR_FONTNAME = 0;
    public static final int ATTR_FONTSIZE = 1;
    public static final int ATTR_FONTCOLOR = 2;
    public static final int ATTR_FONTBOLD = 3;
    public static final int ATTR_FONTITALIC = 4;
    public static final int ATTR_UNDERLINE = 5;
    public static final int ATTR_GRAPHPROPORTIONALFONTSIZE = 6;
    protected static final int ATTR_STYLE_MAXID = 7;
    protected String fontTypeface;
    protected int fontStyle;
    protected int fontSize;
    protected Color fontColor;
    protected int graphProportionalFontSize;
    protected int graphHeightInVC;
    protected int pointsPerInch;
    protected Graph m_graph;
    protected PFJ m_pfj;
    protected IdentObj m_identObj;
    protected IdentObj m_identObj2;
    protected static final String a_name = "name";
    protected static final String a_style = "style";
    protected static final String a_bold = "bold";
    protected static final String a_italic = "italic";
    protected static final String a_underline = "underline";
    protected static final String a_size = "size";
    protected static final String a_fontColor = "fontColor";
    protected static final String a_graphProportionalFontSize = "graphProportionalFontSize";
    private static final int MaxFontSizeinFullScreen = 5300;

    public GraphFont(Graph graph, IdentObj identObj, String string, int n, int n2, Color color, int n3) {
        super(graph);
        this.m_graph = graph;
        this.m_pfj = graph.getPFJ();
        this.m_identObj = identObj;
        this.m_identObj2 = identObj.getObjectID() == 270 ? this.m_pfj.getO1DrillLabel() : (identObj.getObjectID() == 274 ? this.m_pfj.getO2DrillLabel() : null);
        this.graphHeightInVC = GraphDefaultValues.getGraphFontHeightInVC();
        this.pointsPerInch = GraphDefaultValues.getGraphFontPointsPerInch();
        this.fontTypeface = string;
        this.fontStyle = n;
        this.fontSize = n2;
        this.fontColor = color;
        this.graphProportionalFontSize = n3;
    }

    private int _getGraphHeight() {
        int n = this.m_pfj.getSize().height;
        if (n <= 0) {
            n = 500;
        }
        return n;
    }

    private int _getScreenResolution() {
        int n = this.m_pfj.getToolkit().getScreenResolution();
        if (n <= 0) {
            n = 96;
        }
        return n;
    }

    public Color getGraphFontColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setGraphFontColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setGraphFontColor( Color newColor )");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, color);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFillColor(this.m_identObj2, color);
        }
        this.setPropertyOverrideFlags(2);
    }

    public int getGraphFontSize() {
        return this.m_pfj.getFontSize(this.m_identObj);
    }

    public int getGraphProportionalFontSize() {
        return this.m_pfj.getFontSizeVC(this.m_identObj);
    }

    public void setGraphFontSize(int n) {
        if (n < 1) {
            this.m_graph.getErrorHandler().log("invalid graph font size", this.getClass().getName(), "setGraphFontSize(int size)");
        } else {
            this.m_pfj.setFontSize(this.m_identObj, n);
            if (this.m_identObj2 != null) {
                this.m_pfj.setFontSize(this.m_identObj2, n);
            }
            this.setPropertyOverrideFlags(1);
        }
    }

    public void setGraphProportionalFontSize(int n) {
        this.m_pfj.setFontSizeVC(this.m_identObj, n);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontSizeVC(this.m_identObj2, n);
        }
        this.setPropertyOverrideFlags(6);
    }

    public int getGraphFontStyle() {
        return this.m_pfj.getFontStyle(this.m_identObj);
    }

    public void setGraphFontStyle(int n) {
        if (n < 0 || n > 7) {
            this.m_graph.getErrorHandler().log("invalid graph font size", this.getClass().getName(), "setGraphFontStyle( int style )");
        }
        this.m_pfj.setFontStyle(this.m_identObj, n);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontStyle(this.m_identObj2, n |= 4);
        }
        this.setPropertyOverrideFlags(3);
        this.setPropertyOverrideFlags(4);
        this.setPropertyOverrideFlags(5);
    }

    public boolean isFontBold() {
        return (this.m_pfj.getFontStyle(this.m_identObj) & 2) != 0;
    }

    public boolean isFontItalic() {
        return (this.m_pfj.getFontStyle(this.m_identObj) & 1) != 0;
    }

    public boolean isUnderline() {
        return (this.m_pfj.getFontStyle(this.m_identObj) & 4) != 0;
    }

    public void setFontBold(boolean bl) {
        int n = this.m_pfj.getFontStyle(this.m_identObj);
        n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
        this.m_pfj.setFontStyle(this.m_identObj, n);
        if (this.m_identObj2 != null) {
            int n2 = this.m_pfj.getFontStyle(this.m_identObj2);
            n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
            this.m_pfj.setFontStyle(this.m_identObj2, n2);
        }
        this.setPropertyOverrideFlags(3);
    }

    public void setFontItalic(boolean bl) {
        int n = this.m_pfj.getFontStyle(this.m_identObj);
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        this.m_pfj.setFontStyle(this.m_identObj, n);
        if (this.m_identObj2 != null) {
            int n2 = this.m_pfj.getFontStyle(this.m_identObj2);
            n2 = bl ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
            this.m_pfj.setFontStyle(this.m_identObj2, n2);
        }
        this.setPropertyOverrideFlags(4);
    }

    public void setUnderline(boolean bl) {
        int n = this.m_pfj.getFontStyle(this.m_identObj);
        n = bl ? (n |= 4) : (n &= 0xFFFFFFFB);
        this.m_pfj.setFontStyle(this.m_identObj, n);
        this.setPropertyOverrideFlags(5);
    }

    public String getGraphFontTypeface() {
        return this.m_pfj.getFontName(this.m_identObj);
    }

    public void setGraphFontTypeface(String string) {
        if (string == null) {
            this.m_graph.getErrorHandler().log("invalid font name", this.getClass().toString(), "setGraphFontTypeface");
            return;
        }
        this.m_pfj.setFontName(this.m_identObj, string);
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontName(this.m_identObj2, string);
        }
        this.setPropertyOverrideFlags(0);
    }

    public void setFont(Font font) {
        if (font == null) {
            this.m_graph.getErrorHandler().log("invalid font", this.getClass().toString(), "setFont(Font f)");
            return;
        }
        int n = 0;
        switch (font.getStyle()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
        }
        int n2 = this.getGraphFontStyle() & 4 | n;
        this.m_pfj.setFontName(this.m_identObj, font.getName());
        if (this.m_identObj2 != null) {
            this.m_pfj.setFontName(this.m_identObj2, font.getName());
        }
        this.setPropertyOverrideFlags(0);
        this.m_pfj.setFontStyle(this.m_identObj, n2);
        if (this.m_identObj2 != null) {
            n2 = this.m_pfj.getFontStyle(this.m_identObj2) & 4 | n;
            this.m_pfj.setFontStyle(this.m_identObj2, n2);
        }
        this.setPropertyOverrideFlags(3);
        this.setPropertyOverrideFlags(4);
        this.setPropertyOverrideFlags(5);
        this.setGraphFontSize(font.getSize());
    }

    public Font getFont() {
        int n = 0;
        switch (this.m_pfj.getFontStyle(this.m_identObj)) {
            case 0: 
            case 4: {
                n = 0;
                break;
            }
            case 2: 
            case 6: {
                n = 1;
                break;
            }
            case 1: 
            case 5: {
                n = 2;
                break;
            }
            case 3: 
            case 7: {
                n = 3;
                break;
            }
        }
        return new Font(this.m_pfj.getFontName(this.m_identObj), n, this.m_pfj.getFontSize(this.m_identObj));
    }

    protected int convertStyleToInt(String string) {
        int n = 0;
        if (string.equals("FS_PLAIN")) {
            n = 0;
        } else if (string.equals("FS_ITALIC")) {
            n = 1;
        } else if (string.equals("FS_BOLD")) {
            n = 2;
        } else if (string.equals("FS_ITALIC_BOLD")) {
            n = 3;
        } else if (string.equals("FS_UNDERLINE")) {
            n = 4;
        } else if (string.equals("FS_ITALIC_UNDERLINE")) {
            n = 5;
        } else if (string.equals("FS_BOLD_UNDERLINE")) {
            n = 6;
        } else if (string.equals("FS_BOLD_ITALIC_UNDERLINE")) {
            n = 7;
        }
        return n;
    }

    protected String getComponentName() {
        return "GraphFont";
    }

    protected int getStylePropertyCount() {
        return 7;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty(a_name, this.getGraphFontTypeface());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty(a_size, this.getGraphFontSize());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty(a_fontColor, BaseGraphComponent.toHexString(this.getGraphFontColor().getRGB()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(6)) {
            objectNode.addProperty(a_graphProportionalFontSize, this.getGraphProportionalFontSize());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty(a_bold, this.isFontBold());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty(a_italic, this.isFontItalic());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            objectNode.addProperty(a_underline, this.isUnderline());
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty(a_style);
        if (propertyNode != null) {
            this.setGraphFontStyle(this.convertStyleToInt(propertyNode.getValueAsString()));
        }
    }

    protected void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty(a_name);
        if (propertyNode != null) {
            this.setGraphFontTypeface(propertyNode.getValueAsString());
        }
        if ((propertyNode = objectNode.getProperty(a_size)) != null) {
            this.setGraphFontSize(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty(a_graphProportionalFontSize)) != null) {
            this.setGraphProportionalFontSize(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty(a_fontColor)) != null) {
            this.setGraphFontColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty(a_bold)) != null) {
            this.setFontBold(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_italic)) != null) {
            this.setFontItalic(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_underline)) != null) {
            this.setUnderline(propertyNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.m_pfj.setFontName(this.m_identObj, this.fontTypeface);
        this.m_pfj.setFontStyle(this.m_identObj, this.fontStyle);
        this.m_pfj.setFontSize(this.m_identObj, this.fontSize);
        this.m_pfj.setFillColor(this.m_identObj, this.fontColor);
        this.m_pfj.setFontSizeVC(this.m_identObj, this.graphProportionalFontSize);
        super.resetStyle();
    }
}

