/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.BitSet;
import oracle.dss.graph.Graph;
import oracle.dss.util.xml.ObjectNode;

public abstract class BaseGraphXML {
    protected Graph m_graph;
    protected BitSet _userOverrideFlags;
    protected BitSet _styleOverrideFlags;
    private int _stylePropertyCount;

    public BaseGraphXML(Graph graph) {
        this.m_graph = graph;
        this._stylePropertyCount = this.getStylePropertyCount();
        this.createPropertyOverrideFlags();
    }

    protected String getComponentName() {
        return null;
    }

    protected int getStylePropertyCount() {
        return 0;
    }

    protected ObjectNode getXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(this.getComponentName());
        boolean bl2 = this.getStyleXML(bl, objectNode);
        return (bl2 |= this.getNonstyleXML(bl, objectNode)) ? objectNode : null;
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        return false;
    }

    protected ObjectNode getStyleXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(this.getComponentName());
        return this.getStyleXML(bl, objectNode) ? objectNode : null;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        return false;
    }

    protected void setXML(ObjectNode objectNode) {
        this.setNonstyleXML(objectNode);
        this.setStyleXML(objectNode);
    }

    protected void setXML(ObjectNode objectNode, String string, int n) {
        this.setNonstyleXML(objectNode, string, n);
        this.setStyleXML(objectNode);
    }

    protected void setStyleXML(ObjectNode objectNode) {
    }

    protected void setNonstyleXML(ObjectNode objectNode) {
    }

    protected void setNonstyleXML(ObjectNode objectNode, String string, int n) {
    }

    protected void resetStyle() {
        this.createPropertyOverrideFlags();
    }

    protected void createPropertyOverrideFlags() {
        if (this._stylePropertyCount > 0) {
            this._userOverrideFlags = this.m_graph.createPropertyOverrideFlags(this._stylePropertyCount);
            this._styleOverrideFlags = this.m_graph.createPropertyOverrideFlags(this._stylePropertyCount);
        }
    }

    protected void setPropertyOverrideFlags(int n) {
        this.m_graph.setPropertyOverrideFlags(n, this._userOverrideFlags, this._styleOverrideFlags);
    }

    public boolean isUserOverrideFlag(int n) {
        return this.m_graph.isPropertyOverrideFlag(n, this._userOverrideFlags);
    }

    protected void clearUserOverrideFlag(int n) {
        this.m_graph.clearPropertyOverrideFlag(n, this._userOverrideFlags);
    }

    public boolean isStyleOverrideFlag(int n) {
        return this.m_graph.isPropertyOverrideFlag(n, this._styleOverrideFlags);
    }

    protected void clearStyleOverrideFlag(int n) {
        this.m_graph.clearPropertyOverrideFlag(n, this._styleOverrideFlags);
    }
}

