/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Rectangle;
import oracle.dss.dataView.VerticalAlignment;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphBaseTitle;
import oracle.dss.graph.Rect;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseGraphTitle
extends GraphBaseTitle
implements VerticalAlignment,
Rect {
    protected static final int ATTR_VERTICALALIGNMENT = 3;
    protected static final int ATTR_RECT = 4;
    protected static final int ATTR_STYLE_MAXID = 5;
    protected int verticalAlignment;
    protected int rect_Height;
    protected int rect_Width;
    protected int rect_X;
    protected int rect_Y;

    public BaseGraphTitle(Graph graph) {
        super(graph);
    }

    public int getVerticalAlignment() {
        return this.convertPFJVAlignmentToSwing(this.m_pfj.getTextJustVert(this.m_identObj));
    }

    public void setVerticalAlignment(int n) {
        int n2 = this.convertSwingVAlignmentToPFJ(n);
        if (n2 == -1) {
            this.m_graph.getErrorHandler().log("invalid vertical aligment", this.getClass().toString(), "setVerticalAlignment(alignment)");
        } else {
            this.m_pfj.setTextJustVert(this.m_identObj, n2);
            this.setPropertyOverrideFlags(3);
        }
    }

    public Rectangle getRect() {
        Rectangle rectangle = new Rectangle(this.m_pfj.getRect(this.m_identObj));
        rectangle.y += rectangle.height;
        return rectangle;
    }

    public void setRect(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.y -= rectangle2.height;
        this.m_pfj.setRect(this.m_identObj, rectangle2);
        this.setPropertyOverrideFlags(4);
    }

    private void setRectXML(ObjectNode objectNode) {
        Rectangle rectangle = this.getRect();
        PropertyNode propertyNode = objectNode.getProperty("height");
        if (propertyNode != null) {
            rectangle.height = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("width")) != null) {
            rectangle.width = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("x")) != null) {
            rectangle.x = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("y")) != null) {
            rectangle.y = propertyNode.getValueAsInteger();
        }
        this.setRect(rectangle);
    }

    private ObjectNode getRectXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode("Rect");
        boolean bl2 = false;
        Rectangle rectangle = this.getRect();
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("height", rectangle.height);
            objectNode.addProperty("width", rectangle.width);
            objectNode.addProperty("x", rectangle.x);
            objectNode.addProperty("y", rectangle.y);
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected int getStylePropertyCount() {
        return 5;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        Object object;
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("verticalAlignment");
        if (propertyNode != null) {
            object = propertyNode.getValueAsString();
            if (((String)object).equals("TOP")) {
                this.setVerticalAlignment(1);
            } else if (((String)object).equals("CENTER")) {
                this.setVerticalAlignment(0);
            } else {
                this.setVerticalAlignment(3);
            }
        }
        if ((object = objectNode.getPropertyValueAsObjectNode("Rect", true)) != null) {
            this.setRectXML((ObjectNode)object);
        }
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        ObjectNode objectNode2;
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(3)) {
            int n = this.getVerticalAlignment();
            if (n == 1) {
                objectNode.addProperty("verticalAlignment", "TOP");
            } else if (n == 0) {
                objectNode.addProperty("verticalAlignment", "CENTER");
            } else {
                objectNode.addProperty("verticalAlignment", "BOTTOM");
            }
            bl2 = true;
        }
        if ((objectNode2 = this.getRectXML(bl)) != null) {
            objectNode.addProperty(objectNode2);
            bl2 = true;
        }
        return bl2;
    }

    void setRectDefault(boolean bl) {
        if (bl) {
            this.clearUserOverrideFlag(4);
        } else {
            this.setPropertyOverrideFlags(4);
        }
    }

    public void resetStyle() {
        this.setVerticalAlignment(this.verticalAlignment);
        this.setRect(new Rectangle(this.rect_X, this.rect_Y, this.rect_Width, this.rect_Height));
        super.resetStyle();
    }
}

