/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseBorderLine
extends BaseGraphComponent {
    protected static final int ATTR_LINECOLOR = 0;
    protected static final int ATTR_LINEWIDTH = 1;
    protected static final int ATTR_VISIBLE = 2;
    protected static final int ATTR_LINESTYLE = 3;
    protected static final int ATTR_BASEBORDERLINE_LASTID = 3;
    protected static final int ATTR_STYLE_MAXID = 4;
    protected int lineColor;
    protected int lineWidth;
    protected int lineStyle;
    protected boolean visible;

    public BaseBorderLine(Graph graph) {
        super(graph);
    }

    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setLineColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(0);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    public void setLineWidth(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, n);
            this.setPropertyOverrideFlags(1);
        }
    }

    public int getLineStyle() {
        return this.m_pfj.getLineStyle(this.m_identObj);
    }

    public void setLineStyle(int n) {
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle (int style)");
        } else {
            this.m_pfj.setLineStyle(this.m_identObj, n);
            this.setPropertyOverrideFlags(3);
        }
    }

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    protected int getStylePropertyCount() {
        return 4;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("visible", this.isVisible());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("lineWidth", this.getLineWidth());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("lineColor", BaseGraphComponent.toHexString(this.getLineColor().getRGB()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty("lineStyle", this.convertLineStyleToString(this.getLineStyle()));
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("visible");
        if (propertyNode != null) {
            this.setVisible(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("lineWidth")) != null) {
            this.setLineWidth(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("lineStyle")) != null) {
            this.setLineStyle(this.convertLineStyleToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("lineColor")) != null) {
            this.setLineColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
    }

    protected void resetStyle() {
        this.setLineColor(new Color(this.lineColor));
        this.setLineWidth(this.lineWidth);
        this.setLineStyle(this.lineStyle);
        this.setVisible(this.visible);
        super.resetStyle();
    }
}

