/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.dataView.datacache.PageLayer;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class PageEdge
implements Edge {
    private PageLayer[] m_layers;
    private int[] m_defHPos;

    public PageEdge(PageLayer[] pageLayerArray) {
        this.m_layers = pageLayerArray;
        this.m_defHPos = new int[this.m_layers.length];
    }

    public PageEdge(ObjectNode objectNode, Map map, Map map2) {
        int n = 0;
        try {
            n = objectNode.getPropertyValueAsInteger("layerCount");
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        ContainerNode containerNode = objectNode.getContainer("Layers");
        if (containerNode == null) {
            n = 0;
        }
        this.m_layers = new PageLayer[n];
        if (containerNode != null) {
            Enumeration enumeration = containerNode.getContainerNodes("Layer");
            int n2 = 0;
            while (n2 < n) {
                if (enumeration.hasMoreElements()) {
                    ContainerNode containerNode2 = (ContainerNode)enumeration.nextElement();
                    this.m_layers[n2] = new PageLayer(containerNode2, map, map2);
                } else {
                    this.m_layers[n2] = new PageLayer();
                }
                ++n2;
            }
        }
        this.m_defHPos = new int[n];
    }

    public PageEdge(DataAccess dataAccess, int n, Map map, Map map2) {
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = dataAccess.getEdgeCurrentSlice(n);
            n3 = dataAccess.getLayerCount(n);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        this.m_layers = new PageLayer[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_layers[n4] = new PageLayer(dataAccess, n, n4, n2, map, map2);
            ++n4;
        }
        this.m_defHPos = new int[n3];
    }

    public ObjectNode addEdgeToXML(String string, Data data, Map map, Map map2) {
        ObjectNode objectNode = new ObjectNode(string);
        int n = this.getLayerCount();
        objectNode.addProperty("layerCount", n);
        ContainerNode containerNode = new ContainerNode("Layers");
        int n2 = 0;
        while (n2 < n) {
            ContainerNode containerNode2 = this.m_layers[n2].addLayerToXML(map, map2);
            containerNode.addContainedObject(containerNode2);
            ++n2;
        }
        objectNode.addContainer(containerNode);
        return objectNode;
    }

    public Object getMemberMetadata(int n, int n2, String string) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getMember(n, n2).getMetadata(string);
    }

    public Object getLayerMetadata(int n, String string) throws LayerOutOfRangeException {
        if (n >= this.m_layers.length) {
            throw new LayerOutOfRangeException(n, this.m_layers.length - 1);
        }
        return this.m_layers[n].getMetadata(string);
    }

    public int getLayerCount() {
        return this.m_layers.length;
    }

    public int getExtent() {
        return 1;
    }

    public int getLimit() {
        return -1;
    }

    public int getSliceOutlineLayer(int n) throws SliceOutOfRangeException {
        return 0;
    }

    public Object getSliceLabel(int n) throws SliceOutOfRangeException {
        return null;
    }

    public int getSliceMemberCount(int n) throws SliceOutOfRangeException {
        if (n != 0) {
            throw new SliceOutOfRangeException(n, 0);
        }
        return this.m_layers.length;
    }

    public int getMemberDepth(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        this.getMember(n, n2);
        return 1;
    }

    public int getMemberStartLayer(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        this.getMember(n, n2);
        return n;
    }

    public int getMemberExtent(int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(n, n2);
        return 1;
    }

    public int getMemberStartSlice(int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(n, n2);
        return n2;
    }

    public int getMemberSiblingCount(int[] nArray, int n) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 1;
    }

    public Object getMemberMetadata(int[] nArray, int n, int n2, String string) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getMemberMetadata(n, 0, string);
    }

    public int[] getMemberHPos(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        this.getMember(n, n2);
        return new int[n + 1];
    }

    public int[] getFirstHPos() {
        return this.m_defHPos;
    }

    public int[] getLastHPos() {
        return this.m_defHPos;
    }

    public int[] getPrevHPos(int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int[] getNextHPos(int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int getCurrentSlice() {
        return 0;
    }

    public int[] getCurrentHPos() {
        return this.m_defHPos;
    }

    public QDR getSliceQDR(int n) {
        return null;
    }

    public QDR getMemberQDR(int n, int n2) {
        return null;
    }

    private Member getMember(int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException {
        if (n2 != 0) {
            throw new SliceOutOfRangeException(n2, 0);
        }
        if (n < 0) {
            throw new LayerOutOfRangeException(n2, 0);
        }
        if (n >= this.m_layers.length) {
            throw new LayerOutOfRangeException(n2, this.m_layers.length - 1);
        }
        return this.m_layers[n].getMember();
    }

    public Enumeration getMemberEnumeration(int n) {
        return new _MemberEnumeration(n);
    }

    private class _MemberEnumeration
    implements Enumeration {
        private Member member;

        _MemberEnumeration(int n) {
            this.member = PageEdge.this.m_layers[n].getMember();
        }

        public boolean hasMoreElements() {
            return this.member != null;
        }

        public Object nextElement() throws NoSuchElementException {
            Member member = null;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            member = this.member;
            this.member = null;
            return member;
        }
    }
}

