/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import oracle.dss.dataView.datacache.BaseCachedDataSource;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.RowColumnEdge;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class CachedDataSource
extends BaseCachedDataSource
implements CubeDataDirector {
    protected static final String[] DEFAULT_SUPPORTED_METADATAMAP = new String[]{"longName", "mediumName", "shortName", "hierLevel", "value", "dataType", "isTotal"};
    public static final String CACHED_DATA = "CachedData";
    public static final String EXTENT = "extent";
    public static final String LIMIT = "limit";

    public static CachedDataSource createCachedDataSource(DataAccess dataAccess, DataDirector dataDirector) {
        CachedDataSource cachedDataSource = new CachedDataSource();
        cachedDataSource.initializeDataSource(dataAccess, dataDirector, -1, -1);
        return cachedDataSource;
    }

    public static CachedDataSource createCachedDataSource(DataAccess dataAccess, DataDirector dataDirector, int n, int n2) {
        CachedDataSource cachedDataSource = new CachedDataSource();
        cachedDataSource.initializeDataSource(dataAccess, dataDirector, n, n2);
        return cachedDataSource;
    }

    public QDR getValueQDR(int n, int n2, int n3) throws ColumnOutOfRangeException, RowOutOfRangeException {
        QDR qDR = this.createQDR();
        try {
            if (n3 == 1) {
                this.addPageEdgeToQDR(qDR);
            }
            try {
                this.addEdgeToQDR(qDR, 0, n2);
            }
            catch (SliceOutOfRangeException sliceOutOfRangeException) {
                throw new ColumnOutOfRangeException(sliceOutOfRangeException.getMessage());
            }
            try {
                if (this.m_edges[1] != null) {
                    this.addEdgeToQDR(qDR, 1, n);
                }
            }
            catch (SliceOutOfRangeException sliceOutOfRangeException) {
                throw new RowOutOfRangeException(sliceOutOfRangeException.getMessage());
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return qDR;
    }

    public QDR getSliceQDR(int n, int n2, int n3) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        boolean bl;
        QDR qDR = this.m_edges[n].getSliceQDR(n2);
        boolean bl2 = bl = qDR != null;
        if (!bl) {
            qDR = this.createQDR();
        }
        try {
            if (n != 2 && n3 == 1) {
                this.addPageEdgeToQDR(qDR);
            }
            if (!bl) {
                this.addEdgeToQDR(qDR, n, n2);
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            // empty catch block
        }
        return qDR;
    }

    public QDR getMemberQDR(int n, int n2, int n3, int n4) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        int n5;
        boolean bl;
        QDR qDR = null;
        qDR = this.m_edges[n].getMemberQDR(n2, n3);
        boolean bl2 = bl = qDR != null;
        if (!bl) {
            qDR = this.createQDR();
        }
        if (n != 2 && n4 == 1) {
            this.addPageEdgeToQDR(qDR);
        }
        if (bl) {
            return qDR;
        }
        int n6 = this.getSliceMemberCount(n, n3);
        if (n6 < (n5 = n2 + 1)) {
            n5 = n6;
        }
        int n7 = 0;
        while (n7 < n5) {
            Object object = this.getMemberMetadata(n, n7, n3, "value");
            String string = (String)this.getLayerMetadata(n, n7, "dimName");
            qDR.addDimMemberPair(string, object == null ? null : object.toString());
            n7 += this.getMemberDepth(n, n7, n3);
        }
        return qDR;
    }

    public QDR getMemberQDR(int n, int[] nArray, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n != 2) {
            return null;
        }
        QDR qDR = this.createQDR();
        int n4 = nArray.length;
        if (n2 + 1 < n4) {
            n4 = n2 + 1;
        }
        int n5 = 0;
        while (n5 < n4) {
            if (nArray[n5] != -1) {
                String string = (String)this.getLayerMetadata(n, n5, "dimName");
                Object object = this.getMemberMetadata(n, nArray, n5, nArray[n5], "value");
                qDR.addDimMemberPair(string, object == null ? null : object.toString());
            }
            ++n5;
        }
        return qDR;
    }

    public QDR getLayerQDR(int n, int n2, int n3) throws LayerOutOfRangeException, EdgeOutOfRangeException {
        QDR qDR = this.createQDR();
        try {
            if (n != 2 && n3 == 1) {
                this.addPageEdgeToQDR(qDR);
            }
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        String string = (String)this.getLayerMetadata(n, n2, "dimName");
        qDR.addDimMemberPair(string, new QDRMember(1));
        return qDR;
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    protected String getXMLObjectType() {
        return "DataCache";
    }

    protected String getXMLObjectName() {
        return CACHED_DATA;
    }

    protected Edge createRowColumnEdge(ObjectNode objectNode, boolean bl, Data data, Map map, Map map2) {
        return new RowColumnEdge(objectNode, bl, data, map, map2);
    }

    protected Edge createRowColumnEdge(DataAccess dataAccess, boolean bl, int n, Map map, Map map2, int n2) {
        return new RowColumnEdge(dataAccess, bl, n, map, map2, n2);
    }

    protected int getInitialRowCount() {
        return 1;
    }

    protected int getEdgeExtent(ObjectNode objectNode) throws NoSuchPropertyException {
        return objectNode.getPropertyValueAsInteger(EXTENT);
    }

    protected MetadataMap getDefaultSupportedMetadataMap() {
        return new MetadataMap(DEFAULT_SUPPORTED_METADATAMAP);
    }

    private void addPageEdgeToQDR(QDR qDR) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        Edge edge = this.m_edges[2];
        if (edge == null) {
            return;
        }
        int[] nArray = edge.getCurrentHPos();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != -1) {
                String string = (String)edge.getLayerMetadata(n, "dimName");
                Object object = edge.getMemberMetadata(nArray, n, nArray[n], "value");
                qDR.addDimMemberPair(string, object == null ? null : object.toString());
            }
            ++n;
        }
    }

    private void addEdgeToQDR(QDR qDR, int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        int n3 = 0;
        while (n3 < this.getLayerCount(n)) {
            String string = (String)this.getLayerMetadata(n, n3, "dimName");
            Object object = this.getMemberMetadata(n, n3, n2, "value");
            qDR.addDimMemberPair(string, object == null ? null : object.toString());
            n3 += this.getMemberDepth(n, n3, n2);
        }
    }
}

