/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.io.Serializable;
import javax.swing.event.EventListenerList;
import oracle.dss.dataView.ControllerActions;
import oracle.dss.dataView.DataListener;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DrillEvent;
import oracle.dss.dataView.FormatManager;
import oracle.dss.dataView.LocalDataSource;
import oracle.dss.dataView.ManagerAdapter;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ModelListener;
import oracle.dss.dataView.PageEvent;
import oracle.dss.dataView.PivotEvent;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.WaitDataAvailableEvent;

public abstract class ModelAdapter
implements Model,
ControllerActions,
DataDirectorListener,
Serializable {
    protected static final int INITIAL_EDGE_SIZE = 100;
    protected static final int INITIAL_DATA_COLUMN = 20;
    protected static final int INITIAL_DATA_ROW = 20;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient DataSource dataDirectorFactory;
    protected transient DataDirector dataDirector;
    protected transient DataAccess dataAccess;
    protected transient DataAccess metadataAccess;
    protected boolean drillingEnabled;
    protected transient ErrorHandler m_eh;
    private FormatManager formatManager = ManagerAdapter.getInstance();

    protected void initDefaults(DataviewDefaultValues dataviewDefaultValues) {
        this.drillingEnabled = dataviewDefaultValues.isDrillingEnabled();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.dataDirector != null) {
            this.dataDirector.removeDataDirectorListener(this);
        }
        this.dataDirectorFactory = dataSource == null ? this.createDefaultDataSource() : dataSource;
    }

    protected DataSource createDefaultDataSource() {
        return new LocalDataSource();
    }

    public DataSource getDataSource() {
        return this.dataDirectorFactory;
    }

    public void setDataDirector(DataDirector dataDirector) {
        this.dataDirector = dataDirector;
        this.dataDirector.setManualUpdate();
        try {
            this.dataDirector.setDataMap(this.getDataMap(), 20, 20);
            this.dataDirector.setMetadataMap(0, -1, this.getMetadataMap(0), 100);
            this.dataDirector.setMetadataMap(1, -1, this.getMetadataMap(1), 100);
            this.dataDirector.setMetadataMap(2, -1, this.getMetadataMap(2), 100);
            this.dataDirector.update();
        }
        catch (DataException dataException) {
            this.getErrorHandler().error(dataException, this.getClass().getName(), "setDataDirector");
        }
        this.setSupportedDataLayerFlags();
        this.dataDirector.addDataDirectorListener(this);
    }

    protected abstract void setSupportedDataLayerFlags();

    public DataDirector getDataDirector() {
        return this.dataDirector;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public void addDataListener(DataListener dataListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.DataListener"), dataListener);
    }

    public void removeDataListener(DataListener dataListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.DataListener"), dataListener);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.ModelListener"), modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.ModelListener"), modelListener);
    }

    public boolean pivotGestureHappened(Object object, int n, int n2, int n3, int n4, int n5) throws DataDirectorException, LayerOutOfRangeException, EdgeOutOfRangeException {
        PivotEvent pivotEvent = new PivotEvent(object, n, n2, n3, n4, n5);
        this.fireviewPivotRequesting(pivotEvent);
        if (pivotEvent.isConsumed()) {
            return false;
        }
        boolean bl = this.dataDirector.pivot(n, n2, n3, n4, n5);
        this.fireviewPivotRequested(pivotEvent);
        return bl;
    }

    public boolean canPivot(Object object, int n, int n2, int n3, int n4, int n5) throws DataDirectorException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.dataDirector.pivotOK(n, n2, n3, n4, n5);
    }

    public boolean drillGestureHappened(Object object, int n, int n2, int n3, int n4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        DrillEvent drillEvent = new DrillEvent(object, n, n2, n3, n4);
        this.fireviewDrillRequesting(drillEvent);
        if (drillEvent.isConsumed()) {
            return false;
        }
        boolean bl = this.dataDirector.drill(n, n2, n3, n4);
        this.fireviewDrillRequested(drillEvent);
        return bl;
    }

    public boolean canDrill(Object object, int n, int n2, int n3, int n4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.dataDirector.drillOK(n, n2, n3, n4);
    }

    public boolean pageChangeHappened(Object object, int n) throws DataDirectorException, SliceOutOfRangeException {
        int[] nArray = null;
        try {
            int[] nArray2 = null;
            switch (n) {
                case 0: {
                    nArray = this.dataAccess.getFirstHPos(2);
                    break;
                }
                case 1: {
                    nArray = this.dataAccess.getLastHPos(2);
                    break;
                }
                case 2: {
                    nArray2 = this.dataAccess.getEdgeCurrentHPos(2);
                    nArray = this.dataAccess.getPrevHPos(2, nArray2);
                    if (nArray != null) break;
                    boolean bl = false;
                    return bl;
                }
                case 3: {
                    nArray2 = this.dataAccess.getEdgeCurrentHPos(2);
                    nArray = this.dataAccess.getNextHPos(2, nArray2);
                    if (nArray != null) break;
                    boolean bl = false;
                    return bl;
                }
            }
            int n2 = -1;
            if (nArray != null) {
                n2 = nArray.length - 1;
            }
            PageEvent pageEvent = new PageEvent(object, nArray, n2);
            this.fireviewPageRequesting(pageEvent);
            if (pageEvent.isConsumed()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.dataDirector.changeEdgeCurrentHPos(2, nArray, n2);
            this.fireviewPageRequested(pageEvent);
            boolean bl2 = bl;
            return bl2;
        }
        catch (DataException dataException) {
            this.getErrorHandler().error(dataException, this.getClass().getName(), "pageChangeHappened");
            return false;
        }
    }

    public boolean pageChangeHappened(Object object, int[] nArray, int n) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException {
        PageEvent pageEvent = new PageEvent(object, nArray, n);
        this.fireviewPageRequesting(pageEvent);
        if (pageEvent.isConsumed()) {
            return false;
        }
        boolean bl = false;
        try {
            bl = this.dataDirector.changeEdgeCurrentHPos(2, nArray, n);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "pageChangeHappened");
        }
        this.fireviewPageRequested(pageEvent);
        return bl;
    }

    public void setDrillingEnabled(boolean bl) {
        this.drillingEnabled = bl;
    }

    public boolean isDrillingEnabled() {
        return this.drillingEnabled;
    }

    public ControllerActions getControllerActions() {
        return this;
    }

    protected void fireviewPivotRequesting(PivotEvent pivotEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.DataListener")) {
                ((DataListener)objectArray[n + 1]).viewPivotRequesting(pivotEvent);
            }
            n -= 2;
        }
    }

    protected void fireviewPivotRequested(PivotEvent pivotEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.DataListener")) {
                ((DataListener)objectArray[n + 1]).viewPivotRequested(pivotEvent);
            }
            n -= 2;
        }
    }

    protected void fireviewDrillRequesting(DrillEvent drillEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.DataListener")) {
                ((DataListener)objectArray[n + 1]).viewDrillRequesting(drillEvent);
            }
            n -= 2;
        }
    }

    protected void fireviewDrillRequested(DrillEvent drillEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.DataListener")) {
                ((DataListener)objectArray[n + 1]).viewDrillRequested(drillEvent);
            }
            n -= 2;
        }
    }

    protected void fireviewPageRequesting(PageEvent pageEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.DataListener")) {
                ((DataListener)objectArray[n + 1]).viewPageRequesting(pageEvent);
            }
            n -= 2;
        }
    }

    protected void fireviewPageRequested(PageEvent pageEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.DataListener")) {
                ((DataListener)objectArray[n + 1]).viewPageRequested(pageEvent);
            }
            n -= 2;
        }
    }

    public void viewDataChanged(DataChangedEvent dataChangedEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ModelListener")) {
                ((ModelListener)objectArray[n + 1]).modelDataChanged(dataChangedEvent);
            }
            n -= 2;
        }
    }

    public void viewDataAvailable(DataAvailableEvent dataAvailableEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ModelListener")) {
                ((ModelListener)objectArray[n + 1]).modelDataAvailable(dataAvailableEvent);
            }
            n -= 2;
        }
    }

    public void waitDataAvailable(WaitDataAvailableEvent waitDataAvailableEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ModelListener")) {
                ((ModelListener)objectArray[n + 1]).modelWaitDataAvailable(waitDataAvailableEvent);
            }
            n -= 2;
        }
    }

    protected void setFormatManager(FormatManager formatManager) {
        this.formatManager = formatManager;
    }

    protected FormatManager getFormatManager() {
        return this.formatManager;
    }

    protected abstract DataMap getDataMap();

    protected abstract MetadataMap getMetadataMap(int var1);

    protected abstract LayerMetadataMap getLayerMetadataMap(int var1);
}

