/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class LocalDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    protected double[][] defaultData1 = new double[][]{{42.0, 50.0, 38.0, 46.0}, {26.0, 34.0, 22.0, 30.0}, {10.0, 18.0, 6.0, 14.0}};
    protected double[][] defaultData2 = new double[][]{{23.0, 4.0, 17.0, 82.0}, {44.0, 3.0, 22.0, 15.0}, {33.0, 14.0, 87.0, 94.0}};
    protected int rowCount;
    protected int columnCount;
    protected int pageCount;
    protected int currentPage;
    private Object[][] cellData;
    protected String[] rowLabels;
    protected String[] columnLabels;
    protected String[] pageLabels;
    private Locale loc;
    protected ResourceBundle rBundle;
    private String baseEdgeDim;
    private String baseDim;
    private String basePageMem;
    private String strPage;
    protected DataDirectorListener listener;

    public LocalDataSource() {
        Integer n;
        this.updateResourceBundle(null);
        String string = this.rBundle.getString("Row");
        String string2 = this.rBundle.getString("Column");
        this.strPage = this.rBundle.getString("Page");
        this.baseEdgeDim = this.rBundle.getString("LDSEdgeDim");
        this.baseDim = this.rBundle.getString("LDSDim");
        this.basePageMem = this.rBundle.getString("LDSPageMem");
        this.pageCount = 2;
        this.rowCount = 3;
        this.columnCount = 4;
        this.currentPage = 0;
        this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
        this.rowLabels = new String[this.rowCount];
        int n2 = 0;
        while (n2 < this.rowCount) {
            n = new Integer(n2 + 1);
            this.rowLabels[n2] = String.valueOf(string) + " " + n.toString();
            ++n2;
        }
        this.columnLabels = new String[this.columnCount];
        int n3 = 0;
        while (n3 < this.columnCount) {
            n = new Integer(n3 + 1);
            this.columnLabels[n3] = String.valueOf(string2) + " " + n.toString();
            ++n3;
        }
        this.pageLabels = new String[this.pageCount];
        int n4 = 0;
        while (n4 < this.pageCount) {
            n = new Integer(n4 + 1);
            this.pageLabels[n4] = String.valueOf(this.strPage) + " " + n.toString();
            ++n4;
        }
    }

    public void setLocale(Locale locale) {
        this.loc = locale;
        this.updateResourceBundle(locale);
    }

    public Locale getLocale() {
        return this.loc;
    }

    protected void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
    }

    public void populateCellData(int n, int n2, double[][] dArray) {
        this.cellData = new Object[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.cellData[n3][n4] = new Double(dArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener dataDirectorListener) {
        this.listener = dataDirectorListener;
        this.listener.viewDataAvailable(new DataAvailableEvent(this, this));
    }

    public void removeDataDirectorListener(DataDirectorListener dataDirectorListener) {
        if (this.listener == dataDirectorListener) {
            this.listener = null;
        }
    }

    public boolean drill(int n, int n2, int n3, int n4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return true;
    }

    public boolean changeEdgeCurrentSlice(int n, int n2) throws DataDirectorException, SliceOutOfRangeException, EdgeOutOfRangeException {
        if (n2 == 1) {
            this.currentPage = 1;
            this.populateCellData(this.columnCount, this.rowCount, this.defaultData2);
            this.listener.viewDataChanged(new DataChangedEvent(this, this, true, true, true, true));
        } else if (n2 == 0) {
            this.currentPage = 0;
            this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
            this.listener.viewDataChanged(new DataChangedEvent(this, this, true, false, false, true));
        }
        return true;
    }

    public boolean changeEdgeCurrentHPos(int n, int[] nArray, int n2) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        try {
            boolean bl = this.changeEdgeCurrentSlice(n, nArray[n2]);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    public int getEdgeExtent(int n) throws EdgeOutOfRangeException {
        switch (n) {
            case 0: {
                return this.columnCount;
            }
            case 1: {
                return this.rowCount;
            }
            case 2: {
                return this.pageCount;
            }
        }
        return 0;
    }

    public int getEdgeCount() {
        return 3;
    }

    public Object getValue(int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        if (n < 0 || n >= this.rowCount) {
            throw new RowOutOfRangeException(n, this.rowCount);
        }
        if (n2 < 0 || n2 >= this.columnCount) {
            throw new ColumnOutOfRangeException(n2, this.columnCount);
        }
        if (string.equals("dataRatio")) {
            return new Integer(0);
        }
        if (string.equals("dataGroupSort")) {
            return new Integer(0);
        }
        if (string.equals("dataViewFormat") || string.equals("dataViewStyle") || string.equals("dataFormatted") || string.equals("dataAnnotation")) {
            return null;
        }
        if (string.equals("dataIsTotal")) {
            return new Boolean(false);
        }
        return this.cellData[n][n2];
    }

    public boolean setValue(Object object, int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        if (n < 0 || n >= this.rowCount) {
            throw new RowOutOfRangeException(n, this.rowCount);
        }
        if (n2 < 0 || n2 >= this.columnCount) {
            throw new ColumnOutOfRangeException(n2, this.columnCount);
        }
        Object object2 = this.getValue(n, n2, string);
        Object object3 = object;
        try {
            object3 = object2.getClass().getMethod("valueOf", Class.forName("java.lang.String")).invoke(null, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cellData[n][n2] = object3;
        return true;
    }

    public Object getSliceLabel(int n, int n2, String string) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= this.columnCount) {
                    throw new SliceOutOfRangeException(n2, this.columnCount);
                }
                return this.columnLabels[n2];
            }
            case 1: {
                if (n2 < 0 || n2 >= this.rowCount) {
                    throw new SliceOutOfRangeException(n2, this.rowCount);
                }
                return this.rowLabels[n2];
            }
            case 2: {
                if (n2 < 0 || n2 >= this.pageCount) {
                    throw new SliceOutOfRangeException(n2, this.pageCount);
                }
                return this.pageLabels[n2];
            }
        }
        return null;
    }

    public int getEdgeCurrentSlice(int n, int n2) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        if (n == 2) {
            return this.currentPage;
        }
        return 0;
    }

    public void setCurrentPage(long l) {
        if (l < (long)0 || l >= (long)this.pageCount) {
            return;
        }
        this.currentPage = (int)l;
    }

    public int getLayerCount(int n) throws EdgeOutOfRangeException {
        return 1;
    }

    public int getSliceMemberCount(int n, int n2) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        return 1;
    }

    public Object getLayerMetadata(int n, int n2, String string) throws LayerOutOfRangeException, EdgeOutOfRangeException {
        if (string.equals("dimCanPivot")) {
            return new Integer(1);
        }
        if (string.equals("dimIsMeasure")) {
            return new Boolean(false);
        }
        if (string.equals("viewStyle")) {
            return null;
        }
        if (string.equals("dimDrillState")) {
            return new Integer(0);
        }
        if (n == 2) {
            return MessageFormat.format(this.baseEdgeDim, this.strPage, "1");
        }
        return MessageFormat.format(this.baseDim, String.valueOf(n2 + 1));
    }

    public Object getMemberMetadata(int n, int n2, int n3, String string) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (string.equals("drillState")) {
            switch (n3) {
                case 0: {
                    return new Integer(1);
                }
                case 1: {
                    return new Integer(2);
                }
            }
            return new Integer(0);
        }
        if (string.equals("hierLevel") || string.equals("relIndent")) {
            return new Integer(n3);
        }
        if (string.equals("value") || string.equals("displayName") || string.equals("longName") || string.equals("mediumName") || string.equals("shortName")) {
            String string2 = null;
            switch (n) {
                case 0: {
                    string2 = this.columnLabels[n3];
                    break;
                }
                case 1: {
                    string2 = this.rowLabels[n3];
                    break;
                }
                case 2: {
                    string2 = this.pageLabels[n3];
                }
            }
            return string2;
        }
        return null;
    }

    public int getMemberExtent(int n, int n2, int n3) {
        return 1;
    }

    public int getMemberDepth(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return 1;
    }

    public int getMemberStartSlice(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return n3;
    }

    public boolean drillOK(int n, int n2, int n3, int n4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return false;
    }

    public void setOutline(boolean bl) throws DataDirectorException {
        this.listener.viewDataChanged(new DataChangedEvent(this, this, true, true, true, true));
    }

    public boolean isOutline() {
        return false;
    }

    public int getMemberSiblingCount(int n, int[] nArray, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return 2;
    }

    public Object getMemberMetadata(int n, int[] nArray, int n2, int n3, String string) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n2 == 0 || nArray == null) {
            return MessageFormat.format(this.basePageMem, String.valueOf(n3));
        }
        return String.valueOf(nArray[0]) + " # " + n3;
    }

    public int[] getEdgeCurrentHPos(int n) throws EdgeOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getMemberHPos(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getNextHPos(int n, int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n == 2 && this.currentPage == 0) {
            return new int[]{1};
        }
        return null;
    }

    public int[] getPrevHPos(int n, int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n == 2 && this.currentPage == 1) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getFirstHPos(int n) throws EdgeOutOfRangeException {
        if (n == 2) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getLastHPos(int n) throws EdgeOutOfRangeException {
        if (n == 2) {
            return new int[]{1};
        }
        return null;
    }

    public DataMap getDataMap() {
        return new DataMap();
    }

    public DataMap getSupportedDataMap() {
        String[] stringArray = new String[]{"dataUnformatted", "dataFormatted", "dataRatio", "dataViewFormat", "dataViewStyle", "dataGroupSort", "dataAnnotation", "value", "dataIsTotal"};
        return new DataMap(stringArray);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] stringArray = new String[]{"longName", "mediumName", "shortName", "drillState", "viewStyle", "value", "hierLevel", "relIndent", "date"};
        return new MetadataMap(stringArray);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] stringArray = new String[]{"dimLongName", "dimMediumName", "dimShortName", "dimName", "dimCanPivot", "dimIsMeasure", "viewStyle", "dimDrillState"};
        return new LayerMetadataMap(stringArray);
    }

    public QDR getLayerQDR(int n, int n2, int n3) throws LayerOutOfRangeException, EdgeOutOfRangeException {
        String string = this.getLayerMetadata(n, n2, "dimLongName").toString();
        return new QDR(null, string, null);
    }

    public QDR getSliceQDR(int n, int n2, int n3) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        return this.constructSliceQDR(n, n2);
    }

    protected QDR constructSliceQDR(int n, int n2) {
        String string = null;
        String string2 = null;
        String string3 = "";
        int n3 = 0;
        try {
            n3 = this.getLayerCount(n);
        }
        catch (DataException dataException) {
            // empty catch block
        }
        int n4 = 0;
        while (n4 < n3) {
            try {
                string = this.getLayerMetadata(n, n4, "dimLongName").toString();
            }
            catch (DataException dataException) {
                string = "";
            }
            try {
                string2 = this.getMemberMetadata(n, n4, n2, "longName").toString();
            }
            catch (DataException dataException) {
                string2 = "";
            }
            string3 = String.valueOf(string3) + ";" + string.toString() + ":" + string2.toString();
            ++n4;
        }
        QDR qDR = new QDR(null, string3);
        return qDR;
    }
}

