/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;

public abstract class CachedPage
extends BasePage
implements Cacheable {
    protected boolean alreadyReadPage;
    protected byte[] pageData;
    protected boolean isDirty;
    protected boolean preDirty;
    protected int initialRowCount;
    private long containerRowCount;
    protected CacheManager pageCache;
    protected CacheManager containerCache;
    protected BaseDataFileFactory dataFactory;
    protected static final int PAGE_FORMAT_ID_SIZE = 4;
    public static final int WRITE_SYNC = 1;
    public static final int WRITE_NO_SYNC = 2;

    public final void setFactory(BaseDataFileFactory baseDataFileFactory) {
        this.dataFactory = baseDataFileFactory;
        this.pageCache = baseDataFileFactory.getPageCache();
        this.containerCache = baseDataFileFactory.getContainerCache();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.isDirty = false;
        this.preDirty = false;
        this.initialRowCount = 0;
        this.containerRowCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable setIdentity(Object object) throws StandardException {
        this.initialize();
        PageKey pageKey = (PageKey)object;
        FileContainer fileContainer = (FileContainer)this.containerCache.find(pageKey.getContainerId());
        this.setContainerRowCount(fileContainer.getEstimatedRowCount(0));
        try {
            if (!this.alreadyReadPage) {
                this.readPage(fileContainer, pageKey);
            } else {
                this.alreadyReadPage = false;
            }
            int n = this.getTypeFormatId();
            int n2 = FormatIdUtil.readFormatIdInteger(this.pageData);
            if (n != n2) {
                Cacheable cacheable = this.changeInstanceTo(n2, pageKey).setIdentity(object);
                return cacheable;
            }
            this.initFromData(fileContainer, pageKey);
        }
        finally {
            this.containerCache.release(fileContainer);
            fileContainer = null;
        }
        this.fillInIdentity(pageKey);
        this.initialRowCount = 0;
        return this;
    }

    @Override
    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        this.initialize();
        PageKey pageKey = (PageKey)object;
        PageCreationArgs pageCreationArgs = (PageCreationArgs)object2;
        int n = pageCreationArgs.formatId;
        if (n == -1) {
            throw StandardException.newException("XSDBB.D", pageKey, StringUtil.hexDump(this.pageData));
        }
        if (n != this.getTypeFormatId()) {
            return this.changeInstanceTo(n, pageKey).createIdentity(object, object2);
        }
        this.initializeHeaders(5);
        this.createPage(pageKey, pageCreationArgs);
        this.fillInIdentity(pageKey);
        this.initialRowCount = 0;
        int n2 = pageCreationArgs.syncFlag;
        if ((n2 & 1) != 0 || (n2 & 2) != 0) {
            this.writePage(pageKey, (n2 & 1) != 0);
        }
        return this;
    }

    private CachedPage changeInstanceTo(int n, PageKey pageKey) throws StandardException {
        CachedPage cachedPage;
        try {
            cachedPage = (CachedPage)Monitor.newInstanceFromIdentifier(n);
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() > 20000) {
                throw standardException;
            }
            throw StandardException.newException("XSDBB.D", pageKey, StringUtil.hexDump(this.pageData));
        }
        cachedPage.setFactory(this.dataFactory);
        if (this.pageData != null) {
            cachedPage.alreadyReadPage = true;
            cachedPage.usePageBuffer(this.pageData);
        }
        return cachedPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            return this.isDirty || this.preDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActuallyDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            return this.isDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            if (!this.isDirty) {
                this.preDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirty() {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            this.isDirty = true;
            this.preDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void releaseExclusive() {
        if (this.isDirty && !this.isOverflowPage() && this.containerRowCount / 8L < (long)this.recordCount()) {
            int n;
            int n2 = this.internalNonDeletedRecordCount();
            int n3 = n2 - this.initialRowCount;
            int n4 = n = n3 > 0 ? n3 : -n3;
            if (this.containerRowCount / 8L < (long)n) {
                FileContainer fileContainer = null;
                try {
                    fileContainer = (FileContainer)this.containerCache.find(this.identity.getContainerId());
                    if (fileContainer != null) {
                        fileContainer.updateEstimatedRowCount(n3);
                        this.setContainerRowCount(fileContainer.getEstimatedRowCount(0));
                        this.initialRowCount = n2;
                        fileContainer.trackUnfilledPage(this.identity.getPageNumber(), this.unfilled());
                    }
                }
                catch (StandardException standardException) {
                }
                finally {
                    if (fileContainer != null) {
                        this.containerCache.release(fileContainer);
                    }
                }
            }
        }
        super.releaseExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(boolean bl) throws StandardException {
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            if (!this.isDirty()) {
                return;
            }
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            if (!this.isDirty()) {
                return;
            }
            this.inClean = true;
            while (this.owner != null && !this.preLatch) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            if (!this.isActuallyDirty()) {
                this.preDirty = false;
                this.inClean = false;
                this.notifyAll();
                return;
            }
        }
        try {
            this.writePage(this.getPageId(), false);
        }
        catch (StandardException standardException) {
            throw this.dataFactory.markCorrupt(standardException);
        }
        finally {
            CachedPage cachedPage2 = this;
            synchronized (cachedPage2) {
                this.inClean = false;
                this.notifyAll();
            }
        }
    }

    @Override
    public void clearIdentity() {
        this.alreadyReadPage = false;
        super.clearIdentity();
    }

    private void readPage(FileContainer fileContainer, PageKey pageKey) throws StandardException {
        int n = fileContainer.getPageSize();
        this.setPageArray(n);
        int n2 = 0;
        while (true) {
            try {
                fileContainer.readPage(pageKey.getPageNumber(), this.pageData);
            }
            catch (IOException iOException) {
                if (++n2 <= 4) continue;
                StandardException standardException = StandardException.newException("XSDG0.D", iOException, pageKey, new Integer(n));
                if (this.dataFactory.getLogFactory().inRFR()) {
                    throw standardException;
                }
                throw standardException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePage(PageKey pageKey, boolean bl) throws StandardException {
        FileContainer fileContainer;
        this.writeFormatId(pageKey);
        this.writePage(pageKey);
        LogInstant logInstant = this.getLastLogInstant();
        this.dataFactory.flush(logInstant);
        if (logInstant != null) {
            this.clearLastLogInstant();
        }
        if ((fileContainer = (FileContainer)this.containerCache.find(pageKey.getContainerId())) == null) {
            StandardException standardException = StandardException.newException("40XD2", pageKey.getContainerId());
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG1.D", standardException, pageKey));
        }
        try {
            fileContainer.writePage(pageKey.getPageNumber(), this.pageData, bl);
            if (!this.isOverflowPage() && this.isDirty()) {
                fileContainer.trackUnfilledPage(pageKey.getPageNumber(), this.unfilled());
                int n = this.internalNonDeletedRecordCount();
                if (n != this.initialRowCount) {
                    fileContainer.updateEstimatedRowCount(n - this.initialRowCount);
                    this.setContainerRowCount(fileContainer.getEstimatedRowCount(0));
                    this.initialRowCount = n;
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDG1.D", iOException, pageKey);
        }
        finally {
            this.containerCache.release(fileContainer);
            fileContainer = null;
        }
        CachedPage cachedPage = this;
        synchronized (cachedPage) {
            this.isDirty = false;
            this.preDirty = false;
        }
    }

    @Override
    public void setContainerRowCount(long l) {
        this.containerRowCount = l;
    }

    protected void setPageArray(int n) {
        if (this.pageData == null || this.pageData.length != n) {
            this.pageData = null;
            this.pageData = new byte[n];
        }
        this.usePageBuffer(this.pageData);
    }

    @Override
    protected byte[] getPageArray() throws StandardException {
        this.writeFormatId(this.identity);
        this.writePage(this.identity);
        return this.pageData;
    }

    protected abstract void usePageBuffer(byte[] var1);

    protected abstract void initFromData(FileContainer var1, PageKey var2) throws StandardException;

    protected abstract void createPage(PageKey var1, PageCreationArgs var2) throws StandardException;

    protected abstract void writePage(PageKey var1) throws StandardException;

    protected abstract void writeFormatId(PageKey var1) throws StandardException;
}

