/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jbo.Transaction;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.jbo.domain.DatumFactory;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.GenericDomainException;
import oracle.jbo.domain.KeyAttributeInterface;
import oracle.jbo.domain.MarshalledDomain;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.svcmsg.ResponseValues;

public class Char
extends CHAR
implements MarshalledDomain,
Serializable,
CustomDatum,
KeyAttributeInterface,
DomainInterface {
    private int mHashCode;
    private static final long serialVersionUID = -5720324827729458337L;
    static CustomDatumFactory fac = null;

    private /* synthetic */ void $init$() {
        this.mHashCode = 0;
    }

    public static CustomDatumFactory getCustomDatumFactory() {
        if (fac == null) {
            fac = new 1facClass();
        }
        return fac;
    }

    public Datum toDatum(OracleConnection oracleConnection) throws SQLException {
        return new CHAR(this.getBytes(), this.getCharacterSet());
    }

    public Char() throws SQLException {
        super("", CharacterSet.make((int)-1));
        this.$init$();
    }

    public Char(Char char_) throws SQLException {
        super((Object)char_, char_.getCharacterSet());
        this.$init$();
    }

    public Char(CHAR cHAR) throws SQLException {
        super(cHAR.getBytes(), cHAR.getCharacterSet());
        this.$init$();
    }

    public Char(String string) throws SQLException {
        super(string, CharacterSet.make((int)-1));
        this.$init$();
    }

    public Char(Object object) throws SQLException {
        super(object, CharacterSet.make((int)-1));
        this.$init$();
    }

    public Char(byte[] byArray, CharacterSet characterSet) {
        super(byArray, characterSet);
        this.$init$();
    }

    public Char(byte[] byArray, int n, int n2, CharacterSet characterSet) {
        super(byArray, characterSet);
        this.$init$();
    }

    public Char(String string, CharacterSet characterSet) throws SQLException {
        super(string, characterSet);
        this.$init$();
    }

    public Char(Object object, CharacterSet characterSet) throws SQLException {
        super(object, characterSet);
        this.$init$();
    }

    public Char(ResponseValues responseValues) throws SQLException {
        this((String)responseValues.getObjectValues()[1]);
    }

    public String getValue() {
        return (String)this.getData();
    }

    public Object getData() {
        try {
            Object object = this.toJdbc();
            return object;
        }
        catch (Exception exception) {
            Diagnostic.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            this.mHashCode = this.toString().hashCode();
            if (this.mHashCode == 0) {
                this.mHashCode = -6857;
            }
        }
        return this.mHashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            try {
                Char char_ = new Char(object.toString(), this.getCharacterSet());
                boolean bl = super.equals((Object)char_);
                return bl;
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
            }
        }
        CharacterSet characterSet = this.getCharacterSet();
        CHAR cHAR = (CHAR)object;
        if (!cHAR.getCharacterSet().equals((Object)characterSet)) {
            byte[] byArray = cHAR.getBytes();
            try {
                boolean bl = new Char(characterSet.convert(cHAR.getCharacterSet(), byArray, 0, byArray.length), characterSet).equals(this);
                return bl;
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
            }
        }
        return super.equals(object);
    }

    public static void main(String[] stringArray) throws SQLException {
        System.out.println("Char Test BEGIN");
        System.out.println("  Simple Conversion Test ...");
        try {
            Integer n = new Integer(123);
            Char char_ = new Char(n, CharacterSet.make((int)871));
            System.out.print("  String value (expect 123): ");
            if (char_.isConvertibleTo(Class.forName("java.lang.String"))) {
                System.out.println(char_.stringValue());
            } else {
                System.out.println("failed");
            }
            System.out.print("  Long value   (expect 123): ");
            if (char_.isConvertibleTo(Class.forName("java.lang.Long"))) {
                System.out.println(char_.longValue());
            } else {
                System.out.println("failed");
            }
            if (char_.isConvertibleTo(Class.forName("java.lang.Integer"))) {
                System.out.println("  You should never see this string !!!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("CHAR Test END");
    }

    public ResponseValues marshal() {
        return new SvcMsgResponseValues(4255, null).setObjectValues(new Object[]{this.getClass().getName(), this.toString()});
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.getBytes();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.read(byArray);
        this.setBytes(byArray);
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.Integer") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.lang.Float") == 0 || string.compareTo("java.lang.Double") == 0 || string.compareTo("java.math.BigInteger") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Boolean") == 0;
    }

    public int intValue() {
        try {
            int n = super.bigDecimalValue().intValue();
            return n;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Char.intValue", (Object)this, (Exception)sQLException);
        }
    }

    public long longValue() {
        try {
            long l = super.bigDecimalValue().longValue();
            return l;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Char.longValue", (Object)this, (Exception)sQLException);
        }
    }

    public float floatValue() {
        try {
            float f = super.bigDecimalValue().floatValue();
            return f;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Char.floatValue", (Object)this, (Exception)sQLException);
        }
    }

    public double doubleValue() {
        try {
            double d = super.bigDecimalValue().doubleValue();
            return d;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Char.doubleValue", (Object)this, (Exception)sQLException);
        }
    }

    public BigInteger bigIntegerValue() {
        try {
            BigInteger bigInteger = super.bigDecimalValue().toBigInteger();
            return bigInteger;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Char.bigIntegerValue", (Object)this, (Exception)sQLException);
        }
    }

    public boolean booleanValue() {
        return new Boolean(this.stringValue());
    }

    public BigDecimal bigDecimalValue() {
        try {
            BigDecimal bigDecimal = super.bigDecimalValue();
            return bigDecimal;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Char.bigDecimalValue", (Object)this, (Exception)sQLException);
        }
    }

    public static class 1facClass
    implements DatumFactory {
        public Datum createDatum(CallableStatement callableStatement, int n) throws SQLException {
            CHAR cHAR = ((OracleCallableStatement)callableStatement).getCHAR(n);
            return new Char(cHAR.shareBytes(), cHAR.getCharacterSet());
        }

        public Datum createDatum(ResultSet resultSet, int n) throws SQLException {
            try {
                CHAR cHAR = ((OracleResultSet)resultSet).getCHAR(n);
                Char char_ = cHAR != null ? new Char(cHAR.shareBytes(), cHAR.getCharacterSet()) : null;
                return char_;
            }
            catch (SQLException sQLException) {
                Char char_ = new Char(((OracleResultSet)resultSet).getString(n));
                return char_;
            }
        }

        public CustomDatum create(Datum datum, int n) throws SQLException {
            if (datum instanceof CHAR) {
                return new Char((CHAR)datum);
            }
            if (datum != null) {
                return new Char(datum.getBytes(), CharacterSet.make((int)-1));
            }
            return null;
        }

        1facClass() {
        }
    }
}

