/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import oracle.dms.clock.ClockManager;
import oracle.dms.clock.SimpleClock;
import oracle.dms.clock.SimpleClockDescription;

public class HighResolutionClock
extends SimpleClock {
    private double _adjustment = 1.0;

    public HighResolutionClock() {
        this("highres");
        this._desc = new SimpleClockDescription();
        this._reportedFrequency = this.getHRReportedFrequency();
        this._maxFrequency = this.getHRFrequency();
        this._units = ClockManager.getUnits(this._reportedFrequency);
        this._adjustment = (double)this._reportedFrequency / (double)this._maxFrequency;
        this.start();
    }

    private HighResolutionClock(String string) {
        super(string);
    }

    public long getTime() {
        long l = this.getHighResTime();
        long l2 = (long)((double)l * this._adjustment);
        if (l2 > this._lastTime) {
            this._lastTime = l2;
        }
        return this._lastTime;
    }

    public native long getHighResTime();

    public native long getHRFrequency();

    public native long getHRReportedFrequency();

    static {
        try {
            System.loadLibrary("dms2");
        }
        catch (Throwable throwable) {
            try {
                System.loadLibrary("yod");
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }
}

