/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.LogWriterException;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.SimpleFormatter;

public class OutputStreamLogWriter
extends LogWriter {
    private OutputStreamWriter m_out;
    private LogFormatter m_formatter;

    private OutputStreamLogWriter(OutputStreamWriter outputStreamWriter) {
        this(new SimpleFormatter(), outputStreamWriter);
    }

    private OutputStreamLogWriter(LogFormatter logFormatter, OutputStreamWriter outputStreamWriter) {
        this.m_out = outputStreamWriter;
        this.m_formatter = logFormatter;
        String string = logFormatter.header();
        if (string != null) {
            this.write(string);
        }
    }

    public static OutputStreamLogWriter create(OutputStream outputStream) {
        return new OutputStreamLogWriter(new OutputStreamWriter(outputStream));
    }

    public static OutputStreamLogWriter create(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        return new OutputStreamLogWriter(new OutputStreamWriter(outputStream, string));
    }

    public static OutputStreamLogWriter create(LogFormatter logFormatter, OutputStream outputStream) throws LogWriterException {
        if (logFormatter == null) {
            throw new LogWriterException("Illegal argument: LogFormatter argument cannot be null");
        }
        return new OutputStreamLogWriter(logFormatter, new OutputStreamWriter(outputStream));
    }

    public static OutputStreamLogWriter create(LogFormatter logFormatter, OutputStream outputStream, String string) throws LogWriterException, UnsupportedEncodingException {
        if (logFormatter == null) {
            throw new LogWriterException("Illegal argument: LogFormatter argument cannot be null");
        }
        return new OutputStreamLogWriter(logFormatter, new OutputStreamWriter(outputStream, string));
    }

    public void close() {
        String string = this.m_formatter.tail();
        if (string != null) {
            this.write(string);
        }
        super.close();
        if (this.m_out == null) {
            return;
        }
        try {
            this.m_out.flush();
            this.m_out.close();
        }
        catch (Exception exception) {
            this.handleException(new LoggingException(exception));
        }
        this.m_out = null;
    }

    public void flush() {
        super.flush();
        if (this.m_out == null) {
            this.handleException(new LoggingException("Attempt to flush a closed Writer"));
            return;
        }
        try {
            this.m_out.flush();
        }
        catch (Exception exception) {
            this.handleException(new LoggingException(exception));
        }
    }

    public void write(LogMessage logMessage) {
        this.write(this.m_formatter.format(logMessage));
    }

    private final void write(String string) {
        try {
            this.m_out.write(string);
        }
        catch (Exception exception) {
            this.handleException(new LoggingException(exception));
        }
    }

    private void handleException(Exception exception) {
        this.getExceptionHandler().onException(exception);
    }
}

