/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.MessageType;

public class LogMessage
implements Serializable {
    static final int MAX_LEVEL = 32;
    public static final String ORGANIZATION_ID = "ORG_ID";
    public static final String COMPONENT_ID = "COMPONENT_ID";
    public static final String INSTANCE_ID = "INSTANCE_ID";
    public static final String MESSAGE_ID = "MSG_ID";
    public static final String HOSTING_CLIENT_ID = "HOSTING_CLIENT_ID";
    public static final String MESSAGE_TYPE = "MSG_TYPE";
    public static final String MESSAGE_GROUP = "MSG_GROUP";
    public static final String MESSAGE_LEVEL = "MSG_LEVEL";
    public static final String MODULE_ID = "MODULE_ID";
    public static final String PROCESS_ID = "PROCESS_ID";
    public static final String THREAD_ID = "THREAD_ID";
    public static final String USER_ID = "USER_ID";
    public static final String SUPPL_ATTRS = "SUPPL_ATTRS";
    public static final String SUPPL_ATTR_NAME = "SUPPL_ATTR.NAME";
    public static final String SUPPL_ATTR_VALUE = "SUPPL_ATTR.VALUE";
    public static final String UPSTREAM_COMPONENT_ID = "UPSTREAM_COMPONENT_ID";
    public static final String DOWNSTREAM_COMPONENT_ID = "DOWNSTREAM_COMPONENT_ID";
    public static final String EXEC_CONTEXT_UNIQUE_ID = "EXEC_CONTEXT_UNIQUE_ID";
    public static final String EXEC_CONTEXT_SEQ = "EXEC_CONTEXT_SEQ";
    public static final String ERROR_UNIQUE_ID = "ERROR_UNIQUE_ID";
    public static final String ERROR_SEQ = "ERROR_SEQ";
    public static final String MESSAGE_TEXT = "MSG_TEXT";
    public static final String MSG_ARGS = "MSG_ARGS";
    public static final String MSG_ARG_NAME = "NAME";
    public static final String MSG_ARG_VALUE = "VALUE";
    public static final String DETAIL_LOCATION = "DETAIL_PATH";
    public static final String SUPPL_DETAIL = "SUPPL_DETAIL";
    public static final String TSTZ = "TSTZ_ORIGINATING";
    public static final String TSTZ_ORIGINATING = "TSTZ_ORIGINATING";
    public static final String TSTZ_NORMALIZED = "TSTZ_NORMALIZED";
    public static final String HOST_ID = "HOST_ID";
    public static final String HOST_NWADDR = "HOST_NWADDR";
    public static final String PROBLEM_KEY = "PROB_KEY";
    static final long serialVersionUID = -189888222135417808L;
    private static final String ORG_ID_PROP = "OrganizationId";
    private static final String COMP_ID_PROP = "ComponentId";
    private static final String HOST_CLIENT_ID_PROP = "HostingClientId";
    private static final String INSTANCE_ID_PROP = "InstanceId";
    private static HashMap s_messageProperties;
    private static String s_defaultOrganizationId;
    private static String s_defaultComponentId;
    private static String s_defaultHostingClientId;
    private static String s_hostId;
    private static String s_hostNwAddr;
    private static String s_defaultUserId;
    private static String s_defaultInstanceId;
    private long m_timestamp;
    private long m_timestampNorm;
    private String m_organizationId;
    private String m_componentId;
    private String m_instanceId;
    private String m_messageId;
    private String m_hostingClientId;
    private MessageType m_messageType;
    private String m_messageGroup;
    private int m_messageLevel;
    private String m_hostId;
    private String m_hostNwAddr;
    private String m_moduleId;
    private String m_processId;
    private String m_userId;
    private String m_problemKey;
    private Map m_supplAttrs;
    private String m_upstreamCompId;
    private String m_downstreamCompId;
    private InstanceId m_execContextId;
    private InstanceId m_errorInstanceId;
    private String m_messageText;
    private MessageArgument[] m_messageArgs;
    private String m_detailLocation;
    private String m_supplDetail;
    private String m_threadId;

    public LogMessage(String string, String string2, String string3, String string4, MessageType messageType, String string5, int n, String string6, String string7, String string8, String string9, String string10, InstanceId instanceId, InstanceId instanceId2, String string11, MessageArgument[] messageArgumentArray, String string12, String string13) {
        this.m_timestamp = System.currentTimeMillis();
        this.m_organizationId = string != null ? string : s_defaultOrganizationId;
        if (string2 != null) {
            this.m_componentId = string2;
        } else if (s_defaultComponentId != null) {
            this.m_componentId = s_defaultComponentId;
        } else {
            LogManager.getLogManager().getExceptionHandler().onException(new LoggingException("Missing value for componentId"));
            this.m_componentId = null;
        }
        this.m_instanceId = s_defaultInstanceId;
        this.m_messageId = string3;
        this.m_hostingClientId = string4 != null ? string4 : s_defaultHostingClientId;
        this.m_messageType = messageType;
        this.m_messageGroup = string5;
        if (n >= 1 && n <= 32) {
            this.m_messageLevel = n;
        } else {
            LogManager.getLogManager().getExceptionHandler().onException(new LoggingException("Invalid message level"));
            this.m_messageLevel = 16;
        }
        this.m_hostId = s_hostId;
        this.m_hostNwAddr = s_hostNwAddr;
        this.m_moduleId = string6;
        if (string7 != null) {
            this.m_processId = string7;
            this.m_threadId = null;
        } else {
            this.m_processId = LogMessage.getDefaultProcessId();
            this.m_threadId = Thread.currentThread().getName();
        }
        this.m_userId = string8 != null ? string8 : s_defaultUserId;
        this.m_upstreamCompId = string9;
        this.m_downstreamCompId = string10;
        this.m_execContextId = instanceId;
        this.m_errorInstanceId = instanceId2;
        this.m_messageText = string11;
        this.m_messageArgs = messageArgumentArray;
        this.m_detailLocation = string12;
        this.m_supplDetail = string13;
    }

    public LogMessage() {
        this(true);
    }

    public LogMessage(boolean bl) {
        if (bl) {
            this.m_timestamp = System.currentTimeMillis();
            this.m_organizationId = s_defaultOrganizationId;
            this.m_componentId = s_defaultComponentId;
            this.m_instanceId = s_defaultInstanceId;
            this.m_hostingClientId = s_defaultHostingClientId;
            this.m_messageType = MessageType.UNKNOWN;
            this.m_messageLevel = 16;
            this.m_processId = LogMessage.getDefaultProcessId();
            this.m_threadId = Thread.currentThread().getName();
            this.m_hostId = s_hostId;
            this.m_hostNwAddr = s_hostNwAddr;
            this.m_userId = s_defaultUserId;
        } else {
            this.m_messageLevel = 1;
        }
    }

    public LogMessage(Properties properties) {
        String string;
        String string2;
        int n;
        String string3;
        String string4;
        if (properties == null) {
            this.m_organizationId = s_defaultOrganizationId;
            this.m_componentId = s_defaultComponentId;
            this.m_hostingClientId = s_defaultHostingClientId;
            this.m_messageType = MessageType.UNKNOWN;
            this.m_messageLevel = 16;
            this.m_processId = LogMessage.getDefaultProcessId();
            this.m_threadId = Thread.currentThread().getName();
            this.m_userId = s_defaultUserId;
            return;
        }
        StringBuffer stringBuffer = null;
        String string5 = properties.getProperty("TSTZ_ORIGINATING");
        if (string5 == null) {
            this.m_timestamp = System.currentTimeMillis();
        } else {
            try {
                this.m_timestamp = Long.parseLong(string5);
            }
            catch (Exception exception) {
                this.m_timestamp = System.currentTimeMillis();
                stringBuffer = new StringBuffer(string5);
            }
        }
        string5 = properties.getProperty(TSTZ_NORMALIZED);
        if (string5 != null) {
            try {
                this.m_timestampNorm = Long.parseLong(string5);
            }
            catch (Exception exception) {
                this.m_timestampNorm = 0L;
            }
        }
        this.m_hostId = properties.getProperty(HOST_ID);
        if (this.m_hostId == null) {
            this.m_hostId = s_hostId;
        }
        this.m_hostNwAddr = properties.getProperty(HOST_NWADDR);
        if (this.m_hostNwAddr == null) {
            this.m_hostNwAddr = s_hostNwAddr;
        }
        this.m_organizationId = properties.getProperty(ORGANIZATION_ID);
        if (this.m_organizationId == null) {
            this.m_organizationId = s_defaultOrganizationId;
        }
        this.m_componentId = properties.getProperty(COMPONENT_ID);
        if (this.m_componentId == null) {
            this.m_componentId = s_defaultComponentId;
        }
        this.m_instanceId = properties.getProperty(INSTANCE_ID);
        if (this.m_instanceId == null) {
            this.m_instanceId = s_defaultInstanceId;
        }
        this.m_messageId = properties.getProperty(MESSAGE_ID);
        this.m_hostingClientId = properties.getProperty(HOSTING_CLIENT_ID);
        if (this.m_hostingClientId == null) {
            this.m_hostingClientId = s_defaultHostingClientId;
        }
        this.m_messageType = (string4 = properties.getProperty(MESSAGE_TYPE)) != null ? MessageType.getMessageType(string4) : MessageType.UNKNOWN;
        this.m_messageGroup = properties.getProperty(MESSAGE_GROUP);
        String string6 = properties.getProperty(MESSAGE_LEVEL);
        try {
            this.m_messageLevel = Integer.parseInt(string6);
        }
        catch (Exception exception) {
            this.m_messageLevel = 16;
        }
        if (this.m_messageLevel <= 0 || this.m_messageLevel > 32) {
            this.m_messageLevel = 16;
        }
        this.m_moduleId = properties.getProperty(MODULE_ID);
        this.m_processId = properties.getProperty(PROCESS_ID);
        if (this.m_processId == null) {
            this.m_processId = LogMessage.getDefaultProcessId();
        }
        this.m_threadId = properties.getProperty(THREAD_ID);
        if (this.m_threadId == null) {
            this.m_threadId = Thread.currentThread().getName();
        }
        this.m_userId = properties.getProperty(USER_ID);
        if (this.m_userId == null) {
            this.m_userId = s_defaultUserId;
        }
        this.m_problemKey = properties.getProperty(PROBLEM_KEY);
        this.m_upstreamCompId = properties.getProperty(UPSTREAM_COMPONENT_ID);
        this.m_downstreamCompId = properties.getProperty(DOWNSTREAM_COMPONENT_ID);
        String string7 = properties.getProperty(EXEC_CONTEXT_UNIQUE_ID);
        if (string7 != null) {
            string3 = properties.getProperty(EXEC_CONTEXT_SEQ);
            if (string3 != null) {
                try {
                    n = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    n = 0;
                }
            } else {
                n = 0;
            }
            this.m_execContextId = new InstanceId(string7, n);
        }
        if ((string2 = properties.getProperty(ERROR_UNIQUE_ID)) != null) {
            string3 = properties.getProperty(ERROR_SEQ);
            if (string3 != null) {
                try {
                    n = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    n = 0;
                }
            } else {
                n = 0;
            }
            this.m_errorInstanceId = new InstanceId(string2, n);
        }
        this.m_messageText = properties.getProperty(MESSAGE_TEXT);
        this.m_detailLocation = properties.getProperty(DETAIL_LOCATION);
        string5 = properties.getProperty(SUPPL_DETAIL);
        if (string5 != null) {
            if (stringBuffer != null) {
                stringBuffer.append(string5);
            } else {
                stringBuffer = new StringBuffer(string5);
            }
        }
        ArrayList<MessageArgument> arrayList = null;
        int n2 = 0;
        while (true) {
            Object object;
            String string8;
            if ((string8 = properties.getProperty(string = "MSG_ARGS." + n2 + "." + MSG_ARG_VALUE)) == null) {
                if (arrayList == null) break;
                object = new MessageArgument[arrayList.size()];
                this.setMessageArgs(arrayList.toArray((T[])object));
                break;
            }
            object = "MSG_ARGS." + n2 + "." + MSG_ARG_NAME;
            String string9 = properties.getProperty((String)object);
            MessageArgument messageArgument = new MessageArgument(string9, string8);
            if (arrayList == null) {
                arrayList = new ArrayList<MessageArgument>();
            }
            arrayList.add(messageArgument);
            ++n2;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (s_messageProperties.containsKey(string) || string.startsWith(MSG_ARGS)) continue;
            if (this.m_supplAttrs == null) {
                this.m_supplAttrs = new HashMap();
            }
            this.m_supplAttrs.put(string, properties.getProperty(string));
        }
        this.m_supplDetail = stringBuffer != null ? stringBuffer.toString() : null;
    }

    public void setTimestamp(long l) {
        this.m_timestamp = l;
    }

    public void setNormalizedTimestamp(long l) {
        this.m_timestampNorm = l;
    }

    public void setOrganizationId(String string) {
        this.m_organizationId = string;
    }

    public void setComponentId(String string) {
        this.m_componentId = string;
    }

    public void setInstanceId(String string) {
        this.m_instanceId = string;
    }

    public void setMessageId(String string) {
        this.m_messageId = string;
    }

    public void setHostingClientId(String string) {
        this.m_hostingClientId = string;
    }

    public void setMessageType(MessageType messageType) {
        this.m_messageType = messageType;
    }

    public void setMessageGroup(String string) {
        this.m_messageGroup = string;
    }

    public void setMessageLevel(int n) {
        if (n >= 1 && n <= 32) {
            this.m_messageLevel = n;
        } else {
            LogManager.getLogManager().getExceptionHandler().onException(new LoggingException("Invalid message level"));
            this.m_messageLevel = 16;
        }
    }

    public void setHostId(String string) {
        this.m_hostId = string;
    }

    public void setHostNwAddr(String string) {
        this.m_hostNwAddr = string;
    }

    public void setModuleId(String string) {
        this.m_moduleId = string;
    }

    public void setProcessId(String string) {
        this.m_processId = string;
    }

    public void setThreadId(String string) {
        this.m_threadId = string;
    }

    public void setUserId(String string) {
        this.m_userId = string;
    }

    public void setProblemKey(String string) {
        this.m_problemKey = string;
    }

    public void setSupplAttrs(Map map) {
        this.m_supplAttrs = map;
    }

    public void setUpstreamCompId(String string) {
        this.m_upstreamCompId = string;
    }

    public void setDownstreamCompId(String string) {
        this.m_downstreamCompId = string;
    }

    public void setExecContextId(InstanceId instanceId) {
        this.m_execContextId = instanceId;
    }

    public void setErrorInstanceId(InstanceId instanceId) {
        this.m_errorInstanceId = instanceId;
    }

    public void setMessageText(String string) {
        this.m_messageText = string;
    }

    public void setMessageArgs(MessageArgument[] messageArgumentArray) {
        this.m_messageArgs = messageArgumentArray;
    }

    public void setDetailLocation(String string) {
        this.m_detailLocation = string;
    }

    public void setSupplementalDetail(String string) {
        this.m_supplDetail = string;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public long getNormalizedTimestamp() {
        return this.m_timestampNorm;
    }

    public String getOrganizationId() {
        return this.m_organizationId;
    }

    public String getComponentId() {
        return this.m_componentId;
    }

    public String getInstanceId() {
        return this.m_instanceId;
    }

    public String getMessageId() {
        return this.m_messageId;
    }

    public String getHostingClientId() {
        return this.m_hostingClientId;
    }

    public MessageType getMessageType() {
        return this.m_messageType;
    }

    public String getMessageGroup() {
        return this.m_messageGroup;
    }

    public int getMessageLevel() {
        return this.m_messageLevel;
    }

    public String getHostId() {
        return this.m_hostId;
    }

    public String getHostNwAddr() {
        return this.m_hostNwAddr;
    }

    public String getModuleId() {
        return this.m_moduleId;
    }

    public String getProcessId() {
        return this.m_processId;
    }

    public String getUserId() {
        return this.m_userId;
    }

    public String getProblemKey() {
        return this.m_problemKey;
    }

    public Map getSupplAttrs() {
        return this.m_supplAttrs;
    }

    public String getUpstreamCompId() {
        return this.m_upstreamCompId;
    }

    public String getDownstreamCompId() {
        return this.m_downstreamCompId;
    }

    public InstanceId getExecContextId() {
        return this.m_execContextId;
    }

    public InstanceId getErrorInstanceId() {
        return this.m_errorInstanceId;
    }

    public String getMessageText() {
        return this.m_messageText;
    }

    public MessageArgument[] getMessageArgs() {
        return this.m_messageArgs;
    }

    public String getDetailLocation() {
        return this.m_detailLocation;
    }

    public String getSupplDetail() {
        return this.m_supplDetail;
    }

    public String getThreadId() {
        return this.m_threadId;
    }

    static void initDefaultValues() {
        LogManager logManager = LogManager.getLogManager();
        s_defaultOrganizationId = logManager.getProperty(ORG_ID_PROP, null);
        s_defaultComponentId = logManager.getProperty(COMP_ID_PROP, null);
        s_defaultHostingClientId = logManager.getProperty(HOST_CLIENT_ID_PROP, null);
        s_defaultInstanceId = logManager.getProperty(INSTANCE_ID_PROP, null);
    }

    private static void init() {
        try {
            s_hostId = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            LogManager.getLogManager().getExceptionHandler().onException(exception);
            s_hostId = null;
        }
        try {
            s_hostNwAddr = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            LogManager.getLogManager().getExceptionHandler().onException(exception);
            s_hostNwAddr = null;
        }
        try {
            s_defaultUserId = System.getProperty("user.name");
        }
        catch (Exception exception) {
            s_defaultUserId = null;
        }
        s_messageProperties = new HashMap();
        s_messageProperties.put(ORGANIZATION_ID, "");
        s_messageProperties.put(COMPONENT_ID, "");
        s_messageProperties.put(INSTANCE_ID, "");
        s_messageProperties.put(MESSAGE_ID, "");
        s_messageProperties.put(HOSTING_CLIENT_ID, "");
        s_messageProperties.put(MESSAGE_TYPE, "");
        s_messageProperties.put(MESSAGE_GROUP, "");
        s_messageProperties.put(MESSAGE_LEVEL, "");
        s_messageProperties.put(MODULE_ID, "");
        s_messageProperties.put(PROCESS_ID, "");
        s_messageProperties.put(THREAD_ID, "");
        s_messageProperties.put(USER_ID, "");
        s_messageProperties.put(UPSTREAM_COMPONENT_ID, "");
        s_messageProperties.put(DOWNSTREAM_COMPONENT_ID, "");
        s_messageProperties.put(EXEC_CONTEXT_UNIQUE_ID, "");
        s_messageProperties.put(EXEC_CONTEXT_SEQ, "");
        s_messageProperties.put(ERROR_UNIQUE_ID, "");
        s_messageProperties.put(ERROR_SEQ, "");
        s_messageProperties.put(MESSAGE_TEXT, "");
        s_messageProperties.put(DETAIL_LOCATION, "");
        s_messageProperties.put(SUPPL_DETAIL, "");
        s_messageProperties.put("TSTZ_ORIGINATING", "");
        s_messageProperties.put(HOST_ID, "");
        s_messageProperties.put(HOST_NWADDR, "");
        s_messageProperties.put(PROBLEM_KEY, "");
    }

    static String getDefaultProcessId() {
        return LogManager.getLogManager().getProcessId();
    }

    static {
        s_defaultOrganizationId = null;
        s_defaultComponentId = null;
        s_defaultHostingClientId = null;
        s_hostId = null;
        s_hostNwAddr = null;
        s_defaultUserId = null;
        s_defaultInstanceId = null;
        LogMessage.init();
    }

    public static class InstanceId
    implements Serializable {
        private String m_uniqueId;
        private int m_sequenceNum;

        public InstanceId(String string, int n) {
            this.m_uniqueId = string;
            this.m_sequenceNum = n;
        }

        public String getUniqueId() {
            return this.m_uniqueId;
        }

        public int getSequenceNumber() {
            return this.m_sequenceNum;
        }
    }

    public static class MessageArgument
    implements Serializable {
        private String m_name;
        private String m_value;

        public MessageArgument(String string, String string2) {
            this.m_name = string;
            this.m_value = string2;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

