/*
 * Decompiled with CFR 0.152.
 */
package tdg.utilities.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import tdg.utilities.beans.TDGSimplePropertyDescriptor;

public abstract class TDGSimpleBeanInfo
extends SimpleBeanInfo {
    private final String ERRORMESSAGE = " Icon not found.";
    protected TDGSimplePropertyDescriptor[] pDescInits;
    protected Class beanClass;

    protected abstract TDGSimplePropertyDescriptor[] getPropertyDescriptionInits();

    protected abstract Class getBeanClass();

    public abstract String getIcon16FileName();

    public abstract String getIcon32FileName();

    public abstract String getBeanDescription();

    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor bd = new BeanDescriptor(this.getBeanClass());
        bd.setShortDescription(this.getBeanDescription());
        return bd;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        this.pDescInits = this.getPropertyDescriptionInits();
        this.beanClass = this.getBeanClass();
        PropertyDescriptor[] beanProps = new PropertyDescriptor[this.pDescInits.length];
        int i = 0;
        while (i < this.pDescInits.length) {
            String propertyName = this.pDescInits[i].propertyName;
            String getterName = this.pDescInits[i].getterName;
            String setterName = this.pDescInits[i].setterName;
            Class propertyEditor = this.pDescInits[i].propertyEditor;
            boolean expert = this.pDescInits[i].expert;
            boolean bound = this.pDescInits[i].bound;
            boolean constrained = this.pDescInits[i].constrained;
            boolean hidden = this.pDescInits[i].hidden;
            try {
                beanProps[i] = new PropertyDescriptor(propertyName, this.beanClass, getterName, setterName);
            }
            catch (IntrospectionException fatalException) {
                System.err.println(this.getClass().getName() + " getProps() data does not agree with introspected reality!");
                System.err.println(fatalException);
                System.exit(10);
            }
            if (propertyEditor != null) {
                beanProps[i].setPropertyEditorClass(propertyEditor);
            }
            beanProps[i].setExpert(expert);
            beanProps[i].setBound(bound);
            beanProps[i].setConstrained(constrained);
            beanProps[i].setHidden(hidden);
            ++i;
        }
        return beanProps;
    }

    public Image getIcon(int iconKind) {
        if (iconKind == 1 || iconKind == 3) {
            Image im = this.loadImage(this.getIcon16FileName());
            if (im == null) {
                System.err.println("BeanInfo: could not find Icon 16x16");
            }
            return im;
        }
        if (iconKind == 2 || iconKind == 4) {
            Image im = this.loadImage(this.getIcon32FileName());
            if (im == null) {
                System.err.println("BeanInfo: could not find Icon 32x32");
            }
            return im;
        }
        System.err.println(this.getBeanClass() + " Icon not found.");
        return null;
    }
}

