/*
 * Decompiled with CFR 0.152.
 */
package tdg.utilities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class TDGGraphicsKit {
    public static void drawHorizontal(Graphics g, int x1, int x2, int y) {
        g.drawLine(x1, y, x2, y);
    }

    public static void drawVertical(Graphics g, int y1, int y2, int x) {
        g.drawLine(x, y1, x, y2);
    }

    public static void drawPixel(Graphics g, int x, int y) {
        g.drawLine(x, y, x, y);
    }

    public static void wipeImage(Image image, Color color, ImageObserver observer) {
        Graphics g = image.getGraphics();
        int width = image.getWidth(observer);
        int height = image.getHeight(observer);
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        g.dispose();
    }

    public static void drawCenteredString(Graphics g, String str, int width, int height, FontMetrics fm) {
        Dimension rect = new Dimension(width, height);
        TDGGraphicsKit.drawCenteredString(g, str, rect, fm);
    }

    public static void drawCenteredString(Graphics g, String str, Dimension rect, FontMetrics fm) {
        int stringWidth = fm.stringWidth(str);
        int stringAscent = fm.getAscent();
        int centerBoxX = rect.width / 2 - stringWidth / 2;
        int centerBoxY = rect.height / 2 + stringAscent / 2;
        g.drawString(str, centerBoxX, centerBoxY);
    }

    public static Image loadImage(URL imageURL) throws Exception {
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getImage(imageURL);
    }
}

