/*
 * Decompiled with CFR 0.152.
 */
package tdg.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import tdg.CategoryIF;
import tdg.Perspective;
import tdg.event.TDGErrorManager;

public class FTPSession {
    static final CategoryIF LOG = Perspective.getInstance("UTIL.FTPSession");
    Socket m_ftpSocket = null;
    PrintStream m_outStream = null;
    BufferedReader m_inStream = null;
    String ServerMessage = null;
    private TDGErrorManager m_errorManager = null;

    public FTPSession(TDGErrorManager errMgr, String strHost) {
        this.m_errorManager = errMgr;
        try {
            this.m_ftpSocket = new Socket(strHost, 21);
            this.m_outStream = new PrintStream(this.m_ftpSocket.getOutputStream());
            this.m_inStream = new BufferedReader(new InputStreamReader(this.m_ftpSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            LOG.warn("Can't resolve host: " + strHost);
            return;
        }
        catch (IOException e) {
            LOG.warn("IO error connecting to: " + strHost);
            return;
        }
        if (this.m_ftpSocket != null && this.m_outStream != null && this.m_inStream != null) {
            this.getServerResponse(this.m_inStream);
        }
    }

    public synchronized int getServerResponse(BufferedReader m_inStream) {
        String endCode = "000";
        try {
            String currentLine;
            String completeResponse = currentLine = m_inStream.readLine();
            endCode = currentLine.substring(0, 3) + " ";
            if (currentLine.charAt(3) == '-') {
                endCode = currentLine.substring(0, 3) + " ";
                while ((currentLine = m_inStream.readLine()) != null) {
                    completeResponse = completeResponse + System.getProperty("line.separator") + currentLine;
                    if (currentLine.length() <= 3 || !currentLine.substring(0, 4).equals(endCode)) continue;
                }
            }
            this.ServerMessage = completeResponse;
        }
        catch (IOException e) {
            this.m_errorManager.notifyErrorListener(this, 3970, "Error reading multi-line response", null);
            this.ServerMessage = "000";
        }
        this.m_errorManager.notifyErrorListener(this, 3970, this.ServerMessage, null);
        return Integer.parseInt(endCode.substring(0, 1));
    }

    public boolean listenPort(ServerSocket socket, BufferedReader inPort, PrintStream outPort) {
        InetAddress localip;
        int localport = socket.getLocalPort();
        this.m_errorManager.notifyErrorListener(this, 3970, "Will listen on port, " + localport, null);
        InetAddress inetaddress = socket.getInetAddress();
        try {
            localip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.warn("can't get local host");
            return false;
        }
        byte[] addrbytes = localip.getAddress();
        short[] addrshorts = new short[4];
        int i = 0;
        while (i <= 3) {
            addrshorts[i] = addrbytes[i];
            if (addrshorts[i] < 0) {
                int n = i;
                addrshorts[n] = (short)(addrshorts[n] + 256);
            }
            ++i;
        }
        outPort.println("port " + addrshorts[0] + "," + addrshorts[1] + "," + addrshorts[2] + "," + addrshorts[3] + "," + ((localport & 0xFF00) >> 8) + "," + (localport & 0xFF));
        int result = this.getServerResponse(inPort);
        return result == 2;
    }

    public void logOff() {
        if (this.m_ftpSocket == null || this.m_outStream == null || this.m_inStream == null) {
            return;
        }
        this.m_outStream.println("QUIT");
        this.m_outStream.flush();
        this.getServerResponse(this.m_inStream);
        try {
            this.m_outStream.close();
            this.m_inStream.close();
            this.m_ftpSocket.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close FTP connections...");
        }
    }

    public void logOn(String strUser, String strPassword) {
        if (this.m_ftpSocket == null || this.m_outStream == null || this.m_inStream == null) {
            return;
        }
        this.m_outStream.println("USER " + strUser);
        this.m_outStream.flush();
        this.getServerResponse(this.m_inStream);
        this.m_outStream.println("PASS " + strPassword);
        this.m_outStream.flush();
        this.getServerResponse(this.m_inStream);
    }

    public int sendCommand(String strCommand) {
        if (this.m_ftpSocket == null || this.m_outStream == null || this.m_inStream == null) {
            return 0;
        }
        this.m_outStream.println(strCommand);
        this.m_outStream.flush();
        int nResult = this.getServerResponse(this.m_inStream);
        return nResult;
    }

    /*
     * WARNING - void declaration
     */
    public boolean uploadFile(String strFilename) {
        ServerSocket serverSocket = null;
        Socket clientSocket = null;
        if (this.m_ftpSocket == null || this.m_outStream == null || this.m_inStream == null) {
            return false;
        }
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            LOG.warn("Could not get port for listening...");
            return false;
        }
        this.listenPort(serverSocket, this.m_inStream, this.m_outStream);
        this.m_outStream.println("type i");
        this.m_outStream.flush();
        this.getServerResponse(this.m_inStream);
        this.m_outStream.println("STOR " + strFilename);
        this.m_outStream.flush();
        int result = this.getServerResponse(this.m_inStream);
        this.m_errorManager.notifyErrorListener(this, 3970, "STOR " + strFilename, null);
        if (result == 1) {
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                LOG.warn("Accept failed!");
            }
            try {
                int nCount;
                OutputStream outdataport = clientSocket.getOutputStream();
                byte[] b = new byte[1024];
                RandomAccessFile infile = new RandomAccessFile(strFilename, "r");
                while ((nCount = infile.read(b)) > 0) {
                    void var3_12;
                    outdataport.write(b, 0, (int)var3_12);
                }
                this.m_errorManager.notifyErrorListener(this, 3970, "File Transfered!", null);
                infile.close();
                outdataport.close();
                clientSocket.close();
                serverSocket.close();
                result = this.getServerResponse(this.m_inStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result == 2;
        }
        this.m_errorManager.notifyErrorListener(this, 3970, "Server not ready for upload!", null);
        try {
            serverSocket.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing server socket.");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean uploadFile(String strFilename, InputStream streamFileSrc) {
        ServerSocket serverSocket = null;
        Socket clientSocket = null;
        if (this.m_ftpSocket == null || this.m_outStream == null || this.m_inStream == null) {
            return false;
        }
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            LOG.warn("Could not get port for listening...");
            return false;
        }
        this.listenPort(serverSocket, this.m_inStream, this.m_outStream);
        this.m_outStream.println("type i");
        this.m_outStream.flush();
        this.getServerResponse(this.m_inStream);
        this.m_outStream.println("STOR " + strFilename);
        this.m_outStream.flush();
        int result = this.getServerResponse(this.m_inStream);
        this.m_errorManager.notifyErrorListener(this, 3970, "STOR " + strFilename, null);
        if (result == 1) {
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                LOG.warn("Accept failed!");
            }
            try {
                int nCount;
                OutputStream outdataport = clientSocket.getOutputStream();
                byte[] b = new byte[1024];
                streamFileSrc.reset();
                this.m_errorManager.notifyErrorListener(this, 3970, "Bytes in stream: " + streamFileSrc.available(), null);
                while ((nCount = streamFileSrc.read(b)) > 0) {
                    void var4_12;
                    outdataport.write(b, 0, (int)var4_12);
                }
                this.m_errorManager.notifyErrorListener(this, 3970, "Done!", null);
                outdataport.close();
                clientSocket.close();
                serverSocket.close();
                result = this.getServerResponse(this.m_inStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result == 2;
        }
        this.m_errorManager.notifyErrorListener(this, 3970, "Server not ready for upload!", null);
        try {
            serverSocket.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing server socket.");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean downloadFile(String strFilename, OutputStream streamFileSrc) {
        ServerSocket serverSocket = null;
        Socket clientSocket = null;
        if (this.m_ftpSocket == null || this.m_outStream == null || this.m_inStream == null) {
            return false;
        }
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            LOG.warn("Could not get port for listening...");
            return false;
        }
        this.listenPort(serverSocket, this.m_inStream, this.m_outStream);
        this.m_outStream.println("type i");
        this.m_outStream.flush();
        this.getServerResponse(this.m_inStream);
        this.m_outStream.println("RETR " + strFilename);
        this.m_outStream.flush();
        int result = this.getServerResponse(this.m_inStream);
        this.m_errorManager.notifyErrorListener(this, 3970, "RETR " + strFilename, null);
        if (result == 1) {
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                LOG.warn("Accept failed!");
            }
            try {
                int nCount;
                InputStream indataport = clientSocket.getInputStream();
                byte[] b = new byte[1024];
                this.m_errorManager.notifyErrorListener(this, 3970, "Bytes in stream: " + indataport.available(), null);
                while ((nCount = indataport.read(b)) > 0) {
                    void var4_12;
                    streamFileSrc.write(b, 0, (int)var4_12);
                }
                this.m_errorManager.notifyErrorListener(this, 3970, "Done!", null);
                indataport.close();
                clientSocket.close();
                serverSocket.close();
            }
            catch (IOException e) {
                LOG.error("download from FTP failed, error: ", e);
            }
            return result == 2;
        }
        this.m_errorManager.notifyErrorListener(this, 3970, "Server not ready for upload!", null);
        try {
            serverSocket.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing server socket.");
        }
        return false;
    }
}

