/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import com.threedgraphics.math.FP;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetObj;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;

public class DetPolygon
extends DetObj {
    Polygon m_polygon;
    Polygon m_destPolygon;
    double m_fIntensity;
    Area m_area;

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity) {
        super(detectiv, id, blackBox, null, false, true, true);
        this.m_polygon = poly;
        this.m_fIntensity = fIntensity;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable) {
        this(detectiv, id, poly, blackBox, null, fIntensity, bHiliteable);
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, double fIntensity, boolean bHiliteable, Area area) {
        this(detectiv, id, poly, blackBox, null, fIntensity, bHiliteable);
        this.m_area = area;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect) {
        this(detectiv, id, poly, blackBox, clipRect, 1.0, true);
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox) {
        super(detectiv, id, blackBox, null, false, true, true);
        this.m_fIntensity = 1.0;
        this.m_destPolygon = poly;
    }

    public DetPolygon(Detectiv detectiv, IdentObj id, Polygon poly, BlackBoxIF blackBox, Rectangle clipRect, double fIntensity, boolean bHiliteable) {
        super(detectiv, id, blackBox, clipRect, false, true, bHiliteable);
        this.m_polygon = poly;
        this.m_fIntensity = fIntensity;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetPolygon)) {
            return false;
        }
        DetPolygon detPolygon = (DetPolygon)obj;
        return this.m_id.equals(detPolygon.m_id);
    }

    public Rectangle getBounds() {
        if (this.m_destPolygon != null) {
            return this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_destPolygon).getBounds();
        }
        return this.m_polygon.getBounds();
    }

    public void hilite(Graphics g, VC vc) {
        g.setXORMode(Color.yellow);
        if (this.m_destPolygon != null) {
            g.drawPolygon(this.m_destPolygon);
        } else if (g instanceof Graphics2D && this.m_Detectiv.getPerspective().isPie()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.draw(vc.virtToDestPath(this.m_polygon));
        } else {
            Polygon dest = vc.virtToDest(this.m_polygon);
            g.drawPolygon(dest);
        }
        g.setPaintMode();
    }

    public boolean isPointInObj(int x, int y, VC vc) {
        if (this.m_destPolygon != null) {
            return this.m_bDetectable && this.m_destPolygon.contains(vc.virtToDestX(x), vc.virtToDestY(y));
        }
        return this.m_bDetectable && this.m_polygon.contains(x, y);
    }

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    public void paintIt(Graphics g, VC vc) {
        Polygon pDest = null;
        GeneralPath path = null;
        if (this.m_destPolygon != null) {
            pDest = this.m_destPolygon;
        } else if (this.m_area == null && g instanceof Graphics2D && this.m_Detectiv.getPerspective().isPie()) {
            path = vc.virtToDestPath(this.m_polygon);
        } else {
            pDest = vc.virtToDest(this.m_polygon);
        }
        if (FP.equal(this.m_fIntensity, 1.0) || this.m_blackBox.getFillType() != 1) {
            this.paint(g, pDest, this.m_area, path);
        } else {
            Color colorOrig = this.m_blackBox.getFillColor();
            if (colorOrig == null) {
                this.paint(g, pDest, this.m_area, path);
            } else {
                double fR = (double)colorOrig.getRed() * this.m_fIntensity;
                double fG = (double)colorOrig.getGreen() * this.m_fIntensity;
                double fB = (double)colorOrig.getBlue() * this.m_fIntensity;
                this.m_blackBox.setFillColor(new Color(FP.round(fR), FP.round(fG), FP.round(fB)));
                this.paint(g, pDest, this.m_area, path);
                this.m_blackBox.setFillColor(colorOrig);
            }
        }
    }

    public void paint(Graphics g, Polygon p, Area area, GeneralPath path) {
        if (this.m_area != null && g instanceof Graphics2D) {
            this.m_blackBox.paint(g, this.m_area);
        } else if (g instanceof Graphics2D && this.m_Detectiv.getPerspective().isPie()) {
            this.m_blackBox.paint(g, path);
        } else {
            this.m_blackBox.paint(g, p);
        }
    }

    public void setBounds(Rectangle rBounds) {
    }

    public Polygon getShape(VC vc) {
        if (this.m_destPolygon != null) {
            return vc.destToVirt(this.m_destPolygon);
        }
        return this.m_polygon;
    }
}

