/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.io.Serializable;
import tdg.AssertionException;

public class ColorObj
implements Serializable {
    static final int HSB_HUE = 0;
    static final int HSB_SATURATION = 1;
    static final int HSB_BRIGHTNESS = 2;
    private double m_fRed;
    private double m_fGreen;
    private double m_fBlue;
    private double m_fAlpha;

    public ColorObj() {
        this.m_fAlpha = 1.0;
        this.m_fBlue = 1.0;
        this.m_fGreen = 1.0;
        this.m_fRed = 1.0;
    }

    public ColorObj(double r, double g, double b, double a) {
        this.setColor(r, g, b, a);
    }

    public ColorObj(int r, int g, int b, int a) {
        this.setColor(r, g, b, a);
    }

    public ColorObj(Color color) {
        this.setColor(color);
    }

    public ColorObj(ColorObj color) {
        this.m_fRed = color.m_fRed;
        this.m_fGreen = color.m_fGreen;
        this.m_fBlue = color.m_fBlue;
        this.m_fAlpha = color.m_fAlpha;
    }

    public void copy(ColorObj color) {
        this.m_fRed = color.m_fRed;
        this.m_fGreen = color.m_fGreen;
        this.m_fBlue = color.m_fBlue;
        this.m_fAlpha = color.m_fAlpha;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColorObj)) {
            return false;
        }
        ColorObj co = (ColorObj)obj;
        boolean bEqual = this.m_fRed == co.m_fRed && this.m_fGreen == co.m_fGreen && this.m_fBlue == co.m_fBlue && this.m_fAlpha == co.m_fAlpha;
        return bEqual;
    }

    public double getAlpha() {
        return this.m_fAlpha;
    }

    public double getBlue() {
        return this.m_fBlue;
    }

    public Color getColor() {
        Color color = new Color((int)(this.m_fRed * 255.0), (int)(this.m_fGreen * 255.0), (int)(this.m_fBlue * 255.0));
        return color;
    }

    public double getGreen() {
        return this.m_fGreen;
    }

    public double getRed() {
        return this.m_fRed;
    }

    public void setAlpha(double fAlpha) {
        if (fAlpha < 0.0 || fAlpha > 1.0) {
            throw new AssertionException(0.0, 1.0, fAlpha);
        }
        this.m_fAlpha = fAlpha;
    }

    public void setBlue(double fBlue) {
        if (fBlue < 0.0 || fBlue > 1.0) {
            throw new AssertionException(0.0, 1.0, fBlue);
        }
        this.m_fBlue = fBlue;
    }

    public void setColor(double r, double g, double b, double a) {
        if (r < 0.0 || r > 1.0) {
            throw new AssertionException(0.0, 1.0, r);
        }
        if (g < 0.0 || g > 1.0) {
            throw new AssertionException(0.0, 1.0, g);
        }
        if (b < 0.0 || b > 1.0) {
            throw new AssertionException(0.0, 1.0, b);
        }
        if (a < 0.0 || a > 1.0) {
            throw new AssertionException(0.0, 1.0, a);
        }
        this.m_fRed = r;
        this.m_fGreen = g;
        this.m_fBlue = b;
        this.m_fAlpha = a;
    }

    public void setColor(int r, int g, int b, int a) {
        if (r < 0 || r > 255) {
            throw new AssertionException(0, 255, r);
        }
        if (g < 0 || g > 255) {
            throw new AssertionException(0, 255, g);
        }
        if (b < 0 || b > 255) {
            throw new AssertionException(0, 255, b);
        }
        if (a < 0 || a > 255) {
            throw new AssertionException(0, 255, a);
        }
        this.m_fRed = 1.0 * (double)r / 255.0;
        this.m_fGreen = 1.0 * (double)g / 255.0;
        this.m_fBlue = 1.0 * (double)b / 255.0;
        this.m_fAlpha = 1.0 * (double)a / 255.0;
    }

    public void setColor(Color color) {
        this.m_fRed = 1.0 * (double)color.getRed() / 255.0;
        this.m_fGreen = 1.0 * (double)color.getGreen() / 255.0;
        this.m_fBlue = 1.0 * (double)color.getBlue() / 255.0;
        this.m_fAlpha = 1.0;
    }

    public void setGreen(double fGreen) {
        if (fGreen < 0.0 || fGreen > 1.0) {
            throw new AssertionException(0.0, 1.0, fGreen);
        }
        this.m_fGreen = fGreen;
    }

    public void setRed(double fRed) {
        if (fRed < 0.0 || fRed > 1.0) {
            throw new AssertionException(0.0, 1.0, fRed);
        }
        this.m_fRed = fRed;
    }

    public void shadeColor(int nShading) {
        if (nShading < 0 || nShading > 100) {
            throw new AssertionException(0, 100, nShading);
        }
        Color color = this.getColor();
        float[] HSB = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        HSB[2] = HSB[2] * (float)nShading / 100.0f;
        color = new Color(Color.HSBtoRGB(HSB[0], HSB[1], HSB[2]));
        this.m_fRed = 1.0 * (double)color.getRed() / 255.0;
        this.m_fGreen = 1.0 * (double)color.getGreen() / 255.0;
        this.m_fBlue = 1.0 * (double)color.getBlue() / 255.0;
        this.m_fAlpha = 1.0;
    }
}

