/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import tdg.AxisDescriptor;
import tdg.CircularAxisObj;
import tdg.JChart_2D_Standard;
import tdg.JChart_Base;
import tdg.JGraphType;
import tdg.Perspective;
import tdg.RelativeAxisObj;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLine;
import tdg.draw.DetOval;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class ReferenceLineObj
implements Serializable {
    protected Perspective m_Perspective;
    protected IdentObj m_id;
    protected Point pt1;
    protected Point pt2;
    protected int m_nLineWidth = 1;
    protected int m_lineStyle = 0;
    protected int m_nNdx;
    protected Point m_frameDepthOffset;
    protected String m_szLabel;
    protected IdentObj m_AxisObj = null;
    protected double m_nValue;
    protected boolean m_bDrawWithDepth;
    protected Rectangle m_frameRect;
    protected int m_nAxisID;
    protected int m_axisLineObjID;
    protected int m_nSIndex;
    private String m_szFontName;
    private int m_nFontStyle;
    private int m_nFontSize;
    private int m_nFontSizeVC;
    private TextStyleObj m_textStyle;
    private Rectangle m_rFrameVC = new Rectangle();
    private Point m_centerFramePosVC = new Point(0, 0);
    private double m_relVal;
    DetLine m_LineObj;
    int m_nWidthVC;
    JChart_Base m_chart = null;
    int sID;

    public ReferenceLineObj(Perspective perspective, IdentObj axisObj, int nNdx, double nValue) {
        this.m_Perspective = perspective;
        this.m_nAxisID = axisObj.getObjectID();
        IdentObj idl = null;
        boolean axisID = false;
        switch (this.m_nAxisID) {
            case 2004: {
                idl = this.m_Perspective.getY1AxisLine();
                break;
            }
            case 2005: {
                idl = this.m_Perspective.getY2AxisLine();
                break;
            }
            case 2003: {
                idl = this.m_Perspective.getX1AxisLine();
            }
        }
        this.m_axisLineObjID = idl.getObjectID();
        this.m_id = new IdentObj(358, nNdx, this.m_axisLineObjID);
        this.m_nNdx = nNdx;
        this.m_AxisObj = axisObj;
        this.m_nValue = nValue;
        this.m_Perspective.setDisplay(this.m_Perspective.getReferenceLineLegendText(this.m_AxisObj, this.m_nNdx), false);
        this.m_Perspective.setFillColor(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx), new Color(0, 0, 0));
        switch (this.m_nAxisID) {
            case 2004: {
                this.sID = 3000;
                break;
            }
            case 2005: {
                this.sID = 4000;
                break;
            }
            case 2003: {
                this.sID = 5000;
                break;
            }
            default: {
                this.sID = this.m_nAxisID;
            }
        }
        this.m_nSIndex = this.sID + this.m_nNdx + (int)this.m_nValue + 1;
    }

    public void calc() {
        double val;
        JGraphType gt = this.m_Perspective.getJGraphType();
        this.m_chart = this.m_Perspective.getGraphObject();
        if (!(gt.isBLAType() || gt.isPolar() || gt.isRadarType() || gt.isScatter() || gt.isBubble())) {
            return;
        }
        if (!this.checkValidAxis(this.m_AxisObj, this.m_nAxisID, this.m_chart)) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_id);
        this.m_nLineWidth = this.m_Perspective.getLineWidth(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx));
        this.m_lineStyle = this.m_Perspective.getLineStyle(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx));
        int nWidth = this.m_nLineWidth;
        if (this.m_nLineWidth == 0) {
            nWidth = 1;
        }
        this.m_nWidthVC = this.m_Perspective.m_VC.destToVirtWidth(nWidth);
        blackBox.setBorderColor(this.m_Perspective.getFillColor(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx)));
        blackBox.setFillColor(this.m_Perspective.getFillColor(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx)));
        this.m_bDrawWithDepth = this.m_Perspective.getDepthRadius() > 0;
        this.m_frameDepthOffset = this.m_Perspective.getFrameDepthOffset();
        this.m_frameRect = this.m_Perspective.getFrameRect(true);
        this.m_szLabel = this.m_Perspective.getTextString(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx));
        this.m_frameRect = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        JChart_2D_Standard ch2 = (JChart_2D_Standard)this.m_chart;
        RelativeAxisObj aObj = null;
        if (this.m_nAxisID == 2004) {
            aObj = ch2.getY1Axis();
            if (aObj != null) {
                val = this.m_nValue;
                if (gt.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                    val = this.m_nValue / 100.0;
                }
                if (aObj.isVertical()) {
                    int y = (int)aObj.getValueCoord(val);
                    this.pt1 = new Point(this.m_frameRect.x, y);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, y);
                    this.m_relVal = aObj.getValueRelCoord(val);
                } else {
                    int x = (int)aObj.getValueCoord(val);
                    this.pt1 = new Point(x, this.m_frameRect.y);
                    this.pt2 = new Point(x, this.m_frameRect.y + this.m_frameRect.height);
                    this.m_relVal = aObj.getValueRelCoord(val);
                }
            }
        } else if (this.m_nAxisID == 2003) {
            aObj = ch2.getX1Axis();
            if (aObj != null) {
                val = this.m_nValue;
                if (gt.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                    val = this.m_nValue / 100.0;
                }
                if (aObj.isVertical()) {
                    int y = (int)aObj.getValueCoord(val);
                    this.pt1 = new Point(this.m_frameRect.x, y);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, y);
                    this.m_relVal = aObj.getValueRelCoord(val);
                } else {
                    int x = (int)aObj.getValueCoord(val);
                    this.pt1 = new Point(x, this.m_frameRect.y);
                    this.pt2 = new Point(x, this.m_frameRect.y + this.m_frameRect.height);
                    this.m_relVal = aObj.getValueRelCoord(val);
                }
            }
        } else if (this.m_nAxisID == 2005 && (aObj = ch2.getY2Axis()) != null) {
            val = this.m_nValue;
            if (gt.isParetoType() || gt.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                val = this.m_nValue / 100.0;
            }
            if (aObj.isVertical()) {
                if (gt.isParetoType()) {
                    double valFromRelCoord = aObj.getValueFromRelCoord(val);
                    int y = (int)aObj.getValueCoord(valFromRelCoord);
                    this.pt1 = new Point(this.m_frameRect.x, y);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, y);
                    this.m_relVal = val;
                } else {
                    int y = (int)aObj.getValueCoord(val);
                    this.pt1 = new Point(this.m_frameRect.x, y);
                    this.pt2 = new Point(this.m_frameRect.x + this.m_frameRect.width, y);
                    this.m_relVal = aObj.getValueRelCoord(val);
                }
            } else if (gt.isParetoType()) {
                double valFromRelCoord = aObj.getValueFromRelCoord(val);
                int x = (int)aObj.getValueCoord(valFromRelCoord);
                this.pt1 = new Point(x, this.m_frameRect.y);
                this.pt2 = new Point(x, this.m_frameRect.y + this.m_frameRect.height);
                this.m_relVal = val;
            } else {
                int x = (int)aObj.getValueCoord(val);
                this.pt1 = new Point(x, this.m_frameRect.y);
                this.pt2 = new Point(x, this.m_frameRect.y + this.m_frameRect.height);
                this.m_relVal = aObj.getValueRelCoord(val);
            }
        }
        if (aObj != null) {
            double max = aObj.getMaxValue();
            double min = aObj.getMinValue();
            if (gt.isParetoType() && this.m_nAxisID == 2005) {
                double val2 = this.m_nValue / 100.0;
                double valFromRelCoord = aObj.getValueFromRelCoord(val2);
                if (valFromRelCoord > max || valFromRelCoord < min) {
                    return;
                }
            } else {
                double val3 = this.m_nValue;
                if (gt.isPercent() && this.m_nValue > 1.0 && this.m_nValue <= 100.0) {
                    val3 = this.m_nValue / 100.0;
                }
                if (val3 > max || val3 < min) {
                    return;
                }
            }
        }
        if (this.pt1 != null && this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLine(this.m_AxisObj, this.m_nNdx))) {
            if (gt.isPolar() || gt.isRadarType()) {
                this.m_rFrameVC.width = this.m_frameRect.width;
                this.m_rFrameVC.height = this.m_frameRect.height;
                this.m_centerFramePosVC.x = this.m_frameRect.x + this.m_frameRect.width / 2;
                this.m_centerFramePosVC.y = this.m_frameRect.y + this.m_frameRect.height / 2;
                if (this.m_nAxisID == 2004) {
                    Rectangle rOval = new Rectangle(this.getValueOval(this.m_relVal));
                    DetOval dOval = new DetOval(this.m_Perspective.m_Detectiv, this.m_id, rOval.x, rOval.y, rOval.width, rOval.height, blackBox, null, false, true, true, this.m_nLineWidth, this.m_nWidthVC);
                    dOval.setReferenceData(this.m_nValue);
                    dOval.setReferenceObject();
                } else if (this.m_nAxisID == 2003) {
                    aObj = ch2.getX1Axis();
                    Rectangle rFrame = this.m_Perspective.getFrameRect(false);
                    Point pt2 = new Point(0, 0);
                    double angle = aObj.getValueCoord(this.m_nValue);
                    Dimension m_frameDimVC = new Dimension(rFrame.width, rFrame.height);
                    CircularAxisObj cObj = (CircularAxisObj)aObj;
                    CircularAxisObj.polarToCartesian(pt2, angle, 1.0, m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                    this.m_LineObj = new DetLine(this.m_Perspective.m_Detectiv, this.m_id, this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, pt2.x, pt2.y, (BlackBoxIF)blackBox, null, this.m_nLineWidth, this.m_lineStyle);
                    this.m_LineObj.setReferenceData(this.m_nValue);
                    this.m_LineObj.setReferenceObject();
                }
            } else if (!this.m_bDrawWithDepth) {
                this.m_LineObj = new DetLine(this.m_Perspective.m_Detectiv, this.m_id, this.pt1.x, this.pt1.y, this.pt2.x, this.pt2.y, blackBox, null, false, true, this.m_nLineWidth, this.m_lineStyle);
                this.m_LineObj.setReferenceData(this.m_nValue);
                this.m_LineObj.setReferenceObject();
            } else {
                this.m_LineObj = new DetLine(this.m_Perspective.m_Detectiv, this.m_id, this.pt1.x - this.m_frameDepthOffset.x, this.pt1.y - this.m_frameDepthOffset.y, this.pt2.x - this.m_frameDepthOffset.x, this.pt2.y - this.m_frameDepthOffset.y, blackBox, null, false, true, this.m_nLineWidth, this.m_lineStyle);
                this.m_LineObj.setReferenceData(this.m_nValue);
                this.m_LineObj.setReferenceObject();
            }
        }
    }

    public IdentObj getIdentObj() {
        return this.m_AxisObj;
    }

    public double getPosition() {
        return this.m_nValue;
    }

    public void setLineLabel(String str) {
        this.m_szLabel = str;
    }

    public String getLineLabel() {
        return this.m_szLabel;
    }

    public int getObjectID() {
        return this.m_AxisObj.getObjectID() * this.m_nNdx;
    }

    public int getAxisLineObjID() {
        return this.m_axisLineObjID;
    }

    public int getAxisID() {
        return this.m_nAxisID;
    }

    public int getIndex() {
        return this.m_nNdx;
    }

    public int getSID() {
        return this.sID;
    }

    public int getRelativeXPos() {
        return this.pt1.x;
    }

    public int getSortIndex() {
        return this.m_nSIndex;
    }

    public Rectangle getValueOval(double fRelValue) {
        return new Rectangle((int)((double)this.m_centerFramePosVC.x - (double)(this.m_rFrameVC.width / 2) * fRelValue), (int)((double)this.m_centerFramePosVC.y - (double)(this.m_rFrameVC.height / 2) * fRelValue), (int)((double)(2 * this.m_rFrameVC.width / 2) * fRelValue), (int)((double)(2 * this.m_rFrameVC.height / 2) * fRelValue));
    }

    private boolean checkValidAxis(IdentObj axisObj, int nAxisID, JChart_Base m_chart) {
        boolean bValid = false;
        if (m_chart != null) {
            JChart_2D_Standard ch2 = (JChart_2D_Standard)m_chart;
            JGraphType gt = this.m_Perspective.getJGraphType();
            AxisDescriptor axisDescriptor = gt.getAxisDescriptor();
            if (axisDescriptor != null) {
                if (nAxisID == 2004) {
                    if (axisDescriptor.hasY1()) {
                        bValid = true;
                    }
                } else if (nAxisID == 2003) {
                    if (axisDescriptor.hasX1()) {
                        bValid = true;
                    }
                } else if (nAxisID == 2005 && axisDescriptor.hasY2()) {
                    bValid = true;
                }
            }
        }
        return bValid;
    }

    public boolean IsReferenceLineAxisValid() {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (!(gt.isBLAType() || gt.isPolar() || gt.isRadarType() || gt.isScatter() || gt.isBubble())) {
            return this.checkValidAxis(this.m_AxisObj, this.m_nAxisID, this.m_chart);
        }
        return false;
    }

    public boolean IsValidAxis() {
        return this.checkValidAxis(this.m_AxisObj, this.m_nAxisID, this.m_Perspective.getGraphObject());
    }
}

