/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Polygon;
import tdg.Cubic;

public class NatCubic {
    static final int STEPS = 12;

    private NatCubic() {
    }

    static Cubic[] calcNaturalCubic(int n, int[] x) {
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        int i = 1;
        while (i < n) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
            ++i;
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = (float)(3 * (x[1] - x[0])) * gamma[0];
        i = 1;
        while (i < n) {
            delta[i] = ((float)(3 * (x[i + 1] - x[i - 1])) - delta[i - 1]) * gamma[i];
            ++i;
        }
        delta[n] = ((float)(3 * (x[n] - x[n - 1])) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        i = n - 1;
        while (i >= 0) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
            --i;
        }
        Cubic[] C = new Cubic[n];
        i = 0;
        while (i < n) {
            C[i] = new Cubic(x[i], D[i], (float)(3 * (x[i + 1] - x[i])) - 2.0f * D[i] - D[i + 1], (float)(2 * (x[i] - x[i + 1])) + D[i] + D[i + 1]);
            ++i;
        }
        return C;
    }

    public static Polygon interpolate(Polygon polyIn) {
        Polygon polyOut = new Polygon();
        if (polyIn.npoints >= 2) {
            Cubic[] X = NatCubic.calcNaturalCubic(polyIn.npoints - 1, polyIn.xpoints);
            Cubic[] Y = NatCubic.calcNaturalCubic(polyIn.npoints - 1, polyIn.ypoints);
            polyOut.addPoint(Math.round(X[0].eval(0.0f)), Math.round(Y[0].eval(0.0f)));
            int i = 0;
            while (i < X.length) {
                int j = 1;
                while (j <= 12) {
                    float u = (float)j / 12.0f;
                    polyOut.addPoint(Math.round(X[i].eval(u)), Math.round(Y[i].eval(u)));
                    ++j;
                }
                ++i;
            }
        }
        return polyOut;
    }
}

