/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Rectangle;
import tdg.Assert;
import tdg.AssertionException;
import tdg.FrameObj;
import tdg.JChart_Base;
import tdg.Perspective;
import tdg.SeriesEnumerator;

public abstract class JChart_2D
extends JChart_Base {
    FrameObj m_Frame;
    Rectangle m_rClip;
    int m_nBaseType;
    int[] m_seriesTypes;
    int[] m_axisAssignments;
    int[] m_seriesPlanes;
    int m_nDepthPlanes;
    int m_nDepthAngle;
    int m_nDepthRadius;

    public void calc() {
        Rectangle rClip = null;
        super.calc();
        this.createFrame();
        if (this.m_Frame != null) {
            this.m_Frame.calc();
        }
        if (this.m_Frame != null) {
            rClip = this.m_Perspective.getFrameRect(false);
        }
        this.m_rClip = rClip != null && !rClip.isEmpty() ? rClip : null;
    }

    public double calcBackOffset(int nCurrPlane, int nDepthPlanes) {
        if (nDepthPlanes == 0) {
            return 0.0;
        }
        double fUnit = 1.0 / (double)nDepthPlanes;
        double fOffset = fUnit * (double)nCurrPlane;
        return fOffset;
    }

    public void calcDataScrollers() {
        this.m_Frame.calcDataScrollers();
    }

    public int calcDepthPlanes() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        int nNumPlanes = 0;
        int nAreas = 0;
        boolean bHasBars = false;
        boolean bHasAreas = false;
        boolean bHasLines = false;
        this.m_seriesPlanes = new int[this.m_nTotalSeries];
        if (this.m_bAbsolute) {
            int nSeriesType;
            int s;
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                nSeriesType = this.m_seriesTypes[s];
                if (nSeriesType == 1) {
                    bHasBars = true;
                    continue;
                }
                if (nSeriesType == 3) {
                    this.m_seriesPlanes[s] = nAreas++;
                    ++nNumPlanes;
                    continue;
                }
                if (nSeriesType == 2) {
                    bHasLines = true;
                    ++nNumPlanes;
                    continue;
                }
                if (nSeriesType == 12) {
                    bHasBars = true;
                    continue;
                }
                throw new AssertionException("Unknown riser type = " + nSeriesType + " for series = " + s);
            }
            int plane = nAreas;
            if (bHasBars) {
                ++nNumPlanes;
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType == 1) {
                        this.m_seriesPlanes[s] = plane;
                    }
                    if (nSeriesType != 12) continue;
                    nNumPlanes = 2;
                }
                ++plane;
            }
            if (bHasLines) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 2) continue;
                    this.m_seriesPlanes[s] = plane++;
                }
            }
        } else {
            int nSeriesType;
            int s;
            int plane = 0;
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                nSeriesType = this.m_seriesTypes[s];
                switch (nSeriesType) {
                    case 1: {
                        bHasBars = true;
                        break;
                    }
                    case 3: {
                        this.m_seriesPlanes[s] = plane;
                        bHasAreas = true;
                        break;
                    }
                    case 2: {
                        bHasLines = true;
                        break;
                    }
                    default: {
                        throw new AssertionException("unknown seriesType = " + nSeriesType);
                    }
                }
            }
            if (bHasAreas) {
                ++nNumPlanes;
                ++plane;
            }
            if (bHasBars) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 1) continue;
                    this.m_seriesPlanes[s] = plane;
                }
                ++nNumPlanes;
                ++plane;
            }
            if (bHasLines) {
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    nSeriesType = this.m_seriesTypes[s];
                    if (nSeriesType != 2) continue;
                    this.m_seriesPlanes[s] = plane;
                }
                ++nNumPlanes;
            }
        }
        return nNumPlanes;
    }

    public double calcFrontOffset(int nCurrPlane, int nDepthPlanes) {
        if (nDepthPlanes == 0) {
            return 0.0;
        }
        double fUnit = 1.0 / (double)nDepthPlanes;
        double fOffset = fUnit * (double)nCurrPlane + fUnit;
        return fOffset;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_nDepthRadius = this.m_Perspective.getDepthRadius();
        this.m_nDepthAngle = this.m_Perspective.getDepthAngle();
        this.m_nBaseType = this.m_gt.getRiserType();
        this.m_seriesTypes = this.m_Perspective.getSeriesTypes();
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            this.m_nDepthPlanes = this.calcDepthPlanes();
        }
        this.m_axisAssignments = new int[this.m_nTotalSeries];
        if (this.m_gt.isDualY() || this.m_gt.isParetoType() || this.m_gt.isMultiY()) {
            int s = 0;
            while (s < this.m_nTotalSeries) {
                this.m_axisAssignments[s] = this.m_Perspective.getAxisAssignment(s);
                ++s;
            }
        } else {
            int s = 0;
            while (s < this.m_nTotalSeries) {
                this.m_axisAssignments[s] = 0;
                ++s;
            }
        }
    }

    public void createFrame() {
        this.m_Frame = new FrameObj(this.m_Perspective);
    }

    public int getAxisAssignment(int s) {
        return this.m_axisAssignments[s];
    }

    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_Frame = null;
    }

    public boolean isGroupScrollerPresent() {
        boolean bGroupScrollerPresent = false;
        if (this.m_Frame != null) {
            bGroupScrollerPresent = this.m_Frame.isGroupScrollerPresent();
        }
        return bGroupScrollerPresent;
    }

    public Rectangle getLeftFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getLeftEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getRightFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getRightEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public Rectangle getBottomFrameEdge() {
        if (this.m_Frame != null) {
            return this.m_Frame.getBottomEdge();
        }
        return this.m_Perspective.getFrameRect(false);
    }

    public void releaseReferences() {
        if (this.m_Frame != null) {
            this.m_Frame.releaseReferences();
        }
        super.releaseReferences();
    }
}

