/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.math;

import com.threedgraphics.math.CurveFitIF;
import tdg.Assert;
import tdg.AssertionException;

public class FitExponential
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        double y = a[1] * Math.pow(a[2], x);
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        a[1] = 1.0;
        a[2] = x;
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double y) throws AssertionException {
        Assert.assert(y > 0.0);
        return Math.log(y);
    }

    public double invTransformCoeff(int ia, double a) {
        return Math.exp(a);
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        Assert.assert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + "^x";
        return "y = " + strTerm1 + " * " + strTerm2;
    }
}

