/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.controls;

import java.io.IOException;
import java.io.InputStream;
import oracle.ord.controls.OrdSeekableSource;

class OrdSeekableInputStream
extends InputStream {
    private static final int INVALID = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    OrdSeekableSource m_source;
    long m_length;
    int state;
    byte[] buffer;
    int bufferSize;
    long bufferStartPos;
    long markPos;
    int bufferPos;
    int bufferCount;
    String dbErrorMsg;

    private /* synthetic */ void $init$() {
        this.m_source = null;
        this.state = 0;
        this.bufferStartPos = 1L;
        this.markPos = -1;
        this.bufferPos = 0;
        this.bufferCount = 0;
        this.dbErrorMsg = null;
    }

    public OrdSeekableInputStream(OrdSeekableSource ordSeekableSource) throws IOException {
        this.$init$();
        this.m_source = ordSeekableSource;
        int n = ordSeekableSource.getIdealBufferSize();
        if (n < 1) {
            throw new IOException("Non-positive chunkSize specified for OrdSeekableInputStream.");
        }
        this.m_length = ordSeekableSource.getLength();
        this.markPos = -1;
        this.bufferSize = (long)n > this.m_length ? (int)this.m_length : n;
        this.buffer = new byte[this.bufferSize];
        this.state = 1;
    }

    public OrdSeekableSource getSource() {
        return this.m_source;
    }

    public long getFilePointer() throws IOException {
        if (1 != this.state) {
            return -1;
        }
        return this.bufferStartPos + (long)this.bufferPos - 1L;
    }

    public int read() throws IOException {
        if (1 != this.state) {
            throw new IOException("Attempted to read() closed OrdSeekableInputStream");
        }
        if (this.remaining() == 0L) {
            return -1;
        }
        if (!this.hasData()) {
            return -1;
        }
        return 0xFF & this.buffer[this.bufferPos++];
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException("Null array reference passed to OrdSeekableInputStream read.");
        }
        if (1 != this.state) {
            throw new IOException("Attempted to read() closed OrdSeekableInputStream");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Attempted OrdSeekableInputStream read with negative buffer offset");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Attempted OrdSeekableInputStream read with negative buffer length");
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Attempted OrdSeekableInputStream read would overflow buffer");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.remaining() == 0L) {
            return -1;
        }
        if (!this.hasData()) {
            throw new IOException("Couldn't read at least one byte from OrdSeekableInputStream");
        }
        int n4 = n;
        int n5 = n + n2;
        do {
            if ((n3 = n5 - n4) > this.bufferCount - this.bufferPos) {
                n3 = this.bufferCount - this.bufferPos;
            }
            System.arraycopy(this.buffer, this.bufferPos, byArray, n4, n3);
            this.bufferPos += n3;
        } while ((n4 += n3) < n5 && this.hasData());
        return n4 - n;
    }

    public void seek(long l) throws IOException {
        if (1 != this.state) {
            throw new IOException("Attemped to seek() closed OrdSeekableInputStream");
        }
        if (l < 0L) {
            throw new IOException("Attempted to seek before start of OrdSeekableInputStream");
        }
        if (l + 1L >= this.bufferStartPos && l + 1L < this.bufferStartPos + (long)this.bufferCount) {
            this.bufferPos = (int)(l + 1L - this.bufferStartPos);
            return;
        }
        this.bufferStartPos = l + 1L;
        this.bufferPos = 0;
        this.bufferCount = 0;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public void mark(int n) {
        this.markPos = this.bufferStartPos + (long)this.bufferPos;
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() throws IOException {
        if (1 != this.state) {
            throw new IOException("Attemped to reset() closed OrdSeekableInputStream");
        }
        if ((long)-1 == this.markPos) {
            throw new IOException("Attempted to reset an unmarked OrdSeekableInputStream.");
        }
        if (this.markPos >= this.bufferStartPos && this.markPos < this.bufferStartPos + (long)this.bufferCount) {
            this.bufferPos = (int)(this.markPos - this.bufferStartPos);
            return;
        }
        this.bufferStartPos = this.markPos;
        this.bufferPos = 0;
        this.bufferCount = 0;
    }

    public long skip(long l) throws IOException {
        if (1 != this.state) {
            throw new IOException("Attemped to skip() closed OrdSeekableInputStream");
        }
        if (l <= 0L) {
            return 0L;
        }
        if (l > this.remaining()) {
            l = (int)this.remaining();
            this.bufferStartPos = this.m_length + 1L;
            this.bufferPos = 0;
            this.bufferCount = 0;
            return l;
        }
        if (l < (long)(this.bufferCount - this.bufferPos)) {
            this.bufferPos = (int)((long)this.bufferPos + l);
            return l;
        }
        this.bufferStartPos += (long)this.bufferPos + l;
        this.bufferPos = 0;
        this.bufferCount = 0;
        return l;
    }

    public void close() throws IOException {
        this.state = 2;
        super.close();
    }

    public long remaining() {
        if (1 != this.state) {
            return 0L;
        }
        long l = this.m_length - this.bufferStartPos - (long)this.bufferPos + 1L;
        return l > 0L ? l : 0L;
    }

    public boolean hasDBErrorMessage() {
        return this.dbErrorMsg != null;
    }

    public String getDBErrorMessage() {
        return this.dbErrorMsg;
    }

    protected void setDBErrorMessage(String string) {
        this.dbErrorMsg = string;
    }

    private boolean hasData() throws IOException {
        if (this.bufferPos < this.bufferCount) {
            return true;
        }
        this.bufferStartPos += (long)this.bufferPos;
        this.bufferPos = 0;
        if (this.bufferStartPos > this.m_length) {
            return false;
        }
        try {
            this.bufferCount = this.m_source.getBytes(this.bufferStartPos, this.bufferSize, this.buffer);
        }
        catch (Exception exception) {
            this.bufferCount = 0;
            throw new IOException(exception.getMessage());
        }
        return this.bufferCount >= 1;
    }

    public int available() throws IOException {
        int n = this.bufferCount - this.bufferPos;
        if (n > 0) {
            return n;
        }
        return 0;
    }
}

