/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FlatXmlProducer
extends DefaultHandler
implements IDataSetProducer,
ContentHandler {
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private static final String DATASET = "dataset";
    private final InputSource _inputSource;
    private final EntityResolver _resolver;
    private final boolean _dtdMetadata;
    private boolean _validating = false;
    private IDataSet _metaDataSet;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private ITableMetaData _activeMetaData;

    public FlatXmlProducer(InputSource xmlSource) {
        this._inputSource = xmlSource;
        this._resolver = this;
        this._dtdMetadata = true;
        this._validating = false;
    }

    public FlatXmlProducer(InputSource xmlSource, boolean dtdMetadata) {
        this._inputSource = xmlSource;
        this._resolver = this;
        this._dtdMetadata = dtdMetadata;
        this._validating = false;
    }

    public FlatXmlProducer(InputSource xmlSource, IDataSet metaDataSet) {
        this._inputSource = xmlSource;
        this._metaDataSet = metaDataSet;
        this._resolver = this;
        this._dtdMetadata = false;
        this._validating = false;
    }

    public FlatXmlProducer(InputSource xmlSource, EntityResolver resolver) {
        this._inputSource = xmlSource;
        this._resolver = resolver;
        this._dtdMetadata = true;
        this._validating = false;
    }

    private ITableMetaData createTableMetaData(String tableName, Attributes attributes) throws DataSetException {
        if (this._metaDataSet != null) {
            return this._metaDataSet.getTableMetaData(tableName);
        }
        Column[] columns = new Column[attributes.getLength()];
        for (int i = 0; i < attributes.getLength(); ++i) {
            columns[i] = new Column(attributes.getQName(i), DataType.UNKNOWN);
        }
        return new DefaultTableMetaData(tableName, columns);
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(this._validating);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            if (this._dtdMetadata) {
                FlatDtdHandler dtdHandler = new FlatDtdHandler();
                FlatDtdProducer.setLexicalHandler(xmlReader, dtdHandler);
                FlatDtdProducer.setDeclHandler(xmlReader, dtdHandler);
            }
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.setEntityResolver(this._resolver);
            xmlReader.parse(this._inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new DataSetException(e);
        }
        catch (SAXException e) {
            Exception exception;
            int lineNumber = -1;
            if (e instanceof SAXParseException) {
                lineNumber = ((SAXParseException)e).getLineNumber();
            }
            Exception exception2 = exception = e.getException() == null ? e : e.getException();
            if (lineNumber >= 0) {
                String message = "Line " + lineNumber + ": " + exception.getMessage();
                throw new DataSetException(message, e);
            }
            throw new DataSetException(exception);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (!this._dtdMetadata) {
            return new InputSource(new StringReader(""));
        }
        return null;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (this._activeMetaData == null && qName.equals(DATASET)) {
                this._consumer.startDataSet();
                return;
            }
            if (this._activeMetaData == null || !this._activeMetaData.getTableName().equals(qName)) {
                if (this._activeMetaData != null) {
                    this._consumer.endTable();
                }
                this._activeMetaData = this.createTableMetaData(qName, attributes);
                this._consumer.startTable(this._activeMetaData);
            }
            if (attributes.getLength() > 0) {
                Column[] columns = this._activeMetaData.getColumns();
                Object[] rowValues = new Object[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    Column column = columns[i];
                    rowValues[i] = attributes.getValue(column.getColumnName());
                }
                this._consumer.row(rowValues);
            }
        }
        catch (DataSetException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(DATASET)) {
            try {
                if (this._activeMetaData != null) {
                    this._consumer.endTable();
                }
                this._consumer.endDataSet();
            }
            catch (DataSetException e) {
                throw new SAXException(e);
            }
        }
    }

    private class FlatDtdHandler
    extends FlatDtdProducer {
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            try {
                FlatDtdDataSet metaDataSet = new FlatDtdDataSet();
                this.setConsumer(metaDataSet);
                FlatXmlProducer.this._metaDataSet = metaDataSet;
                super.startDTD(name, publicId, systemId);
            }
            catch (DataSetException e) {
                throw new SAXException(e);
            }
        }
    }
}

