/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.ws.tagext;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import oracle.ds.v2.impl.system.typemap.XmlJavaTypeMap;
import oracle.j2ee.ws.client.WebServiceProxy;
import oracle.j2ee.ws.client.WebServiceProxyFactory;

public class WebServiceTag
extends TagSupport {
    private WebServiceProxyFactory _proxyF = new WebServiceProxyFactory();
    private Hashtable _htProperties = new Hashtable();
    private ArrayList _alMaps = new ArrayList();
    private WebServiceProxy _proxy;
    private String _wsdlUrl;
    private InputStream _wsdlIs;
    private String _scope;
    private String _binding;
    private String _soapLocation;
    private String _service;
    private String _port;
    private static final String MSG_FILE = "oracle.jsp.webutil.ws.tagext.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.ws.tagext.LocalStrings");

    public void setWsdlUrl(String wsdlUrl) {
        this._wsdlUrl = wsdlUrl;
    }

    public void setWsdlIs(InputStream wsdlis) {
        this._wsdlIs = wsdlis;
    }

    public void setScope(String s) {
        this._scope = s;
    }

    public void setBinding(String b) {
        this._binding = b;
    }

    public String getBinding() {
        return this._binding;
    }

    public void setSoapLocation(String s) {
        this._soapLocation = s;
    }

    public String getSoapLocation() {
        return this._soapLocation;
    }

    public void setService(String s) {
        this._service = s;
    }

    public String getService() {
        return this._service;
    }

    public void setPort(String p) {
        this._port = p;
    }

    public String getPort() {
        return this._port;
    }

    public int doStartTag() throws JspTagException {
        if (this._wsdlUrl == null || this._wsdlUrl.trim().length() == 0) {
            throw new JspTagException(msgs.getString("no_wsdlUrl"));
        }
        return 1;
    }

    public int doEndTag() throws JspTagException {
        this.setWebServiceProxy();
        if (this._proxy == null) {
            throw new JspTagException(msgs.getString("proxy_failed"));
        }
        String tagId = this.getId();
        if (tagId != null && tagId.trim().length() != 0) {
            int iScope = 1;
            if (this._scope != null && this._scope.equalsIgnoreCase("request")) {
                iScope = 2;
            } else if (this._scope != null && this._scope.equalsIgnoreCase("session")) {
                iScope = 3;
            } else if (this._scope != null && this._scope.equalsIgnoreCase("application")) {
                iScope = 4;
            }
            this.pageContext.setAttribute(tagId, (Object)this._proxy, iScope);
            this.pageContext.setAttribute(tagId + ".mapping", (Object)this._alMaps, iScope);
            this.pageContext.setAttribute(tagId + ".Binding", (Object)this.getBinding(), iScope);
            this.pageContext.setAttribute(tagId + ".Endpoint", (Object)this.getSoapLocation(), iScope);
            this.pageContext.setAttribute(tagId + ".Service", (Object)this.getService(), iScope);
            this.pageContext.setAttribute(tagId + ".Port", (Object)this.getPort(), iScope);
            this.pageContext.setAttribute(tagId + ".WSDL", (Object)this._wsdlUrl, iScope);
        }
        return 6;
    }

    public void setProperty(String name, String value) {
        if (value != null) {
            System.setProperty(name, value);
        }
        this._htProperties.put(name, value);
    }

    public void setParameter(String name, String value) {
    }

    public void addMap(String encodingStyle, String localName, String namespaceUri, String javaType, String java2xmlClassName, String xml2javaClassName) throws JspTagException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            XmlJavaTypeMap map = new XmlJavaTypeMap(encodingStyle, localName, namespaceUri, javaType, java2xmlClassName, xml2javaClassName, cl);
            this._alMaps.add(map);
        }
        catch (Exception e) {
            throw new JspTagException(e.toString() + ": " + e.getMessage());
        }
    }

    public void release() {
        this._proxy = null;
        this._proxyF = new WebServiceProxyFactory();
        this._htProperties.clear();
        this._alMaps.clear();
        super.release();
    }

    private void setWebServiceProxy() throws JspTagException {
        URL url = null;
        try {
            url = new URL(this._wsdlUrl);
        }
        catch (Exception e) {
            throw new JspTagException(msgs.getString("invalid_wsdlURL") + e.getMessage());
        }
        try {
            this._proxyF.setProperties(this._htProperties);
            if (this._binding != null && this._soapLocation != null && this._service == null && this._port == null) {
                this._proxy = this._proxyF.createWebServiceProxyFromBinding(url, this._binding, this._soapLocation);
            } else if (this._service != null && this._binding == null && this._soapLocation == null) {
                this._proxy = this._proxyF.createWebServiceProxyFromService(url, this._service, this._port);
            } else if (this._binding == null && this._soapLocation == null && this._service == null && this._port == null) {
                this._proxy = this._proxyF.createWebServiceProxy(url);
            } else {
                throw new JspTagException(msgs.getString("invalid_endpoint"));
            }
            if (this._proxy == null) {
                return;
            }
        }
        catch (Exception e) {
            throw new JspTagException(e.toString() + ": " + e.getMessage());
        }
    }
}

