/*
 * Decompiled with CFR 0.152.
 */
package oracle.jsp.webutil.tagutil;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import oracle.jsp.webutil.tagutil.ImplicitXMLObjConsumer;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import sun.io.CharacterEncoding;

public class TagUtil {
    public static final String DEFAULT_PAGE = "index.jsp";
    public static final String INCLUDED_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDED_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDED_QUERY_STRING = "javax.servlet.include.query_string";
    public static String THAI_CHARSET_IANA = "TIS-620";
    public static String THAI_CHARSET_JAVA = "TIS620";
    public static String SIMPLIFIED_CHINESE_CHARSET_JAVA = "GBK";
    public static String KOREAN_CHARSET_ALTERNATE = "EUC_KR";
    public static String KOREAN_CHARSET_JAVA = "EUC-KR";
    private static final String MESSAGE_FILE = "oracle.jsp.webutil.tagutil.LocalStrings";
    private static ResourceBundle msgs = ResourceBundle.getBundle("oracle.jsp.webutil.tagutil.LocalStrings");

    public static String stripTarget(String s) {
        return TagUtil.stripTarget(s, '/');
    }

    public static String stripTarget(String s, char sep) {
        String newS = TagUtil.handleDotsInPath(s, sep);
        if (newS == null) {
            throw new IllegalArgumentException(msgs.getString("invalid_dots"));
        }
        s = newS;
        int end = s.lastIndexOf(sep);
        if (end <= 0) {
            return "" + sep;
        }
        return s.substring(0, end);
    }

    public static String getQueryString(HttpServletRequest request) {
        String path = (String)request.getAttribute(INCLUDED_QUERY_STRING);
        if (path != null) {
            return path;
        }
        return request.getQueryString();
    }

    public static String getAbsoluteUrlPath(String relativeUrlPath, ServletContext application, HttpServletRequest request) throws ServletException {
        if (relativeUrlPath.charAt(0) != '/') {
            String pagePath = null;
            pagePath = TagUtil.request2AppPath(request);
            relativeUrlPath = pagePath + relativeUrlPath;
        }
        relativeUrlPath = TagUtil.handleDotsInPath(relativeUrlPath);
        String contextPath = request.getContextPath();
        return contextPath + relativeUrlPath;
    }

    public static String convIANAtoJavaEncoding(String ianaEncoding, boolean privileged) {
        if (ianaEncoding == null) {
            return null;
        }
        if (ianaEncoding.equalsIgnoreCase(THAI_CHARSET_IANA)) {
            return THAI_CHARSET_JAVA;
        }
        if (ianaEncoding.equalsIgnoreCase(SIMPLIFIED_CHINESE_CHARSET_JAVA)) {
            return SIMPLIFIED_CHINESE_CHARSET_JAVA;
        }
        if (ianaEncoding.equalsIgnoreCase(KOREAN_CHARSET_ALTERNATE)) {
            return KOREAN_CHARSET_JAVA;
        }
        if (privileged) {
            final String enc_arg = ianaEncoding.toUpperCase();
            String jdkEncoding = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return CharacterEncoding.aliasName((String)enc_arg);
                }
            });
            return jdkEncoding;
        }
        return CharacterEncoding.aliasName((String)ianaEncoding.toUpperCase());
    }

    public static String handleDotsInPath(String s) {
        return TagUtil.handleDotsInPath(s, '/');
    }

    public static String handleDotsInPath(String origStr, char sep) {
        String queryStr;
        String s;
        int qMark = origStr.indexOf(63);
        if (qMark == -1) {
            s = origStr;
            queryStr = "";
        } else {
            s = origStr.substring(0, qMark);
            queryStr = origStr.substring(qMark, origStr.length());
        }
        char[] c0 = s.toCharArray();
        StringBuffer sb0 = new StringBuffer();
        int len = c0.length;
        for (int i = 0; i < len; ++i) {
            if (c0[i] == sep) {
                if (i > 0 && c0[i - 1] == sep) continue;
                sb0.append(c0[i]);
                continue;
            }
            sb0.append(c0[i]);
        }
        char[] c = new String(sb0).toCharArray();
        int begin = 0;
        int index = s.indexOf(sep, begin);
        StringBuffer sb = new StringBuffer();
        do {
            if (c[begin] == '.') {
                if (c.length == begin + 1 || c[begin + 1] == sep) {
                    if ((begin += 2) > c.length) {
                        begin = c.length;
                    }
                } else if (c[begin + 1] == '.' && (c.length == begin + 2 || c[begin + 2] == sep)) {
                    if (sb.length() < 2) {
                        return null;
                    }
                    int lastIndex = -1;
                    for (int i = sb.length() - 2; i >= 0; --i) {
                        if (sb.charAt(i) != sep) continue;
                        lastIndex = i;
                        break;
                    }
                    sb.setLength(lastIndex + 1);
                    if ((begin += 3) > c.length) {
                        begin = c.length;
                    }
                } else {
                    if (index == -1) break;
                    sb.append(c, begin, index + 1 - begin);
                    begin = index + 1;
                }
            } else {
                if (index == -1) break;
                sb.append(c, begin, index + 1 - begin);
                begin = index + 1;
            }
            index = s.indexOf(sep, begin);
        } while (begin < c.length && index < c.length);
        if (begin < c.length) {
            sb.append(c, begin, c.length - begin);
        }
        sb.append(queryStr);
        return new String(sb);
    }

    public static String getTarget(String s) {
        int end = 0;
        end = s.indexOf("?");
        if (end != -1) {
            s = s.substring(0, end);
        }
        if ((end = s.lastIndexOf("/")) < 0) {
            return s;
        }
        if (end == s.length() - 1) {
            return DEFAULT_PAGE;
        }
        return s.substring(end + 1);
    }

    public static String request2AppPath(HttpServletRequest request) throws ServletException {
        String appPath = null;
        String sPath = null;
        String path = (String)request.getAttribute(INCLUDED_SERVLET_PATH);
        sPath = path != null ? path : request.getServletPath();
        String pPath = request.getPathInfo();
        if (sPath == null && pPath == null) {
            throw new ServletException(msgs.getString("no_app_path"));
        }
        appPath = sPath == null || sPath.length() <= 1 ? pPath : (pPath == null || pPath.length() <= 1 ? sPath : sPath + pPath);
        int last = appPath.lastIndexOf("/");
        if (last == -1) {
            throw new ServletException(msgs.getString("no_app_path"));
        }
        if (last != appPath.length() - 1) {
            appPath = appPath.substring(0, last + 1);
        }
        return appPath;
    }

    public static URL getURLFromResource(PageContext pageContext, String rs, String extension) throws ServletException, MalformedURLException, IOException {
        ServletContext sc = pageContext.getServletContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        URL url = null;
        String appPath = TagUtil.request2AppPath(request);
        if (rs.indexOf("://") != -1) {
            url = new URL(rs);
        } else if (TagUtil.getTarget(rs).toLowerCase().endsWith(extension)) {
            String scResource = rs;
            if (scResource.charAt(0) != '/') {
                scResource = appPath + scResource;
            }
            url = sc.getResource(scResource);
        }
        if (url == null) {
            throw new ServletException(MessageFormat.format(msgs.getString("res_not_found"), rs));
        }
        return url;
    }

    public static void setToXMLObj(Tag tag, XMLDocument xmlDoc) throws JspTagException {
        ImplicitXMLObjConsumer consumerTag = TagUtil.getImplicitXMLObjConsumer(tag);
        if (consumerTag != null) {
            consumerTag.setImplicitFromXMLObj((Document)xmlDoc);
        }
    }

    public static ImplicitXMLObjConsumer getImplicitXMLObjConsumer(Tag tag) {
        Tag parentTag = tag.getParent();
        if (parentTag != null && parentTag instanceof ImplicitXMLObjConsumer) {
            return (ImplicitXMLObjConsumer)parentTag;
        }
        return null;
    }

    public static void validateString(String s, String attrName) throws JspTagException {
        if (s == null || s.equals("")) {
            throw new JspTagException(MessageFormat.format(msgs.getString("null_or_empty"), attrName));
        }
    }
}

